(ns feeds.view
  (:use [hiccup core def element page form]
        [clojure.tools.logging]
        )
  (:require [feeds.util :as util]
            [net.cgrand.enlive-html :as html]))

(defn menu [user]
  (if user
    [:nav.navigation
     [:ul
      [:div.seven.columns
       [:li [:a {:href "#"} "Get started"]]]
      ]
     ]))

(html/deftemplate main-template "index.html" [])

(defn template [user & content]
  (apply str (main-template)))

(defn index []
  (template nil
    [:div.sixteen.columns
     [:div.main
      [:h1 "feeds"]
      [:p "Please sign in to your account"]
      ]]))

(defn login [username login_failed]
  (template nil
    [:div.sixteen.columns
     [:div.main
      (form-to [:post "/login"]
               (if (= login_failed "Y") "Login failed")
               (label "username" "Username")
               (text-field {:autofocus true :autocomplete "off"} "username" username)
               (label "password" "Password")
               (password-field "password")
               (submit-button "Login")
               )]]))

(defn user [user]
  (template user
    [:div.sixteen.columns
     [:div.main
      [:h1 "feeds"]
      [:p "Welcome user"]
      ]]))

(defn admin [user]
  (template user
    [:div.sixteen.columns
     [:div.main
      [:h1 "feeds"]
      [:p "Welcome admin"]
      ]]))
