(ns clj-slack.rtmtest
  (:require [clj-slack.rtm :as rtm]))

(comment
  (def conn {:api-url "https://slack.com/api"
             :token "xoxb-3802177514-D0ZJLsBpoAhF50MU85aiSYT5"})

  (do
    (def time-now (System/currentTimeMillis))
    (defn on-close [evt] (println "took: " (- (System/currentTimeMillis) time-now)))

    ;; connect to slack via RTM
    (def rtm-conn (rtm/connect conn
                               :hello #(prn "connected to slack" %)
                               :on-close on-close))

    ;; get a publication that will allow us to subscribe to certain kind of events
    (def publication (:events-publication rtm-conn))

    ;; get a channel to send messages to slack
    (def dispatcher (:dispatcher rtm-conn))

    ;; get a publication to get raw data
    (def ws-publication (:websocket-publication rtm-conn)))

  ;; send message to slack
  (rtm/send-event dispatcher {:type "ping"})
  (rtm/send-event dispatcher {:type "message"
                              :text "Hi there @channel"
                              :channel "C03PHJ58Z"})
  (rtm/send-event dispatcher :close)

  ;; subscribe to the pong events
  (defn receive-event [event] (prn "got something: " event))
  (def pong-ch (rtm/sub-to-event publication "pong" receive-event))

  (defn on-error [err] (println "fuck this shit!!! " err))
  (def err-ch (rtm/sub-to-event publication "error" on-error))

  (defn receive-message [event] (println "nice msg: " (:text event)))
  (def messenger (rtm/sub-to-event publication "message" receive-message))

  (def channel-reporter #(-> % :channel println))
  (def ch-reporter-ch (rtm/sub-to-event publication "message" channel-reporter))

  ;; TODO invert params order
  (rtm/unsub-from-event publication "pong" pong-ch)
  (rtm/unsub-from-event publication "message" messenger)
  (rtm/unsub-from-all-events publication))
