(ns leiningen.new.cs-rabbit-to-mysql
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(defn cs-rabbit-to-mysql
  "Generate a project with a RabbitMQ listener and MySQL connection pool"
  [name]
  (let [render (renderer "cs-rabbit-to-mysql")
  		data {:name name :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' cs-rabbit-to-mysql project.")
    (->files data
             ["src/{{sanitized}}/main.clj" (render "main.clj" data)]
             ["src/{{sanitized}}/utils/logger.clj" (render "logger.clj" data)]
             ["src/{{sanitized}}/services/mysql-service.clj" (render "mysql_service.clj" data)]
             ["src/{{sanitized}}/services/rabbit-service.clj" (render "rabbit_service.clj" data)]
             ["Dockerfile" (render "Dockerfile" data)]
             [".gitignore" (render ".gitignore" data)]
             ["project.clj" (render "project.clj" data)])))