(ns billing-detail.core
  (:require [clostache.parser :as clostache]
            [constants.core :as constants]
            [soa.core :as soa]
            [clojure.tools.logging :as log]))

(def ^:private template "templates/RetrievePolicyBillingSummary.xml")

(def ^:private url constants/billing-detail-url)

(defn- model-mapper
  [policy model]
  {:policyNumber (:number policy) :billingDetail (:policy (:policyBillingSummary (:billingSummaries (:retrievePolicyBillingSummariesResponse model))))})

(defn billing-detail-model
  "Returns a Billing Summary model for the requested policy.
  **See** [Dat Keys page for :billing-details](/data-keys#billing-detail)"
  [customer]
  (soa/model customer url template model-mapper))





















