# Digital Services: Connect Framework

[![Clojars Project](https://img.shields.io/clojars/v/csaa-digital/connect-framework.svg)](https://clojars.org/csaa-digital/connect-framework)

This is the Digital Services framework for developing user-experiences and service,
with authentication and security built-in. It is a micro-service architecture and
provides a clean/clear path to all of the SOA services through easy to declare
data keys.

## Videos
[Connect Framework Installation Tutorial](https://vimeo.com/201934877)

## Usage

#### Launch the environment that will host the Authentication server
    $ ./bin/launch-env.sh
    $ ./bin/crash-env.sh # this shuts it down

#### Create a Connect Service
    $ ./bin/create-service.sh

#### Create a Connect Route
    $ ./bin/create-route.sh

### Runtime Usage (making HTTP calls to Routes and Services)

For every request to a Connect Route or Service you will be required to supply a Digital Auth JWT. 

- The JWT can be placed in a Header or a Cookie. 
- The name is always `x-digital-auth`.
- The JWT is required to have a `sub` field describing the user or app making the request.
- The JWT is required to have at least one of the following:
    - An `app` describing the 3rd party app making the request
    - A `user` describing the user making the request
    - Each of these will be required to have an `id` value
    - Each of these can add any extra info to help further describe the request
    
The structure of the JWT is as follows:

**With an App ID**
```json
{
  "sub": "identity-of-user-or-app",
  "app": {
    "id": "optional-id-of-app-making-the-request"
  }
}
```

**With a User ID**
```json
{
  "sub": "identity-of-user-or-app",
  "user": {
    "id": "optional-id-of-user-making-the-request"
  }
}
```

**Example Curl requests with Connect JWT:**

```bash
curl -X GET -H "x-digital-auth: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiYXBwIjp7ImlkIjoiOTg3NjU0MyJ9fQ.Dag6XtIgBILtetyTUsoiIdDx9-7FHPh6BmMDYUi3FK8" \
"http://example.apps.prod.pdc.digital.csaa-insurance.aaa.com/"
```

```bash
curl -X GET -H "Cookie: x-digital-auth=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiYXBwIjp7ImlkIjoiOTg3NjU0MyJ9fQ.Dag6XtIgBILtetyTUsoiIdDx9-7FHPh6BmMDYUi3FK8;" \
 "http://example.apps.prod.pdc.digital.csaa-insurance.aaa.com/"
```
