(ns cacheing.core
  (:require [taoensso.carmine :as car  :refer (wcar)]
            [environ.core :refer [env]]))

(def redis-conn {:pool {}
                 :spec {:uri (env :redis-db)}})

(def cache-turned-off
  (let [cache-off (env :cache-turned-off)]
    (and (not= "false" cache-off) (not (nil? cache-off)))))

(defn get-cache
  [key]
  (when-not cache-turned-off
    (car/wcar redis-conn (car/get key))))

(defn set-cache
  [key data]
  (when-not cache-turned-off
    (car/wcar redis-conn (car/setex key 1200 data))))
