(ns documents.core
  (:require [clostache.parser :as clostache]
            [policies.core :as policies]
            [soa.core :as soa]
            [constants.core :as constants]
            [clojure.tools.logging :as log]
            [clojure.java.io :as io]
            [org.httpkit.client :as http]))

(def document-list-template "templates/RetrieveAgreementRelatedDocuments.xml")

(def document-list-url constants/document-list-url)

(defn model-mapper
  [policy model]
  {:policyNumber (:number policy) :documents (map :documentProfile (:retrieveAgreementRelatedDocumentsResponse model))})

(defn documents-model
  [customer]
  (soa/model customer document-list-url document-list-template model-mapper))

;;;;;;;Document Download Helper

(def document-download-template "templates/RetrieveDocument.xml")

(def document-download-url constants/document-url)

(defn create-document-response
  [document-url]
  (let [response @(http/get document-url {:headers {"X-Proxy-Destination-Hostname" ""}})
        body (:body response)]
    {:status 200 :body body :headers {"Content-Disposition" "inline; filename=document.pdf" "Content-Type" "application/pdf"}}))

(defn document-url-model
  [policy model]
  (:documentLocation (:retrieveDocumentResponse model)))

(defn download-document
  [object-id]
  (let [document-url (soa/soa-xml {:objectId object-id} document-download-url document-download-template document-url-model)]
    (if (not (nil? (:error document-url)))
      {:status 404 :body (str "Could not find a document for id: " object-id)}
      (create-document-response document-url))))
