(defproject csaa-digital/connect-framework "1.8.5"
  :description "Digital Connect: Framework"
  :url "https://github.com/aaa-ncnu-ie/ds-connect-framework"
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/data.json "0.2.6"]
                 [org.clojure/tools.logging "0.3.1"]
                 [compojure "1.5.1"]
                 [ring/ring-core "1.5.0"]
                 [ring/ring-codec "1.0.1"]
                 [ring/ring-mock "0.3.0"]
                 [ring-cors "0.1.8"]
                 [buddy/buddy-sign "1.1.0"]
                 [com.onelogin/java-saml "1.1.2-atlassian-hosted" :exclusions [com.fasterxml.jackson.core/jackson-core
                                                                               org.slf4j/slf4j-log4j12
                                                                               org.slf4j/slf4j-simple]]
                 [ch.qos.logback/logback-classic "1.1.3"]
                 [environ "1.1.0"]
                 [clj-time "0.12.0"]
                 [http-kit "2.1.18"]
                 [http-kit.fake "0.2.2"]
                 [cheshire "5.6.3"]
                 [robert/hooke "1.3.0"]
                 [com.github.kyleburton/clj-xpath "1.4.3"]
                 [de.ubercode.clostache/clostache  "1.4.0"]
                 [org.apache.santuario/xmlsec "2.0.4"]
                 [org.clojure/java.jdbc "0.6.2-alpha3"]
                 [sqljdbc4/sqljdbc4 "1.0"]
                 [com.pingidentity/opentoken-agent "2.4"]
                 ;; required for PF OpenToken
                 [commons-collections/commons-collections "3.2.1"]
                 [commons-beanutils/commons-beanutils "1.9.2"]
                 [javax.servlet/servlet-api "2.5"]
                 [com.taoensso/carmine "2.15.0"]
                 ;; required for TAOEnsso Carmine
                 [commons-codec/commons-codec "1.10"]]

  :plugins [[lein-environ "1.1.0"]]

  :profiles {:uberjar {:aot :all}
             :dev {:plugins [[lein-cloverage "1.0.9"]]
                   :env {:use-test-cert true
                         :forward-for-ip "54.84.85.220"
                         :redis-db "redis://ab083ab4-ef97-411f-80d8-e147794e119b:5wnbtVMKKfLEzVpR@redis-12488.c10.us-east-1-4.ec2.cloud.redislabs.com:12488"
                         :directaccess-db-host "N01DSW247i.tent.trt.csaa.pri"
                         :directaccess-db-name ";databaseName=MyPolicy_Dev"
                         :directaccess-db-password "$Milion2016"}}
             :test {:env {:use-test-cert true
                          :cache-turned-off "true"
                          :forward-for-ip "54.84.85.220"}
                    :resource-paths ["test-resources"]}}


  :repositories [["clojars" {:sign-releases false}]
                 ["releases" "https://maven.atlassian.com/3rdparty/"]
                 ["csaa" "https://devnexus.tent.trt.csaa.pri:8443/nexus/content/repositories/thirdparty/"]])
