(ns constants.core
  (:require [environ.core :refer [env]]))

(def ^{:doc "Base soa url: https://perf-soaservices.tent.trt.csaa.pri"} soa-base-url (or (env :soa-base-url) "https://perf-soaservices.tent.trt.csaa.pri"))
(def ^{:doc "Search port number. 2073"} search-port-url (str soa-base-url ":2073"))
(def ^{:doc "auth url. https://perf-sso.tent.trt.csaa.pri/as/token.oauth2"} auth-url (or (env :auth-url) "https://perf-sso.tent.trt.csaa.pri/as/token.oauth2"))
(def ^{:doc "Access token for SSO auth."} auth-access-token (or (env :auth-access-token) "Y2NfaWV3bXM6ZEJWc2owTVRvREc4S0NJUFdlSzE4aUkzQ1hrWTZER3hDalJ0cktVMUFyZklzS25rYVh4dE15THhMczh0eUNaRg=="))
(def ^{:doc "Search url. /ent/perf/csaa/v3/search/customerCentric"} search-url (str search-port-url "/ent/perf/csaa/v3/search/customerCentric"))
(def ^{:doc "RCD url. /2.2/RetrieveCustomerDetails"} customer-url (str soa-base-url "/2.2/RetrieveCustomerDetails"))
(def ^{:doc "RAPD url. /RetrieveAutoPolicyDetailV2"} auto-policy-url (str soa-base-url "/RetrieveAutoPolicyDetailV2"))
(def ^{:doc "RPPD url. /RetrievePropertyPolicyDetailV2"} property-policy-url (str soa-base-url "/RetrievePropertyPolicyDetailV2"))
(def ^{:doc "Claims summary url. /RetrieveClaimSummariesV2"} claims-url (str soa-base-url "/RetrieveClaimSummariesV2"))
(def ^{:doc "Document url. /3.0/RetrieveDocument"} document-url (str soa-base-url "/3.0/RetrieveDocument"))
(def ^{:doc "RARD url. /3.0/RetrieveAgreementRelatedDocuments"} document-list-url (str soa-base-url "/3.0/RetrieveAgreementRelatedDocuments"))
(def ^{:doc "RPBH url. /RetrievePolicyBillingHistoryV2"} billing-history-url (str soa-base-url "/RetrievePolicyBillingHistoryV2"))
(def ^{:doc "RPBS url. /RetrievePolicyBillingSummariesV2"} billing-detail-url (str soa-base-url "/RetrievePolicyBillingSummariesV2"))
