(ns constants.core
  (:require [environ.core :refer [env]]))

(def soa-base-url (or (env :soa-base-url) "https://perf-soaservices.tent.trt.csaa.pri"))
(def envoy-base-url "https://csaa-insurance.aaa.com/api/envoy")
(def search-port-url (str soa-base-url ":2073"))
(def auth-url (or (env :auth-url) "https://perf-sso.tent.trt.csaa.pri/as/token.oauth2"))

(def forwarded-for-ip (or (env :forward-for-ip) "54.84.85.220"))

(def search-url (str envoy-base-url "/ent/perf/csaa/v3/search/customerCentric"))
(def customer-url (str envoy-base-url "/2.2/RetrieveCustomerDetails"))
(def auto-policy-url (str envoy-base-url "/RetrieveAutoPolicyDetailV2"))
(def property-policy-url (str envoy-base-url "/RetrievePropertyPolicyDetailV2"))
(def claims-url (str envoy-base-url "/RetrieveClaimSummariesV2"))
(def document-url (str envoy-base-url "/3.0/RetrieveDocument"))
(def document-list-url (str envoy-base-url "/3.0/RetrieveAgreementRelatedDocuments"))
(def billing-history-url (str envoy-base-url "/RetrievePolicyBillingHistoryV2"))
(def billing-detail-url (str envoy-base-url "/RetrievePolicyBillingSummariesV2"))
