(ns fu.middleware.anti-forgery
  (:require [ring.middleware.anti-forgery :as ring.mw.anti-forgery]
            [zou.web.middleware.proto :as proto]))

(defrecord AntiForgery [read-token error-response error-handler]
  proto/RingMiddleware
  (wrap [_ handler]
    (->> (cond-> {}
           (ifn? read-token) (assoc :read-token read-token)
           (seq error-response) (assoc :error-response error-response)
           (ifn? error-handler) (assoc :error-handler error-handler))
         (ring.mw.anti-forgery/wrap-anti-forgery handler))))
