(ns fu.middleware.multipart-params
  (:require [ring.middleware.multipart-params :as ring.mw.multipart-params]
            [zou.web.middleware.proto :as proto]))

(defrecord MultipartParams [encoding fallback-encoding store progress-fn]
  proto/RingMiddleware
  (wrap [this handler]
    (->> (cond-> {}
           (seq encoding) (assoc :encoding encoding)
           (seq fallback-encoding) (assoc :fallback-encoding fallback-encoding)
           (ifn? store) (assoc :store store)
           (ifn? progress-fn) (assoc :progress-fn progress-fn))
         (ring.mw.multipart-params/wrap-multipart-params handler))))
