(ns fu.middleware.session
  (:require [ring.middleware.session :as ring.mw.session]
            [ring.middleware.session.store :as ring.mw.session.store]
            [zou.web.middleware.proto :as proto]))

(defrecord Session [store root cookie-name cookie-attrs]
  proto/RingMiddleware
  (wrap [_ handler]
    (->> (cond-> {}
           (satisfies? ring.mw.session.store/SessionStore store) (assoc :store store)
           (seq root) (assoc :root root)
           (seq cookie-name) (assoc :cookie-name cookie-name)
           (map? cookie-attrs) (assoc :cookie-attrs cookie-attrs))
         (ring.mw.session/wrap-session handler))))
