(ns fu.middleware.ssl
  (:require [ring.middleware.ssl :as ring.mw.ssl]
            [zou.web.middleware.proto :as proto]))

(defn- boolean? [x]
  (or (true? x) (false? x)
      (instance? Boolean x)))

(defrecord Hsts [max-age include-subdomain?]
  proto/RingMiddleware
  (wrap [this handler]
    (->> (cond-> {}
           (and (integer? max-age) (pos? max-age)) (assoc :max-age max-age)
           (boolean? include-subdomain?) (assoc :include-subdomains? include-subdomain?))
         (ring.mw.ssl/wrap-hsts handler))))

(defrecord SslRedirect [ssl-port]
  proto/RingMiddleware
  (wrap [this handler]
    (->> (cond-> {}
           (and (integer? ssl-port) (pos? ssl-port))
           (assoc :ssl-port ssl-port))
         (ring.mw.ssl/wrap-ssl-redirect handler))))

(defrecord ForwardedScheme [header]
  proto/RingMiddleware
  (wrap [this handler]
    (if (seq header)
      (ring.mw.ssl/wrap-forwarded-scheme handler header)
      (ring.mw.ssl/wrap-forwarded-scheme handler))))
