(ns fu.middleware.x-headers
  (:require [ring.middleware.x-headers :as ring.mw.x-headers]
            [zou.web.middleware.proto :as proto]))

(defrecord XHeaders [xss-protection frame-options content-type-options]
  proto/RingMiddleware
  (wrap [this handler]
    (cond-> handler
      (and (map? xss-protection) (seq xss-protection))
      (ring.mw.x-headers/wrap-xss-protection (:enable? xss-protection false) (dissoc xss-protection :enable?))

      (or (and (map? frame-options) (seq frame-options))
          (keyword? frame-options))
      (ring.mw.x-headers/wrap-frame-options frame-options)

      (or (and (map? content-type-options) (seq content-type-options))
          (keyword? content-type-options))
      (ring.mw.x-headers/wrap-content-type-options content-type-options))))
