(ns versionator.plugin
  (:require
   clojure.pprint
   [leiningen.versionator :refer [get-version]]))

(defn middleware
  [project]
  (let [code (str
              ";; Do not edit.  Generated by the versionator plugin.\n"
              "(ns " (:name project) ".versionator\n"
              "(def version \"" (get-version project) "\")\n")
        proj-dir (.toLowerCase (.replace (:name project) \- \_))
        filename (or (-> project :versionator :path)
                     (str (or (first (:source-paths project)) "src") "/"
                          proj-dir "/versionator.clj"))]
    (-> project
        (update-in [:injections] concat `[(spit ~filename ~code)])
        (assoc :version (get-version project))
        (assoc :current-versionator {:version (get-version project)}))))
