/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.channels;

import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.Closable;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionBuilder;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public abstract class AbstractMessagesSocketChannel
implements Closable {
    protected static final ExceptionBuilder EXCEPTION_BUILDER = new ExceptionBuilder(6);
    protected SocketChannel m_internal;
    protected ILogger m_log;
    protected AbstractInboundDataHandler m_dataHandler;

    public AbstractMessagesSocketChannel(SocketChannel socketChannel, AbstractInboundDataHandler abstractInboundDataHandler, ILogger iLogger) throws ErrorException {
        this.m_internal = socketChannel;
        this.m_log = iLogger;
        this.m_dataHandler = abstractInboundDataHandler;
        this.m_dataHandler.setSocketChannel(this);
    }

    public SocketChannel getSocketChannel() {
        return this.m_internal;
    }

    public abstract int getReadBufferCapacity();

    public abstract int getWriteBufferCapacity();

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.m_internal.close();
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, this.m_log);
        }
    }

    public synchronized void write(InboundMessagesPipeline inboundMessagesPipeline, AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        if (!this.m_internal.isConnected()) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Internal channel not connected", this.m_log);
            }
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name());
            throw errorException;
        }
        this.m_dataHandler.addPipeline(inboundMessagesPipeline);
        this.writeMessages(abstractOutboundMessageArray);
    }

    public synchronized void write(InboundMessagesPipeline inboundMessagesPipeline, Iterator<AbstractOutboundMessage> iterator) throws ErrorException {
        if (this.m_internal.isConnected()) {
            this.m_dataHandler.addPipeline(inboundMessagesPipeline);
            AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[1];
            while (iterator.hasNext()) {
                abstractOutboundMessageArray[0] = iterator.next();
                this.writeMessages(abstractOutboundMessageArray);
            }
        } else {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Internal channel not connected", this.m_log);
            }
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name());
            throw errorException;
        }
    }

    protected abstract void writeMessages(AbstractOutboundMessage[] var1) throws ErrorException;

    public void read() throws ErrorException, MessageBoundarySyncronizationLostException {
        if (!this.m_internal.isConnected()) {
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name());
            throw errorException;
        }
        this.readMessages();
    }

    protected abstract void readMessages() throws ErrorException, MessageBoundarySyncronizationLostException;
}

