/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.OperationMetadataImpl;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ParameterStatus;
import com.amazon.redshift.client.messages.inbound.ParseComplete;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.client.messages.outbound.Execute;
import com.amazon.redshift.client.messages.outbound.Sync;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class InboundDataHandler
extends AbstractInboundDataHandler
implements PGConstants {
    private static final char NULL_CHAR = '\uffff';
    public Map<String, String> m_parameterStatus;
    public KeyData m_keyData;
    private DataRow m_currentDataRow;
    private boolean m_processingDataRow;
    private char m_currentMessageType = (char)65535;
    private int m_currentMessageLength = -1;
    private OperationMetadataImpl m_currentOperationMetadata;
    private PGMessagingContext m_currentMessagingContext;
    private char m_lastMessageLogged = (char)88;
    private StringBuffer m_messageTypeLogging;
    private IWarningListener m_connectionWarningListener;
    protected IPGLogger m_log;

    public InboundDataHandler(IPGLogger iPGLogger, int n, int n2) {
        super(iPGLogger, n, n2);
        this.m_log = iPGLogger;
        this.m_parameterStatus = new HashMap<String, String>();
    }

    @Override
    public void closeOperation() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        super.closeOperation();
    }

    @Override
    protected boolean validateCurrentPipeline() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = super.validateCurrentPipeline();
        if (null != this.m_currentPipeline && this.m_currentPipeline instanceof PGMessagingContext) {
            this.m_currentMessagingContext = (PGMessagingContext)this.m_currentPipeline;
        }
        return bl;
    }

    private void logMessageType() {
        if ('\uffff' != this.m_currentMessageType) {
            if (this.m_lastMessageLogged != this.m_currentMessageType) {
                if (null != this.m_messageTypeLogging) {
                    LogUtilities.logDebug(this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
                    this.m_messageTypeLogging = null;
                }
                this.m_messageTypeLogging = new StringBuffer();
                this.m_messageTypeLogging.append("Message Type: ");
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            } else {
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            }
        } else if (null != this.m_messageTypeLogging) {
            LogUtilities.logDebug("Finally:" + this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
            this.m_messageTypeLogging = null;
        }
        this.m_lastMessageLogged = this.m_currentMessageType;
    }

    @Override
    public void handle(ByteBuffer byteBuffer) throws MessageBoundarySyncronizationLostException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        byteBuffer.rewind();
        if (this.m_log.isEnabled()) {
            LogUtilities.logInfo("Deserializing # of bytes: " + byteBuffer.remaining(), (ILogger)this.m_log);
        }
        try {
            if (this.m_processingDataRow) {
                this.sendOperationMetadata();
                this.m_currentDataRow.read(byteBuffer);
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Adding to Data row #" + this.m_currentOperationMetadata.m_dataRowCount + ", # of columns: " + this.m_currentDataRow.getNumberOfColumns(), (ILogger)this.m_log);
                }
                if (this.m_currentDataRow.isRowComplete()) {
                    ++this.m_currentOperationMetadata.m_dataRowCount;
                    this.addToPipeline(this.m_currentDataRow, false);
                    this.m_processingDataRow = false;
                    this.m_currentDataRow = null;
                } else {
                    return;
                }
            }
            while (byteBuffer.hasRemaining() && byteBuffer.remaining() > 5) {
                if ('\uffff' == this.m_currentMessageType) {
                    this.m_currentMessageType = (char)byteBuffer.get();
                    if (this.m_log.isEnabled()) {
                        this.logMessageType();
                    }
                }
                if (-1 == this.m_currentMessageLength) {
                    this.m_currentMessageLength = byteBuffer.getInt();
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Message Length: " + this.m_currentMessageLength, (ILogger)this.m_log);
                    }
                }
                if ('D' == this.m_currentMessageType && DataRow.getUniqueMessageSize() > byteBuffer.remaining() || 'D' != this.m_currentMessageType && this.m_currentMessageLength - 4 > byteBuffer.remaining()) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Next message spanning into the next buffer read, currently have " + byteBuffer.remaining() + " bytes. Message type: " + this.m_currentMessageType + ", total messages in pipeline:" + (null != this.m_currentPipeline ? Integer.valueOf(this.m_currentPipeline.m_totalMessageCount) : " pipeline is null") + ", length expected: " + this.m_currentMessageLength, (ILogger)this.m_log);
                    }
                    return;
                }
                switch (this.m_currentMessageType) {
                    case 'R': {
                        this.addToPipeline(new Authentication(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 'K': {
                        this.m_keyData = new KeyData(byteBuffer, this.m_log);
                        break;
                    }
                    case 'S': {
                        Object object = new ParameterStatus(byteBuffer, this.m_log);
                        this.m_parameterStatus.put(((ParameterStatus)object).getName(), ((ParameterStatus)object).getValue());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logInfo(((ParameterStatus)object).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'E': {
                        Object object = new ErrorResponse(byteBuffer, this.m_currentMessageLength, this.m_log);
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logError(((ErrorResponse)object).toString(), (ILogger)this.m_log);
                        }
                        if (0 == ((ErrorResponse)object).getTranslateSeverity().compareTo(ErrorResponse.Severity.FATAL) || 0 == ((ErrorResponse)object).getTranslateSeverity().compareTo(ErrorResponse.Severity.PANIC)) {
                            throw ((ErrorResponse)object).toErrorException();
                        }
                        if (!FilterUtilities.checkFilterLevel(((ErrorResponse)object).getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline((IInboundMessage)object, true);
                        if (null == this.m_currentOperationMetadata) {
                            this.m_currentOperationMetadata = new OperationMetadataImpl();
                        }
                        this.m_currentOperationMetadata.m_errorResponse = object;
                        this.sendOperationMetadata();
                        this.resetOperationMetadata();
                        break;
                    }
                    case 'N': {
                        Object object = new NoticeResponse(byteBuffer, this.m_currentMessageLength, this.m_log);
                        if (!FilterUtilities.checkFilterLevel(((ErrorResponse)object).getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline((IInboundMessage)object, true);
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(((ErrorResponse)object).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'A': {
                        Object object = new NotificationResponse(byteBuffer, this.m_log);
                        this.m_connectionWarningListener.postWarning(((NotificationResponse)object).toWarning());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(((NotificationResponse)object).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case '1': {
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_parseComplete = new ParseComplete(byteBuffer, this.m_log);
                        break;
                    }
                    case '2': {
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_bindComplete = new BindComplete(byteBuffer, this.m_log);
                        this.sendOperationMetadata();
                        break;
                    }
                    case 'T': {
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_rowDescription = new RowDescription(byteBuffer, this.m_log);
                        break;
                    }
                    case 't': {
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_parameterDescription = new ParameterDescription(byteBuffer, this.m_log);
                        break;
                    }
                    case 'n': {
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_noData = new NoData(byteBuffer, this.m_log);
                        break;
                    }
                    case 'D': {
                        this.sendOperationMetadata();
                        this.m_currentDataRow = new DataRow(byteBuffer, this.m_log, this.m_currentMessageLength);
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logDebug("Data row #" + this.m_currentOperationMetadata.m_dataRowCount + ", # of columns: " + this.m_currentDataRow.getNumberOfColumns(), (ILogger)this.m_log);
                        }
                        if (this.m_currentDataRow.isRowComplete()) {
                            ++this.m_currentOperationMetadata.m_dataRowCount;
                            this.addToPipeline(this.m_currentDataRow, false);
                            this.m_currentDataRow = null;
                            break;
                        }
                        this.m_processingDataRow = true;
                        break;
                    }
                    case 's': {
                        this.sendOperationMetadata();
                        Object object = new AbstractOutboundMessage[]{new Execute(this.m_currentMessagingContext.getPortalName(this.m_currentMessagingContext.getOperationMetadataSize() - 1), 0, this.m_log), new Sync(this.m_log)};
                        try {
                            this.m_socketChannel.write(null, (AbstractOutboundMessage[])object);
                        }
                        catch (ErrorException errorException) {
                            LogUtilities.logFatal(errorException, (ILogger)this.m_log);
                            throw errorException;
                        }
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logFatal("Portal suspended, reexecuting", (ILogger)this.m_log);
                        break;
                    }
                    case 'I': {
                        this.addToPipeline(new EmptyQueryResponse(byteBuffer, this.m_log), false);
                        this.sendOperationMetadata();
                        this.resetOperationMetadata();
                        break;
                    }
                    case 'C': {
                        Object object = new CommandComplete(byteBuffer, this.m_currentMessageLength, this.m_log);
                        this.addToPipeline((IInboundMessage)object, false);
                        this.setOperationMetadata(false);
                        this.m_currentOperationMetadata.m_commandCompleteReceivedFromWire = true;
                        this.m_currentOperationMetadata.m_openOperation.set(false);
                        this.sendOperationMetadata();
                        this.resetOperationMetadata();
                        break;
                    }
                    case '3': {
                        break;
                    }
                    case 'Z': {
                        Object object = new ReadyForQuery(byteBuffer, this.m_log);
                        if (null == object) break;
                        if (this.m_log.isEnabled()) {
                            if (((ReadyForQuery)object).isIdle()) {
                                LogUtilities.logDebug("Ready for query - idle.", (ILogger)this.m_log);
                            } else if (((ReadyForQuery)object).isTransactionBlock()) {
                                LogUtilities.logDebug("Ready for query - in transaction block.", (ILogger)this.m_log);
                            } else if (((ReadyForQuery)object).isFailedTransactionBlock()) {
                                LogUtilities.logFatal("Ready for query - in a failed transaction block.", (ILogger)this.m_log);
                            }
                        }
                        this.validateCurrentPipeline();
                        this.m_currentPipeline.closeCurrentOperation();
                        this.addToPipeline((IInboundMessage)object, false);
                        this.setOperationMetadata(true);
                        this.sendOperationMetadata();
                        this.resetOperationMetadata();
                        this.m_currentPipeline = null;
                        this.m_currentMessagingContext = null;
                        this.removeCurrentPipeline();
                        break;
                    }
                    default: {
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logError("Message boundary syncronization lost (unrecognized message type found). Terminate. Found message type: " + this.m_currentMessageType + ":ReadBuffer.remaining:" + byteBuffer.remaining() + ":ReadBuffer.pos:" + byteBuffer.position() + ":ReadBuffer.limit:" + byteBuffer.limit(), (ILogger)this.m_log);
                        }
                        throw new MessageBoundarySyncronizationLostException();
                    }
                }
                this.m_currentMessageType = (char)65535;
                this.m_currentMessageLength = -1;
            }
        }
        catch (Throwable throwable) {
            LogUtilities.logFatal("InboundDataHandler caught throwable: " + throwable.getMessage(), (ILogger)this.m_log);
            if (throwable instanceof ErrorException) {
                throw (ErrorException)throwable;
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
            errorException.initCause(throwable);
            throw errorException;
        }
        finally {
            if (this.m_log.isEnabled()) {
                this.logMessageType();
            }
            byteBuffer.compact();
        }
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_connectionWarningListener = iWarningListener;
    }

    private void setOperationMetadata(boolean bl) throws ErrorException {
        if (null == this.m_currentOperationMetadata) {
            this.validateCurrentPipeline();
            if (this.m_currentMessagingContext.getOperationMetadataSize() > 0) {
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.m_currentMessagingContext.getOperationMetadata(this.m_currentMessagingContext.getOperationMetadataSize() - 1, false);
                if (!operationMetadataImpl.m_commandCompleteReceivedFromWire || bl) {
                    this.m_currentOperationMetadata = operationMetadataImpl;
                    return;
                }
            }
            this.m_currentOperationMetadata = new OperationMetadataImpl();
        }
    }

    private void sendOperationMetadata() {
        this.validateCurrentPipeline();
        if (null != this.m_currentOperationMetadata) {
            this.m_currentPipeline.addOperationMetadata(this.m_currentOperationMetadata);
        }
    }

    private void resetOperationMetadata() {
        this.m_currentOperationMetadata = null;
    }

    @Override
    public boolean isOpenOperation() {
        if (null == this.m_currentOperationMetadata) {
            return false;
        }
        return this.m_currentOperationMetadata.m_openOperation.get();
    }
}

