/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.channels.AbstractMessagesSocketChannel;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.IOperationMetadata;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.OperationMetadataImpl;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.client.messages.outbound.Flush;
import com.amazon.redshift.client.messages.outbound.Sync;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class PGMessagingContext
extends InboundMessagesPipeline
implements PGConstants {
    private Authentication m_authentication;
    public int m_operationsExecuted = 0;
    public int m_currentOperationInPipeline = 0;
    public List<ParameterMetadata> m_parameterMetadata = null;
    public List<Integer> m_parameterOids = null;
    public short[] m_columnTypes = null;
    public boolean m_isCanceled = false;
    public DataRow m_currentDataRow;
    private List<byte[]> m_portalNames;
    public byte[] m_preparedStatementName;
    public boolean m_hasResults = false;
    public boolean m_isPreparedStatement = false;
    private AbstractOutboundMessage[] m_outboundMessagesFlushSync;
    private AbstractMessagesSocketChannel m_channel;
    protected IPGLogger m_log;
    private IWarningListener m_statementWarningListener;

    public PGMessagingContext(AbstractMessagesSocketChannel abstractMessagesSocketChannel, int n, IPGLogger iPGLogger, IWarningListener iWarningListener, IWarningListener iWarningListener2) {
        super(n, iPGLogger, iWarningListener);
        this.m_log = iPGLogger;
        this.m_channel = abstractMessagesSocketChannel;
        this.m_parameterMetadata = new ArrayList<ParameterMetadata>();
        this.m_parameterOids = new ArrayList<Integer>();
        this.m_statementWarningListener = iWarningListener2;
    }

    @Override
    protected boolean handleMessage(IInboundMessage iInboundMessage) throws ErrorException {
        if (null != iInboundMessage) {
            if (iInboundMessage instanceof InboundErrorMessage) {
                this.m_hasResults = true;
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(this.m_currentOperationInPipeline);
                if (null != operationMetadataImpl) {
                    operationMetadataImpl.m_openOperation.set(false);
                }
                this.closeCurrentOperation();
                this.sync();
                throw (InboundErrorMessage)iInboundMessage;
            }
            if (iInboundMessage instanceof NoticeResponse) {
                this.m_hasResults = true;
                this.handleErrorResponse((NoticeResponse)iInboundMessage);
            } else if (iInboundMessage instanceof Authentication) {
                this.m_hasResults = true;
                this.m_authentication = (Authentication)iInboundMessage;
            } else if (iInboundMessage instanceof DataRow) {
                this.m_hasResults = true;
                this.m_currentDataRow = (DataRow)iInboundMessage;
            } else if (iInboundMessage instanceof ErrorResponse) {
                this.m_hasResults = true;
                ErrorResponse errorResponse = (ErrorResponse)iInboundMessage;
                if (errorResponse.getTranslateSeverity() != ErrorResponse.Severity.FATAL) {
                    OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(this.m_currentOperationInPipeline);
                    operationMetadataImpl.m_errorResponse = errorResponse;
                }
                ++this.m_currentOperationInPipeline;
                this.handleErrorResponse(errorResponse);
            } else if (iInboundMessage instanceof CommandComplete) {
                this.m_hasResults = true;
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(this.m_currentOperationInPipeline);
                operationMetadataImpl.m_commandCompleteFromPipeline = (CommandComplete)iInboundMessage;
                operationMetadataImpl.m_openOperation.set(false);
                ++this.m_currentOperationInPipeline;
            } else if (iInboundMessage instanceof EmptyQueryResponse) {
                this.m_hasResults = true;
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(this.m_currentOperationInPipeline);
                operationMetadataImpl.m_emptyQueryResponse = (EmptyQueryResponse)iInboundMessage;
                ++this.m_currentOperationInPipeline;
            } else if (iInboundMessage instanceof ReadyForQuery) {
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(this.m_currentOperationInPipeline > 0 ? this.m_currentOperationInPipeline - 1 : 0);
                if (this.m_isPreparedStatement && !this.m_hasResults && null == operationMetadataImpl.m_readyForQueryFromPipelineForPrepare) {
                    operationMetadataImpl.m_readyForQueryFromPipelineForPrepare = (ReadyForQuery)iInboundMessage;
                } else {
                    operationMetadataImpl.m_readyForQueryFromPipelineForQuery = (ReadyForQuery)iInboundMessage;
                }
            }
        }
        return true;
    }

    private void handleErrorResponse(ErrorResponse errorResponse) throws ErrorException {
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug(errorResponse.toString(), (ILogger)this.m_log);
        }
        switch (errorResponse.getTranslateSeverity()) {
            case FATAL: 
            case PANIC: 
            case ERROR: {
                throw errorResponse.toErrorException();
            }
            case WARNING: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(errorResponse.toWarning());
                } else {
                    if (null != this.m_warningListener) {
                        this.m_warningListener.postWarning(errorResponse.toWarning());
                        break;
                    }
                    throw errorResponse.toErrorException();
                }
            }
            case DEBUG: 
            case INFO: 
            case LOG: 
            case NOTICE: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(errorResponse.toWarning());
                    break;
                }
                if (null == this.m_warningListener) break;
                this.m_warningListener.postWarning(errorResponse.toWarning());
            }
        }
    }

    public Authentication getAuthentication(int n) throws ErrorException {
        this.m_authentication = null;
        this.getNextMessageOfClass(Authentication.class, n);
        return this.m_authentication;
    }

    public RowDescription getRowDescription(int n) throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(n);
        if (null != operationMetadataImpl && null != operationMetadataImpl.m_rowDescription) {
            return operationMetadataImpl.m_rowDescription;
        }
        operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(0);
        if (null != operationMetadataImpl) {
            return operationMetadataImpl.m_rowDescription;
        }
        return null;
    }

    public NoData getNoData(int n) throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(n);
        if (null != operationMetadataImpl) {
            return operationMetadataImpl.m_noData;
        }
        return null;
    }

    public BindComplete getBindComplete(int n) throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(n);
        if (null != operationMetadataImpl) {
            return operationMetadataImpl.m_bindComplete;
        }
        return null;
    }

    public ParameterDescription getParameterDescription() throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(0);
        if (null != operationMetadataImpl) {
            return operationMetadataImpl.m_parameterDescription;
        }
        return null;
    }

    public boolean doMoveToNextRow(int n) throws ErrorException {
        return this.doMoveToNextClass(DataRow.class, n);
    }

    public CommandComplete getCommandCompleteMessage(int n) throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(n);
        if (null == operationMetadataImpl || null != operationMetadataImpl && null == operationMetadataImpl.m_commandCompleteFromPipeline) {
            if (!this.doMoveToNextClass(CommandComplete.class, n)) {
                LogUtilities.logFatal("PGMessagingContext.getCommandCompleteMessage():" + n + ":Ops", (ILogger)this.m_log);
            }
            if (null == operationMetadataImpl) {
                operationMetadataImpl = (OperationMetadataImpl)this.getOperationMetadata(n);
            }
        }
        if (null == operationMetadataImpl) {
            LogUtilities.logFatal("PGMessagingContext.getCommandCompleteMessage():" + n + ":Ops", (ILogger)this.m_log);
            return null;
        }
        this.doMoveToNextClass(null, n);
        return operationMetadataImpl.m_commandCompleteFromPipeline;
    }

    public boolean getErrorResponse(int n) throws ErrorException {
        return this.doMoveToNextClass(ErrorResponse.class, n);
    }

    public boolean getReadyForQuery(int n, boolean bl) throws ErrorException {
        return this.doMoveToNextClass(ReadyForQuery.class, n, bl);
    }

    public boolean doMoveToNextClass(Class clazz, int n) throws ErrorException {
        return this.doMoveToNextClass(clazz, n, true);
    }

    public boolean doMoveToNextClass(Class clazz, int n, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, clazz, n, this.m_currentOperationInPipeline);
        OperationMetadataImpl operationMetadataImpl = null;
        do {
            if (n >= this.m_currentOperationInPipeline) {
                if (this.getNextMessageOfClass(clazz, 0) && n <= this.m_currentOperationInPipeline) {
                    return true;
                }
            } else {
                return false;
            }
            if (!bl) continue;
            operationMetadataImpl = clazz == ReadyForQuery.class ? (OperationMetadataImpl)this.getOperationMetadata(n > 0 ? n - 1 : 0) : (OperationMetadataImpl)this.getOperationMetadata(n);
        } while ((null != operationMetadataImpl ? operationMetadataImpl.m_openOperation.get() : this.hasOpenOperation()) && !this.m_close);
        return false;
    }

    public void addPortalName(byte[] byArray) {
        if (null == this.m_portalNames) {
            this.m_portalNames = new ArrayList<byte[]>();
        }
        this.m_portalNames.add(byArray);
    }

    public void checkErrorResponse(int n) throws ErrorException {
        this.getNextMessageOfClass(ErrorResponse.class, n);
    }

    public void clearPortalNames() {
        if (null == this.m_portalNames) {
            this.m_portalNames = new ArrayList<byte[]>();
        } else {
            this.m_portalNames.clear();
        }
    }

    public byte[] getPortalName(int n) {
        if (null == this.m_portalNames || n > this.m_portalNames.size()) {
            return null;
        }
        return this.m_portalNames.get(n);
    }

    public int getPortalCount() {
        if (null != this.m_portalNames) {
            return this.m_portalNames.size();
        }
        return 0;
    }

    public void closeBatch(int n) {
        LogUtilities.logFunctionEntrance(this.m_log, n, this.m_query);
        try {
            if (null == this.getCommandCompleteMessage(n)) {
                LogUtilities.logFatal("PGMessagingContext.closeBatch():" + n + ":CC", (ILogger)this.m_log);
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logFatal(errorException, (ILogger)this.m_log);
        }
    }

    @Override
    public IOperationMetadata getOperationMetadata(int n) throws ErrorException {
        return this.getOperationMetadata(n, true);
    }

    public IOperationMetadata getOperationMetadata(int n, boolean bl) throws ErrorException {
        OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)super.getOperationMetadata(n);
        if (null != operationMetadataImpl && null != operationMetadataImpl.m_errorResponse && bl) {
            this.getReadyForQuery(n, false);
            this.handleErrorResponse(operationMetadataImpl.m_errorResponse);
            if (!operationMetadataImpl.m_syncSent.get()) {
                operationMetadataImpl.m_syncSent.set(true);
                this.sync();
            }
        }
        return operationMetadataImpl;
    }

    private void sync() throws ErrorException {
        if (null == this.m_outboundMessagesFlushSync) {
            this.m_outboundMessagesFlushSync = new AbstractOutboundMessage[2];
            this.m_outboundMessagesFlushSync[0] = new Flush(this.m_log);
            this.m_outboundMessagesFlushSync[1] = new Sync(this.m_log);
        }
        PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_channel, this.m_nRowMode, this.m_log, null, null);
        pGMessagingContext.openCurrentOperation();
        if (null != this.m_channel && this.m_channel.getSocketChannel().isConnected()) {
            this.m_channel.write((InboundMessagesPipeline)pGMessagingContext, this.m_outboundMessagesFlushSync);
            pGMessagingContext.getReadyForQuery(0, false);
        }
    }
}

