/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class DataRow
extends AbstractInboundMessage
implements PGConstants {
    public static final int COLUMN_NULL = -1;
    private final short m_numberOfColumns;
    private int m_messageLength;
    private final byte[] m_data;
    private int[] m_columnBeginIndexes;
    private int[] m_columnEndIndexes;
    private Object[] m_columnObjects;
    private String[] m_columnStrings;
    private int m_position;
    private final IPGLogger m_log;

    public DataRow(ByteBuffer byteBuffer, IPGLogger iPGLogger, int n) throws ErrorException {
        this.m_log = iPGLogger;
        this.m_numberOfColumns = byteBuffer.getShort();
        this.m_columnObjects = new Object[this.m_numberOfColumns];
        this.m_messageLength = n - 4 - 2;
        this.m_columnBeginIndexes = null;
        this.m_columnEndIndexes = null;
        try {
            this.m_data = new byte[this.m_messageLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LogUtilities.logFatal("OutOfMemoryError:DataRow:Size=" + n + ":" + outOfMemoryError.getMessage(), (ILogger)this.m_log);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), outOfMemoryError.getMessage() + ":DataRow:Size=" + n);
            errorException.initCause(outOfMemoryError);
            throw errorException;
        }
        this.read(byteBuffer);
        if (this.m_log.isExternalLoggerEnabled()) {
            this.logMessageContent(this.m_log);
        }
    }

    public void read(ByteBuffer byteBuffer) {
        int n = this.m_data.length - this.m_position;
        if (byteBuffer.remaining() < this.m_data.length - this.m_position) {
            n = byteBuffer.remaining();
        }
        byteBuffer.get(this.m_data, this.m_position, n);
        this.m_position += n;
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("DataRow read " + this.m_position + " bytes of expected " + this.m_data.length, (ILogger)this.m_log);
        }
    }

    public byte[] getData() {
        return this.m_data;
    }

    public void setConvertedObject(int n, Object object) {
        if (n <= this.m_numberOfColumns) {
            this.m_columnObjects[n] = object;
        }
    }

    public Object getConvertedObject(int n) {
        if (n <= this.m_numberOfColumns) {
            return this.m_columnObjects[n];
        }
        return null;
    }

    public void buildColumnIndexes() throws ErrorException {
        if (null == this.m_columnBeginIndexes) {
            this.m_columnBeginIndexes = new int[this.m_numberOfColumns];
            this.m_columnEndIndexes = new int[this.m_numberOfColumns];
            int n = 0;
            for (int i = 0; i < this.m_numberOfColumns; ++i) {
                int n2 = PGDataTypeUtilities.toInt(this.m_data, n);
                n += 4;
                if (-1 != n2) {
                    this.m_columnBeginIndexes[i] = n;
                    this.m_columnEndIndexes[i] = n2 - 1 + n;
                    n += n2;
                    continue;
                }
                this.m_columnBeginIndexes[i] = -1;
                this.m_columnEndIndexes[i] = -1;
            }
        }
    }

    public int getColumnBeginIndex(int n) throws ErrorException {
        this.buildColumnIndexes();
        return this.m_columnBeginIndexes[n];
    }

    public int getColumnEndIndex(int n) throws ErrorException {
        this.buildColumnIndexes();
        return this.m_columnEndIndexes[n];
    }

    public int getNumberOfColumns() {
        return this.m_numberOfColumns;
    }

    public static int getUniqueMessageSize() {
        return 2;
    }

    public boolean isRowComplete() {
        if (null == this.m_data) {
            return true;
        }
        return this.m_data.length == this.m_position;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE DataRow(" + this.m_messageLength + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nDataRow: getNumberOfColumns - ");
        stringBuffer.append(this.getNumberOfColumns());
        return stringBuffer.toString();
    }
}

