/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class FieldDescription
extends AbstractInboundMessage
implements PGConstants {
    private final byte[] m_fieldName;
    private final byte[] m_tableObjectID;
    private final short m_columnAttributeNumber;
    private final int m_dataTypeObjectID;
    private final int m_dataTypeSize;
    private final int m_dataTypeModifier;
    private final short m_formatCode;

    public FieldDescription(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        this.m_fieldName = this.getNullTerminatedField(byteBuffer);
        this.m_tableObjectID = new byte[4];
        byteBuffer.get(this.m_tableObjectID);
        this.m_columnAttributeNumber = byteBuffer.getShort();
        this.m_dataTypeObjectID = byteBuffer.getInt();
        int n = byteBuffer.getShort();
        this.m_dataTypeModifier = byteBuffer.getInt();
        this.m_formatCode = byteBuffer.getShort();
        int n2 = this.getDataTypeModifier();
        if (-1 == n) {
            if (n2 > 0) {
                n = n2;
                if (FieldDescription.isVariableLengthType(this.m_dataTypeObjectID)) {
                    n -= 4;
                }
            } else {
                n = 0;
            }
        }
        this.m_dataTypeSize = n;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public byte[] getFieldName() {
        return this.m_fieldName;
    }

    public byte[] getTableObjectID() {
        return this.m_tableObjectID;
    }

    public short getColumnAttributeNumber() {
        return this.m_columnAttributeNumber;
    }

    public int getDataTypeObjectID() {
        return this.m_dataTypeObjectID;
    }

    public int getDataTypeSize() {
        return this.m_dataTypeSize;
    }

    public int getDataTypeModifier() {
        return this.m_dataTypeModifier;
    }

    public short getFormatCode() {
        return this.m_formatCode;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = this.getFormatCode() == 0 ? "T" : "B";
        String string2 = "\t Field(" + new String(this.getFieldName()) + "," + this.getDataTypeObjectID() + "," + this.m_dataTypeSize + "," + string + ")";
        iPGLogger.logDebugExternal(string2);
    }

    public String toString() {
        return "\nFieldDescription: getFieldName - " + new String(this.getFieldName()) + "\ngetTableObjectID - " + new String(this.getTableObjectID()) + "\ngetColumnAttributeNumber - " + this.getColumnAttributeNumber() + "\ngetDataTypeObjectID - " + this.getDataTypeObjectID() + "\ngetDataTypeSize - " + this.getDataTypeSize() + "\ngetDataTypeModifier - " + this.getDataTypeModifier() + "\ngetFormatCode - " + this.getFormatCode();
    }

    private static boolean isVariableLengthType(int n) {
        return n == 25 || n == 1043 || n == 1562 || n == 1042;
    }
}

