/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import java.nio.ByteBuffer;

public class NotificationResponse
extends AbstractInboundMessage
implements Notification,
PGConstants {
    private static final String WARNING_MESSAGE_PART1 = "Notify,";
    private static final String WARNING_MESSAGE_PART2 = "name=";
    private static final String WARNING_MESSAGE_PART3 = ",payload=";
    private static final String WARNING_MESSAGE_PART4 = ",PID=";
    private int m_processID = -1;
    private String m_name = null;
    private String m_payload = null;

    public NotificationResponse(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        this.m_processID = PGDataTypeUtilities.toInt(byArray);
        this.m_name = new String(this.getNullTerminatedField(byteBuffer));
        this.m_payload = new String(this.getNullTerminatedField(byteBuffer));
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public NotificationResponse(Warning warning) {
        String string = warning.getMessage();
        string = string.replace(WARNING_MESSAGE_PART1, "");
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        int n3 = string.indexOf("=", n2);
        int n4 = string.indexOf(",", n2 + 1);
        int n5 = string.indexOf("=", n4);
        if (-1 != n && -1 != n2) {
            this.m_name = string.substring(n + 1, n2);
        }
        if (-1 != n3 && -1 != n4) {
            this.m_payload = string.substring(n3 + 1, n4);
        }
        if (-1 != n5) {
            this.m_processID = Integer.parseInt(string.substring(n5 + 1, string.length()));
        }
    }

    public Warning toWarning() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WARNING_MESSAGE_PART1);
        stringBuffer.append(WARNING_MESSAGE_PART2);
        stringBuffer.append(this.m_name);
        stringBuffer.append(WARNING_MESSAGE_PART3);
        stringBuffer.append(this.m_payload);
        stringBuffer.append(WARNING_MESSAGE_PART4);
        stringBuffer.append(this.m_processID);
        return new Warning(WarningCode.GENERAL_WARNING, stringBuffer.toString());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPayload() {
        return this.m_payload;
    }

    @Override
    public int getProcessId() {
        return this.m_processID;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE NotificationResponse(name=" + this.m_name + ", payload= " + this.m_payload + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        return "\nNotificationResponse: name - `" + this.m_name + "`, payload - `" + this.m_payload + "`";
    }
}

