/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class RowDescription
extends AbstractInboundMessage
implements PGConstants {
    private final short m_numberOfFields;
    private final FieldDescription[] m_fieldDescriptions;

    public RowDescription(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        this.m_numberOfFields = byteBuffer.getShort();
        this.m_fieldDescriptions = new FieldDescription[this.m_numberOfFields];
        for (int i = 0; i < this.m_numberOfFields; ++i) {
            this.m_fieldDescriptions[i] = new FieldDescription(byteBuffer, iPGLogger);
        }
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public int getNumberOfFields() {
        return this.m_numberOfFields;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this.m_fieldDescriptions;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE RowDescription(" + this.getNumberOfFields() + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nRowDescription: getNumberOfFields - ");
        stringBuffer.append(this.getNumberOfFields());
        for (FieldDescription fieldDescription : this.m_fieldDescriptions) {
            stringBuffer.append(fieldDescription.toString());
        }
        return stringBuffer.toString();
    }
}

