/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Query
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] query;

    public Query(String string, IPGLogger iPGLogger) {
        this.query = string.getBytes();
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)81);
        byteBuffer.put(byArray);
        byteBuffer.put(this.query);
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + this.query.length + 1;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "=>FE Query(" + new String(this.query) + ")";
        iPGLogger.logDebugExternal(string);
    }
}

