/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.exceptions.ErrorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PGCoreUtils {
    private static final String HOST_DELIMITER = "//";
    private static final String PORT_DELIMITER = ":";
    private static final String SCHEMA_DELIMITER = "/";
    private static final String KEY_VALUE_DELIMITER = ";";
    private static final String KEY_VALUE_DELIMITER_ALT_START = "?";
    private static final String KEY_VALUE_DELIMITER_ALT = "&";
    private static final String VALUE_DELIMITER = "=";
    private static final char SQL_QUERY_PARAMETER_SIGN = '?';
    private static final char PG_QUERY_PARAMETER_SIGN = '$';
    public static boolean REDSHIFT_SERVER = false;
    public static String SERVER_NAME = null;
    public static String SERVER_VERSION = null;
    public static String NON_VALIDATING_SSL_FACTORY = "org.postgresql.ssl.NonValidatingFactory";
    public static final List<FunctionDefinition> FUNCTION_DEFINITIONS;

    public static String parameterQueryBuilder(String string, ArrayList<String> arrayList) throws ErrorException {
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean bl = PGCoreUtils.parameterQueryAnalyzeHelper(string, '$', n, n2, arrayList2);
        if (arrayList2.size() == 0) {
            return string;
        }
        if (bl) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name(), "Error in building the parameter query");
            throw errorException;
        }
        if (arrayList2.size() != arrayList.size()) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name(), "Error in building the parameter query");
            throw errorException;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!arrayList2.contains(i)) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(arrayList.get(n3));
            ++i;
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String parameterQueryFormatter(String string, List<Integer> list) throws ErrorException {
        Serializable serializable;
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = PGCoreUtils.parameterQueryAnalyzeHelper(string, '?', n, n2, arrayList);
        String string2 = null;
        if (arrayList.size() != 0) {
            serializable = new StringBuilder();
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                if (!arrayList.contains(i)) {
                    serializable.append(string.charAt(i));
                    continue;
                }
                serializable.append('$').append(n3);
                ++n3;
            }
            string2 = serializable.toString();
        } else {
            string2 = string;
        }
        bl = PGCoreUtils.generateMetadataForRegisteredFunctions(string2, '$', n, n2, list);
        if (bl) {
            serializable = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name(), "Error in building the parameter query");
            throw serializable;
        }
        return string2;
    }

    public static int parameterCounter(String string) throws ErrorException {
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = PGCoreUtils.parameterQueryAnalyzeHelper(string, '?', n, n2, arrayList);
        if (arrayList.size() == 0) {
            return 0;
        }
        if (bl) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name(), "Error in building the parameter query");
            throw errorException;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            if (!arrayList.contains(i)) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append('$').append(n3);
            ++n3;
        }
        return n3;
    }

    public static boolean parseSubName(String string, Properties properties, boolean bl) {
        Object object;
        if (null == string || 0 == string.length() || !string.startsWith(HOST_DELIMITER)) {
            return false;
        }
        String string2 = string.trim().substring(HOST_DELIMITER.length());
        if (0 == string2.length()) {
            return false;
        }
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = string2.split(KEY_VALUE_DELIMITER);
        if (1 == stringArray.length && string2.contains(KEY_VALUE_DELIMITER_ALT_START)) {
            stringArray = string2.split("\\?|\\&");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                object = new String[]{"Host", "Port", "ConnSchema"};
                String string3 = stringArray[0];
                String string4 = null;
                String string5 = null;
                String string6 = null;
                int n = string3.indexOf(PORT_DELIMITER);
                int n2 = string3.indexOf(SCHEMA_DELIMITER);
                if (-1 == n) {
                    if (-1 != n2) {
                        string4 = string3.substring(0, n2);
                        string6 = string3.substring(n2 + 1, string3.length());
                        treeMap.put(object[2], string6);
                    } else {
                        string4 = string3;
                    }
                    treeMap.put(object[0], string4);
                    continue;
                }
                string4 = string3.substring(0, n);
                treeMap.put(object[0], string4);
                if (-1 != n2) {
                    string5 = string3.substring(n + 1, n2);
                    treeMap.put(object[1], string5);
                    string6 = string3.substring(n2 + 1, string3.length());
                    treeMap.put(object[2], string6);
                    continue;
                }
                string5 = string3.substring(n + 1, string3.length());
                treeMap.put(object[1], string5);
                continue;
            }
            object = stringArray[i].split(VALUE_DELIMITER);
            if (2 > ((String[])object).length) {
                treeMap.put(object[0], "");
                continue;
            }
            treeMap.put(object[0], object[1]);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (treeMap.containsKey(object)) continue;
            treeMap.put(object, properties.getProperty((String)object));
        }
        if (bl && treeMap.containsKey("OpenSourceSubProtocolOverride") && Boolean.parseBoolean((String)treeMap.get("OpenSourceSubProtocolOverride"))) {
            try {
                Class.forName("org.postgresql.Driver");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static TransactionVerb parseTransactionVerb(String string) {
        TransactionVerb transactionVerb = TransactionVerb.NONE;
        boolean bl = false;
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (string.charAt(i)) {
                case 'B': 
                case 'b': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "egin", i + 1)) {
                        transactionVerb = TransactionVerb.BEGIN;
                        i += "egin".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case 'C': 
                case 'c': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "ommit", i + 1)) {
                        transactionVerb = TransactionVerb.COMMIT;
                        i += "ommit".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case 'R': 
                case 'r': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "ollback", i + 1)) {
                        transactionVerb = TransactionVerb.ROLLBACK;
                        i += "ollback".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case '#': {
                    ++i;
                    while (string.length() > i && '\n' != string.charAt(i)) {
                        ++i;
                    }
                    continue block9;
                }
                case '-': {
                    if (i + 1 < string.length() && '-' == string.charAt(i + 1)) {
                        i += 2;
                        while (string.length() > i && '\n' != string.charAt(i)) {
                            ++i;
                        }
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case '/': {
                    int n;
                    if (i + 1 < string.length() && '*' == string.charAt(i + 1) && 0 < (n = string.indexOf("*/", i + 2))) {
                        i = n + 1;
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case ';': {
                    bl = true;
                    continue block9;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block9;
                    return TransactionVerb.NONE;
                }
            }
        }
        return transactionVerb;
    }

    public static int safeLongToInt(long l) throws ErrorException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_DATA_RETRIEVE_ERR.name(), "Error in getting the integer data");
            throw errorException;
        }
        return (int)l;
    }

    public static List<Notification> getNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        ArrayList<NotificationResponse> arrayList = null;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            NotificationResponse notificationResponse = null;
            arrayList = new ArrayList<NotificationResponse>();
            for (Warning warning : list) {
                if (null == warning || null == (notificationResponse = new NotificationResponse(warning)).getName()) continue;
                arrayList.add(notificationResponse);
            }
        }
        return arrayList;
    }

    public static void clearNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            list.clear();
        }
    }

    private static boolean parameterQueryAnalyzeHelper(String string, char c, int n, int n2, ArrayList<Integer> arrayList) {
        ParseStatus parseStatus = new ParseStatus();
        parseStatus.currentStrPointer = n;
        while (parseStatus.currentStrPointer < n2) {
            PGCoreUtils.skipEscapedContent(string, parseStatus, n2);
            if (string.charAt(parseStatus.currentStrPointer) == c) {
                arrayList.add(parseStatus.currentStrPointer);
                ++parseStatus.currentStrPointer;
                continue;
            }
            ++parseStatus.currentStrPointer;
        }
        return parseStatus.invalidQuery;
    }

    private static boolean generateMetadataForRegisteredFunctions(String string, char c, int n, int n2, List<Integer> list) {
        boolean bl = false;
        String string2 = string.toLowerCase();
        HashMap<Integer, FunctionDefinition> hashMap = new HashMap<Integer, FunctionDefinition>();
        block0: for (FunctionDefinition functionDefinition : FUNCTION_DEFINITIONS) {
            int n3 = n;
            while (-1 != (n3 = string2.indexOf(functionDefinition.functionName, n3))) {
                hashMap.put(n3, functionDefinition);
                if ((n3 += functionDefinition.functionName.length()) < string2.length()) continue;
                continue block0;
            }
        }
        if (0 == hashMap.size()) {
            return false;
        }
        ParseStatus parseStatus = new ParseStatus();
        parseStatus.currentStrPointer = n;
        while (parseStatus.currentStrPointer < n2) {
            FunctionDefinition functionDefinition;
            PGCoreUtils.skipEscapedContent(string2, parseStatus, n2);
            functionDefinition = (FunctionDefinition)hashMap.get(parseStatus.currentStrPointer);
            if (null != functionDefinition && PGCoreUtils.parseFunctionArguments(string2, parseStatus, n2, functionDefinition, hashMap, list)) {
                return true;
            }
            if (string2.charAt(parseStatus.currentStrPointer) == c) {
                list.add(0);
                ++parseStatus.currentStrPointer;
                continue;
            }
            ++parseStatus.currentStrPointer;
        }
        return bl;
    }

    private static boolean parseFunctionArguments(String string, ParseStatus parseStatus, int n, FunctionDefinition functionDefinition, Map<Integer, FunctionDefinition> map, List<Integer> list) {
        int n2 = 0;
        int n3 = 0;
        char c = string.charAt(parseStatus.currentStrPointer - 1);
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        parseStatus.currentStrPointer += functionDefinition.functionName.length();
        int n4 = string.indexOf(40, parseStatus.currentStrPointer);
        if (-1 == n4) {
            return true;
        }
        while (parseStatus.currentStrPointer < n4) {
            if (!Character.isWhitespace(string.charAt(parseStatus.currentStrPointer))) {
                return false;
            }
            ++parseStatus.currentStrPointer;
        }
        ++parseStatus.currentStrPointer;
        block1: while (parseStatus.currentStrPointer < n) {
            char c2;
            PGCoreUtils.skipEscapedContent(string, parseStatus, n);
            FunctionDefinition functionDefinition2 = map.get(parseStatus.currentStrPointer);
            if (null != functionDefinition2 && PGCoreUtils.parseFunctionArguments(string, parseStatus, n, functionDefinition2, map, list)) {
                return true;
            }
            if (0 == n2) {
                String string2 = string.substring(parseStatus.currentStrPointer);
                for (DelimiterDefinition delimiterDefinition : functionDefinition.delimiterSets) {
                    String string3;
                    if (delimiterDefinition.delimiters.size() <= n3 || !string2.startsWith(string3 = delimiterDefinition.delimiters.get(n3)) || delimiterDefinition.isWhiteSpaceRequired && (!delimiterDefinition.isWhiteSpaceRequired || !Character.isWhitespace(string.charAt(parseStatus.currentStrPointer - 1)) || !Character.isWhitespace(string2.charAt(string3.length())))) continue;
                    ++n3;
                    parseStatus.currentStrPointer += string3.length();
                    continue block1;
                }
            }
            if ('$' == (c2 = string.charAt(parseStatus.currentStrPointer))) {
                if (0 == n2) {
                    list.add(functionDefinition.oid.get(n3));
                } else {
                    list.add(0);
                }
            } else if ('(' == c2) {
                ++n2;
            } else if (')' == c2) {
                if (0 == n2) {
                    ++parseStatus.currentStrPointer;
                    return false;
                }
                --n2;
            }
            ++parseStatus.currentStrPointer;
        }
        return false;
    }

    private static boolean matchesRegionCI(String string, String string2, int n) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private static void skipEscapedContent(String string, ParseStatus parseStatus, int n) {
        switch (string.charAt(parseStatus.currentStrPointer)) {
            case '[': {
                int n2 = string.substring(parseStatus.currentStrPointer, n).indexOf("]");
                if (n2 != -1) {
                    parseStatus.currentStrPointer = n2 + parseStatus.currentStrPointer;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '\'': {
                int n3 = string.substring(parseStatus.currentStrPointer + 1, n).indexOf(39);
                if (n3 != -1) {
                    parseStatus.currentStrPointer = n3 + parseStatus.currentStrPointer + 1;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '\"': {
                int n4 = string.substring(parseStatus.currentStrPointer + 1, n).indexOf(34);
                if (n4 != -1) {
                    parseStatus.currentStrPointer = n4 + parseStatus.currentStrPointer + 1;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '-': {
                if (parseStatus.currentStrPointer + 1 >= n || string.charAt(parseStatus.currentStrPointer + 1) != '-') break;
                int n5 = string.substring(parseStatus.currentStrPointer, n).indexOf("\n");
                if (n5 != -1) {
                    parseStatus.currentStrPointer = n5 + parseStatus.currentStrPointer;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '/': {
                if (parseStatus.currentStrPointer + 2 >= n || string.charAt(parseStatus.currentStrPointer + 1) != '*') break;
                int n6 = string.substring(parseStatus.currentStrPointer, n).indexOf("*/");
                if (n6 != -1) {
                    parseStatus.currentStrPointer = n6 + parseStatus.currentStrPointer;
                    break;
                }
                parseStatus.invalidQuery = true;
            }
        }
    }

    static {
        ArrayList<FunctionDefinition> arrayList = new ArrayList<FunctionDefinition>();
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.functionName = "substring".toLowerCase();
        functionDefinition.oid = new ArrayList<Integer>();
        functionDefinition.oid.add(1043);
        functionDefinition.oid.add(23);
        functionDefinition.oid.add(23);
        DelimiterDefinition delimiterDefinition = new DelimiterDefinition();
        delimiterDefinition.isWhiteSpaceRequired = false;
        delimiterDefinition.delimiters.add(",");
        delimiterDefinition.delimiters.add(",");
        functionDefinition.delimiterSets.add(delimiterDefinition);
        DelimiterDefinition delimiterDefinition2 = new DelimiterDefinition();
        delimiterDefinition2.isWhiteSpaceRequired = true;
        delimiterDefinition2.delimiters.add("from");
        delimiterDefinition2.delimiters.add("for");
        functionDefinition.delimiterSets.add(delimiterDefinition2);
        arrayList.add(functionDefinition);
        FUNCTION_DEFINITIONS = Collections.unmodifiableList(arrayList);
    }

    private static class ParseStatus {
        int currentStrPointer;
        boolean invalidQuery = false;

        private ParseStatus() {
        }
    }

    public static enum TransactionVerb {
        BEGIN,
        COMMIT,
        ROLLBACK,
        NONE;

    }

    public static class DelimiterDefinition {
        List<String> delimiters = new ArrayList<String>();
        boolean isWhiteSpaceRequired;
    }

    public static class FunctionDefinition {
        public String functionName;
        public List<Integer> oid;
        public List<DelimiterDefinition> delimiterSets = new ArrayList<DelimiterDefinition>();
    }
}

