/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SWarningListener;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.TypeNames;
import com.amazon.utilities.conversion.TypeConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PGDSIOverrideHelper {
    public static void checkValidParameterIndex(int n, int n2, PGJDBCStatement pGJDBCStatement, SWarningListener sWarningListener) throws SQLException {
        if (pGJDBCStatement.hasReturnQuestionMark() && pGJDBCStatement.isCallableStatement()) {
            ++n;
        }
        if (1 > n2 || n < n2) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)sWarningListener, ExceptionType.DEFAULT, String.valueOf(n2));
        }
    }

    public static synchronized void registerOutParameter(int n, int n2, int n3, SWarningListener sWarningListener, List<ParameterType> list, Map<Integer, Integer> map, int n4, ArrayList<ParameterMetadata> arrayList) throws SQLException {
        if (0 > n3) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SCALE, (IWarningListener)sWarningListener, ExceptionType.DEFAULT, String.valueOf(n3), "0");
        }
        if (ParameterType.INPUT == list.get(n - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_REGISTER_TYPE, (IWarningListener)sWarningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
        }
        ParameterMetadata parameterMetadata = arrayList.get(n - 1);
        short s = parameterMetadata.getTypeMetadata().getType();
        if (!TypeConverter.canConvert(s, n2)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)sWarningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(n2));
        }
        if (TypeUtilities.isExactNumericType(n2)) {
            map.put(n, n3);
        }
    }

    public static DataWrapper getOutputParameterValue(int n, DataWrapper dataWrapper, ResultSet resultSet, int n2, ArrayList<ParameterMetadata> arrayList, int n3) throws SQLException {
        if (n != 1) {
            return null;
        }
        if (null != dataWrapper) {
            return dataWrapper;
        }
        if (resultSet != null) {
            resultSet.next();
            ParameterMetadata parameterMetadata = arrayList.get(0);
            dataWrapper = new DataWrapper();
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            int n4 = typeMetadata.getType();
            if (n2 != n3 && n2 != n4) {
                n4 = n2;
            }
            switch (n4) {
                case -5: {
                    dataWrapper.setBigInt(resultSet.getLong(1));
                    break;
                }
                case 4: {
                    dataWrapper.setInteger(resultSet.getInt(1));
                    break;
                }
                case 12: {
                    dataWrapper.setVarChar(resultSet.getString(1));
                    break;
                }
                case 5: {
                    dataWrapper.setSmallInt(resultSet.getShort(1));
                    break;
                }
                case 3: {
                    dataWrapper.setDouble(resultSet.getDouble(1));
                    break;
                }
                case 7: {
                    dataWrapper.setReal(resultSet.getFloat(1));
                    break;
                }
                case 8: {
                    dataWrapper.setDouble(resultSet.getDouble(1));
                    break;
                }
                case 16: {
                    dataWrapper.setBoolean(resultSet.getBoolean(1));
                    break;
                }
                case 1: {
                    dataWrapper.setChar(resultSet.getString(1));
                    break;
                }
                case 91: {
                    dataWrapper.setDate(resultSet.getDate(1));
                    break;
                }
                case 93: {
                    dataWrapper.setTimestamp(resultSet.getTimestamp(1));
                    break;
                }
                default: {
                    dataWrapper.setVarChar(resultSet.getString(1));
                }
            }
        }
        return dataWrapper;
    }

    public static synchronized void execute(ArrayList<ParameterMetadata> arrayList, List<Boolean> list, ILogger iLogger, SWarningListener sWarningListener, ParameterMetadata parameterMetadata, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        if (list.contains(Boolean.FALSE)) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)sWarningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(sQLException, iLogger);
            throw sQLException;
        }
        if (parameterMetadata.getParameterType() == ParameterType.OUTPUT && parameterMetadata.getTypeMetadata().getType() != (short)n) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException("INCONSISTENT TYPE REGISTERED", "EXPECTED java.sql.type=" + parameterMetadata.getTypeMetadata().getType() + " HOWEVER java.sql.type=" + n + " REGISTERED", 0, ExceptionType.NON_TRANSIENT);
            LogUtilities.logError(sQLException, iLogger);
            throw sQLException;
        }
    }
}

