/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIConnection;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.interfaces.ITransactionStateListener;
import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.ConnSettingResponseMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.exceptions.BadAttrValException;
import com.amazon.dsi.exceptions.BadAuthException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.common.CommonCoreUtils;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.core.BrandingPreferences;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.PGLogger;
import com.amazon.redshift.dataengine.PGScalarFunctionParser;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PGJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private PGClient m_postgresqlClient;
    protected ILogger m_log;
    protected IPGLogger m_driverlog;
    private PGJDBCSettings m_settings;
    private final Lock m_txLock = new ReentrantLock();
    private static final String POSTGRESQL_LOG_NAME_PREFIX = "RedshiftJDBC_connection_";
    private static final int MIN_LOGIN_TIMEOUT = 0;
    private static final int DEFAULT_SOCKET_TIMEOUT = 0;

    public PGJDBCConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            this.setProperty(136, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(137, new Variant(7, 11L));
            this.setProperty(1009, new Variant(6, 1));
        }
        catch (NumericOverflowException numericOverflowException) {
            LogUtilities.logError(numericOverflowException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            LogUtilities.logError(incorrectTypeException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), incorrectTypeException);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    public PGClient getPostgresqlClient() {
        return this.m_postgresqlClient;
    }

    public PGJDBCSettings getConnectionSettings() {
        return this.m_settings;
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant;
        Variant variant2;
        Variant variant3;
        Object object;
        Comparable<Boolean> comparable;
        String[] stringArray;
        CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, PGJDBCDriver.DRIVER_MAJOR_VERSION, PGJDBCDriver.DRIVER_MINOR_VERSION, PGJDBCDriver.DRIVER_HOT_FIX_VERSION, PGJDBCDriver.DRIVER_BUILD_NUMBER);
        this.m_settings = new PGJDBCSettings();
        this.m_settings.m_host = this.getRequiredSetting("Host", connSettingRequestMap).getString();
        Variant variant4 = this.getRequiredSetting("Port", connSettingRequestMap);
        this.m_settings.m_Schema = this.getRequiredSetting("ConnSchema", connSettingRequestMap).getString();
        this.m_settings.m_username = this.getRequiredSetting("UID", connSettingRequestMap).getString();
        this.m_settings.m_password = this.getRequiredSetting("PWD", connSettingRequestMap).getString();
        this.m_settings.m_loginTimeoutMS = 0;
        this.m_settings.m_rowsFetchedPerBlock = 10000;
        this.m_settings.m_authMech = BrandingPreferences.defaultSslOption;
        this.m_settings.m_newTCPConnectionKeepAliveMinutes = 0;
        this.m_settings.m_validate = Boolean.FALSE;
        this.m_settings.m_nRowMode = 0;
        this.m_settings.m_socketTimeoutMS = 0;
        try {
            this.m_settings.m_port = variant4.getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        Variant variant5 = this.getOptionalSetting("BlockingRowsMode", connSettingRequestMap);
        if (null != variant5) {
            try {
                this.m_settings.m_nRowMode = variant5.getInt();
                if (this.m_settings.m_nRowMode < 0) {
                    this.m_settings.m_nRowMode = 0;
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
                } else if (0 < this.m_settings.m_nRowMode && this.m_settings.m_nRowMode < 5) {
                    this.m_settings.m_nRowMode = 5;
                    stringArray = new String[2];
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("The given value is too small. Falling back to the default value ");
                    stringArray[0] = "BlockingRowsMode";
                    stringArray[1] = ((StringBuilder)comparable).toString();
                    object = new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
                    this.getWarningListener().postWarning((Warning)object);
                }
            }
            catch (Exception exception) {
                this.m_settings.m_nRowMode = 0;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
            }
        }
        this.m_settings.m_filterLevel = null != (stringArray = this.getOptionalSetting("FilterLevel", connSettingRequestMap)) ? stringArray.getString() : "NOTICE";
        comparable = null;
        object = this.getOptionalSetting("tcpKeepAlive", connSettingRequestMap);
        if (null != object) {
            if (0 == ((Variant)object).getString().length() || Boolean.parseBoolean(((Variant)object).getString())) {
                comparable = true;
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
            } else {
                comparable = false;
            }
        } else {
            comparable = true;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
        }
        object = this.getOptionalSetting("TCPKeepAliveMinutes", connSettingRequestMap);
        if (null != object) {
            try {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = ((Variant)object).getInt();
            }
            catch (Exception exception) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
            if (null != comparable && (((Boolean)comparable).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes == 0 || !((Boolean)comparable).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes != 0)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), new String[]{"tcpKeepAlive", "TCPKeepAliveMinutes"});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            if (this.m_settings.m_newTCPConnectionKeepAliveMinutes < 0) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
        }
        if (null != (variant3 = this.getOptionalSetting("ssl", connSettingRequestMap)) && (Boolean.parseBoolean(variant3.getString()) || variant3.getString().equals(""))) {
            this.m_settings.m_authMech = AuthMech.REQUIRE;
        }
        Variant variant6 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        AuthMech authMech = null;
        if (null != variant6) {
            try {
                authMech = AuthMech.valueOf(variant6.getString().toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < AuthMech.values().length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((Object)AuthMech.values()[i]);
                }
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"AuthMech", stringBuffer.toString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        if (null != variant3 && null != variant6 && null != this.m_settings.m_authMech && this.m_settings.m_authMech != authMech) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), new String[]{"AuthMech", "ssl"});
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        if (null != authMech) {
            this.m_settings.m_authMech = authMech;
        }
        if (AuthMech.REQUIRE == this.m_settings.m_authMech) {
            variant2 = this.getOptionalSetting("sslfactory", connSettingRequestMap);
            this.m_settings.m_validate = null != variant2 && this.isNonValidationFactory(variant2.getString()) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (null != (variant2 = this.getOptionalSetting("socketTimeout", connSettingRequestMap))) {
            try {
                int n = variant2.getInt();
                if (n > 0) {
                    this.m_settings.m_socketTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
            }
        }
        if (DriverManager.getLoginTimeout() > 0) {
            this.m_settings.m_loginTimeoutMS = DriverManager.getLoginTimeout() * 1000;
        }
        if (null != (variant = this.getOptionalSetting("loginTimeout", connSettingRequestMap))) {
            try {
                int n = variant.getInt();
                if (n > 0) {
                    this.m_settings.m_loginTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
            }
        }
        this.m_postgresqlClient = new PGClient(this.m_settings, this.getDriverConnectionLog(), this.getWarningListener());
        this.incrementConnectionID();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    public IStatement prepareStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(POSTGRESQL_LOG_NAME_PREFIX + Integer.toString(s_connectionID));
            this.m_log.setLocale(this.getLocale());
        }
        return this.m_log;
    }

    public IPGLogger getDriverConnectionLog() {
        if (null == this.m_driverlog) {
            this.m_driverlog = new PGLogger(POSTGRESQL_LOG_NAME_PREFIX, s_connectionID);
            this.m_driverlog.setLocale(this.getLocale());
        }
        return this.m_driverlog;
    }

    @Override
    public String toNativeSQL(String string) {
        String string2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            string2 = string.trim();
            if (string2.charAt(0) == '{' && string2.length() > 1 && (string2 = string2.substring(1, string2.length()).trim()).length() > 6 && string2.charAt(string2.length() - 1) == '}') {
                String string3 = string2.trim().substring(0, "CALL".length()).toUpperCase();
                if (!string3.equals("CALL")) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_DICONNECT_ERR.name(), new String[]{"Wrong procedure call format"}));
                    return string;
                }
                string2 = string2.substring(0, string2.length() - 1).trim();
                if ((string2 = string2.substring("CALL".length())).charAt(string2.length() - 1) != ')') {
                    string2 = string2 + "()";
                }
                stringBuilder.append("SELECT").append(" ").append(string2.trim());
                String string4 = PGScalarFunctionParser.scalarFunctionParse(stringBuilder.toString());
                return string4;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_DICONNECT_ERR.name(), new String[]{"Wrong procedure call format"}));
            return string;
        }
        string2 = PGScalarFunctionParser.scalarFunctionParse(string);
        return string2;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String string : PGJDBCPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : PGJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        switch (n) {
            case 26: {
                try {
                    if (1L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read uncommitted'", null);
                        break;
                    }
                    if (2L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read committed'", null);
                        break;
                    }
                    if (4L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='repeatable read'", null);
                        break;
                    }
                    if (8L != variant.getLong()) break;
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='serializable'", null);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    LogUtilities.logError(numericOverflowException, this.m_log);
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    break;
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    LogUtilities.logError(incorrectTypeException, this.m_log);
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), incorrectTypeException.getMessage());
                    errorException.initCause(incorrectTypeException);
                }
            }
        }
        super.setProperty(n, variant);
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("BEGIN;", null);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("COMMIT;", null);
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        this.m_postgresqlClient.directExecuteImmediately("SAVEPOINT JDBC_SYNTH_SP_" + string + ";", null);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        super.registerWarningListener(iWarningListener);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.registerWarningListener(iWarningListener);
        }
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        this.m_postgresqlClient.directExecuteImmediately("RELEASE SAVEPOINT JDBC_SYNTH_SP_" + string + ";", null);
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK;", null);
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK TO SAVEPOINT JDBC_SYNTH_SP_" + string + ";", null);
    }

    final Lock getTransactionLock() {
        return this.m_txLock;
    }

    final ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    private boolean isNonValidationFactory(String string) {
        boolean bl = false;
        if (string.equals(PGCoreUtils.NON_VALIDATING_SSL_FACTORY) || string.equals(NonValidatingFactory.class.getName())) {
            bl = true;
        }
        return bl;
    }

    private Warning buildWarningForIncorrectIntPropertyValue(String string) {
        String[] stringArray = new String[2];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Numbers between 0 and 2147483647");
        stringBuilder.append(". The value is either negative, too large or not a number. ");
        stringBuilder.append("Falling back to the default value");
        stringArray[0] = string;
        stringArray[1] = stringBuilder.toString();
        return new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementConnectionID() {
        PGJDBCConnection pGJDBCConnection = this;
        synchronized (pGJDBCConnection) {
            ++s_connectionID;
        }
    }
}

