/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIStatement;
import com.amazon.dsi.dataengine.interfaces.IDataEngine;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGJDBCIDataEngine;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class PGJDBCStatement
extends DSIStatement {
    private ExpectedResult m_expectedResult;
    private List<PGMessagingContext> m_messagingContexts;
    private PGClient m_client;
    private int m_socketTimeoutMS;
    private boolean m_isCallableStatement;
    private boolean m_hasReturnQuestionMark = false;
    private int[] m_parameterOID;

    public PGJDBCStatement(PGJDBCConnection pGJDBCConnection, PGClient pGClient, int n) throws ErrorException {
        super(pGJDBCConnection);
        this.m_client = pGClient;
        this.m_socketTimeoutMS = n;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        try {
            if (null != this.m_messagingContexts) {
                for (PGMessagingContext pGMessagingContext : this.m_messagingContexts) {
                    if (null == pGMessagingContext.m_preparedStatementName) continue;
                    this.m_client.closePreparedStatement(pGMessagingContext, null);
                    pGMessagingContext.m_preparedStatementName = null;
                }
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, this.getLog());
        }
    }

    @Override
    public IDataEngine createDataEngine() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return new PGJDBCIDataEngine(this, ((PGJDBCConnection)this.getParentConnection()).getPostgresqlClient(), this.getLog(), this.m_socketTimeoutMS);
    }

    public void setExpectedResult(ExpectedResult expectedResult) {
        this.m_expectedResult = expectedResult;
    }

    public ExpectedResult getExpectedResult() {
        return this.m_expectedResult;
    }

    public void pushContexts(List<PGMessagingContext> list) {
        this.m_messagingContexts = list;
    }

    public boolean isCallableStatement() {
        return this.m_isCallableStatement;
    }

    public boolean hasReturnQuestionMark() {
        return this.m_hasReturnQuestionMark;
    }

    public int[] getParameterOID() {
        return this.m_parameterOID;
    }

    public Lock getTransactionLock() {
        return ((PGJDBCConnection)this.getParentConnection()).getTransactionLock();
    }

    public void notifyTransaction(PGCoreUtils.TransactionVerb transactionVerb) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{transactionVerb});
        if (null == transactionVerb || PGCoreUtils.TransactionVerb.NONE == transactionVerb) {
            return;
        }
        PGJDBCConnection pGJDBCConnection = (PGJDBCConnection)this.getParentConnection();
        switch (transactionVerb) {
            case BEGIN: {
                pGJDBCConnection.getTransactionStateListener().notifyBeginTransaction();
                break;
            }
            case COMMIT: {
                pGJDBCConnection.getTransactionStateListener().notifyCommit();
                break;
            }
            case ROLLBACK: {
                pGJDBCConnection.getTransactionStateListener().notifyRollback();
                break;
            }
            default: {
                throw new IllegalArgumentException("" + (Object)((Object)transactionVerb));
            }
        }
    }

    public void setIsCallableStatement(boolean bl) {
        this.m_isCallableStatement = bl;
    }

    public void sethasReturnQuestionMark(boolean bl) {
        this.m_hasReturnQuestionMark = bl;
    }

    public void setparameterOID(int[] nArray) {
        this.m_parameterOID = nArray;
    }
}

