/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc41.S41DatabaseMetaData;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PGJDBC41DatabaseMetaData
extends S41DatabaseMetaData {
    public PGJDBC41DatabaseMetaData(IConnection iConnection, SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
        try {
            this.setDefaultProperties((PGJDBCConnection)iConnection);
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
    }

    private void setDefaultProperties(PGJDBCConnection pGJDBCConnection) throws ErrorException {
        Object object;
        PGResultSet pGResultSet = new PGResultSet(pGJDBCConnection.getPostgresqlClient().directExecute("SELECT character_value, version() FROM INFORMATION_SCHEMA.SQL_IMPLEMENTATION_INFO WHERE implementation_info_id = '17' or implementation_info_id = '18'", 0, null).get(0), 0, this.m_logger);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (pGResultSet.hasMoreRows()) {
            DataWrapper dataWrapper = new DataWrapper();
            if (!pGResultSet.moveToNextRow()) continue;
            pGResultSet.getData(0, 0L, -1L, dataWrapper);
            try {
                object = dataWrapper.getVarChar();
                if (null != object) {
                    arrayList.add((String)object);
                } else {
                    arrayList.add("");
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), incorrectTypeException);
            }
            pGResultSet.getData(1, 0L, -1L, dataWrapper);
            try {
                object = dataWrapper.getVarChar();
                if (null == object || !((String)object).matches("(?i:.*redshift.*)")) continue;
                PGCoreUtils.REDSHIFT_SERVER = true;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                LogUtilities.logError(incorrectTypeException, this.m_logger);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), incorrectTypeException.getCause());
            }
        }
        pGResultSet.close();
        PGCoreUtils.SERVER_NAME = (String)arrayList.get(0);
        PGCoreUtils.SERVER_VERSION = (String)arrayList.get(1);
        int n = Integer.parseInt(PGCoreUtils.SERVER_VERSION.split("\\.")[0]);
        if (n >= 9) {
            pGJDBCConnection.getPostgresqlClient().directExecuteImmediately("SET extra_float_digits = 3", null);
        }
        object = new ArrayList();
        PGResultSet pGResultSet2 = new PGResultSet(pGJDBCConnection.getPostgresqlClient().directExecute("SELECT supported_value FROM INFORMATION_SCHEMA.SQL_SIZING WHERE sizing_id = 34 or sizing_id = 30 or sizing_id = 31 or sizing_id = 10005 or sizing_id = 32 or sizing_id = 35 or sizing_id = 107 or sizing_id = 97 or sizing_id = 99 or sizing_id = 100 or sizing_id = 101", 0, null).get(0), 0, this.m_logger);
        while (pGResultSet2.hasMoreRows()) {
            DataWrapper dataWrapper = new DataWrapper();
            pGResultSet2.moveToNextRow();
            pGResultSet2.getData(0, 0L, -1L, dataWrapper);
            try {
                int n2 = -1;
                if (null != dataWrapper.getInteger()) {
                    n2 = PGCoreUtils.safeLongToInt(dataWrapper.getInteger());
                }
                ((ArrayList)object).add(n2);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), incorrectTypeException);
            }
        }
        pGResultSet2.close();
        try {
            pGJDBCConnection.setProperty(101, new Variant(0, "PostgreSQLJDBCDriver"));
            pGJDBCConnection.setProperty(139, new Variant(0, "User"));
            pGJDBCConnection.setProperty(22, new Variant(0, pGJDBCConnection.getConnectionSettings().m_Schema));
            pGJDBCConnection.setProperty(58, new Variant(0, "\""));
            pGJDBCConnection.setProperty(80, new Variant(0, "N"));
            pGJDBCConnection.setProperty(69, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(0)).intValue())));
            pGJDBCConnection.setProperty(71, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(1)).intValue())));
            pGJDBCConnection.setProperty(72, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(2)).intValue())));
            pGJDBCConnection.setProperty(73, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(3)).intValue())));
            pGJDBCConnection.setProperty(66, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(4)).intValue())));
            pGJDBCConnection.setProperty(68, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(5)).intValue())));
            pGJDBCConnection.setProperty(75, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(6)).intValue())));
            pGJDBCConnection.setProperty(76, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(7)).intValue())));
            pGJDBCConnection.setProperty(81, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(8)).intValue())));
            pGJDBCConnection.setProperty(83, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(9)).intValue())));
            pGJDBCConnection.setProperty(85, new Variant(2, Character.valueOf((char)((Integer)((ArrayList)object).get(10)).intValue())));
            pGJDBCConnection.setProperty(41, new Variant(0, PGCoreUtils.SERVER_NAME));
            pGJDBCConnection.setProperty(42, new Variant(0, PGCoreUtils.SERVER_VERSION));
            pGJDBCConnection.setProperty(74, new Variant(2, Character.valueOf('\u0001')));
        }
        catch (Exception exception) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getCause());
        }
    }
}

