/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class PGBatchQueryExecutor
extends PGAbstractQueryExecutor {
    private Map<PGMessagingContext, Integer> m_parameterCountPerQuery = new HashMap<PGMessagingContext, Integer>();
    private List<String> m_queries;
    private List<PGCoreUtils.TransactionVerb> m_txCommands;

    public PGBatchQueryExecutor(List<String> list, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, list, pGClient);
        this.m_queries = list;
        this.m_log = iLogger;
        this.m_isDirectExecute = bl;
        this.m_client = pGClient;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_contexts = new ArrayList();
        ArrayList<PGCoreUtils.TransactionVerb> arrayList = new ArrayList<PGCoreUtils.TransactionVerb>(list.size());
        for (String string : list) {
            object = PGCoreUtils.parseTransactionVerb(string);
            if (PGCoreUtils.TransactionVerb.NONE != object) {
                this.m_txCommands = arrayList;
            }
            arrayList.add((PGCoreUtils.TransactionVerb)((Object)object));
        }
        if (!bl) {
            for (String string : list) {
                object = new ArrayList();
                string = PGCoreUtils.parameterQueryFormatter(string, (List<Integer>)object);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string, (List<Integer>)object, pGJDBCStatement.getWarningListener());
                pGMessagingContext.addSocketCloseListener(this);
                this.m_contexts.add(pGMessagingContext);
            }
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        PGCoreUtils.TransactionVerb transactionVerb;
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.m_queries.size(); ++i) {
                stringBuilder.append(this.m_queries.get(i));
                if (i >= this.m_queries.size() - 1) continue;
                stringBuilder.append(", ");
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", stringBuilder.toString()}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            if (null != this.m_txCommands) {
                Lock lock = this.m_statement.getTransactionLock();
                lock.lock();
                try {
                    Iterator<PGCoreUtils.TransactionVerb> object3 = this.m_txCommands.iterator();
                    for (String string : this.m_queries) {
                        transactionVerb = object3.next();
                        if (PGCoreUtils.TransactionVerb.NONE == transactionVerb) {
                            this.m_contexts.addAll(this.m_client.directExecute(string, n, this.m_statement.getWarningListener()));
                            continue;
                        }
                        this.m_contexts.add(this.m_client.directExecuteImmediately(string, this.m_statement.getWarningListener()));
                        this.m_statement.notifyTransaction(transactionVerb);
                    }
                }
                finally {
                    lock.unlock();
                }
            } else {
                for (String errorException : this.m_queries) {
                    this.m_contexts.addAll(this.m_client.directExecute(errorException, n, this.m_statement.getWarningListener()));
                }
            }
        } else {
            try {
                Object object;
                Iterator<Object> iterator;
                int n2 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --n2;
                }
                HashMap hashMap = new HashMap(this.m_contexts.size());
                if (n2 != 0) {
                    iterator = executionContexts.contextIterator();
                    while (iterator.hasNext()) {
                        ExecutionContext executionContext = (ExecutionContext)iterator.next();
                        int n3 = 0;
                        for (Integer n4 : this.m_parameterCountPerQuery.values()) {
                            byte[][] byArrayArray = new byte[n4.intValue()][];
                            object = null;
                            int n5 = 0;
                            while (n5 < n4 && n3 < executionContext.getInputs().size()) {
                                ParameterInputValue parameterInputValue = executionContext.getInputs().get(n3);
                                byArrayArray[n5] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                                ++n5;
                                if (null == object) {
                                    object = ((PGParameterMetadata)parameterInputValue.getMetadata()).getContext();
                                }
                                ++n3;
                            }
                            hashMap.put(object, byArrayArray);
                        }
                    }
                }
                iterator = null;
                Object var7_23 = null;
                if (null != this.m_txCommands) {
                    iterator = this.m_txCommands.iterator();
                    Lock lock = this.m_statement.getTransactionLock();
                    lock.lock();
                }
                try {
                    transactionVerb = PGCoreUtils.TransactionVerb.NONE;
                    for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                        if (null != iterator) {
                            transactionVerb = (PGCoreUtils.TransactionVerb)((Object)iterator.next());
                        }
                        int n6 = this.m_parameterCountPerQuery.get(pGMessagingContext);
                        object = new ArrayList();
                        ((ArrayList)object).add(hashMap.get(pGMessagingContext));
                        if (n > 5) {
                            pGMessagingContext.setNRowMode(n);
                        }
                        if (n6 != 0) {
                            if (1 == ((ArrayList)object).size()) {
                                this.m_client.executePreparedStatement(pGMessagingContext, (byte[][])((ArrayList)object).get(0), false, false);
                                continue;
                            }
                            byte[][][] byArrayArray = new byte[n6][][];
                            for (int i = 0; i < byArrayArray.length; ++i) {
                                byArrayArray[i] = (byte[][])((ArrayList)object).get(i);
                            }
                            this.m_client.executePreparedStatementBatch(pGMessagingContext, this.m_currentExecuteIndex, byArrayArray, false);
                            continue;
                        }
                        this.m_client.executePreparedStatement(pGMessagingContext, null, false, false);
                        if (PGCoreUtils.TransactionVerb.NONE == transactionVerb) continue;
                        pGMessagingContext.closeBatch(0);
                        this.m_statement.notifyTransaction(transactionVerb);
                    }
                }
                finally {
                    void var7_25;
                    if (null != var7_25) {
                        var7_25.unlock();
                    }
                }
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
        this.m_statement.pushContexts(this.m_contexts);
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.addSocketCloseListener(this);
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
        List<ParameterMetadata> list = null;
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            list = this.getMetadataForParameters(pGMessagingContext);
            this.m_parameterCountPerQuery.put(pGMessagingContext, list.size());
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_queries.get(0));
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return this.m_parameterCountPerQuery.get(pGMessagingContext);
    }
}

