/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.support.exceptions.ErrorException;
import java.util.Map;

public class PGCatalogQueryBuilder {
    public static String BuildCatalogQuery(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = null;
        switch (metadataSourceID) {
            case CATALOG_ONLY: {
                string = PGCatalogQueryBuilder.BuildCatalogOnlyQuery();
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                string = PGCatalogQueryBuilder.BuildCatalogSchemaOnlyQuery();
                break;
            }
            case TABLES: {
                string = PGCatalogQueryBuilder.BuildTablesQuery(map);
                break;
            }
            case TABLE_PRIVILEGES: {
                string = PGCatalogQueryBuilder.BuildTablePriviledgesQuery(map);
                break;
            }
            case COLUMNS: {
                string = PGCatalogQueryBuilder.BuildColumnsQuery(map);
                break;
            }
            case FOREIGN_KEYS: {
                string = PGCatalogQueryBuilder.BuildForeignKeysQuery(map);
                break;
            }
            case PRIMARY_KEYS: {
                string = PGCatalogQueryBuilder.BuildPrimaryKeysQuery(map);
                break;
            }
            case PROCEDURES: {
                string = PGCatalogQueryBuilder.BuildProceduresQuery(map);
                break;
            }
            case PROCEDURE_COLUMNS: {
                string = PGCatalogQueryBuilder.BuildProcedureColumnsQuery(map);
                break;
            }
            case FUNCTIONS_JDBC4: {
                string = PGCatalogQueryBuilder.BuildFunctionsQuery(map);
                break;
            }
            default: {
                string = "Query not support";
            }
        }
        return string;
    }

    public static String buildProcedureColumnsQueryForOldPostgres(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string4 = "SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, CAST( 'returnValue' AS VARCHAR(256)) AS COLUMN_NAME, CAST(5 AS SMALLINT) AS COLUMN_TYPE, prorettype AS DATA_TYPE, CAST(NULL AS SMALLINT) AS COLUMN_SIZE, CAST(NULL AS SMALLINT) AS BUFFER_LENGTH, CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS, CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX, CAST(2 AS SMALLINT) AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH, CAST(0 AS SMALLINT) AS ORDINAL_POSITION, CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.oid AS SPECIFIC_NAME, p.proargtypes,  p.proargnames FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (null != string && !string.equals("")) {
            string4 = string4 + " AND  n.nspname LIKE '" + string + "' ";
            if (null != string2 && !string2.equals("")) {
                string4 = string4 + " AND  proname LIKE '" + string2 + "' ";
            }
        } else if (null != string2 && !string2.equals("")) {
            string4 = string4 + " AND  proname LIKE '" + string2 + "' ";
        }
        string4 = string4 + " ORDER BY n.nspname, p.proname, p.oid";
        return string4;
    }

    private static String BuildCatalogOnlyQuery() {
        String string = "SELECT * FROM(select CAST(current_database() AS VARCHAR(124)) AS \"TABLE_CAT\") S ";
        return string;
    }

    private static String BuildCatalogSchemaOnlyQuery() {
        String string = "SELECT * FROM (select CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, CAST(nspname AS VARCHAR(124)) AS TABLE_SCHEM, CAST(NULL AS VARCHAR(124)) AS TABLE_NAME, CAST(NULL AS VARCHAR(124)) AS TABLE_TYPE, CAST('' AS VARCHAR(250)) AS REMARKS FROM pg_catalog.pg_namespace n WHERE true AND nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_' OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_' OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_'))) S ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return string;
    }

    private static String BuildColumnsQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT current_database() AS TABLE_CAT, ");
        stringBuilder.append("n.nspname , ");
        stringBuilder.append("c.relname as TABLE_NAME , ");
        stringBuilder.append("a.attname as COLUMN_NAME, ");
        stringBuilder.append("CAST(case typname ");
        stringBuilder.append("when 'text' THEN 12 ");
        stringBuilder.append("when 'bit' THEN -7 ");
        stringBuilder.append("when 'bool' THEN -7 ");
        stringBuilder.append("when 'varchar' THEN 12 ");
        stringBuilder.append("when 'character varying' THEN 12 ");
        stringBuilder.append("when 'char' THEN 1 ");
        stringBuilder.append("when 'character' THEN 1 ");
        stringBuilder.append("when 'nchar' THEN 1 ");
        stringBuilder.append("when 'bpchar' THEN 1 ");
        stringBuilder.append("when 'nvarchar' THEN 1 ");
        stringBuilder.append("when 'date' THEN 91 ");
        stringBuilder.append("when 'timestamp' THEN 93 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 4 ");
        stringBuilder.append("when 'int' THEN 4 ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'bigint' THEN -5 ");
        stringBuilder.append("when 'int8' THEN -5 ");
        stringBuilder.append("when 'decimal' THEN 3 ");
        stringBuilder.append("when 'real' THEN 7 ");
        stringBuilder.append("when 'float4' THEN 7 ");
        stringBuilder.append("when 'double precision' THEN 8 ");
        stringBuilder.append("when 'float8' THEN 8 ");
        stringBuilder.append("when 'float' THEN 6 ");
        stringBuilder.append("when 'numeric' THEN 2 ");
        stringBuilder.append("when '_float4' THEN 2003 ");
        stringBuilder.append("when 'timestamptz' THEN 93 ");
        stringBuilder.append("when '_aclitem' THEN 2003 ");
        stringBuilder.append("when '_text' THEN 2003 ");
        stringBuilder.append("when 'bytea' THEN -2 ");
        stringBuilder.append("when 'oid' THEN -5 ");
        stringBuilder.append("when 'name' THEN 12 ");
        stringBuilder.append("when '_int4' THEN 2003 ");
        stringBuilder.append("when '_int2' THEN 2003 ");
        stringBuilder.append("else 1111 END as SMALLINT) AS DATA_TYPE, ");
        stringBuilder.append("t.typname as TYPE_NAME, ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bit' THEN 1 ");
        stringBuilder.append("when 'bool' THEN 1 ");
        stringBuilder.append("when 'varchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'character varying' THEN atttypmod -4 ");
        stringBuilder.append("when 'char' THEN atttypmod -4 ");
        stringBuilder.append("when 'character' THEN atttypmod -4 ");
        stringBuilder.append("when 'nchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'bpchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'nvarchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'date' THEN 13 ");
        stringBuilder.append("when 'timestamp' THEN 29 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 10 ");
        stringBuilder.append("when 'int' THEN 10 ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bigint' THEN 19 ");
        stringBuilder.append("when 'int8' THEN 19 ");
        stringBuilder.append("when 'decimal' then atttypmod >> 16 ");
        stringBuilder.append("when 'real' THEN 8 ");
        stringBuilder.append("when 'float4' THEN 8 ");
        stringBuilder.append("when 'double precision' THEN 17 ");
        stringBuilder.append("when 'float8' THEN 17 ");
        stringBuilder.append("when 'float' THEN 17 ");
        stringBuilder.append("when 'numeric' THEN atttypmod >> 16 ");
        stringBuilder.append("when '_float4' THEN 8 ");
        stringBuilder.append("when 'timestamptz' THEN 35 ");
        stringBuilder.append("when 'oid' THEN 10 ");
        stringBuilder.append("when '_int4' THEN 10 ");
        stringBuilder.append("when '_int2' THEN 5 ");
        stringBuilder.append("else 2147483647 end as COLUMN_SIZE , ");
        stringBuilder.append("null as BUFFER_LENGTH , ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'float4' then 8 ");
        stringBuilder.append("when 'float8' then 17 ");
        stringBuilder.append("when 'numeric' then atttypmod % 16 - 4 ");
        stringBuilder.append("when 'timestamp' then 6 ");
        stringBuilder.append("else 0 end as DECIMAL_DIGITS, ");
        stringBuilder.append("10 AS NUM_PREC_RADIX , ");
        stringBuilder.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        stringBuilder.append("when 'false' then 1 ");
        stringBuilder.append("when NULL then 2 ");
        stringBuilder.append("else 0 end AS NULLABLE , ");
        stringBuilder.append("dsc.description as REMARKS , ");
        stringBuilder.append("pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS COLUMN_DEF, ");
        stringBuilder.append("CAST(case typname ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'text' THEN 12 ");
        stringBuilder.append("when 'bit' THEN -7 ");
        stringBuilder.append("when 'bool' THEN -7 ");
        stringBuilder.append("when 'varchar' THEN 12 ");
        stringBuilder.append("when 'character varying' THEN 12 ");
        stringBuilder.append("when 'char' THEN 1 ");
        stringBuilder.append("when 'character' THEN 1 ");
        stringBuilder.append("when 'nchar' THEN 1 ");
        stringBuilder.append("when 'bpchar' THEN 1 ");
        stringBuilder.append("when 'nvarchar' THEN 1 ");
        stringBuilder.append("when 'date' THEN 91 ");
        stringBuilder.append("when 'timestamp' THEN 93 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 4 ");
        stringBuilder.append("when 'int' THEN 4 ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'bigint' THEN -5 ");
        stringBuilder.append("when 'int8' THEN -5 ");
        stringBuilder.append("when 'decimal' THEN 3 ");
        stringBuilder.append("when 'real' THEN 7 ");
        stringBuilder.append("when 'float4' THEN 7 ");
        stringBuilder.append("when 'double precision' THEN 8 ");
        stringBuilder.append("when 'float8' THEN 8 ");
        stringBuilder.append("when 'float' THEN 6 ");
        stringBuilder.append("when 'numeric' THEN 2 ");
        stringBuilder.append("when '_float4' THEN 2003 ");
        stringBuilder.append("when 'timestamptz' THEN 93 ");
        stringBuilder.append("when '_aclitem' THEN 2003 ");
        stringBuilder.append("when '_text' THEN 2003 ");
        stringBuilder.append("when 'bytea' THEN -2 ");
        stringBuilder.append("when 'oid' THEN -5 ");
        stringBuilder.append("when 'name' THEN 12 ");
        stringBuilder.append("when '_int4' THEN 2003 ");
        stringBuilder.append("when '_int2' THEN 2003 ");
        stringBuilder.append("else 1111 END as SMALLINT) AS SQL_DATA_TYPE, ");
        stringBuilder.append("CAST(NULL AS SMALLINT) as SQL_DATETIME_SUB , ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bit' THEN 1 ");
        stringBuilder.append("when 'bool' THEN 1 ");
        stringBuilder.append("when 'varchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'character varying' THEN atttypmod -4 ");
        stringBuilder.append("when 'char' THEN atttypmod -4 ");
        stringBuilder.append("when 'character' THEN atttypmod -4 ");
        stringBuilder.append("when 'nchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'bpchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'nvarchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'date' THEN 13 ");
        stringBuilder.append("when 'timestamp' THEN 29 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 10 ");
        stringBuilder.append("when 'int' THEN 10 ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bigint' THEN 19 ");
        stringBuilder.append("when 'int8' THEN 19 ");
        stringBuilder.append("when 'decimal' then atttypmod >> 16 ");
        stringBuilder.append("when 'real' THEN 8 ");
        stringBuilder.append("when 'float4' THEN 8 ");
        stringBuilder.append("when 'double precision' THEN 17 ");
        stringBuilder.append("when 'float8' THEN 17 ");
        stringBuilder.append("when 'float' THEN 17 ");
        stringBuilder.append("when 'numeric' THEN atttypmod >> 16 ");
        stringBuilder.append("when '_float4' THEN 8 ");
        stringBuilder.append("when 'timestamptz' THEN 35 ");
        stringBuilder.append("when 'oid' THEN 10 ");
        stringBuilder.append("when '_int4' THEN 10 ");
        stringBuilder.append("when '_int2' THEN 5 ");
        stringBuilder.append("else 2147483647 end as CHAR_OCTET_LENGTH , ");
        stringBuilder.append("a.attnum AS ORDINAL_POSITION, ");
        stringBuilder.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        stringBuilder.append("when 'false' then 'YES' ");
        stringBuilder.append("else 'NO' end AS IS_NULLABLE, ");
        stringBuilder.append("null as SCOPE_CATLOG , ");
        stringBuilder.append("null as SCOPE_SCHEMA , ");
        stringBuilder.append("null as SCOPE_TABLE, ");
        stringBuilder.append("t.typbasetype AS SOURCE_DATA_TYPE , ");
        stringBuilder.append("'NO' as IS_AUTOINCREMENT ");
        stringBuilder.append("FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid) ");
        stringBuilder.append("JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) ");
        stringBuilder.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class') ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog') ");
        stringBuilder.append("WHERE a.attnum > 0 AND NOT a.attisdropped    ");
        if (null != string && !string.equals("")) {
            stringBuilder.append(" AND n.nspname LIKE '" + string + "' ");
        } else {
            stringBuilder.append(" AND n.nspname LIKE '%' ");
        }
        if (null != string2 && !string2.equals("")) {
            stringBuilder.append(" AND c.relname LIKE '" + string2 + "' ");
        }
        if (null != string3 && !string3.equals("")) {
            stringBuilder.append(" AND attname LIKE '" + string3 + "' ");
        }
        stringBuilder.append(" ORDER BY nspname,c.relname,attnum  ");
        return stringBuilder.toString();
    }

    private static String BuildForeignKeysQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string3 = null;
        String string4 = null;
        if (null == string && null == string2) {
            string = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            string2 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        } else {
            string3 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            string4 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        }
        String string5 = "SELECT current_database() AS PKTABLE_CAT,  n2.nspname AS PKTABLE_SCHEM,  c2.relname AS PKTABLE_NAME,  a2.attname AS PKCOLUMN_NAME,  current_database() AS FKTABLE_CAT,  n1.nspname AS FKTABLE_SCHEM,  c1.relname AS FKTABLE_NAME,  a1.attname AS FKCOLUMN_NAME,  i::int2 AS KEY_SEQ,  CASE ref.confupdtype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS UPDATE_RULE,  CASE ref.confdeltype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS DELETE_RULE,  ref.conname AS FK_NAME,  cn.conname AS PK_NAME,  CASE  WHEN ref.condeferrable THEN  CASE  WHEN ref.condeferred THEN 5::int2  ELSE 6::int2  END  ELSE 7::int2  END AS DEFERRABILITY  FROM  ((((((((SELECT cn.oid, conrelid, conkey, confrelid, confkey,  GENERATE_SERIES(ARRAY_LOWER(conkey, 1), ARRAY_UPPER(conkey, 1)) AS i,  confupdtype, confdeltype, conname,  condeferrable, condeferred  FROM pg_catalog.pg_constraint cn,  pg_catalog.pg_class c,  pg_catalog.pg_namespace n  WHERE contype = 'f'  AND  conrelid = c.oid ";
        if (null != string && !string.equals("")) {
            string5 = string5 + " AND  relname = '" + string.toLowerCase() + "' ";
        }
        if (null != string2 && !string2.equals("")) {
            string5 = string5 + " AND  n.nspname LIKE '" + string2 + "' ";
        }
        string5 = string5 + " ) ref INNER JOIN pg_catalog.pg_class c1  ON c1.oid = ref.conrelid)  INNER JOIN pg_catalog.pg_namespace n1  ON  n1.oid = c1.relnamespace)  INNER JOIN pg_catalog.pg_attribute a1  ON  a1.attrelid = c1.oid  AND  a1.attnum = conkey[i])  INNER JOIN pg_catalog.pg_class c2  ON  c2.oid = ref.confrelid)  INNER JOIN pg_catalog.pg_namespace n2  ON  n2.oid = c2.relnamespace)  INNER JOIN pg_catalog.pg_attribute a2  ON  a2.attrelid = c2.oid  AND  a2.attnum = confkey[i])  LEFT OUTER JOIN pg_catalog.pg_constraint cn  ON cn.conrelid = ref.confrelid  AND cn.contype = 'p') ";
        if (null != string3 && !string3.equals("")) {
            string5 = string5 + " WHERE c2.relname = '" + string3 + "' ";
        }
        if (null != string4 && !string4.equals("")) {
            string5 = null == string3 || string3.equals("") ? string5 + " WHERE c2.relname = '" + string3 + "' " : string5 + " AND c2.relname = '" + string3 + "' ";
        }
        string5 = string5 + " ORDER BY ref.oid, ref.i";
        return string5;
    }

    private static String BuildPrimaryKeysQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string3 = "SELECT current_database() AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  ct.relname AS TABLE_NAME,   a.attname AS COLUMN_NAME,   a.attnum AS KEY_SEQ,   ci.relname AS PK_NAME   FROM  pg_catalog.pg_namespace n,  pg_catalog.pg_class ct,  pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid  AND a.attrelid=ci.oid AND i.indisprimary  AND ct.relnamespace = n.oid ";
        if (null != string2) {
            string3 = string3 + " AND ct.relname='" + string2.toLowerCase() + "' ";
        }
        if (null != string && !string.equals("")) {
            string3 = string3 + " AND  n.nspname = '" + string.toLowerCase() + "' ";
        }
        string3 = string3 + " ORDER BY table_name, pk_name, key_seq";
        return string3;
    }

    private static String BuildProceduresQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname AS PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(NULL AS VARCHAR(256)) AS NUM_INPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_OUTPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_RESULT_SETS,  d.description AS REMARKS,  2 AS PROCEDURE_TYPE,  p.proname || '_' || p.oid AS SPECIFIC_NAME FROM pg_catalog.pg_namespace n,  pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid) LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc') LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog') WHERE p.pronamespace=n.oid ";
        if (null != string && !string.equals("")) {
            string3 = string3 + " AND n.nspname LIKE '" + string + "' ";
            if (null != string2 && !string2.equals("")) {
                string3 = string3 + " AND p.proname LIKE '" + string2 + "' ";
            }
        } else if (null != string2 && !string2.equals("")) {
            string3 = string3 + " AND n.nspname LIKE '" + string2 + "' ";
        }
        string3 = string3 + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.oid::text";
        return string3;
    }

    private static String BuildFunctionsQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = "SELECT routine_catalog AS FUNCTION_CAT,  routine_schema AS FUNCTION_SCHEM,  routine_name AS FUNCTION_NAME, CAST('' AS VARCHAR(256)) AS REMARKS,  0 AS FUNCTION_TYPE, specific_name AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES";
        if (null != string && !string.equals("")) {
            string3 = string3 + " WHERE  routine_schema LIKE '" + string + "' ";
            if (null != string2 && !string2.equals("")) {
                string3 = string3 + " AND  routine_name LIKE '" + string2 + "' ";
            }
        } else if (null != string2 && !string2.equals("")) {
            string3 = string3 + " WHERE  routine_name LIKE '" + string2 + "' ";
        }
        string3 = string3 + " ORDER BY routine_catalog, routine_schema, routine_name";
        return string3;
    }

    private static String BuildProcedureColumnsQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string4 = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(5 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN 'timestamptz' THEN 93  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF,  CAST(CASE  pg_catalog.format_type(p.prorettype, NULL) WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  UNION ALL  SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(1 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(unnest(p.proargtypes), NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF, CAST(CASE  pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace";
        if (null != string && !string.equals("")) {
            string4 = string4 + " WHERE  n.nspname LIKE '" + string + "' ";
            if (null != string2 && !string2.equals("")) {
                string4 = string4 + " AND  proname LIKE '" + string2 + "' ";
            }
        } else if (null != string2 && !string2.equals("")) {
            string4 = string4 + " WHERE  proname LIKE '" + string2 + "' ";
        }
        return string4;
    }

    private static String BuildTablePriviledgesQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        stringBuilder.append("CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT,");
        stringBuilder.append("n.nspname AS TABLE_SCHEM,");
        stringBuilder.append("c.relname AS TABLE_NAME,");
        stringBuilder.append("u.usename,");
        stringBuilder.append("c.relacl ");
        stringBuilder.append("FROM ");
        stringBuilder.append("pg_catalog.pg_namespace n, ");
        stringBuilder.append("pg_catalog.pg_class c, ");
        stringBuilder.append("pg_catalog.pg_user u ");
        stringBuilder.append("WHERE ");
        stringBuilder.append("c.relnamespace = n.oid");
        stringBuilder.append(" AND u.usesysid = c.relowner");
        stringBuilder.append(" AND c.relkind = 'r'");
        stringBuilder.append(" AND n.nspname LIKE '%'");
        stringBuilder.append(" AND c.relname LIKE '%'");
        if (null != string && !string.equals("")) {
            stringBuilder.append(" AND n.nspname LIKE '");
            stringBuilder.append(string);
            stringBuilder.append("' ");
        }
        if (null != string2 && !string2.equals("")) {
            stringBuilder.append(" AND c.relname LIKE '");
            stringBuilder.append(string2);
            stringBuilder.append("' ");
        }
        stringBuilder.append(" ORDER BY nspname, relname");
        return stringBuilder.toString();
    }

    private static String BuildTablesQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        String string4 = "SELECT * FROM( SELECT  CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  c.relname AS TABLE_NAME, CAST( CASE c.relkind WHEN 'r' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM TABLE'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST TABLE' WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY TABLE'  ELSE 'TABLE'  END  WHEN 'v' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM VIEW'  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY VIEW' ELSE 'VIEW'  END  WHEN 'i' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM INDEX'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST INDEX'  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY INDEX'  ELSE 'INDEX'  END  WHEN 'S' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN NULL  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY SEQUENCE'  ELSE 'SEQUENCE'  END  END  AS VARCHAR(124)) AS TABLE_TYPE, d.description AS REMARKS FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)WHERE c.relnamespace = n.oid ";
        if (null != string && !string.equals("")) {
            string4 = string4 + "AND n.nspname like '" + string + "' ";
        } else if (null != string2 && !string2.equals("")) {
            string4 = string4 + "AND n.nspname like current_schema() ";
        }
        if (null != string2 && !string2.equals("")) {
            string4 = string4 + "AND c.relname like '" + string2 + "' ";
        }
        string4 = string4 + ") S ";
        if (null != string3 && !string3.equals("")) {
            String string5 = PGCatalogQueryBuilder.convertTableTypesListToInClause(string3);
            string4 = string4 + " WHERE TABLE_TYPE IN (" + string5 + ") ";
        }
        string4 = string4 + "ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return string4;
    }

    private static String convertTableTypesListToInClause(String string) {
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != stringArray.length - 1) {
                    stringBuilder.append("'").append(stringArray[i]).append("'").append(", ");
                    continue;
                }
                stringBuilder.append("'").append(stringArray[i]).append("'");
            }
        } else {
            stringBuilder.append("'").append(stringArray[0]).append("'");
        }
        return stringBuilder.toString();
    }

    private static String PGNamespaceQueryBuilder() {
        return "SELECT n.nspname,    c.relname,    a.attname,    a.atttypid,    a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,    a.atttypmod,    a.attlen,    a.attnum,    pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,    dsc.description,    t.typbasetype,    t.typtype,    c.relnameFROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped  AND attname LIKE '%'  AND   (    c.relname LIKE 'pg_attribute'        OR    c.relname LIKE 'pg_type'  ) ORDER BY nspname,c.relname,attnum";
    }

    private static String PGAttNotNullBuilder(byte[] byArray, byte[] byArray2) {
        return "SELECT a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) FROM pg_catalog.pg_attribute a JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) WHERE a.attrelid = " + new String(byArray) + " AND a.attnum = " + new String(byArray2);
    }

    private static String PGAttrDefBuilder(byte[] byArray, byte[] byArray2) {
        return "SELECT 1 FROM pg_catalog.pg_attrdef WHERE adrelid = " + new String(byArray) + " AND adnum = " + new String(byArray2) + " AND pg_catalog.pg_get_expr(adbin, adrelid) LIKE '%nextval(%' ";
    }

    private static String PGTypeNameBuilder(byte[] byArray) {
        return "SELECT typname FROM pg_catalog.pg_type WHERE oid = " + new String(byArray);
    }

    private static String PGRegProcBuilder() {
        return "SELECT typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type WHERE typname = 'regproc'";
    }
}

