/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class PGIQueryExecutor
extends PGAbstractQueryExecutor {
    private PGMessagingContext m_messagingContext;
    private String m_query;
    private PGCoreUtils.TransactionVerb m_txVerb = PGCoreUtils.TransactionVerb.NONE;

    public PGIQueryExecutor(String string, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, pGClient);
        this.m_query = string;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_isDirectExecute = bl;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        if (!bl) {
            string = ParseQueryUtils.parseCommentsOnSingleQuery(string);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            string = PGCoreUtils.parameterQueryFormatter(string, arrayList);
            this.m_txVerb = PGCoreUtils.parseTransactionVerb(string);
            this.m_messagingContext = this.m_client.prepareStatement(string, arrayList, pGJDBCStatement.getWarningListener());
            this.m_messagingContext.addSocketCloseListener(this);
            this.m_contexts.add(this.m_messagingContext);
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.parseTransactionVerb(this.m_query);
            if (PGCoreUtils.TransactionVerb.NONE != transactionVerb) {
                Lock lock = this.m_statement.getTransactionLock();
                lock.lock();
                try {
                    this.m_contexts = Collections.singletonList(this.m_client.directExecuteImmediately(this.m_query, this.m_statement.getWarningListener()));
                    this.m_statement.notifyTransaction(transactionVerb);
                }
                finally {
                    lock.unlock();
                }
            } else {
                this.m_contexts = this.m_client.directExecute(this.m_query, n, this.m_statement.getWarningListener());
            }
            this.m_statement.pushContexts(this.m_contexts);
            for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                pGMessagingContext.addSocketCloseListener(this);
            }
        } else {
            try {
                int n2 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --n2;
                }
                if (n > 5) {
                    this.m_messagingContext.setNRowMode(n);
                }
                if (n2 != 0) {
                    Object object;
                    ArrayList<byte[][]> arrayList = new ArrayList<byte[][]>();
                    Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
                    while (iterator.hasNext()) {
                        object = new byte[n2][];
                        ExecutionContext executionContext = iterator.next();
                        for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                            ParameterInputValue parameterInputValue = executionContext.getInputs().get(i);
                            object[i] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                        }
                        arrayList.add((byte[][])object);
                    }
                    if (1 == arrayList.size()) {
                        this.m_client.executePreparedStatement(this.m_messagingContext, (byte[][])arrayList.get(0), false, false);
                    }
                    object = new byte[arrayList.size()][][];
                    for (int i = 0; i < ((byte[][])object).length; ++i) {
                        object[i] = (byte[])((byte[][])arrayList.get(i));
                    }
                    this.m_client.executePreparedStatementBatch(this.m_messagingContext, this.m_currentExecuteIndex, (byte[][][])object, false);
                }
                if (PGCoreUtils.TransactionVerb.NONE != this.m_txVerb) {
                    Lock lock = this.m_statement.getTransactionLock();
                    lock.lock();
                    try {
                        this.m_client.executePreparedStatement(this.m_messagingContext, null, false, false);
                        this.m_messagingContext.closeBatch(0);
                        this.m_statement.notifyTransaction(this.m_txVerb);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.m_client.executePreparedStatement(this.m_messagingContext, null, false, false);
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        List<ParameterMetadata> list = this.getMetadataForParameters(this.m_messagingContext);
        return (ArrayList)list;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_query);
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return pGMessagingContext.m_parameterMetadata.size();
    }
}

