/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.interfaces.IRowCountResult;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;

public class PGRowCountResult
implements IRowCountResult {
    private PGMessagingContext m_messagingContext = null;
    private int m_batchIndex = 0;
    private ILogger m_log = null;

    public PGRowCountResult(PGMessagingContext pGMessagingContext, int n, ILogger iLogger) {
        this.m_batchIndex = n;
        this.m_messagingContext = pGMessagingContext;
        this.m_log = iLogger;
        LogUtilities.logFunctionEntrance(this.m_log, n);
    }

    public void setMessagingContext(PGMessagingContext pGMessagingContext) {
        this.m_messagingContext = pGMessagingContext;
    }

    @Override
    public boolean hasRowCount() {
        return true;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        CommandComplete commandComplete = null;
        if (null != this.m_messagingContext) {
            commandComplete = this.m_messagingContext.getCommandCompleteMessage(this.m_batchIndex);
        }
        if (null != commandComplete) {
            LogUtilities.logDebug(commandComplete.toString(), this.m_log);
            return commandComplete.getNumRows();
        }
        LogUtilities.logDebug("0", this.m_log);
        return 0L;
    }

    @Override
    public void close() {
        if (null != this.m_messagingContext) {
            this.m_messagingContext.closeBatch(this.m_batchIndex);
        }
    }
}

