/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PGScalarFunctionParser {
    public static final String CHAR = "&f%n&char";
    public static final String UCASE = "&f%n&ucase";
    public static final String LCASE = "&f%n&lcase";
    public static final String IFNULL = "&f%n&ifnull";
    public static final String NOW = "&f%n&now";
    public static final String MONTHNAME = "&f%n&monthname";
    public static final String QUARTER = "&f%n&quarter";
    public static final String DAYOFMONTH = "&f%n&dayofmonth";
    public static final String DAYOFYEAR = "&f%n&dayofyear";
    public static final String DAYOFWEEK = "&f%n&dayofweek";
    public static final String DAYNAME = "&f%n&dayname";
    public static final String WEEK = "&f%n&week";
    public static final String DAY = "&f%n&day";
    public static final String HOUR = "&f%n&hour";
    public static final String MINUTE = "&f%n&minute";
    public static final String SECOND = "&f%n&second";
    public static final String RAND = "&f%n&rand";
    public static final String LOG10 = "&f%n&log10";
    public static final String USER = "&f%n&user";
    public static final String CURDATE = "&f%n&curdate";
    public static final String CURTIME = "&f%n&curtime";
    public static final String LOG = "&f%n&log";
    public static final String TRUNCATE = "&f%n&truncate";
    public static final String DATABASE = "&f%n&database";
    public static final String SPACE = "&f%n&space";
    public static final String MONTH = "&f%n&month";
    public static final String YEAR = "&f%n&year";
    private static final String LOCATE = "&f%n&locate";
    private static final String INSERT = "&f%n&insert";
    private static final ArrayList<String> ORDERED_FUNCTION_LIST;
    private static final Map<String, String> SCALAR_FUNCTION_MAP;

    public static String scalarFunctionParse(String string) {
        String string2 = "";
        try {
            string2 = PGScalarFunctionParser.parseFunctionBracket(string);
            string2 = PGScalarFunctionParser.primaryFunctionParser(string2, "");
            if (PGScalarFunctionParser.hasLocateOrInsertFunction(string2, LOCATE)) {
                string2 = PGScalarFunctionParser.handleLocateOrInsertScalarFunction(string2, LOCATE);
            }
            if (PGScalarFunctionParser.hasLocateOrInsertFunction(string2, INSERT)) {
                string2 = PGScalarFunctionParser.handleLocateOrInsertScalarFunction(string2, INSERT);
            }
            string2 = string2.replaceAll("&f%n&", " ");
        }
        catch (Exception exception) {
            return string;
        }
        return string2;
    }

    private static void splitToList(String string, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.indexOf(44);
        int n2 = 0;
        while (-1 != n) {
            arrayList2.add(string.substring(n2, n + 1));
            n2 = n + 1;
            n = string.indexOf(44, n2);
        }
        arrayList2.add(string.substring(n2));
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string2 = (String)arrayList2.get(i);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n3 = 0;
            int n4 = 0;
            while (-1 != (n3 = string2.indexOf(32, n3))) {
                arrayList3.add(string2.substring(n4, n3));
                n4 = n3++;
            }
            arrayList3.add(string2.substring(n4));
            for (int j = 0; j < arrayList3.size(); ++j) {
                String string3 = (String)arrayList3.get(j);
                if (string3.equals("") || string3.equals(" ")) continue;
                arrayList.add(string3.toLowerCase().trim());
            }
        }
    }

    private static String FunctionReplace(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PGScalarFunctionParser.splitToList(string, arrayList);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = arrayList.get(i).toLowerCase();
            if (-1 == string3.indexOf(string2)) continue;
            if (string3.trim().length() != string2.length()) {
                if (i - 1 < 0 || "table".equals(arrayList.get(i - 1))) continue;
                if (string2 == YEAR || string2 == QUARTER || string2 == MONTH || string2 == WEEK || string2 == DAY || string2 == HOUR || string2 == MINUTE || string2 == SECOND) {
                    arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length() + 1));
                } else if (string2 == USER || string2 == CURTIME || string2 == CURDATE) {
                    if (i + 1 < arrayList.size()) {
                        if (arrayList.get(i + 1).charAt(0) == ')') {
                            arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length() + 1));
                            arrayList.set(i + 1, arrayList.get(i + 1).substring(1));
                        } else {
                            arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length() + 2));
                        }
                    } else {
                        arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length() + 2));
                    }
                } else if (string2 == DAYOFMONTH || string2 == DAYOFYEAR || string2 == DAYOFWEEK || string2 == MONTHNAME || string2 == SPACE || string2 == DAYNAME) {
                    arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length() + 1));
                } else {
                    arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length()));
                }
                bl = true;
                continue;
            }
            if (i + 1 >= arrayList.size() || arrayList.get(i + 1).charAt(0) != '(' || i - 1 < 0 || arrayList.get(i - 1).equals("table")) continue;
            if (string2 == YEAR || string2 == QUARTER || string2 == MONTH || string2 == WEEK || string2 == DAY || string2 == HOUR || string2 == MINUTE || string2 == SECOND) {
                arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2));
                arrayList.set(i + 1, arrayList.get(i + 1).substring(1));
            } else if (string2 == USER || string2 == CURTIME || string2 == CURDATE) {
                if (arrayList.get(i + 1).startsWith("()")) {
                    arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2));
                    arrayList.set(i + 1, arrayList.get(i + 1).substring(2));
                } else if (i + 2 < arrayList.size()) {
                    String string4 = arrayList.get(i + 1);
                    String string5 = arrayList.get(i + 2);
                    if (string4.startsWith("(") && string5.startsWith(")")) {
                        arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2));
                        arrayList.set(i + 1, "");
                        arrayList.set(i + 2, string5.substring(1));
                    }
                }
            } else if (string2 == DAYOFMONTH || string2 == DAYOFYEAR || string2 == DAYOFWEEK || string2 == MONTHNAME || string2 == SPACE || string2 == DAYNAME) {
                arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2));
                arrayList.set(i + 1, arrayList.get(i + 1).substring(1));
            } else {
                arrayList.set(i, SCALAR_FUNCTION_MAP.get(string2) + string3.substring(string2.length()));
            }
            bl = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            for (String string4 : arrayList) {
                if (string4.equals("") && string4.equals(" ")) continue;
                stringBuilder.append(string4);
                stringBuilder.append(" ");
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static int getIndexOfNextNot(String string, int n, char c) {
        if (n < 0 || string == null) {
            return -1;
        }
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasLocateOrInsertFunction(String string, String string2) {
        String string3 = string;
        string3 = string3.toLowerCase();
        int n = -2;
        int n2 = -2;
        n = string3.indexOf(39);
        if (-1 == n) {
            return false;
        }
        while (-1 != n) {
            String string4 = string3.substring(n + 1);
            n2 = string4.indexOf(39);
            String string5 = string3.substring(0, n);
            String string6 = string3.substring(n + n2 + 2);
            ArrayList<String> arrayList = new ArrayList<String>();
            string3 = string6;
            n = string3.indexOf(39);
            PGScalarFunctionParser.splitToList(string5, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string7 = string2 + "(";
                if (!(arrayList.get(i).equals(string7) ? i - 1 >= 0 && arrayList.get(i - 1) != "table" : arrayList.get(i).equals(string2) && i - 1 < arrayList.size() && arrayList.get(i + 1).equals("("))) continue;
                return true;
            }
        }
        return false;
    }

    private static String handleLocateOrInsertScalarFunction(String string, String string2) {
        String string3;
        if (string2 == LOCATE) {
            string3 = "strpos";
        } else if (string2 == INSERT) {
            string3 = "substring";
        } else {
            return string;
        }
        String string4 = string;
        String string5 = string4.toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = "";
        if (-1 != string5.indexOf(string2)) {
            int n;
            while (-1 != (n = string5.indexOf(string2))) {
                int n2;
                int n3 = PGScalarFunctionParser.getIndexOfNextNot(string4, n + string2.length(), ' ');
                String string7 = string4.substring(n3);
                if ('(' != string7.charAt(0)) {
                    return string;
                }
                int n4 = string4.indexOf(41);
                String string8 = string4.substring(n3 + 1, n4);
                String string9 = string4.substring(0, n) + string3 + "(";
                string6 = string4.substring(n4);
                int n5 = 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                while (-1 != (n2 = string8.indexOf(44, n5))) {
                    if (n2 > n5) {
                        arrayList.add(string8.substring(n5, n2));
                    }
                    n5 = n2 + 1;
                }
                if (n5 < string8.length()) {
                    arrayList.add(string8.substring(n5));
                }
                if (LOCATE == string2) {
                    if (arrayList.size() == 2) {
                        stringBuilder.append(string9);
                        stringBuilder.append((String)arrayList.get(1));
                        stringBuilder.append("," + (String)arrayList.get(0));
                    }
                    if (3 == arrayList.size()) {
                        stringBuilder.append(string9);
                        stringBuilder.append("substring(");
                        stringBuilder.append((String)arrayList.get(1));
                        stringBuilder.append(" from ");
                        stringBuilder.append((String)arrayList.get(2));
                        stringBuilder.append("),");
                        stringBuilder.append((String)arrayList.get(0));
                        stringBuilder.append(") +");
                        stringBuilder.append((String)arrayList.get(2));
                        stringBuilder.append("-1");
                        string6 = string6.substring(1);
                    }
                } else if (INSERT == string2) {
                    stringBuilder.append(string9);
                    stringBuilder.append((String)arrayList.get(0));
                    stringBuilder.append(" from ");
                    stringBuilder.append((String)arrayList.get(2));
                    stringBuilder.append(" for ");
                    stringBuilder.append((String)arrayList.get(1));
                    stringBuilder.append("-");
                    stringBuilder.append((String)arrayList.get(2));
                    stringBuilder.append(") || ");
                    stringBuilder.append((String)arrayList.get(3));
                    stringBuilder.append(" || substring ( ");
                    stringBuilder.append((String)arrayList.get(0));
                    stringBuilder.append(" from ");
                    stringBuilder.append((String)arrayList.get(1));
                    stringBuilder.append("+");
                    stringBuilder.append((String)arrayList.get(2));
                }
                string4 = string6;
                string5 = string4.toLowerCase();
            }
        }
        stringBuilder.append(string6);
        if (0 != stringBuilder.length()) {
            return stringBuilder.toString();
        }
        return string;
    }

    private static String searchForFunctionNameAndReplace(String string) {
        String string2 = string;
        String string3 = string2.toLowerCase();
        for (String string4 : ORDERED_FUNCTION_LIST) {
            int n;
            int n2 = string3.indexOf(string4);
            if (-1 == n2 || string2.charAt(n = PGScalarFunctionParser.getIndexOfNextNot(string2, n2 + string4.length(), ' ')) != '(') continue;
            string2 = PGScalarFunctionParser.FunctionReplace(string2, string4);
            string3 = string2.toLowerCase();
        }
        return string2;
    }

    private static String primaryFunctionParser(String string, String string2) {
        int n;
        String string3 = string;
        int n2 = string.indexOf(39);
        if (string.length() <= 1) {
            return string2 + string;
        }
        if (n2 == -1) {
            string = PGScalarFunctionParser.searchForFunctionNameAndReplace(string);
            return string2 + string;
        }
        int n3 = string.indexOf(39, n2 + 1);
        if (n3 == -1) {
            n3 = 0;
        }
        String string4 = n2 == 0 ? "" : string.substring(0, n2);
        String string5 = n3 == string.length() - 1 ? "" : string.substring(n3 + 1);
        String string6 = string.substring(n2, n3 + 1);
        string4 = PGScalarFunctionParser.searchForFunctionNameAndReplace(string4);
        String string7 = string2 + string4 + string6;
        String string8 = string3.substring(0, n2);
        string8 = string8.toLowerCase();
        if (-1 != string7.indexOf("to_char(")) {
            if (-1 != string8.indexOf("dayname")) {
                string7 = string7 + ", 'Day'";
            } else if (-1 != string8.indexOf("monthname")) {
                string7 = string7 + ", 'Month'";
            }
        }
        if (-1 != string7.indexOf("extract(dow from ") && -1 != string8.indexOf("dayofweek") && -1 != (n = string5.indexOf(41))) {
            string5 = string5.substring(0, n + 1) + "+1" + string5.substring(n + 1);
        }
        return PGScalarFunctionParser.primaryFunctionParser(string5, string7);
    }

    private static String parseFunctionBracket(String string) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block10: for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            switch (c.charValue()) {
                case '{': {
                    if (!bl && !bl2) {
                        ++n;
                        bl3 = true;
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                case '}': {
                    if (!bl && !bl2 && n > 0) {
                        --n;
                    } else {
                        stringBuilder.append(c);
                    }
                    bl3 = false;
                    continue block10;
                }
                case '\"': {
                    if (!bl) {
                        bl2 = !bl2;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                case '\'': {
                    if (!bl2) {
                        bl = !bl;
                        bl3 = false;
                    }
                    stringBuilder.append(c);
                    bl3 = false;
                    continue block10;
                }
                case 'f': {
                    if (!bl && !bl2 && n > 0 && bl3) {
                        if (string.charAt(i + 1) == 'n') {
                            stringBuilder.append("&f%n&");
                            ++i;
                            while (string.charAt(i + 1) == ' ' && ++i + 2 < string.length()) {
                            }
                        }
                    } else {
                        stringBuilder.append(c);
                    }
                    bl3 = false;
                    continue block10;
                }
                case 't': {
                    if (!bl && !bl2 && n > 0 && bl3) {
                        if (string.charAt(i + 1) == 's') {
                            stringBuilder.append(" timestamp ");
                            ++i;
                        } else {
                            stringBuilder.append(" time ");
                        }
                    } else {
                        stringBuilder.append(c);
                    }
                    bl3 = false;
                    continue block10;
                }
                case 'd': {
                    if (!bl && !bl2 && n > 0 && bl3) {
                        stringBuilder.append(" date ");
                    } else {
                        stringBuilder.append(c);
                    }
                    bl3 = false;
                    continue block10;
                }
                case ' ': {
                    stringBuilder.append(c);
                    continue block10;
                }
                default: {
                    bl3 = false;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static {
        SCALAR_FUNCTION_MAP = new HashMap<String, String>();
        ORDERED_FUNCTION_LIST = new ArrayList();
        SCALAR_FUNCTION_MAP.put(UCASE, "upper");
        SCALAR_FUNCTION_MAP.put(LCASE, "lower");
        SCALAR_FUNCTION_MAP.put(IFNULL, "coalesce");
        SCALAR_FUNCTION_MAP.put(NOW, "getdate");
        SCALAR_FUNCTION_MAP.put(YEAR, "extract ( year from ");
        SCALAR_FUNCTION_MAP.put(MONTHNAME, "to_char( ");
        SCALAR_FUNCTION_MAP.put(MONTH, "extract ( month from ");
        SCALAR_FUNCTION_MAP.put(QUARTER, "extract ( quarter from ");
        SCALAR_FUNCTION_MAP.put(DAYOFMONTH, "extract(day from ");
        SCALAR_FUNCTION_MAP.put(DAYOFYEAR, "extract(doy from ");
        SCALAR_FUNCTION_MAP.put(DAYOFWEEK, "extract(dow from ");
        SCALAR_FUNCTION_MAP.put(DAYNAME, "to_char( ");
        SCALAR_FUNCTION_MAP.put(WEEK, "extract ( week from ");
        SCALAR_FUNCTION_MAP.put(DAY, "extract ( day from ");
        SCALAR_FUNCTION_MAP.put(HOUR, "extract ( hour from ");
        SCALAR_FUNCTION_MAP.put(MINUTE, "extract ( minute from ");
        SCALAR_FUNCTION_MAP.put(SECOND, "extract ( second from ");
        SCALAR_FUNCTION_MAP.put(RAND, "random");
        SCALAR_FUNCTION_MAP.put(LOG10, "log");
        SCALAR_FUNCTION_MAP.put(USER, "user");
        SCALAR_FUNCTION_MAP.put(CURDATE, "current_date");
        SCALAR_FUNCTION_MAP.put(CURTIME, "current_time");
        SCALAR_FUNCTION_MAP.put(LOG, "ln");
        SCALAR_FUNCTION_MAP.put(TRUNCATE, "trunc");
        SCALAR_FUNCTION_MAP.put(DATABASE, "current_database");
        SCALAR_FUNCTION_MAP.put(CHAR, "chr");
        SCALAR_FUNCTION_MAP.put(SPACE, "repeat(' ',");
        ORDERED_FUNCTION_LIST.add(CHAR);
        ORDERED_FUNCTION_LIST.add(UCASE);
        ORDERED_FUNCTION_LIST.add(LCASE);
        ORDERED_FUNCTION_LIST.add(IFNULL);
        ORDERED_FUNCTION_LIST.add(NOW);
        ORDERED_FUNCTION_LIST.add(MONTHNAME);
        ORDERED_FUNCTION_LIST.add(QUARTER);
        ORDERED_FUNCTION_LIST.add(DAYOFMONTH);
        ORDERED_FUNCTION_LIST.add(DAYOFYEAR);
        ORDERED_FUNCTION_LIST.add(DAYOFWEEK);
        ORDERED_FUNCTION_LIST.add(DAYNAME);
        ORDERED_FUNCTION_LIST.add(WEEK);
        ORDERED_FUNCTION_LIST.add(DAY);
        ORDERED_FUNCTION_LIST.add(HOUR);
        ORDERED_FUNCTION_LIST.add(MINUTE);
        ORDERED_FUNCTION_LIST.add(SECOND);
        ORDERED_FUNCTION_LIST.add(RAND);
        ORDERED_FUNCTION_LIST.add(LOG10);
        ORDERED_FUNCTION_LIST.add(USER);
        ORDERED_FUNCTION_LIST.add(CURDATE);
        ORDERED_FUNCTION_LIST.add(CURTIME);
        ORDERED_FUNCTION_LIST.add(LOG);
        ORDERED_FUNCTION_LIST.add(TRUNCATE);
        ORDERED_FUNCTION_LIST.add(DATABASE);
        ORDERED_FUNCTION_LIST.add(SPACE);
        ORDERED_FUNCTION_LIST.add(MONTH);
        ORDERED_FUNCTION_LIST.add(YEAR);
    }
}

