/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.value;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprProcessor;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.AENodeList;
import com.amazon.sqlengine.aeprocessor.aetree.AESemantics;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.amazon.sqlengine.aeprocessor.aetree.value.AENegate;
import com.amazon.sqlengine.aeprocessor.aetree.value.AENull;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AERename;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.Iterator;

public class AEValueExprComposer {
    public static void compose(AEValueExprList aEValueExprList, AEQueryScope aEQueryScope) throws ErrorException {
        Composer composer = new Composer(aEQueryScope);
        Iterator iterator = aEValueExprList.getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = ((AEValueExpr)iterator.next()).acceptVisitor(composer);
            aEValueExprList.replaceNode(aEValueExpr, n);
            ++n;
        }
    }

    public static AEValueExpr composeExpr(AEValueExpr aEValueExpr, AEQueryScope aEQueryScope) throws ErrorException {
        return aEValueExpr.acceptVisitor(new Composer(aEQueryScope));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Composer
    extends AEDefaultVisitor<AEValueExpr> {
        private AEQueryScope m_queryScope;

        public Composer(AEQueryScope aEQueryScope) {
            this.m_queryScope = aEQueryScope;
        }

        private AEValueExpr createProxy(AEValueExpr aEValueExpr) throws ErrorException {
            AEQueryScope aEQueryScope = AESemantics.findUniqueQueryScope(aEValueExpr, true);
            if (null != aEQueryScope && this.m_queryScope == aEQueryScope) {
                return aEQueryScope.proxyToAggregateExpr(aEValueExpr);
            }
            return null;
        }

        private AEValueExpr composeBinary(AEBinaryValueExpr aEBinaryValueExpr) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aEBinaryValueExpr);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            AEValueExpr aEValueExpr2 = aEBinaryValueExpr.getLeftOperand().acceptVisitor(this);
            aEBinaryValueExpr.setLeftOperand(aEValueExpr2);
            AEValueExpr aEValueExpr3 = aEBinaryValueExpr.getRightOperand().acceptVisitor(this);
            aEBinaryValueExpr.setRightOperand(aEValueExpr3);
            return aEBinaryValueExpr;
        }

        @Override
        public AEValueExpr visit(AEAdd aEAdd) throws ErrorException {
            return this.composeBinary(aEAdd);
        }

        @Override
        public AEValueExpr visit(AEConcat aEConcat) throws ErrorException {
            return this.composeBinary(aEConcat);
        }

        @Override
        public AEValueExpr visit(AEDivide aEDivide) throws ErrorException {
            return this.composeBinary(aEDivide);
        }

        @Override
        public AEValueExpr visit(AEMultiply aEMultiply) throws ErrorException {
            return this.composeBinary(aEMultiply);
        }

        @Override
        public AEValueExpr visit(AESubtract aESubtract) throws ErrorException {
            return this.composeBinary(aESubtract);
        }

        @Override
        public AEValueExpr visit(AEColumnReference aEColumnReference) throws ErrorException {
            if (aEColumnReference.isOuterReference()) {
                return aEColumnReference;
            }
            AEValueExpr aEValueExpr = this.createProxy(aEColumnReference);
            if (null == aEValueExpr) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.NON_GROUPING_COLUMN_IN_SEL_LIST.name(), new String[]{aEColumnReference.getLogString()});
            }
            return aEValueExpr;
        }

        @Override
        public AEValueExpr visit(AEProxyColumn aEProxyColumn) throws ErrorException {
            return aEProxyColumn;
        }

        @Override
        public AEValueExpr visit(AELiteral aELiteral) throws ErrorException {
            return aELiteral;
        }

        @Override
        public AEValueExpr visit(AEParameter aEParameter) throws ErrorException {
            return aEParameter;
        }

        @Override
        public AEValueExpr visit(AENull aENull) throws ErrorException {
            return aENull;
        }

        @Override
        public AEValueExpr visit(AERename aERename) throws ErrorException {
            AEValueExpr aEValueExpr = aERename.getOperand().acceptVisitor(this);
            aERename.setOperand(aEValueExpr);
            return aERename;
        }

        @Override
        public AEValueExpr visit(AEScalarFn aEScalarFn) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aEScalarFn);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            AEValueExprList aEValueExprList = aEScalarFn.getArguments();
            if (null != aEValueExprList && aEValueExprList.getNumChildren() > 0) {
                AEValueExprComposer.compose(aEValueExprList, this.m_queryScope);
            }
            return aEScalarFn;
        }

        @Override
        public AEValueExpr visit(AECustomScalarFn aECustomScalarFn) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aECustomScalarFn);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            AEValueExprList aEValueExprList = aECustomScalarFn.getArguments();
            if (null != aEValueExprList && 0 < aEValueExprList.getNumChildren()) {
                AEValueExprComposer.compose(aEValueExprList, this.m_queryScope);
            }
            return aECustomScalarFn;
        }

        @Override
        public AEValueExpr visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
            return this.m_queryScope.addAggregateFunction(aECountStarAggrFn);
        }

        @Override
        public AEValueExpr visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
            AEQueryScope aEQueryScope = AESemantics.findUniqueQueryScope(aEGeneralAggrFn, true);
            if (null != aEQueryScope) {
                if (aEQueryScope != this.m_queryScope) {
                    throw new IllegalArgumentException("Processing aggregate function with scope not equal to the current scope.");
                }
            } else {
                aEQueryScope = this.m_queryScope;
            }
            return aEQueryScope.addAggregateFunction(aEGeneralAggrFn);
        }

        @Override
        public AEValueExpr visit(AENegate aENegate) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aENegate);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            AEValueExpr aEValueExpr2 = aENegate.getOperand().acceptVisitor(this);
            aENegate.setOperand(aEValueExpr2);
            return aENegate;
        }

        @Override
        public AEValueExpr visit(AESearchedCase aESearchedCase) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aESearchedCase);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aESearchedCase.setElseClause(aESearchedCase.getElseClause().acceptVisitor(this));
            AENodeList<AESearchedWhenClause> aENodeList = aESearchedCase.getWhenClauseList();
            Iterator iterator = aENodeList.getChildItr();
            while (iterator.hasNext()) {
                AESearchedWhenClause aESearchedWhenClause = (AESearchedWhenClause)iterator.next();
                aESearchedWhenClause.setThenExpression(aESearchedWhenClause.getThenExpression().acceptVisitor(this));
                AEBooleanExprProcessor.process(aESearchedWhenClause.getWhenCondition(), this.m_queryScope);
            }
            return aESearchedCase;
        }

        @Override
        public AEValueExpr visit(AESimpleCase aESimpleCase) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aESimpleCase);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aESimpleCase.setElseOperand(aESimpleCase.getElseOperand().acceptVisitor(this));
            aESimpleCase.setCaseOperand(aESimpleCase.getCaseOperand().acceptVisitor(this));
            AENodeList<AESimpleWhenClause> aENodeList = aESimpleCase.getWhenClauseList();
            Iterator iterator = aENodeList.getChildItr();
            while (iterator.hasNext()) {
                AESimpleWhenClause aESimpleWhenClause = (AESimpleWhenClause)iterator.next();
                aESimpleWhenClause.setWhenExpression(aESimpleWhenClause.getWhenExpression().acceptVisitor(this));
                aESimpleWhenClause.setThenExpression(aESimpleWhenClause.getThenExpression().acceptVisitor(this));
            }
            return aESimpleCase;
        }

        @Override
        public AEValueExpr visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
            return aEValueSubQuery;
        }

        @Override
        protected AEValueExpr defaultVisit(IAENode iAENode) throws ErrorException {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.NON_GROUPING_COLUMN_IN_SEL_LIST.name(), new String[]{iAENode.getLogString()});
        }
    }
}

