/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aeoptimizer;

import com.amazon.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.amazon.sqlengine.aeprocessor.aeoptimizer.AEPassdownJoin;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESort;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETop;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.amazon.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AERelationalExprHandler
extends AEDefaultVisitor<AERelationalExpr> {
    DSIExtOperationHandlerFactory m_opHandlerFactory;

    @Override
    public AERelationalExpr visit(AEProject aEProject) {
        this.passdownOperand(aEProject);
        return aEProject;
    }

    @Override
    public AERelationalExpr visit(AETable aETable) {
        return aETable;
    }

    @Override
    public AERelationalExpr visit(AESelect aESelect) {
        if (!this.passdownOperand(aESelect)) {
            return aESelect;
        }
        assert (aESelect.getOperand() instanceof AETable);
        AETable aETable = (AETable)aESelect.getOperand();
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
        if (null == iBooleanExprHandler) {
            return null;
        }
        Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aESelect.getCondition());
        if (pair.key() != null) {
            aETable.setTable(pair.key());
        }
        if (pair.value() == null) {
            return aETable;
        }
        aESelect.setSelectCond(pair.value());
        return aESelect;
    }

    @Override
    public AERelationalExpr visit(AETop aETop) {
        this.passdownOperand(aETop);
        return aETop;
    }

    @Override
    public AERelationalExpr visit(AESort aESort) {
        this.passdownOperand(aESort);
        return aESort;
    }

    @Override
    public AERelationalExpr visit(AECrossJoin aECrossJoin) {
        this.passdownOperand(aECrossJoin);
        return aECrossJoin;
    }

    @Override
    public AERelationalExpr visit(AEJoin aEJoin) {
        if (!this.passdownOperand(aEJoin)) {
            return aEJoin;
        }
        return new AEPassdownJoin(this.m_opHandlerFactory).passdown(aEJoin);
    }

    @Override
    public AERelationalExpr visit(AEAggregate aEAggregate) {
        this.passdownOperand(aEAggregate);
        return aEAggregate;
    }

    @Override
    public AERelationalExpr visit(AESubQuery aESubQuery) {
        AERelationalExpr aERelationalExpr;
        AERelationalExpr aERelationalExpr2;
        if (aESubQuery.isInFromClause() && !aESubQuery.isCorrelated() && null != (aERelationalExpr2 = this.passdown(aERelationalExpr = aESubQuery.getOperand()))) {
            if (aERelationalExpr2 instanceof AETable) {
                AETable aETable = (AETable)aERelationalExpr2;
                aETable.setCorrelationName(aESubQuery.getCorrelationName());
                this.updateColumns(aESubQuery, (AETable)aERelationalExpr2);
                return aERelationalExpr2;
            }
            aESubQuery.setOperand(aERelationalExpr2);
        }
        return aESubQuery;
    }

    @Override
    public AERelationalExpr visit(AETableConstructor aETableConstructor) {
        return aETableConstructor;
    }

    @Override
    public AERelationalExpr visit(AEUnion aEUnion) {
        this.passdownOperand(aEUnion);
        return aEUnion;
    }

    public AERelationalExprHandler(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    public AERelationalExpr passdown(AERelationalExpr aERelationalExpr) {
        try {
            return aERelationalExpr.acceptVisitor(this);
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    @Override
    protected AERelationalExpr defaultVisit(IAENode iAENode) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidAETreeException();
    }

    private boolean passdownOperand(AEUnaryRelationalExpr aEUnaryRelationalExpr) {
        AERelationalExpr aERelationalExpr = aEUnaryRelationalExpr.getOperand();
        if (aERelationalExpr instanceof AETable) {
            return true;
        }
        AERelationalExpr aERelationalExpr2 = this.passdown(aERelationalExpr);
        if (null != aERelationalExpr2) {
            aEUnaryRelationalExpr.getOperand().setParent(null);
            aEUnaryRelationalExpr.setOperand(aERelationalExpr2);
        }
        return aERelationalExpr2 instanceof AETable;
    }

    private boolean passdownOperand(AEBinaryRelationalExpr aEBinaryRelationalExpr) {
        AERelationalExpr aERelationalExpr = aEBinaryRelationalExpr.getLeftOperand();
        AERelationalExpr aERelationalExpr2 = aEBinaryRelationalExpr.getRightOperand();
        AERelationalExpr aERelationalExpr3 = null;
        if (!(aERelationalExpr instanceof AETable) && null != (aERelationalExpr3 = this.passdown(aERelationalExpr))) {
            aEBinaryRelationalExpr.setLeftOperand(aERelationalExpr3);
        }
        if (!(aERelationalExpr2 instanceof AETable) && null != (aERelationalExpr3 = this.passdown(aERelationalExpr2))) {
            aEBinaryRelationalExpr.setRightOperand(aERelationalExpr3);
        }
        return aEBinaryRelationalExpr.getLeftOperand() instanceof AETable && aEBinaryRelationalExpr.getRightOperand() instanceof AETable;
    }

    private void updateColumns(final AENamedRelationalExpr aENamedRelationalExpr, final AENamedRelationalExpr aENamedRelationalExpr2) {
        IAENode iAENode = aENamedRelationalExpr.getParent();
        while (iAENode.getParent() != null && !(iAENode instanceof AESubQuery)) {
            iAENode = iAENode.getParent();
        }
        try {
            AETreeWalker.walk(iAENode, new AETreeWalker.Action<Void>(){

                @Override
                public void act(IAENode iAENode) throws ErrorException {
                    AEColumnReference aEColumnReference;
                    if (iAENode == aENamedRelationalExpr) {
                        this.skipChildren();
                    }
                    if (iAENode instanceof AEColumnReference && (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() == aENamedRelationalExpr) {
                        aEColumnReference.setNamedRelationalExpr(aENamedRelationalExpr2);
                    }
                }
            });
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }
}

