/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree;

import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AEComparisonType {
    EQUAL("="){

        public AEComparisonType flip() {
            return this;
        }

        public AEComparisonType complement() {
            return NOT_EQUAL;
        }
    }
    ,
    NOT_EQUAL("!="){

        public AEComparisonType flip() {
            return this;
        }

        public AEComparisonType complement() {
            return EQUAL;
        }
    }
    ,
    GREATER_THAN(">"){

        public AEComparisonType flip() {
            return LESS_THAN;
        }

        public AEComparisonType complement() {
            return LESS_THAN_OR_EQUAL;
        }
    }
    ,
    LESS_THAN("<"){

        public AEComparisonType flip() {
            return GREATER_THAN;
        }

        public AEComparisonType complement() {
            return GREATER_THAN_OR_EQUAL;
        }
    }
    ,
    GREATER_THAN_OR_EQUAL(">="){

        public AEComparisonType flip() {
            return LESS_THAN_OR_EQUAL;
        }

        public AEComparisonType complement() {
            return LESS_THAN;
        }
    }
    ,
    LESS_THAN_OR_EQUAL("<="){

        public AEComparisonType flip() {
            return GREATER_THAN_OR_EQUAL;
        }

        public AEComparisonType complement() {
            return GREATER_THAN;
        }
    };

    private String m_val;

    private AEComparisonType(String string2) {
        this.m_val = string2;
    }

    public abstract AEComparisonType flip();

    public abstract AEComparisonType complement();

    public static AEComparisonType getComparisonType(PTNonterminalType pTNonterminalType) throws ErrorException {
        switch (pTNonterminalType) {
            case EQUALS_OP: {
                return EQUAL;
            }
            case NOT_EQUALS_OP: {
                return NOT_EQUAL;
            }
            case LESS_THAN_OP: {
                return LESS_THAN;
            }
            case GREATER_THAN_OP: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUALS_OP: {
                return LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUALS_OP: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    public String toString() {
        return this.m_val;
    }
}

