/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEValueSubQuery
extends AEValueExpr {
    private static final int NUM_CHILDREN = 1;
    private AERelationalExpr m_queryExpr;
    private boolean m_isCorrelated;
    private ColumnMetadata m_columnMetadata;

    public AEValueSubQuery(AERelationalExpr aERelationalExpr, boolean bl) {
        this.m_queryExpr = aERelationalExpr;
        this.m_isCorrelated = bl;
        if (1 != aERelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("Illegal number of columns: " + aERelationalExpr.getColumnCount());
        }
        this.m_columnMetadata = ColumnMetadata.copyOf(this.m_queryExpr.getColumn(0));
        this.m_columnMetadata.setName(null);
    }

    public boolean isCorrelated() {
        return this.m_isCorrelated;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    public Iterator<AERelationalExpr> getChildItr() {
        return new AbstractList<AERelationalExpr>(){

            @Override
            public AERelationalExpr get(int n) {
                if (0 == n) {
                    return AEValueSubQuery.this.m_queryExpr;
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 1;
            }
        }.iterator();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEValueSubQuery)) {
            return false;
        }
        AEValueSubQuery aEValueSubQuery = (AEValueSubQuery)iAENode;
        return this.m_isCorrelated == aEValueSubQuery.m_isCorrelated && this.m_queryExpr.isEquivalent(aEValueSubQuery.m_queryExpr);
    }

    @Override
    public IColumn getColumn() {
        return this.m_columnMetadata;
    }

    @Override
    public AEValueSubQuery copy() {
        return new AEValueSubQuery(this.m_queryExpr.copy(), this.m_isCorrelated);
    }

    public AERelationalExpr getQueryExpression() {
        return this.m_queryExpr;
    }

    @Override
    public void updateColumn() throws ErrorException {
        this.m_columnMetadata = ColumnMetadata.copyOf(this.m_queryExpr.getColumn(0));
    }
}

