/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.datawrapper;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;

public final class SqlCharDataWrapper
extends DefaultSqlDataWrapper {
    private String m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlCharDataWrapper(int n) {
        assert (n == 1 || n == 12 || n == -1 || n == -8 || n == -9 || n == -10);
        this.m_type = n;
    }

    public String getChar() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setChar(String string) {
        this.m_isSet = true;
        this.m_data = string;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            String string = null;
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    string = dataWrapper.getChar();
                    break;
                }
                case -9: 
                case 12: {
                    string = dataWrapper.getVarChar();
                    break;
                }
                case -10: 
                case -1: {
                    string = dataWrapper.getLongVarChar();
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setChar(string);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case 1: {
                dataWrapper.setChar(this.m_data);
                break;
            }
            case 12: {
                dataWrapper.setVarChar(this.m_data);
                break;
            }
            case -1: {
                dataWrapper.setLongVarChar(this.m_data);
                break;
            }
            case -8: {
                dataWrapper.setWChar(this.m_data);
                break;
            }
            case -9: {
                dataWrapper.setWVarChar(this.m_data);
                break;
            }
            case -10: {
                dataWrapper.setWLongVarChar(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

