/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.datawrapper;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;

public final class SqlExactNumDataWrapper
extends DefaultSqlDataWrapper {
    private BigDecimal m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlExactNumDataWrapper(int n) {
        assert (n == 3 || n == 2);
        this.m_type = n;
    }

    public BigDecimal getExactNumber() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setExactNumber(BigDecimal bigDecimal) {
        this.m_isSet = true;
        this.m_data = bigDecimal;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            BigDecimal bigDecimal = null;
            switch (dataWrapper.getType()) {
                case 3: {
                    bigDecimal = dataWrapper.getDecimal();
                    break;
                }
                case 2: {
                    bigDecimal = dataWrapper.getNumeric();
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setExactNumber(bigDecimal);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case 3: {
                dataWrapper.setDecimal(this.m_data);
                break;
            }
            case 2: {
                dataWrapper.setNumeric(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

