/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.ErrorException;
import java.io.File;

public class LongDataStore {
    private final TemporaryFile m_storage;
    private final long m_memoryUsage;

    public LongDataStore(File file, long l, ILogger iLogger) throws ErrorException {
        this.m_storage = new TemporaryFile(file, iLogger);
        this.m_memoryUsage = l;
    }

    public TemporaryFile.FileMarker put(int n, ETRelationalExpr eTRelationalExpr) throws ErrorException {
        IColumn iColumn = eTRelationalExpr.getColumn(n);
        if (!iColumn.getTypeMetadata().isCharacterOrBinaryType()) {
            throw new IllegalArgumentException("Incompatible type for LongDataSotre");
        }
        ETDataRequest eTDataRequest = new ETDataRequest(iColumn);
        eTDataRequest.setMaxBytes(this.m_memoryUsage);
        boolean bl = eTRelationalExpr.retrieveData(n, eTDataRequest);
        if (eTDataRequest.getData().isNull()) {
            return null;
        }
        long l = 0L;
        byte[] byArray = this.getBytes(eTDataRequest);
        this.m_storage.append(byArray);
        l += (long)byArray.length;
        while (bl) {
            eTDataRequest.setOffset(l);
            bl = eTRelationalExpr.retrieveData(n, eTDataRequest);
            byArray = this.getBytes(eTDataRequest);
            this.m_storage.append(byArray);
            l += (long)byArray.length;
        }
        return this.m_storage.generateFileMarker();
    }

    private byte[] getBytes(ETDataRequest eTDataRequest) throws ErrorException {
        if (eTDataRequest.getMetadata().isCharacterType()) {
            return DataRetrievalUtil.stringToBytes(eTDataRequest.getData().getChar());
        }
        return eTDataRequest.getData().getBinary();
    }

    public boolean retrieveData(TemporaryFile.FileMarker fileMarker, ETDataRequest eTDataRequest) throws ErrorException {
        assert (eTDataRequest.getMetadata().isCharacterOrBinaryType());
        return DataRetrievalUtil.retrieveLongDataFromFile(this.m_storage, fileMarker, eTDataRequest);
    }

    public void destroy() {
        if (this.m_storage != null) {
            this.m_storage.destroy();
        }
    }
}

