/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.util;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.temptable.LongDataStore;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.util.CompressionUtil;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DataRetrievalUtil {
    private DataRetrievalUtil() {
    }

    public static boolean retrieveBinaryData(ISqlDataWrapper iSqlDataWrapper, long l, long l2) throws ErrorException {
        return DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper, l, l2, Long.MAX_VALUE, null);
    }

    public static boolean retrieveCharData(ISqlDataWrapper iSqlDataWrapper, long l, long l2) throws ErrorException {
        return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, l, l2, Long.MAX_VALUE, null);
    }

    public static boolean retrieveBinaryData(ISqlDataWrapper iSqlDataWrapper, long l, long l2, long l3, IWarningListener iWarningListener) throws ErrorException {
        boolean bl;
        int n;
        byte[] byArray = iSqlDataWrapper.getBinary();
        if (l != 0L && (l >= (long)byArray.length || l >= l3)) {
            throw new IllegalArgumentException("Invalid offset: " + l);
        }
        int n2 = l2 == -1L || l2 > Long.MAX_VALUE - l || (long)byArray.length <= l2 + l ? byArray.length : (int)(l2 + l);
        if (l == 0L && (long)byArray.length <= l2 && (long)byArray.length <= l3) {
            return false;
        }
        int n3 = (int)Math.min((long)n2, l3);
        byte[] byArray2 = new byte[(int)((long)n3 - l)];
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = byArray[(int)((long)n + l)];
        }
        iSqlDataWrapper.setBinary(byArray2);
        n = l3 < (long)n2 ? 1 : 0;
        boolean bl2 = bl = n == 0 && n3 < byArray.length;
        if (iWarningListener != null && n != 0) {
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1, -1));
        }
        return bl;
    }

    public static boolean retrieveCharData(ISqlDataWrapper iSqlDataWrapper, long l, long l2, long l3, IWarningListener iWarningListener) throws ErrorException {
        boolean bl;
        if (l % 2L == 1L) {
            throw new IllegalStateException("Invalid offset value: " + l);
        }
        String string = iSqlDataWrapper.getChar();
        int n = string.length();
        if ((l /= 2L) != 0L && (l >= (long)n || l >= l3)) {
            iSqlDataWrapper.setChar("");
            return false;
        }
        int n2 = l2 == -1L || l2 / 2L > Long.MAX_VALUE - l || (long)n <= l2 / 2L + l ? n : (int)(l + l2 / 2L);
        if (l == 0L && n == n2 && (long)n <= l3) {
            return false;
        }
        int n3 = (int)Math.min(l3, (long)n2);
        iSqlDataWrapper.setChar(string.substring((int)l, n3));
        boolean bl2 = l3 < (long)n2;
        boolean bl3 = bl = !bl2 && n3 < n;
        if (iWarningListener != null && bl2) {
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1, -1));
        }
        return bl;
    }

    public static boolean retrieveLongDataFromFile(TemporaryFile temporaryFile, TemporaryFile.FileMarker fileMarker, ETDataRequest eTDataRequest) throws ErrorException {
        assert (eTDataRequest.getColumn().getTypeMetadata().isCharacterOrBinaryType());
        long l = eTDataRequest.getOffset();
        long l2 = fileMarker.m_length - l;
        long l3 = eTDataRequest.getMaxSize();
        if (-1L == l3 || l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        long l4 = Math.min(l3, l2);
        boolean bl = false;
        if (l4 < l2) {
            bl = true;
        }
        fileMarker = new TemporaryFile.FileMarker(fileMarker.m_pos + l, l4);
        byte[] byArray = temporaryFile.get(fileMarker);
        if (eTDataRequest.getColumn().getTypeMetadata().isCharacterType()) {
            eTDataRequest.getData().setChar(DataRetrievalUtil.bytesToString(byArray));
        } else {
            eTDataRequest.getData().setBinary(byArray);
        }
        return bl;
    }

    public static String bytesToString(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.nativeOrder());
        char[] cArray = new char[byArray.length / 2];
        byteBuffer.asCharBuffer().get(cArray);
        return new String(cArray);
    }

    public static String rtrim(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        if (n == string.length() - 1) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static byte[] stringToBytes(String string) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() * 2).order(ByteOrder.nativeOrder());
        byteBuffer.asCharBuffer().put(string);
        return byteBuffer.array();
    }

    public static boolean retrieveFromRowView(int n, boolean bl, ETDataRequest eTDataRequest, IRowView iRowView, TemporaryFile temporaryFile) throws ErrorException {
        if (iRowView.isNull(n)) {
            eTDataRequest.getData().setNull();
            return false;
        }
        boolean bl2 = false;
        if (bl) {
            TemporaryFile.FileMarker fileMarker = iRowView.getFileMarker(n);
            bl2 = DataRetrievalUtil.retrieveLongDataFromFile(temporaryFile, fileMarker, eTDataRequest);
        } else {
            bl2 = DataRetrievalUtil.retrieveNotLongData(n, eTDataRequest, iRowView);
        }
        return bl2;
    }

    public static boolean retrieveFromRowView(int n, boolean bl, ETDataRequest eTDataRequest, IRowView iRowView, LongDataStore longDataStore) throws ErrorException {
        if (iRowView.isNull(n)) {
            eTDataRequest.getData().setNull();
            return false;
        }
        boolean bl2 = false;
        if (bl) {
            TemporaryFile.FileMarker fileMarker = iRowView.getFileMarker(n);
            bl2 = longDataStore.retrieveData(fileMarker, eTDataRequest);
        } else {
            bl2 = DataRetrievalUtil.retrieveNotLongData(n, eTDataRequest, iRowView);
        }
        return bl2;
    }

    private static boolean retrieveNotLongData(int n, ETDataRequest eTDataRequest, IRowView iRowView) throws ErrorException {
        boolean bl = false;
        DataRetrievalUtil.readToDataWrapper(n, eTDataRequest.getColumn(), eTDataRequest.getData(), iRowView);
        if (eTDataRequest.getColumn().getTypeMetadata().isCharacterType()) {
            bl = DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        } else if (eTDataRequest.getColumn().getTypeMetadata().isBinaryType()) {
            bl = DataRetrievalUtil.retrieveBinaryData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        }
        return bl;
    }

    private static void readToDataWrapper(int n, IColumn iColumn, ISqlDataWrapper iSqlDataWrapper, IRowView iRowView) throws ErrorException {
        if (iRowView.isNull(n)) {
            iSqlDataWrapper.setNull();
            return;
        }
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                long l = iRowView.getBigInt(n);
                iSqlDataWrapper.setBigInt(CompressionUtil.getlongAsBigInteger(l, iColumn.getTypeMetadata().isSigned()));
                break;
            }
            case 2: 
            case 3: {
                iSqlDataWrapper.setExactNumber(iRowView.getExactNumber(n));
                break;
            }
            case 6: 
            case 8: {
                iSqlDataWrapper.setDouble(iRowView.getDouble(n));
                break;
            }
            case 7: {
                iSqlDataWrapper.setReal(iRowView.getReal(n));
                break;
            }
            case -7: 
            case 16: {
                iSqlDataWrapper.setBoolean(iRowView.getBoolean(n));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                iSqlDataWrapper.setChar(iRowView.getString(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                iSqlDataWrapper.setBinary(iRowView.getBytes(n));
                break;
            }
            case 91: {
                iSqlDataWrapper.setDate(iRowView.getDate(n));
                break;
            }
            case 92: {
                iSqlDataWrapper.setTime(iRowView.getTime(n));
                break;
            }
            case 93: {
                iSqlDataWrapper.setTimestamp(iRowView.getTimestamp(n));
                break;
            }
            case -11: {
                iSqlDataWrapper.setGuid(iRowView.getGuid(n));
                break;
            }
            case 4: {
                int n2 = iRowView.getInteger(n);
                iSqlDataWrapper.setInteger(CompressionUtil.getIntAsLong(n2, iColumn.getTypeMetadata().isSigned()));
                break;
            }
            case 5: {
                short s = iRowView.getSmallInt(n);
                iSqlDataWrapper.setSmallInt(CompressionUtil.getSmallIntAsInteger(s, iColumn.getTypeMetadata().isSigned()));
                break;
            }
            case -6: {
                byte by = iRowView.getTinyInt(n);
                iSqlDataWrapper.setTinyInt(CompressionUtil.getTinyIntAsShort(by, iColumn.getTypeMetadata().isSigned()));
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + iSqlDataWrapper.getType());
            }
        }
    }
}

