/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETBoolean;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.bool.ETComparison;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.BooleanFunctorFactory;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.IBooleanCompFunctor;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.sqlengine.executor.etree.value.ETSimpleWhenClause;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETSimpleCase
extends ETValueExpr {
    private ETCachedValueExpr m_caseOperand;
    private ETValueExprList m_whenClauses;
    private ETValueExpr m_elseExpr;
    private ETBooleanExpr[] m_conditionsList;

    public ETSimpleCase(ETValueExpr eTValueExpr, IColumn iColumn, ETValueExprList eTValueExprList, ETValueExpr eTValueExpr2, List<IColumn> list, MaterializerContext materializerContext) throws ErrorException {
        this.m_caseOperand = new ETCachedValueExpr(eTValueExpr, iColumn);
        this.m_whenClauses = eTValueExprList;
        this.m_elseExpr = eTValueExpr2;
        this.initConditions(materializerContext, list, iColumn);
    }

    @Override
    public void close() {
        this.m_caseOperand.close();
        this.m_whenClauses.close();
        this.m_elseExpr.close();
        for (int i = 0; i < this.m_conditionsList.length; ++i) {
            this.m_conditionsList[i].close();
        }
    }

    @Override
    public boolean isOpen() {
        if (!this.m_caseOperand.isOpen() || !this.m_elseExpr.isOpen()) {
            return false;
        }
        Iterator iterator = this.m_whenClauses.getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            if (!((ETValueExpr)iterator.next()).isOpen() || !this.m_conditionsList[n].isOpen()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public void open() {
        this.m_caseOperand.open();
        this.m_whenClauses.open();
        this.m_elseExpr.open();
        for (int i = 0; i < this.m_conditionsList.length; ++i) {
            this.m_conditionsList[i].close();
        }
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        Iterator iterator = this.m_whenClauses.getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            ETSimpleWhenClause eTSimpleWhenClause = (ETSimpleWhenClause)iterator.next();
            if (ETBoolean.SQL_BOOLEAN_TRUE == this.m_conditionsList[n].evaluate()) {
                this.m_caseOperand.clearCache();
                return eTSimpleWhenClause.retrieveData(eTDataRequest);
            }
            ++n;
        }
        this.m_caseOperand.clearCache();
        return this.m_elseExpr.retrieveData(eTDataRequest);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.m_whenClauses;
        }
        if (1 == n) {
            return this.m_elseExpr;
        }
        throw new IndexOutOfBoundsException();
    }

    private void initConditions(MaterializerContext materializerContext, List<IColumn> list, IColumn iColumn) throws ErrorException {
        int n = this.m_whenClauses.getNumChildren();
        this.m_conditionsList = new ETBooleanExpr[n];
        Iterator iterator = this.m_whenClauses.getChildItr();
        int n2 = 0;
        while (iterator.hasNext()) {
            ETSimpleWhenClause eTSimpleWhenClause = (ETSimpleWhenClause)iterator.next();
            ETValueExpr eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(this.m_caseOperand, iColumn, list.get(n2), materializerContext);
            ETValueExpr eTValueExpr2 = eTSimpleWhenClause.getWhenOperand();
            IBooleanCompFunctor iBooleanCompFunctor = BooleanFunctorFactory.getBoolCompFunctor(AEComparisonType.EQUAL, list.get(n2).getTypeMetadata());
            this.m_conditionsList[n2] = new ETComparison(list.get(n2), eTValueExpr, eTValueExpr2, iBooleanCompFunctor);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ETCachedValueExpr
    extends ETValueExpr {
        private ETValueExpr m_cachedNode;
        private boolean m_hasCache;
        private boolean m_hasMoreData;
        private long m_lastRetrievedOffset;
        private ETDataRequest m_dataCache;

        public ETCachedValueExpr(ETValueExpr eTValueExpr, IColumn iColumn) throws ErrorException {
            this.m_cachedNode = eTValueExpr;
            this.m_hasCache = false;
            this.m_hasMoreData = false;
            this.m_lastRetrievedOffset = 0L;
            this.m_dataCache = new ETDataRequest(iColumn);
        }

        @Override
        public void close() {
            this.m_cachedNode.close();
        }

        @Override
        public boolean isOpen() {
            return this.m_cachedNode.isOpen();
        }

        @Override
        public void reset() {
            this.clearCache();
            this.m_cachedNode.reset();
        }

        public void clearCache() {
            this.m_hasCache = false;
        }

        @Override
        public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
            return this.m_cachedNode.acceptVisitor(iETNodeVisitor);
        }

        @Override
        public int getNumChildren() {
            return 1;
        }

        @Override
        public void open() {
            this.m_cachedNode.open();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            if (this.needRefreshCache(eTDataRequest)) {
                this.m_dataCache.setMaxBytes(eTDataRequest.getMaxSize());
                this.m_dataCache.setOffset(eTDataRequest.getOffset());
                this.m_hasMoreData = this.m_cachedNode.retrieveData(this.m_dataCache);
                this.m_lastRetrievedOffset = eTDataRequest.getOffset();
                this.m_hasCache = true;
            }
            DefaultSqlDataWrapper.setDataWrapperFromDataWrapper(this.m_dataCache.getData(), eTDataRequest.getData());
            boolean bl = false;
            if (!eTDataRequest.getData().isNull() && TypeUtilities.isCharacterType(eTDataRequest.getData().getType())) {
                bl = DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            } else if (!eTDataRequest.getData().isNull() && TypeUtilities.isBinaryType(eTDataRequest.getData().getType())) {
                bl = DataRetrievalUtil.retrieveBinaryData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            }
            return this.m_hasMoreData || bl;
        }

        @Override
        protected IETNode getChild(int n) throws IndexOutOfBoundsException {
            if (0 == n) {
                return this.m_cachedNode;
            }
            throw new IndexOutOfBoundsException();
        }

        private boolean needRefreshCache(ETDataRequest eTDataRequest) throws ErrorException {
            if (!this.m_hasCache || this.m_lastRetrievedOffset > eTDataRequest.getOffset()) {
                return true;
            }
            if (-1L == eTDataRequest.getMaxSize()) {
                return this.m_hasMoreData;
            }
            if (!this.m_hasMoreData) {
                return false;
            }
            if (TypeUtilities.isCharacterType(eTDataRequest.getData().getType())) {
                int n = eTDataRequest.getData().getChar().length();
                long l = (long)n - (eTDataRequest.getOffset() - this.m_lastRetrievedOffset) / 2L;
                return l < eTDataRequest.getMaxSize();
            }
            if (TypeUtilities.isBinaryType(eTDataRequest.getData().getType())) {
                int n = eTDataRequest.getData().getBinary().length;
                long l = (long)n - (eTDataRequest.getOffset() - this.m_lastRetrievedOffset);
                return l < eTDataRequest.getMaxSize();
            }
            return false;
        }
    }
}

