/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.streams.resultset;

import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.InputOutputException;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.streams.resultset.AbstractInputStream;
import java.io.IOException;

public abstract class AbstractCharacterStream
extends AbstractInputStream {
    private final String m_charSet;

    protected AbstractCharacterStream(IResultSet iResultSet, int n, String string, int n2) {
        super(iResultSet, n, n2);
        this.m_charSet = string;
    }

    @Override
    public int available() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (this.m_buffer.length <= this.m_bufferOffset) {
            if (!this.m_moreData) {
                return -1;
            }
            this.fetchNewData();
            if (0 == this.m_buffer.length) {
                return -1;
            }
        }
        return this.m_buffer[this.m_bufferOffset++];
    }

    private void fetchNewData() throws IOException {
        try {
            DataWrapper dataWrapper = new DataWrapper();
            this.m_moreData = this.m_result.getData(this.m_column, this.m_readOffset, this.m_bufferSize, dataWrapper);
            this.m_bufferOffset = 0;
            this.m_readOffset += this.m_bufferSize;
            this.m_buffer = ((String)dataWrapper.getObject()).getBytes(this.m_charSet);
            if (1 < this.m_buffer.length && this.m_charSet.startsWith("UTF-16") && (-1 == this.m_buffer[0] && -2 == this.m_buffer[1] || -2 == this.m_buffer[0] && -1 == this.m_buffer[1])) {
                this.m_bufferOffset = 2;
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
    }
}

