// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14419 = [];
var len__7107__auto___14429 = arguments.length;
var i__7108__auto___14430 = (0);
while(true){
if((i__7108__auto___14430 < len__7107__auto___14429)){
args14419.push((arguments[i__7108__auto___14430]));

var G__14431 = (i__7108__auto___14430 + (1));
i__7108__auto___14430 = G__14431;
continue;
} else {
}
break;
}

var G__14425 = args14419.length;
switch (G__14425) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14419.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14426 = (function (f,blockable,meta14427){
this.f = f;
this.blockable = blockable;
this.meta14427 = meta14427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14428,meta14427__$1){
var self__ = this;
var _14428__$1 = this;
return (new cljs.core.async.t_cljs$core$async14426(self__.f,self__.blockable,meta14427__$1));
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14428){
var self__ = this;
var _14428__$1 = this;
return self__.meta14427;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14427","meta14427",-969928677,null)], null);
});

cljs.core.async.t_cljs$core$async14426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14426";

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14426");
});

cljs.core.async.__GT_t_cljs$core$async14426 = (function cljs$core$async$__GT_t_cljs$core$async14426(f__$1,blockable__$1,meta14427){
return (new cljs.core.async.t_cljs$core$async14426(f__$1,blockable__$1,meta14427));
});

}

return (new cljs.core.async.t_cljs$core$async14426(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14439 = [];
var len__7107__auto___14444 = arguments.length;
var i__7108__auto___14445 = (0);
while(true){
if((i__7108__auto___14445 < len__7107__auto___14444)){
args14439.push((arguments[i__7108__auto___14445]));

var G__14446 = (i__7108__auto___14445 + (1));
i__7108__auto___14445 = G__14446;
continue;
} else {
}
break;
}

var G__14441 = args14439.length;
switch (G__14441) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14439.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14451 = [];
var len__7107__auto___14454 = arguments.length;
var i__7108__auto___14455 = (0);
while(true){
if((i__7108__auto___14455 < len__7107__auto___14454)){
args14451.push((arguments[i__7108__auto___14455]));

var G__14456 = (i__7108__auto___14455 + (1));
i__7108__auto___14455 = G__14456;
continue;
} else {
}
break;
}

var G__14453 = args14451.length;
switch (G__14453) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14451.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14466 = [];
var len__7107__auto___14471 = arguments.length;
var i__7108__auto___14472 = (0);
while(true){
if((i__7108__auto___14472 < len__7107__auto___14471)){
args14466.push((arguments[i__7108__auto___14472]));

var G__14473 = (i__7108__auto___14472 + (1));
i__7108__auto___14472 = G__14473;
continue;
} else {
}
break;
}

var G__14470 = args14466.length;
switch (G__14470) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14466.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14478 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14478);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14478,ret){
return (function (){
return fn1.call(null,val_14478);
});})(val_14478,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14480 = [];
var len__7107__auto___14488 = arguments.length;
var i__7108__auto___14489 = (0);
while(true){
if((i__7108__auto___14489 < len__7107__auto___14488)){
args14480.push((arguments[i__7108__auto___14489]));

var G__14490 = (i__7108__auto___14489 + (1));
i__7108__auto___14489 = G__14490;
continue;
} else {
}
break;
}

var G__14486 = args14480.length;
switch (G__14486) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14480.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14498 = n;
var x_14500 = (0);
while(true){
if((x_14500 < n__6952__auto___14498)){
(a[x_14500] = (0));

var G__14501 = (x_14500 + (1));
x_14500 = G__14501;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14502 = (i + (1));
i = G__14502;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14506 = (function (alt_flag,flag,meta14507){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14507 = meta14507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14508,meta14507__$1){
var self__ = this;
var _14508__$1 = this;
return (new cljs.core.async.t_cljs$core$async14506(self__.alt_flag,self__.flag,meta14507__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14508){
var self__ = this;
var _14508__$1 = this;
return self__.meta14507;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14507","meta14507",-708852072,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14506";

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14506");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14506 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507){
return (new cljs.core.async.t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14506(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_handler,flag,cb,meta14513){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_handler,self__.flag,self__.cb,meta14513__$1));
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14512.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});

cljs.core.async.__GT_t_cljs$core$async14512 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513));
});

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14518_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14518_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14519_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14519_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14526 = (i + (1));
i = G__14526;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14534 = arguments.length;
var i__7108__auto___14535 = (0);
while(true){
if((i__7108__auto___14535 < len__7107__auto___14534)){
args__7114__auto__.push((arguments[i__7108__auto___14535]));

var G__14536 = (i__7108__auto___14535 + (1));
i__7108__auto___14535 = G__14536;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14530){
var map__14531 = p__14530;
var map__14531__$1 = ((((!((map__14531 == null)))?((((map__14531.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14531.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14531):map__14531);
var opts = map__14531__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14527){
var G__14528 = cljs.core.first.call(null,seq14527);
var seq14527__$1 = cljs.core.next.call(null,seq14527);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14528,seq14527__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14538 = [];
var len__7107__auto___14595 = arguments.length;
var i__7108__auto___14596 = (0);
while(true){
if((i__7108__auto___14596 < len__7107__auto___14595)){
args14538.push((arguments[i__7108__auto___14596]));

var G__14597 = (i__7108__auto___14596 + (1));
i__7108__auto___14596 = G__14597;
continue;
} else {
}
break;
}

var G__14540 = args14538.length;
switch (G__14540) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14538.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14368__auto___14599 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___14599){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___14599){
return (function (state_14564){
var state_val_14565 = (state_14564[(1)]);
if((state_val_14565 === (7))){
var inst_14560 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14566_14600 = state_14564__$1;
(statearr_14566_14600[(2)] = inst_14560);

(statearr_14566_14600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (1))){
var state_14564__$1 = state_14564;
var statearr_14567_14601 = state_14564__$1;
(statearr_14567_14601[(2)] = null);

(statearr_14567_14601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (4))){
var inst_14543 = (state_14564[(7)]);
var inst_14543__$1 = (state_14564[(2)]);
var inst_14544 = (inst_14543__$1 == null);
var state_14564__$1 = (function (){var statearr_14568 = state_14564;
(statearr_14568[(7)] = inst_14543__$1);

return statearr_14568;
})();
if(cljs.core.truth_(inst_14544)){
var statearr_14569_14602 = state_14564__$1;
(statearr_14569_14602[(1)] = (5));

} else {
var statearr_14570_14603 = state_14564__$1;
(statearr_14570_14603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (13))){
var state_14564__$1 = state_14564;
var statearr_14571_14604 = state_14564__$1;
(statearr_14571_14604[(2)] = null);

(statearr_14571_14604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (6))){
var inst_14543 = (state_14564[(7)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14564__$1,(11),to,inst_14543);
} else {
if((state_val_14565 === (3))){
var inst_14562 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14564__$1,inst_14562);
} else {
if((state_val_14565 === (12))){
var state_14564__$1 = state_14564;
var statearr_14574_14605 = state_14564__$1;
(statearr_14574_14605[(2)] = null);

(statearr_14574_14605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (2))){
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14564__$1,(4),from);
} else {
if((state_val_14565 === (11))){
var inst_14553 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
if(cljs.core.truth_(inst_14553)){
var statearr_14575_14606 = state_14564__$1;
(statearr_14575_14606[(1)] = (12));

} else {
var statearr_14576_14607 = state_14564__$1;
(statearr_14576_14607[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (9))){
var state_14564__$1 = state_14564;
var statearr_14578_14608 = state_14564__$1;
(statearr_14578_14608[(2)] = null);

(statearr_14578_14608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (5))){
var state_14564__$1 = state_14564;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14579_14611 = state_14564__$1;
(statearr_14579_14611[(1)] = (8));

} else {
var statearr_14580_14612 = state_14564__$1;
(statearr_14580_14612[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (14))){
var inst_14558 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14581_14613 = state_14564__$1;
(statearr_14581_14613[(2)] = inst_14558);

(statearr_14581_14613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (10))){
var inst_14550 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14582_14614 = state_14564__$1;
(statearr_14582_14614[(2)] = inst_14550);

(statearr_14582_14614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (8))){
var inst_14547 = cljs.core.async.close_BANG_.call(null,to);
var state_14564__$1 = state_14564;
var statearr_14583_14615 = state_14564__$1;
(statearr_14583_14615[(2)] = inst_14547);

(statearr_14583_14615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___14599))
;
return ((function (switch__14236__auto__,c__14368__auto___14599){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14591 = [null,null,null,null,null,null,null,null];
(statearr_14591[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14591[(1)] = (1));

return statearr_14591;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14564){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14592){if((e14592 instanceof Object)){
var ex__14240__auto__ = e14592;
var statearr_14593_14619 = state_14564;
(statearr_14593_14619[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14620 = state_14564;
state_14564 = G__14620;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___14599))
})();
var state__14370__auto__ = (function (){var statearr_14594 = f__14369__auto__.call(null);
(statearr_14594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___14599);

return statearr_14594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___14599))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14834){
var vec__14835 = p__14834;
var v = cljs.core.nth.call(null,vec__14835,(0),null);
var p = cljs.core.nth.call(null,vec__14835,(1),null);
var job = vec__14835;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14368__auto___15025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function (state_14840){
var state_val_14841 = (state_14840[(1)]);
if((state_val_14841 === (1))){
var state_14840__$1 = state_14840;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14840__$1,(2),res,v);
} else {
if((state_val_14841 === (2))){
var inst_14837 = (state_14840[(2)]);
var inst_14838 = cljs.core.async.close_BANG_.call(null,res);
var state_14840__$1 = (function (){var statearr_14842 = state_14840;
(statearr_14842[(7)] = inst_14837);

return statearr_14842;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14840__$1,inst_14838);
} else {
return null;
}
}
});})(c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14846 = [null,null,null,null,null,null,null,null];
(statearr_14846[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14846[(1)] = (1));

return statearr_14846;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14840){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14847){if((e14847 instanceof Object)){
var ex__14240__auto__ = e14847;
var statearr_14848_15026 = state_14840;
(statearr_14848_15026[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14840);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14847;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_14840;
state_14840 = G__15027;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14840){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
})();
var state__14370__auto__ = (function (){var statearr_14849 = f__14369__auto__.call(null);
(statearr_14849[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15025);

return statearr_14849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14850){
var vec__14851 = p__14850;
var v = cljs.core.nth.call(null,vec__14851,(0),null);
var p = cljs.core.nth.call(null,vec__14851,(1),null);
var job = vec__14851;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15028 = n;
var __15029 = (0);
while(true){
if((__15029 < n__6952__auto___15028)){
var G__14852_15030 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14852_15030) {
case "compute":
var c__14368__auto___15032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14865){
var state_val_14866 = (state_14865[(1)]);
if((state_val_14866 === (1))){
var state_14865__$1 = state_14865;
var statearr_14867_15033 = state_14865__$1;
(statearr_14867_15033[(2)] = null);

(statearr_14867_15033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (2))){
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14865__$1,(4),jobs);
} else {
if((state_val_14866 === (3))){
var inst_14863 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14865__$1,inst_14863);
} else {
if((state_val_14866 === (4))){
var inst_14855 = (state_14865[(2)]);
var inst_14856 = process.call(null,inst_14855);
var state_14865__$1 = state_14865;
if(cljs.core.truth_(inst_14856)){
var statearr_14868_15034 = state_14865__$1;
(statearr_14868_15034[(1)] = (5));

} else {
var statearr_14869_15035 = state_14865__$1;
(statearr_14869_15035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (5))){
var state_14865__$1 = state_14865;
var statearr_14870_15036 = state_14865__$1;
(statearr_14870_15036[(2)] = null);

(statearr_14870_15036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (6))){
var state_14865__$1 = state_14865;
var statearr_14871_15037 = state_14865__$1;
(statearr_14871_15037[(2)] = null);

(statearr_14871_15037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (7))){
var inst_14861 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
var statearr_14872_15038 = state_14865__$1;
(statearr_14872_15038[(2)] = inst_14861);

(statearr_14872_15038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14876 = [null,null,null,null,null,null,null];
(statearr_14876[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14876[(1)] = (1));

return statearr_14876;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14865){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14877){if((e14877 instanceof Object)){
var ex__14240__auto__ = e14877;
var statearr_14878_15039 = state_14865;
(statearr_14878_15039[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14865);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15040 = state_14865;
state_14865 = G__15040;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14865){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14879 = f__14369__auto__.call(null);
(statearr_14879[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15032);

return statearr_14879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
case "async":
var c__14368__auto___15041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14892){
var state_val_14893 = (state_14892[(1)]);
if((state_val_14893 === (1))){
var state_14892__$1 = state_14892;
var statearr_14894_15042 = state_14892__$1;
(statearr_14894_15042[(2)] = null);

(statearr_14894_15042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (2))){
var state_14892__$1 = state_14892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14892__$1,(4),jobs);
} else {
if((state_val_14893 === (3))){
var inst_14890 = (state_14892[(2)]);
var state_14892__$1 = state_14892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14892__$1,inst_14890);
} else {
if((state_val_14893 === (4))){
var inst_14882 = (state_14892[(2)]);
var inst_14883 = async.call(null,inst_14882);
var state_14892__$1 = state_14892;
if(cljs.core.truth_(inst_14883)){
var statearr_14895_15043 = state_14892__$1;
(statearr_14895_15043[(1)] = (5));

} else {
var statearr_14896_15044 = state_14892__$1;
(statearr_14896_15044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (5))){
var state_14892__$1 = state_14892;
var statearr_14897_15045 = state_14892__$1;
(statearr_14897_15045[(2)] = null);

(statearr_14897_15045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (6))){
var state_14892__$1 = state_14892;
var statearr_14898_15046 = state_14892__$1;
(statearr_14898_15046[(2)] = null);

(statearr_14898_15046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (7))){
var inst_14888 = (state_14892[(2)]);
var state_14892__$1 = state_14892;
var statearr_14899_15047 = state_14892__$1;
(statearr_14899_15047[(2)] = inst_14888);

(statearr_14899_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14906 = [null,null,null,null,null,null,null];
(statearr_14906[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14906[(1)] = (1));

return statearr_14906;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14892){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14907){if((e14907 instanceof Object)){
var ex__14240__auto__ = e14907;
var statearr_14908_15048 = state_14892;
(statearr_14908_15048[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14892);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14907;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15049 = state_14892;
state_14892 = G__15049;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14892){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14909 = f__14369__auto__.call(null);
(statearr_14909[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15041);

return statearr_14909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15050 = (__15029 + (1));
__15029 = G__15050;
continue;
} else {
}
break;
}

var c__14368__auto___15051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15051,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15051,jobs,results,process,async){
return (function (state_14932){
var state_val_14933 = (state_14932[(1)]);
if((state_val_14933 === (1))){
var state_14932__$1 = state_14932;
var statearr_14934_15052 = state_14932__$1;
(statearr_14934_15052[(2)] = null);

(statearr_14934_15052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14933 === (2))){
var state_14932__$1 = state_14932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14932__$1,(4),from);
} else {
if((state_val_14933 === (3))){
var inst_14930 = (state_14932[(2)]);
var state_14932__$1 = state_14932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14932__$1,inst_14930);
} else {
if((state_val_14933 === (4))){
var inst_14913 = (state_14932[(7)]);
var inst_14913__$1 = (state_14932[(2)]);
var inst_14914 = (inst_14913__$1 == null);
var state_14932__$1 = (function (){var statearr_14935 = state_14932;
(statearr_14935[(7)] = inst_14913__$1);

return statearr_14935;
})();
if(cljs.core.truth_(inst_14914)){
var statearr_14936_15055 = state_14932__$1;
(statearr_14936_15055[(1)] = (5));

} else {
var statearr_14937_15056 = state_14932__$1;
(statearr_14937_15056[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14933 === (5))){
var inst_14916 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14932__$1 = state_14932;
var statearr_14938_15057 = state_14932__$1;
(statearr_14938_15057[(2)] = inst_14916);

(statearr_14938_15057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14933 === (6))){
var inst_14913 = (state_14932[(7)]);
var inst_14918 = (state_14932[(8)]);
var inst_14918__$1 = cljs.core.async.chan.call(null,(1));
var inst_14919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14920 = [inst_14913,inst_14918__$1];
var inst_14921 = (new cljs.core.PersistentVector(null,2,(5),inst_14919,inst_14920,null));
var state_14932__$1 = (function (){var statearr_14939 = state_14932;
(statearr_14939[(8)] = inst_14918__$1);

return statearr_14939;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14932__$1,(8),jobs,inst_14921);
} else {
if((state_val_14933 === (7))){
var inst_14928 = (state_14932[(2)]);
var state_14932__$1 = state_14932;
var statearr_14943_15058 = state_14932__$1;
(statearr_14943_15058[(2)] = inst_14928);

(statearr_14943_15058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14933 === (8))){
var inst_14918 = (state_14932[(8)]);
var inst_14923 = (state_14932[(2)]);
var state_14932__$1 = (function (){var statearr_14944 = state_14932;
(statearr_14944[(9)] = inst_14923);

return statearr_14944;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14932__$1,(9),results,inst_14918);
} else {
if((state_val_14933 === (9))){
var inst_14925 = (state_14932[(2)]);
var state_14932__$1 = (function (){var statearr_14945 = state_14932;
(statearr_14945[(10)] = inst_14925);

return statearr_14945;
})();
var statearr_14946_15059 = state_14932__$1;
(statearr_14946_15059[(2)] = null);

(statearr_14946_15059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15051,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto___15051,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14950 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14950[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14950[(1)] = (1));

return statearr_14950;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14932){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14951){if((e14951 instanceof Object)){
var ex__14240__auto__ = e14951;
var statearr_14952_15060 = state_14932;
(statearr_14952_15060[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15062 = state_14932;
state_14932 = G__15062;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14932){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15051,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14953 = f__14369__auto__.call(null);
(statearr_14953[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15051);

return statearr_14953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15051,jobs,results,process,async))
);


var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15064 = state_14992__$1;
(statearr_14994_15064[(2)] = inst_14988);

(statearr_14994_15064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15065 = state_14992__$1;
(statearr_14995_15065[(2)] = null);

(statearr_14995_15065[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15066 = state_14992__$1;
(statearr_14996_15066[(2)] = null);

(statearr_14996_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14956 = (state_14992[(7)]);
var inst_14956__$1 = (state_14992[(2)]);
var inst_14957 = (inst_14956__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14956__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14957)){
var statearr_14998_15067 = state_14992__$1;
(statearr_14998_15067[(1)] = (5));

} else {
var statearr_14999_15068 = state_14992__$1;
(statearr_14999_15068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14969 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14969);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15069 = state_14992__$1;
(statearr_15000_15069[(2)] = inst_14983);

(statearr_15000_15069[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15070 = state_14992__$1;
(statearr_15002_15070[(2)] = null);

(statearr_15002_15070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14956 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14956);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15076 = state_14992__$1;
(statearr_15003_15076[(1)] = (19));

} else {
var statearr_15004_15077 = state_14992__$1;
(statearr_15004_15077[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14966 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14966);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15083 = state_14992__$1;
(statearr_15005_15083[(2)] = null);

(statearr_15005_15083[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14966 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14966);

return statearr_15006;
})();
var statearr_15007_15084 = state_14992__$1;
(statearr_15007_15084[(2)] = null);

(statearr_15007_15084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15085 = state_14992__$1;
(statearr_15008_15085[(2)] = null);

(statearr_15008_15085[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15086 = state_14992__$1;
(statearr_15009_15086[(1)] = (8));

} else {
var statearr_15010_15087 = state_14992__$1;
(statearr_15010_15087[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14969 = (state_14992[(8)]);
var inst_14969__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14969__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14969__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15088 = state_14992__$1;
(statearr_15012_15088[(1)] = (15));

} else {
var statearr_15013_15089 = state_14992__$1;
(statearr_15013_15089[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15090 = state_14992__$1;
(statearr_15014_15090[(2)] = inst_14972);

(statearr_15014_15090[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14963 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15091 = state_14992__$1;
(statearr_15015_15091[(2)] = inst_14963);

(statearr_15015_15091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15092 = state_14992__$1;
(statearr_15016_15092[(2)] = inst_14975);

(statearr_15016_15092[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14960 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15093 = state_14992__$1;
(statearr_15017_15093[(2)] = inst_14960);

(statearr_15017_15093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15094 = state_14992;
(statearr_15023_15094[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15095 = state_14992;
state_14992 = G__15095;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_15024 = f__14369__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,jobs,results,process,async))
);

return c__14368__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15096 = [];
var len__7107__auto___15101 = arguments.length;
var i__7108__auto___15102 = (0);
while(true){
if((i__7108__auto___15102 < len__7107__auto___15101)){
args15096.push((arguments[i__7108__auto___15102]));

var G__15103 = (i__7108__auto___15102 + (1));
i__7108__auto___15102 = G__15103;
continue;
} else {
}
break;
}

var G__15100 = args15096.length;
switch (G__15100) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15096.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15108 = [];
var len__7107__auto___15111 = arguments.length;
var i__7108__auto___15112 = (0);
while(true){
if((i__7108__auto___15112 < len__7107__auto___15111)){
args15108.push((arguments[i__7108__auto___15112]));

var G__15113 = (i__7108__auto___15112 + (1));
i__7108__auto___15112 = G__15113;
continue;
} else {
}
break;
}

var G__15110 = args15108.length;
switch (G__15110) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15108.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15116 = [];
var len__7107__auto___15172 = arguments.length;
var i__7108__auto___15173 = (0);
while(true){
if((i__7108__auto___15173 < len__7107__auto___15172)){
args15116.push((arguments[i__7108__auto___15173]));

var G__15174 = (i__7108__auto___15173 + (1));
i__7108__auto___15173 = G__15174;
continue;
} else {
}
break;
}

var G__15118 = args15116.length;
switch (G__15118) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15116.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14368__auto___15177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15177,tc,fc){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15177,tc,fc){
return (function (state_15144){
var state_val_15145 = (state_15144[(1)]);
if((state_val_15145 === (7))){
var inst_15140 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15146_15178 = state_15144__$1;
(statearr_15146_15178[(2)] = inst_15140);

(statearr_15146_15178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (1))){
var state_15144__$1 = state_15144;
var statearr_15147_15179 = state_15144__$1;
(statearr_15147_15179[(2)] = null);

(statearr_15147_15179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (4))){
var inst_15121 = (state_15144[(7)]);
var inst_15121__$1 = (state_15144[(2)]);
var inst_15122 = (inst_15121__$1 == null);
var state_15144__$1 = (function (){var statearr_15148 = state_15144;
(statearr_15148[(7)] = inst_15121__$1);

return statearr_15148;
})();
if(cljs.core.truth_(inst_15122)){
var statearr_15149_15180 = state_15144__$1;
(statearr_15149_15180[(1)] = (5));

} else {
var statearr_15150_15181 = state_15144__$1;
(statearr_15150_15181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (13))){
var state_15144__$1 = state_15144;
var statearr_15154_15182 = state_15144__$1;
(statearr_15154_15182[(2)] = null);

(statearr_15154_15182[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (6))){
var inst_15121 = (state_15144[(7)]);
var inst_15127 = p.call(null,inst_15121);
var state_15144__$1 = state_15144;
if(cljs.core.truth_(inst_15127)){
var statearr_15155_15183 = state_15144__$1;
(statearr_15155_15183[(1)] = (9));

} else {
var statearr_15156_15184 = state_15144__$1;
(statearr_15156_15184[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (3))){
var inst_15142 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15144__$1,inst_15142);
} else {
if((state_val_15145 === (12))){
var state_15144__$1 = state_15144;
var statearr_15157_15185 = state_15144__$1;
(statearr_15157_15185[(2)] = null);

(statearr_15157_15185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (2))){
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15144__$1,(4),ch);
} else {
if((state_val_15145 === (11))){
var inst_15121 = (state_15144[(7)]);
var inst_15131 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15144__$1,(8),inst_15131,inst_15121);
} else {
if((state_val_15145 === (9))){
var state_15144__$1 = state_15144;
var statearr_15158_15186 = state_15144__$1;
(statearr_15158_15186[(2)] = tc);

(statearr_15158_15186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (5))){
var inst_15124 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15125 = cljs.core.async.close_BANG_.call(null,fc);
var state_15144__$1 = (function (){var statearr_15159 = state_15144;
(statearr_15159[(8)] = inst_15124);

return statearr_15159;
})();
var statearr_15160_15187 = state_15144__$1;
(statearr_15160_15187[(2)] = inst_15125);

(statearr_15160_15187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (14))){
var inst_15138 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15161_15188 = state_15144__$1;
(statearr_15161_15188[(2)] = inst_15138);

(statearr_15161_15188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (10))){
var state_15144__$1 = state_15144;
var statearr_15162_15189 = state_15144__$1;
(statearr_15162_15189[(2)] = fc);

(statearr_15162_15189[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (8))){
var inst_15133 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
if(cljs.core.truth_(inst_15133)){
var statearr_15163_15190 = state_15144__$1;
(statearr_15163_15190[(1)] = (12));

} else {
var statearr_15164_15191 = state_15144__$1;
(statearr_15164_15191[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15177,tc,fc))
;
return ((function (switch__14236__auto__,c__14368__auto___15177,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15168 = [null,null,null,null,null,null,null,null,null];
(statearr_15168[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15168[(1)] = (1));

return statearr_15168;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15144){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15169){if((e15169 instanceof Object)){
var ex__14240__auto__ = e15169;
var statearr_15170_15192 = state_15144;
(statearr_15170_15192[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15144);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15169;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15193 = state_15144;
state_15144 = G__15193;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15144){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15177,tc,fc))
})();
var state__14370__auto__ = (function (){var statearr_15171 = f__14369__auto__.call(null);
(statearr_15171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15177);

return statearr_15171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15177,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15270){
var state_val_15271 = (state_15270[(1)]);
if((state_val_15271 === (7))){
var inst_15265 = (state_15270[(2)]);
var state_15270__$1 = state_15270;
var statearr_15276_15309 = state_15270__$1;
(statearr_15276_15309[(2)] = inst_15265);

(statearr_15276_15309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (1))){
var inst_15237 = init;
var state_15270__$1 = (function (){var statearr_15278 = state_15270;
(statearr_15278[(7)] = inst_15237);

return statearr_15278;
})();
var statearr_15279_15310 = state_15270__$1;
(statearr_15279_15310[(2)] = null);

(statearr_15279_15310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (4))){
var inst_15244 = (state_15270[(8)]);
var inst_15244__$1 = (state_15270[(2)]);
var inst_15245 = (inst_15244__$1 == null);
var state_15270__$1 = (function (){var statearr_15281 = state_15270;
(statearr_15281[(8)] = inst_15244__$1);

return statearr_15281;
})();
if(cljs.core.truth_(inst_15245)){
var statearr_15282_15311 = state_15270__$1;
(statearr_15282_15311[(1)] = (5));

} else {
var statearr_15283_15312 = state_15270__$1;
(statearr_15283_15312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (6))){
var inst_15248 = (state_15270[(9)]);
var inst_15244 = (state_15270[(8)]);
var inst_15237 = (state_15270[(7)]);
var inst_15248__$1 = f.call(null,inst_15237,inst_15244);
var inst_15249 = cljs.core.reduced_QMARK_.call(null,inst_15248__$1);
var state_15270__$1 = (function (){var statearr_15289 = state_15270;
(statearr_15289[(9)] = inst_15248__$1);

return statearr_15289;
})();
if(inst_15249){
var statearr_15290_15313 = state_15270__$1;
(statearr_15290_15313[(1)] = (8));

} else {
var statearr_15291_15314 = state_15270__$1;
(statearr_15291_15314[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (3))){
var inst_15267 = (state_15270[(2)]);
var state_15270__$1 = state_15270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15270__$1,inst_15267);
} else {
if((state_val_15271 === (2))){
var state_15270__$1 = state_15270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15270__$1,(4),ch);
} else {
if((state_val_15271 === (9))){
var inst_15248 = (state_15270[(9)]);
var inst_15237 = inst_15248;
var state_15270__$1 = (function (){var statearr_15297 = state_15270;
(statearr_15297[(7)] = inst_15237);

return statearr_15297;
})();
var statearr_15298_15318 = state_15270__$1;
(statearr_15298_15318[(2)] = null);

(statearr_15298_15318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (5))){
var inst_15237 = (state_15270[(7)]);
var state_15270__$1 = state_15270;
var statearr_15299_15320 = state_15270__$1;
(statearr_15299_15320[(2)] = inst_15237);

(statearr_15299_15320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (10))){
var inst_15255 = (state_15270[(2)]);
var state_15270__$1 = state_15270;
var statearr_15300_15321 = state_15270__$1;
(statearr_15300_15321[(2)] = inst_15255);

(statearr_15300_15321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15271 === (8))){
var inst_15248 = (state_15270[(9)]);
var inst_15251 = cljs.core.deref.call(null,inst_15248);
var state_15270__$1 = state_15270;
var statearr_15301_15322 = state_15270__$1;
(statearr_15301_15322[(2)] = inst_15251);

(statearr_15301_15322[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15305 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15305[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15305[(1)] = (1));

return statearr_15305;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15270){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15306){if((e15306 instanceof Object)){
var ex__14240__auto__ = e15306;
var statearr_15307_15323 = state_15270;
(statearr_15307_15323[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15270);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15324 = state_15270;
state_15270 = G__15324;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15270){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15308 = f__14369__auto__.call(null);
(statearr_15308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15325 = [];
var len__7107__auto___15384 = arguments.length;
var i__7108__auto___15385 = (0);
while(true){
if((i__7108__auto___15385 < len__7107__auto___15384)){
args15325.push((arguments[i__7108__auto___15385]));

var G__15386 = (i__7108__auto___15385 + (1));
i__7108__auto___15385 = G__15386;
continue;
} else {
}
break;
}

var G__15330 = args15325.length;
switch (G__15330) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15325.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15356){
var state_val_15357 = (state_15356[(1)]);
if((state_val_15357 === (7))){
var inst_15337 = (state_15356[(2)]);
var state_15356__$1 = state_15356;
var statearr_15358_15389 = state_15356__$1;
(statearr_15358_15389[(2)] = inst_15337);

(statearr_15358_15389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (1))){
var inst_15331 = cljs.core.seq.call(null,coll);
var inst_15332 = inst_15331;
var state_15356__$1 = (function (){var statearr_15359 = state_15356;
(statearr_15359[(7)] = inst_15332);

return statearr_15359;
})();
var statearr_15360_15390 = state_15356__$1;
(statearr_15360_15390[(2)] = null);

(statearr_15360_15390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (4))){
var inst_15332 = (state_15356[(7)]);
var inst_15335 = cljs.core.first.call(null,inst_15332);
var state_15356__$1 = state_15356;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15356__$1,(7),ch,inst_15335);
} else {
if((state_val_15357 === (13))){
var inst_15350 = (state_15356[(2)]);
var state_15356__$1 = state_15356;
var statearr_15361_15391 = state_15356__$1;
(statearr_15361_15391[(2)] = inst_15350);

(statearr_15361_15391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (6))){
var inst_15340 = (state_15356[(2)]);
var state_15356__$1 = state_15356;
if(cljs.core.truth_(inst_15340)){
var statearr_15362_15392 = state_15356__$1;
(statearr_15362_15392[(1)] = (8));

} else {
var statearr_15363_15393 = state_15356__$1;
(statearr_15363_15393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (3))){
var inst_15354 = (state_15356[(2)]);
var state_15356__$1 = state_15356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15356__$1,inst_15354);
} else {
if((state_val_15357 === (12))){
var state_15356__$1 = state_15356;
var statearr_15364_15394 = state_15356__$1;
(statearr_15364_15394[(2)] = null);

(statearr_15364_15394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (2))){
var inst_15332 = (state_15356[(7)]);
var state_15356__$1 = state_15356;
if(cljs.core.truth_(inst_15332)){
var statearr_15365_15395 = state_15356__$1;
(statearr_15365_15395[(1)] = (4));

} else {
var statearr_15366_15396 = state_15356__$1;
(statearr_15366_15396[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (11))){
var inst_15346 = cljs.core.async.close_BANG_.call(null,ch);
var state_15356__$1 = state_15356;
var statearr_15367_15397 = state_15356__$1;
(statearr_15367_15397[(2)] = inst_15346);

(statearr_15367_15397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (9))){
var state_15356__$1 = state_15356;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15368_15398 = state_15356__$1;
(statearr_15368_15398[(1)] = (11));

} else {
var statearr_15369_15399 = state_15356__$1;
(statearr_15369_15399[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (5))){
var inst_15332 = (state_15356[(7)]);
var state_15356__$1 = state_15356;
var statearr_15370_15400 = state_15356__$1;
(statearr_15370_15400[(2)] = inst_15332);

(statearr_15370_15400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (10))){
var inst_15352 = (state_15356[(2)]);
var state_15356__$1 = state_15356;
var statearr_15371_15401 = state_15356__$1;
(statearr_15371_15401[(2)] = inst_15352);

(statearr_15371_15401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15357 === (8))){
var inst_15332 = (state_15356[(7)]);
var inst_15342 = cljs.core.next.call(null,inst_15332);
var inst_15332__$1 = inst_15342;
var state_15356__$1 = (function (){var statearr_15372 = state_15356;
(statearr_15372[(7)] = inst_15332__$1);

return statearr_15372;
})();
var statearr_15373_15402 = state_15356__$1;
(statearr_15373_15402[(2)] = null);

(statearr_15373_15402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15380 = [null,null,null,null,null,null,null,null];
(statearr_15380[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15380[(1)] = (1));

return statearr_15380;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15356){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15381){if((e15381 instanceof Object)){
var ex__14240__auto__ = e15381;
var statearr_15382_15403 = state_15356;
(statearr_15382_15403[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15356);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15404 = state_15356;
state_15356 = G__15404;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15356){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15383 = f__14369__auto__.call(null);
(statearr_15383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15643 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15643 = (function (mult,ch,cs,meta15644){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15644 = meta15644;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15645,meta15644__$1){
var self__ = this;
var _15645__$1 = this;
return (new cljs.core.async.t_cljs$core$async15643(self__.mult,self__.ch,self__.cs,meta15644__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15645){
var self__ = this;
var _15645__$1 = this;
return self__.meta15644;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15644","meta15644",-632527378,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15643";

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15643");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15643 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644){
return (new cljs.core.async.t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15643(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14368__auto___15877 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15877,cs,m,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15877,cs,m,dchan,dctr,done){
return (function (state_15776){
var state_val_15777 = (state_15776[(1)]);
if((state_val_15777 === (7))){
var inst_15772 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15778_15881 = state_15776__$1;
(statearr_15778_15881[(2)] = inst_15772);

(statearr_15778_15881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (20))){
var inst_15677 = (state_15776[(7)]);
var inst_15687 = cljs.core.first.call(null,inst_15677);
var inst_15688 = cljs.core.nth.call(null,inst_15687,(0),null);
var inst_15689 = cljs.core.nth.call(null,inst_15687,(1),null);
var state_15776__$1 = (function (){var statearr_15779 = state_15776;
(statearr_15779[(8)] = inst_15688);

return statearr_15779;
})();
if(cljs.core.truth_(inst_15689)){
var statearr_15780_15882 = state_15776__$1;
(statearr_15780_15882[(1)] = (22));

} else {
var statearr_15781_15883 = state_15776__$1;
(statearr_15781_15883[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (27))){
var inst_15724 = (state_15776[(9)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15648 = (state_15776[(12)]);
var inst_15724__$1 = cljs.core._nth.call(null,inst_15717,inst_15719);
var inst_15725 = cljs.core.async.put_BANG_.call(null,inst_15724__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15782 = state_15776;
(statearr_15782[(9)] = inst_15724__$1);

return statearr_15782;
})();
if(cljs.core.truth_(inst_15725)){
var statearr_15783_15884 = state_15776__$1;
(statearr_15783_15884[(1)] = (30));

} else {
var statearr_15784_15886 = state_15776__$1;
(statearr_15784_15886[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (1))){
var state_15776__$1 = state_15776;
var statearr_15785_15887 = state_15776__$1;
(statearr_15785_15887[(2)] = null);

(statearr_15785_15887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (24))){
var inst_15677 = (state_15776[(7)]);
var inst_15694 = (state_15776[(2)]);
var inst_15695 = cljs.core.next.call(null,inst_15677);
var inst_15657 = inst_15695;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15786 = state_15776;
(statearr_15786[(13)] = inst_15660);

(statearr_15786[(14)] = inst_15658);

(statearr_15786[(15)] = inst_15694);

(statearr_15786[(16)] = inst_15659);

(statearr_15786[(17)] = inst_15657);

return statearr_15786;
})();
var statearr_15787_15888 = state_15776__$1;
(statearr_15787_15888[(2)] = null);

(statearr_15787_15888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (39))){
var state_15776__$1 = state_15776;
var statearr_15791_15889 = state_15776__$1;
(statearr_15791_15889[(2)] = null);

(statearr_15791_15889[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (4))){
var inst_15648 = (state_15776[(12)]);
var inst_15648__$1 = (state_15776[(2)]);
var inst_15649 = (inst_15648__$1 == null);
var state_15776__$1 = (function (){var statearr_15793 = state_15776;
(statearr_15793[(12)] = inst_15648__$1);

return statearr_15793;
})();
if(cljs.core.truth_(inst_15649)){
var statearr_15795_15890 = state_15776__$1;
(statearr_15795_15890[(1)] = (5));

} else {
var statearr_15796_15891 = state_15776__$1;
(statearr_15796_15891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (15))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15659 = (state_15776[(16)]);
var inst_15657 = (state_15776[(17)]);
var inst_15673 = (state_15776[(2)]);
var inst_15674 = (inst_15660 + (1));
var tmp15788 = inst_15658;
var tmp15789 = inst_15659;
var tmp15790 = inst_15657;
var inst_15657__$1 = tmp15790;
var inst_15658__$1 = tmp15788;
var inst_15659__$1 = tmp15789;
var inst_15660__$1 = inst_15674;
var state_15776__$1 = (function (){var statearr_15797 = state_15776;
(statearr_15797[(13)] = inst_15660__$1);

(statearr_15797[(14)] = inst_15658__$1);

(statearr_15797[(16)] = inst_15659__$1);

(statearr_15797[(18)] = inst_15673);

(statearr_15797[(17)] = inst_15657__$1);

return statearr_15797;
})();
var statearr_15798_15892 = state_15776__$1;
(statearr_15798_15892[(2)] = null);

(statearr_15798_15892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (21))){
var inst_15698 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15802_15893 = state_15776__$1;
(statearr_15802_15893[(2)] = inst_15698);

(statearr_15802_15893[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (31))){
var inst_15724 = (state_15776[(9)]);
var inst_15728 = done.call(null,null);
var inst_15729 = cljs.core.async.untap_STAR_.call(null,m,inst_15724);
var state_15776__$1 = (function (){var statearr_15803 = state_15776;
(statearr_15803[(19)] = inst_15728);

return statearr_15803;
})();
var statearr_15804_15894 = state_15776__$1;
(statearr_15804_15894[(2)] = inst_15729);

(statearr_15804_15894[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (32))){
var inst_15716 = (state_15776[(20)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15718 = (state_15776[(21)]);
var inst_15731 = (state_15776[(2)]);
var inst_15732 = (inst_15719 + (1));
var tmp15799 = inst_15716;
var tmp15800 = inst_15717;
var tmp15801 = inst_15718;
var inst_15716__$1 = tmp15799;
var inst_15717__$1 = tmp15800;
var inst_15718__$1 = tmp15801;
var inst_15719__$1 = inst_15732;
var state_15776__$1 = (function (){var statearr_15805 = state_15776;
(statearr_15805[(20)] = inst_15716__$1);

(statearr_15805[(10)] = inst_15719__$1);

(statearr_15805[(11)] = inst_15717__$1);

(statearr_15805[(22)] = inst_15731);

(statearr_15805[(21)] = inst_15718__$1);

return statearr_15805;
})();
var statearr_15806_15895 = state_15776__$1;
(statearr_15806_15895[(2)] = null);

(statearr_15806_15895[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (40))){
var inst_15744 = (state_15776[(23)]);
var inst_15748 = done.call(null,null);
var inst_15749 = cljs.core.async.untap_STAR_.call(null,m,inst_15744);
var state_15776__$1 = (function (){var statearr_15807 = state_15776;
(statearr_15807[(24)] = inst_15748);

return statearr_15807;
})();
var statearr_15808_15896 = state_15776__$1;
(statearr_15808_15896[(2)] = inst_15749);

(statearr_15808_15896[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (33))){
var inst_15735 = (state_15776[(25)]);
var inst_15737 = cljs.core.chunked_seq_QMARK_.call(null,inst_15735);
var state_15776__$1 = state_15776;
if(inst_15737){
var statearr_15809_15902 = state_15776__$1;
(statearr_15809_15902[(1)] = (36));

} else {
var statearr_15810_15903 = state_15776__$1;
(statearr_15810_15903[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (13))){
var inst_15667 = (state_15776[(26)]);
var inst_15670 = cljs.core.async.close_BANG_.call(null,inst_15667);
var state_15776__$1 = state_15776;
var statearr_15811_15905 = state_15776__$1;
(statearr_15811_15905[(2)] = inst_15670);

(statearr_15811_15905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (22))){
var inst_15688 = (state_15776[(8)]);
var inst_15691 = cljs.core.async.close_BANG_.call(null,inst_15688);
var state_15776__$1 = state_15776;
var statearr_15812_15906 = state_15776__$1;
(statearr_15812_15906[(2)] = inst_15691);

(statearr_15812_15906[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (36))){
var inst_15735 = (state_15776[(25)]);
var inst_15739 = cljs.core.chunk_first.call(null,inst_15735);
var inst_15740 = cljs.core.chunk_rest.call(null,inst_15735);
var inst_15741 = cljs.core.count.call(null,inst_15739);
var inst_15716 = inst_15740;
var inst_15717 = inst_15739;
var inst_15718 = inst_15741;
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15813 = state_15776;
(statearr_15813[(20)] = inst_15716);

(statearr_15813[(10)] = inst_15719);

(statearr_15813[(11)] = inst_15717);

(statearr_15813[(21)] = inst_15718);

return statearr_15813;
})();
var statearr_15814_15910 = state_15776__$1;
(statearr_15814_15910[(2)] = null);

(statearr_15814_15910[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (41))){
var inst_15735 = (state_15776[(25)]);
var inst_15751 = (state_15776[(2)]);
var inst_15752 = cljs.core.next.call(null,inst_15735);
var inst_15716 = inst_15752;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15815 = state_15776;
(statearr_15815[(20)] = inst_15716);

(statearr_15815[(10)] = inst_15719);

(statearr_15815[(11)] = inst_15717);

(statearr_15815[(27)] = inst_15751);

(statearr_15815[(21)] = inst_15718);

return statearr_15815;
})();
var statearr_15816_15911 = state_15776__$1;
(statearr_15816_15911[(2)] = null);

(statearr_15816_15911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (43))){
var state_15776__$1 = state_15776;
var statearr_15817_15912 = state_15776__$1;
(statearr_15817_15912[(2)] = null);

(statearr_15817_15912[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (29))){
var inst_15760 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15818_15914 = state_15776__$1;
(statearr_15818_15914[(2)] = inst_15760);

(statearr_15818_15914[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (44))){
var inst_15769 = (state_15776[(2)]);
var state_15776__$1 = (function (){var statearr_15819 = state_15776;
(statearr_15819[(28)] = inst_15769);

return statearr_15819;
})();
var statearr_15820_15915 = state_15776__$1;
(statearr_15820_15915[(2)] = null);

(statearr_15820_15915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (6))){
var inst_15708 = (state_15776[(29)]);
var inst_15707 = cljs.core.deref.call(null,cs);
var inst_15708__$1 = cljs.core.keys.call(null,inst_15707);
var inst_15709 = cljs.core.count.call(null,inst_15708__$1);
var inst_15710 = cljs.core.reset_BANG_.call(null,dctr,inst_15709);
var inst_15715 = cljs.core.seq.call(null,inst_15708__$1);
var inst_15716 = inst_15715;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15821 = state_15776;
(statearr_15821[(20)] = inst_15716);

(statearr_15821[(10)] = inst_15719);

(statearr_15821[(29)] = inst_15708__$1);

(statearr_15821[(11)] = inst_15717);

(statearr_15821[(21)] = inst_15718);

(statearr_15821[(30)] = inst_15710);

return statearr_15821;
})();
var statearr_15822_15916 = state_15776__$1;
(statearr_15822_15916[(2)] = null);

(statearr_15822_15916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (28))){
var inst_15716 = (state_15776[(20)]);
var inst_15735 = (state_15776[(25)]);
var inst_15735__$1 = cljs.core.seq.call(null,inst_15716);
var state_15776__$1 = (function (){var statearr_15823 = state_15776;
(statearr_15823[(25)] = inst_15735__$1);

return statearr_15823;
})();
if(inst_15735__$1){
var statearr_15824_15917 = state_15776__$1;
(statearr_15824_15917[(1)] = (33));

} else {
var statearr_15825_15918 = state_15776__$1;
(statearr_15825_15918[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (25))){
var inst_15719 = (state_15776[(10)]);
var inst_15718 = (state_15776[(21)]);
var inst_15721 = (inst_15719 < inst_15718);
var inst_15722 = inst_15721;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15722)){
var statearr_15826_15919 = state_15776__$1;
(statearr_15826_15919[(1)] = (27));

} else {
var statearr_15827_15920 = state_15776__$1;
(statearr_15827_15920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (34))){
var state_15776__$1 = state_15776;
var statearr_15828_15921 = state_15776__$1;
(statearr_15828_15921[(2)] = null);

(statearr_15828_15921[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (17))){
var state_15776__$1 = state_15776;
var statearr_15829_15922 = state_15776__$1;
(statearr_15829_15922[(2)] = null);

(statearr_15829_15922[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (3))){
var inst_15774 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15776__$1,inst_15774);
} else {
if((state_val_15777 === (12))){
var inst_15703 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15830_15923 = state_15776__$1;
(statearr_15830_15923[(2)] = inst_15703);

(statearr_15830_15923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (2))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(4),ch);
} else {
if((state_val_15777 === (23))){
var state_15776__$1 = state_15776;
var statearr_15831_15924 = state_15776__$1;
(statearr_15831_15924[(2)] = null);

(statearr_15831_15924[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (35))){
var inst_15758 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15832_15925 = state_15776__$1;
(statearr_15832_15925[(2)] = inst_15758);

(statearr_15832_15925[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (19))){
var inst_15677 = (state_15776[(7)]);
var inst_15681 = cljs.core.chunk_first.call(null,inst_15677);
var inst_15682 = cljs.core.chunk_rest.call(null,inst_15677);
var inst_15683 = cljs.core.count.call(null,inst_15681);
var inst_15657 = inst_15682;
var inst_15658 = inst_15681;
var inst_15659 = inst_15683;
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15833 = state_15776;
(statearr_15833[(13)] = inst_15660);

(statearr_15833[(14)] = inst_15658);

(statearr_15833[(16)] = inst_15659);

(statearr_15833[(17)] = inst_15657);

return statearr_15833;
})();
var statearr_15834_15926 = state_15776__$1;
(statearr_15834_15926[(2)] = null);

(statearr_15834_15926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (11))){
var inst_15677 = (state_15776[(7)]);
var inst_15657 = (state_15776[(17)]);
var inst_15677__$1 = cljs.core.seq.call(null,inst_15657);
var state_15776__$1 = (function (){var statearr_15835 = state_15776;
(statearr_15835[(7)] = inst_15677__$1);

return statearr_15835;
})();
if(inst_15677__$1){
var statearr_15836_15927 = state_15776__$1;
(statearr_15836_15927[(1)] = (16));

} else {
var statearr_15837_15928 = state_15776__$1;
(statearr_15837_15928[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (9))){
var inst_15705 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15838_15929 = state_15776__$1;
(statearr_15838_15929[(2)] = inst_15705);

(statearr_15838_15929[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (5))){
var inst_15655 = cljs.core.deref.call(null,cs);
var inst_15656 = cljs.core.seq.call(null,inst_15655);
var inst_15657 = inst_15656;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15839 = state_15776;
(statearr_15839[(13)] = inst_15660);

(statearr_15839[(14)] = inst_15658);

(statearr_15839[(16)] = inst_15659);

(statearr_15839[(17)] = inst_15657);

return statearr_15839;
})();
var statearr_15841_15935 = state_15776__$1;
(statearr_15841_15935[(2)] = null);

(statearr_15841_15935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (14))){
var state_15776__$1 = state_15776;
var statearr_15843_15936 = state_15776__$1;
(statearr_15843_15936[(2)] = null);

(statearr_15843_15936[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (45))){
var inst_15766 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15844_15938 = state_15776__$1;
(statearr_15844_15938[(2)] = inst_15766);

(statearr_15844_15938[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (26))){
var inst_15708 = (state_15776[(29)]);
var inst_15762 = (state_15776[(2)]);
var inst_15763 = cljs.core.seq.call(null,inst_15708);
var state_15776__$1 = (function (){var statearr_15845 = state_15776;
(statearr_15845[(31)] = inst_15762);

return statearr_15845;
})();
if(inst_15763){
var statearr_15846_15939 = state_15776__$1;
(statearr_15846_15939[(1)] = (42));

} else {
var statearr_15847_15940 = state_15776__$1;
(statearr_15847_15940[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (16))){
var inst_15677 = (state_15776[(7)]);
var inst_15679 = cljs.core.chunked_seq_QMARK_.call(null,inst_15677);
var state_15776__$1 = state_15776;
if(inst_15679){
var statearr_15848_15944 = state_15776__$1;
(statearr_15848_15944[(1)] = (19));

} else {
var statearr_15849_15945 = state_15776__$1;
(statearr_15849_15945[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (38))){
var inst_15755 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15850_15946 = state_15776__$1;
(statearr_15850_15946[(2)] = inst_15755);

(statearr_15850_15946[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (30))){
var state_15776__$1 = state_15776;
var statearr_15851_15947 = state_15776__$1;
(statearr_15851_15947[(2)] = null);

(statearr_15851_15947[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (10))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15666 = cljs.core._nth.call(null,inst_15658,inst_15660);
var inst_15667 = cljs.core.nth.call(null,inst_15666,(0),null);
var inst_15668 = cljs.core.nth.call(null,inst_15666,(1),null);
var state_15776__$1 = (function (){var statearr_15854 = state_15776;
(statearr_15854[(26)] = inst_15667);

return statearr_15854;
})();
if(cljs.core.truth_(inst_15668)){
var statearr_15855_15948 = state_15776__$1;
(statearr_15855_15948[(1)] = (13));

} else {
var statearr_15856_15949 = state_15776__$1;
(statearr_15856_15949[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (18))){
var inst_15701 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15857_15950 = state_15776__$1;
(statearr_15857_15950[(2)] = inst_15701);

(statearr_15857_15950[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (42))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(45),dchan);
} else {
if((state_val_15777 === (37))){
var inst_15735 = (state_15776[(25)]);
var inst_15648 = (state_15776[(12)]);
var inst_15744 = (state_15776[(23)]);
var inst_15744__$1 = cljs.core.first.call(null,inst_15735);
var inst_15745 = cljs.core.async.put_BANG_.call(null,inst_15744__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15858 = state_15776;
(statearr_15858[(23)] = inst_15744__$1);

return statearr_15858;
})();
if(cljs.core.truth_(inst_15745)){
var statearr_15859_15952 = state_15776__$1;
(statearr_15859_15952[(1)] = (39));

} else {
var statearr_15860_15953 = state_15776__$1;
(statearr_15860_15953[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (8))){
var inst_15660 = (state_15776[(13)]);
var inst_15659 = (state_15776[(16)]);
var inst_15662 = (inst_15660 < inst_15659);
var inst_15663 = inst_15662;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15663)){
var statearr_15861_15954 = state_15776__$1;
(statearr_15861_15954[(1)] = (10));

} else {
var statearr_15862_15955 = state_15776__$1;
(statearr_15862_15955[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15877,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___15877,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15866 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15866[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15866[(1)] = (1));

return statearr_15866;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15776){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15867){if((e15867 instanceof Object)){
var ex__14240__auto__ = e15867;
var statearr_15868_15956 = state_15776;
(statearr_15868_15956[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15867;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15957 = state_15776;
state_15776 = G__15957;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15776){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15877,cs,m,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_15869 = f__14369__auto__.call(null);
(statearr_15869[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15877);

return statearr_15869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15877,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15958 = [];
var len__7107__auto___15961 = arguments.length;
var i__7108__auto___15962 = (0);
while(true){
if((i__7108__auto___15962 < len__7107__auto___15961)){
args15958.push((arguments[i__7108__auto___15962]));

var G__15963 = (i__7108__auto___15962 + (1));
i__7108__auto___15962 = G__15963;
continue;
} else {
}
break;
}

var G__15960 = args15958.length;
switch (G__15960) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15958.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___15992 = arguments.length;
var i__7108__auto___15993 = (0);
while(true){
if((i__7108__auto___15993 < len__7107__auto___15992)){
args__7114__auto__.push((arguments[i__7108__auto___15993]));

var G__15994 = (i__7108__auto___15993 + (1));
i__7108__auto___15993 = G__15994;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15986){
var map__15987 = p__15986;
var map__15987__$1 = ((((!((map__15987 == null)))?((((map__15987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15987):map__15987);
var opts = map__15987__$1;
var statearr_15989_15995 = state;
(statearr_15989_15995[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15987,map__15987__$1,opts){
return (function (val){
var statearr_15990_15996 = state;
(statearr_15990_15996[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15987,map__15987__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15991_15997 = state;
(statearr_15991_15997[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15982){
var G__15983 = cljs.core.first.call(null,seq15982);
var seq15982__$1 = cljs.core.next.call(null,seq15982);
var G__15984 = cljs.core.first.call(null,seq15982__$1);
var seq15982__$2 = cljs.core.next.call(null,seq15982__$1);
var G__15985 = cljs.core.first.call(null,seq15982__$2);
var seq15982__$3 = cljs.core.next.call(null,seq15982__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15983,G__15984,G__15985,seq15982__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16181 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16181 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16182){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16182 = meta16182;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16183,meta16182__$1){
var self__ = this;
var _16183__$1 = this;
return (new cljs.core.async.t_cljs$core$async16181(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16182__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16183){
var self__ = this;
var _16183__$1 = this;
return self__.meta16182;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16182","meta16182",-1979731515,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16181.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16181.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16181";

cljs.core.async.t_cljs$core$async16181.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16181");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16181 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16181(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16182){
return (new cljs.core.async.t_cljs$core$async16181(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16182));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16181(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16365 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16290){
var state_val_16291 = (state_16290[(1)]);
if((state_val_16291 === (7))){
var inst_16204 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
var statearr_16292_16369 = state_16290__$1;
(statearr_16292_16369[(2)] = inst_16204);

(statearr_16292_16369[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (20))){
var inst_16217 = (state_16290[(7)]);
var state_16290__$1 = state_16290;
var statearr_16293_16370 = state_16290__$1;
(statearr_16293_16370[(2)] = inst_16217);

(statearr_16293_16370[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (27))){
var state_16290__$1 = state_16290;
var statearr_16294_16371 = state_16290__$1;
(statearr_16294_16371[(2)] = null);

(statearr_16294_16371[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (1))){
var inst_16192 = (state_16290[(8)]);
var inst_16192__$1 = calc_state.call(null);
var inst_16194 = (inst_16192__$1 == null);
var inst_16195 = cljs.core.not.call(null,inst_16194);
var state_16290__$1 = (function (){var statearr_16295 = state_16290;
(statearr_16295[(8)] = inst_16192__$1);

return statearr_16295;
})();
if(inst_16195){
var statearr_16296_16372 = state_16290__$1;
(statearr_16296_16372[(1)] = (2));

} else {
var statearr_16297_16373 = state_16290__$1;
(statearr_16297_16373[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (24))){
var inst_16240 = (state_16290[(9)]);
var inst_16261 = (state_16290[(10)]);
var inst_16247 = (state_16290[(11)]);
var inst_16261__$1 = inst_16240.call(null,inst_16247);
var state_16290__$1 = (function (){var statearr_16298 = state_16290;
(statearr_16298[(10)] = inst_16261__$1);

return statearr_16298;
})();
if(cljs.core.truth_(inst_16261__$1)){
var statearr_16299_16375 = state_16290__$1;
(statearr_16299_16375[(1)] = (29));

} else {
var statearr_16300_16376 = state_16290__$1;
(statearr_16300_16376[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (4))){
var inst_16207 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16207)){
var statearr_16301_16377 = state_16290__$1;
(statearr_16301_16377[(1)] = (8));

} else {
var statearr_16302_16378 = state_16290__$1;
(statearr_16302_16378[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (15))){
var inst_16234 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16234)){
var statearr_16303_16379 = state_16290__$1;
(statearr_16303_16379[(1)] = (19));

} else {
var statearr_16304_16380 = state_16290__$1;
(statearr_16304_16380[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (21))){
var inst_16239 = (state_16290[(12)]);
var inst_16239__$1 = (state_16290[(2)]);
var inst_16240 = cljs.core.get.call(null,inst_16239__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16241 = cljs.core.get.call(null,inst_16239__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16242 = cljs.core.get.call(null,inst_16239__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16290__$1 = (function (){var statearr_16305 = state_16290;
(statearr_16305[(9)] = inst_16240);

(statearr_16305[(12)] = inst_16239__$1);

(statearr_16305[(13)] = inst_16241);

return statearr_16305;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16290__$1,(22),inst_16242);
} else {
if((state_val_16291 === (31))){
var inst_16269 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16269)){
var statearr_16306_16381 = state_16290__$1;
(statearr_16306_16381[(1)] = (32));

} else {
var statearr_16307_16382 = state_16290__$1;
(statearr_16307_16382[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (32))){
var inst_16246 = (state_16290[(14)]);
var state_16290__$1 = state_16290;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16290__$1,(35),out,inst_16246);
} else {
if((state_val_16291 === (33))){
var inst_16239 = (state_16290[(12)]);
var inst_16217 = inst_16239;
var state_16290__$1 = (function (){var statearr_16308 = state_16290;
(statearr_16308[(7)] = inst_16217);

return statearr_16308;
})();
var statearr_16310_16383 = state_16290__$1;
(statearr_16310_16383[(2)] = null);

(statearr_16310_16383[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (13))){
var inst_16217 = (state_16290[(7)]);
var inst_16224 = inst_16217.cljs$lang$protocol_mask$partition0$;
var inst_16225 = (inst_16224 & (64));
var inst_16226 = inst_16217.cljs$core$ISeq$;
var inst_16227 = (inst_16225) || (inst_16226);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16227)){
var statearr_16311_16384 = state_16290__$1;
(statearr_16311_16384[(1)] = (16));

} else {
var statearr_16312_16385 = state_16290__$1;
(statearr_16312_16385[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (22))){
var inst_16246 = (state_16290[(14)]);
var inst_16247 = (state_16290[(11)]);
var inst_16245 = (state_16290[(2)]);
var inst_16246__$1 = cljs.core.nth.call(null,inst_16245,(0),null);
var inst_16247__$1 = cljs.core.nth.call(null,inst_16245,(1),null);
var inst_16248 = (inst_16246__$1 == null);
var inst_16249 = cljs.core._EQ_.call(null,inst_16247__$1,change);
var inst_16250 = (inst_16248) || (inst_16249);
var state_16290__$1 = (function (){var statearr_16313 = state_16290;
(statearr_16313[(14)] = inst_16246__$1);

(statearr_16313[(11)] = inst_16247__$1);

return statearr_16313;
})();
if(cljs.core.truth_(inst_16250)){
var statearr_16314_16386 = state_16290__$1;
(statearr_16314_16386[(1)] = (23));

} else {
var statearr_16315_16387 = state_16290__$1;
(statearr_16315_16387[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (36))){
var inst_16239 = (state_16290[(12)]);
var inst_16217 = inst_16239;
var state_16290__$1 = (function (){var statearr_16316 = state_16290;
(statearr_16316[(7)] = inst_16217);

return statearr_16316;
})();
var statearr_16317_16388 = state_16290__$1;
(statearr_16317_16388[(2)] = null);

(statearr_16317_16388[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (29))){
var inst_16261 = (state_16290[(10)]);
var state_16290__$1 = state_16290;
var statearr_16318_16389 = state_16290__$1;
(statearr_16318_16389[(2)] = inst_16261);

(statearr_16318_16389[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (6))){
var state_16290__$1 = state_16290;
var statearr_16319_16393 = state_16290__$1;
(statearr_16319_16393[(2)] = false);

(statearr_16319_16393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (28))){
var inst_16257 = (state_16290[(2)]);
var inst_16258 = calc_state.call(null);
var inst_16217 = inst_16258;
var state_16290__$1 = (function (){var statearr_16320 = state_16290;
(statearr_16320[(15)] = inst_16257);

(statearr_16320[(7)] = inst_16217);

return statearr_16320;
})();
var statearr_16321_16395 = state_16290__$1;
(statearr_16321_16395[(2)] = null);

(statearr_16321_16395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (25))){
var inst_16283 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
var statearr_16322_16397 = state_16290__$1;
(statearr_16322_16397[(2)] = inst_16283);

(statearr_16322_16397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (34))){
var inst_16281 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
var statearr_16323_16398 = state_16290__$1;
(statearr_16323_16398[(2)] = inst_16281);

(statearr_16323_16398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (17))){
var state_16290__$1 = state_16290;
var statearr_16324_16399 = state_16290__$1;
(statearr_16324_16399[(2)] = false);

(statearr_16324_16399[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (3))){
var state_16290__$1 = state_16290;
var statearr_16325_16400 = state_16290__$1;
(statearr_16325_16400[(2)] = false);

(statearr_16325_16400[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (12))){
var inst_16288 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16290__$1,inst_16288);
} else {
if((state_val_16291 === (2))){
var inst_16192 = (state_16290[(8)]);
var inst_16197 = inst_16192.cljs$lang$protocol_mask$partition0$;
var inst_16198 = (inst_16197 & (64));
var inst_16199 = inst_16192.cljs$core$ISeq$;
var inst_16200 = (inst_16198) || (inst_16199);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16200)){
var statearr_16326_16404 = state_16290__$1;
(statearr_16326_16404[(1)] = (5));

} else {
var statearr_16327_16405 = state_16290__$1;
(statearr_16327_16405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (23))){
var inst_16246 = (state_16290[(14)]);
var inst_16252 = (inst_16246 == null);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16252)){
var statearr_16328_16406 = state_16290__$1;
(statearr_16328_16406[(1)] = (26));

} else {
var statearr_16329_16407 = state_16290__$1;
(statearr_16329_16407[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (35))){
var inst_16272 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
if(cljs.core.truth_(inst_16272)){
var statearr_16330_16408 = state_16290__$1;
(statearr_16330_16408[(1)] = (36));

} else {
var statearr_16331_16409 = state_16290__$1;
(statearr_16331_16409[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (19))){
var inst_16217 = (state_16290[(7)]);
var inst_16236 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16217);
var state_16290__$1 = state_16290;
var statearr_16332_16411 = state_16290__$1;
(statearr_16332_16411[(2)] = inst_16236);

(statearr_16332_16411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (11))){
var inst_16217 = (state_16290[(7)]);
var inst_16221 = (inst_16217 == null);
var inst_16222 = cljs.core.not.call(null,inst_16221);
var state_16290__$1 = state_16290;
if(inst_16222){
var statearr_16333_16412 = state_16290__$1;
(statearr_16333_16412[(1)] = (13));

} else {
var statearr_16334_16413 = state_16290__$1;
(statearr_16334_16413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (9))){
var inst_16192 = (state_16290[(8)]);
var state_16290__$1 = state_16290;
var statearr_16335_16414 = state_16290__$1;
(statearr_16335_16414[(2)] = inst_16192);

(statearr_16335_16414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (5))){
var state_16290__$1 = state_16290;
var statearr_16336_16415 = state_16290__$1;
(statearr_16336_16415[(2)] = true);

(statearr_16336_16415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (14))){
var state_16290__$1 = state_16290;
var statearr_16337_16416 = state_16290__$1;
(statearr_16337_16416[(2)] = false);

(statearr_16337_16416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (26))){
var inst_16247 = (state_16290[(11)]);
var inst_16254 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16247);
var state_16290__$1 = state_16290;
var statearr_16338_16417 = state_16290__$1;
(statearr_16338_16417[(2)] = inst_16254);

(statearr_16338_16417[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (16))){
var state_16290__$1 = state_16290;
var statearr_16339_16418 = state_16290__$1;
(statearr_16339_16418[(2)] = true);

(statearr_16339_16418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (38))){
var inst_16277 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
var statearr_16340_16419 = state_16290__$1;
(statearr_16340_16419[(2)] = inst_16277);

(statearr_16340_16419[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (30))){
var inst_16240 = (state_16290[(9)]);
var inst_16247 = (state_16290[(11)]);
var inst_16241 = (state_16290[(13)]);
var inst_16264 = cljs.core.empty_QMARK_.call(null,inst_16240);
var inst_16265 = inst_16241.call(null,inst_16247);
var inst_16266 = cljs.core.not.call(null,inst_16265);
var inst_16267 = (inst_16264) && (inst_16266);
var state_16290__$1 = state_16290;
var statearr_16341_16420 = state_16290__$1;
(statearr_16341_16420[(2)] = inst_16267);

(statearr_16341_16420[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (10))){
var inst_16192 = (state_16290[(8)]);
var inst_16213 = (state_16290[(2)]);
var inst_16214 = cljs.core.get.call(null,inst_16213,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16215 = cljs.core.get.call(null,inst_16213,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16216 = cljs.core.get.call(null,inst_16213,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16217 = inst_16192;
var state_16290__$1 = (function (){var statearr_16342 = state_16290;
(statearr_16342[(16)] = inst_16215);

(statearr_16342[(17)] = inst_16216);

(statearr_16342[(7)] = inst_16217);

(statearr_16342[(18)] = inst_16214);

return statearr_16342;
})();
var statearr_16343_16421 = state_16290__$1;
(statearr_16343_16421[(2)] = null);

(statearr_16343_16421[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (18))){
var inst_16231 = (state_16290[(2)]);
var state_16290__$1 = state_16290;
var statearr_16344_16422 = state_16290__$1;
(statearr_16344_16422[(2)] = inst_16231);

(statearr_16344_16422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (37))){
var state_16290__$1 = state_16290;
var statearr_16345_16423 = state_16290__$1;
(statearr_16345_16423[(2)] = null);

(statearr_16345_16423[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16291 === (8))){
var inst_16192 = (state_16290[(8)]);
var inst_16209 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16192);
var state_16290__$1 = state_16290;
var statearr_16346_16424 = state_16290__$1;
(statearr_16346_16424[(2)] = inst_16209);

(statearr_16346_16424[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16350[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16350[(1)] = (1));

return statearr_16350;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16290){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16351){if((e16351 instanceof Object)){
var ex__14240__auto__ = e16351;
var statearr_16352_16425 = state_16290;
(statearr_16352_16425[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16351;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16426 = state_16290;
state_16290 = G__16426;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16290){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14370__auto__ = (function (){var statearr_16353 = f__14369__auto__.call(null);
(statearr_16353[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16365);

return statearr_16353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16365,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16439 = [];
var len__7107__auto___16443 = arguments.length;
var i__7108__auto___16444 = (0);
while(true){
if((i__7108__auto___16444 < len__7107__auto___16443)){
args16439.push((arguments[i__7108__auto___16444]));

var G__16445 = (i__7108__auto___16444 + (1));
i__7108__auto___16444 = G__16445;
continue;
} else {
}
break;
}

var G__16441 = args16439.length;
switch (G__16441) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16439.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16448 = [];
var len__7107__auto___16583 = arguments.length;
var i__7108__auto___16584 = (0);
while(true){
if((i__7108__auto___16584 < len__7107__auto___16583)){
args16448.push((arguments[i__7108__auto___16584]));

var G__16585 = (i__7108__auto___16584 + (1));
i__7108__auto___16584 = G__16585;
continue;
} else {
}
break;
}

var G__16450 = args16448.length;
switch (G__16450) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16448.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16447_SHARP_){
if(cljs.core.truth_(p1__16447_SHARP_.call(null,topic))){
return p1__16447_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16447_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16451 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16451 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16452){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16452 = meta16452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16453,meta16452__$1){
var self__ = this;
var _16453__$1 = this;
return (new cljs.core.async.t_cljs$core$async16451(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16452__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16453){
var self__ = this;
var _16453__$1 = this;
return self__.meta16452;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16452","meta16452",-150613344,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16451";

cljs.core.async.t_cljs$core$async16451.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16451");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16451 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16451(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16452){
return (new cljs.core.async.t_cljs$core$async16451(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16452));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16451(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16600,mults,ensure_mult,p){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16600,mults,ensure_mult,p){
return (function (state_16526){
var state_val_16527 = (state_16526[(1)]);
if((state_val_16527 === (7))){
var inst_16522 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16528_16601 = state_16526__$1;
(statearr_16528_16601[(2)] = inst_16522);

(statearr_16528_16601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (20))){
var state_16526__$1 = state_16526;
var statearr_16529_16602 = state_16526__$1;
(statearr_16529_16602[(2)] = null);

(statearr_16529_16602[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (1))){
var state_16526__$1 = state_16526;
var statearr_16531_16603 = state_16526__$1;
(statearr_16531_16603[(2)] = null);

(statearr_16531_16603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (24))){
var inst_16505 = (state_16526[(7)]);
var inst_16514 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16505);
var state_16526__$1 = state_16526;
var statearr_16532_16605 = state_16526__$1;
(statearr_16532_16605[(2)] = inst_16514);

(statearr_16532_16605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (4))){
var inst_16457 = (state_16526[(8)]);
var inst_16457__$1 = (state_16526[(2)]);
var inst_16458 = (inst_16457__$1 == null);
var state_16526__$1 = (function (){var statearr_16533 = state_16526;
(statearr_16533[(8)] = inst_16457__$1);

return statearr_16533;
})();
if(cljs.core.truth_(inst_16458)){
var statearr_16534_16606 = state_16526__$1;
(statearr_16534_16606[(1)] = (5));

} else {
var statearr_16535_16607 = state_16526__$1;
(statearr_16535_16607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (15))){
var inst_16499 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16536_16608 = state_16526__$1;
(statearr_16536_16608[(2)] = inst_16499);

(statearr_16536_16608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (21))){
var inst_16519 = (state_16526[(2)]);
var state_16526__$1 = (function (){var statearr_16537 = state_16526;
(statearr_16537[(9)] = inst_16519);

return statearr_16537;
})();
var statearr_16538_16609 = state_16526__$1;
(statearr_16538_16609[(2)] = null);

(statearr_16538_16609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (13))){
var inst_16481 = (state_16526[(10)]);
var inst_16483 = cljs.core.chunked_seq_QMARK_.call(null,inst_16481);
var state_16526__$1 = state_16526;
if(inst_16483){
var statearr_16539_16610 = state_16526__$1;
(statearr_16539_16610[(1)] = (16));

} else {
var statearr_16541_16611 = state_16526__$1;
(statearr_16541_16611[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (22))){
var inst_16511 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
if(cljs.core.truth_(inst_16511)){
var statearr_16543_16612 = state_16526__$1;
(statearr_16543_16612[(1)] = (23));

} else {
var statearr_16544_16613 = state_16526__$1;
(statearr_16544_16613[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (6))){
var inst_16457 = (state_16526[(8)]);
var inst_16507 = (state_16526[(11)]);
var inst_16505 = (state_16526[(7)]);
var inst_16505__$1 = topic_fn.call(null,inst_16457);
var inst_16506 = cljs.core.deref.call(null,mults);
var inst_16507__$1 = cljs.core.get.call(null,inst_16506,inst_16505__$1);
var state_16526__$1 = (function (){var statearr_16546 = state_16526;
(statearr_16546[(11)] = inst_16507__$1);

(statearr_16546[(7)] = inst_16505__$1);

return statearr_16546;
})();
if(cljs.core.truth_(inst_16507__$1)){
var statearr_16547_16614 = state_16526__$1;
(statearr_16547_16614[(1)] = (19));

} else {
var statearr_16548_16615 = state_16526__$1;
(statearr_16548_16615[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (25))){
var inst_16516 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16549_16616 = state_16526__$1;
(statearr_16549_16616[(2)] = inst_16516);

(statearr_16549_16616[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (17))){
var inst_16481 = (state_16526[(10)]);
var inst_16490 = cljs.core.first.call(null,inst_16481);
var inst_16491 = cljs.core.async.muxch_STAR_.call(null,inst_16490);
var inst_16492 = cljs.core.async.close_BANG_.call(null,inst_16491);
var inst_16493 = cljs.core.next.call(null,inst_16481);
var inst_16467 = inst_16493;
var inst_16468 = null;
var inst_16469 = (0);
var inst_16470 = (0);
var state_16526__$1 = (function (){var statearr_16550 = state_16526;
(statearr_16550[(12)] = inst_16492);

(statearr_16550[(13)] = inst_16469);

(statearr_16550[(14)] = inst_16470);

(statearr_16550[(15)] = inst_16467);

(statearr_16550[(16)] = inst_16468);

return statearr_16550;
})();
var statearr_16551_16617 = state_16526__$1;
(statearr_16551_16617[(2)] = null);

(statearr_16551_16617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (3))){
var inst_16524 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16526__$1,inst_16524);
} else {
if((state_val_16527 === (12))){
var inst_16501 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16552_16618 = state_16526__$1;
(statearr_16552_16618[(2)] = inst_16501);

(statearr_16552_16618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (2))){
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16526__$1,(4),ch);
} else {
if((state_val_16527 === (23))){
var state_16526__$1 = state_16526;
var statearr_16554_16619 = state_16526__$1;
(statearr_16554_16619[(2)] = null);

(statearr_16554_16619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (19))){
var inst_16457 = (state_16526[(8)]);
var inst_16507 = (state_16526[(11)]);
var inst_16509 = cljs.core.async.muxch_STAR_.call(null,inst_16507);
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16526__$1,(22),inst_16509,inst_16457);
} else {
if((state_val_16527 === (11))){
var inst_16481 = (state_16526[(10)]);
var inst_16467 = (state_16526[(15)]);
var inst_16481__$1 = cljs.core.seq.call(null,inst_16467);
var state_16526__$1 = (function (){var statearr_16558 = state_16526;
(statearr_16558[(10)] = inst_16481__$1);

return statearr_16558;
})();
if(inst_16481__$1){
var statearr_16559_16621 = state_16526__$1;
(statearr_16559_16621[(1)] = (13));

} else {
var statearr_16560_16622 = state_16526__$1;
(statearr_16560_16622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (9))){
var inst_16503 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16561_16623 = state_16526__$1;
(statearr_16561_16623[(2)] = inst_16503);

(statearr_16561_16623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (5))){
var inst_16464 = cljs.core.deref.call(null,mults);
var inst_16465 = cljs.core.vals.call(null,inst_16464);
var inst_16466 = cljs.core.seq.call(null,inst_16465);
var inst_16467 = inst_16466;
var inst_16468 = null;
var inst_16469 = (0);
var inst_16470 = (0);
var state_16526__$1 = (function (){var statearr_16562 = state_16526;
(statearr_16562[(13)] = inst_16469);

(statearr_16562[(14)] = inst_16470);

(statearr_16562[(15)] = inst_16467);

(statearr_16562[(16)] = inst_16468);

return statearr_16562;
})();
var statearr_16563_16624 = state_16526__$1;
(statearr_16563_16624[(2)] = null);

(statearr_16563_16624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (14))){
var state_16526__$1 = state_16526;
var statearr_16567_16625 = state_16526__$1;
(statearr_16567_16625[(2)] = null);

(statearr_16567_16625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (16))){
var inst_16481 = (state_16526[(10)]);
var inst_16485 = cljs.core.chunk_first.call(null,inst_16481);
var inst_16486 = cljs.core.chunk_rest.call(null,inst_16481);
var inst_16487 = cljs.core.count.call(null,inst_16485);
var inst_16467 = inst_16486;
var inst_16468 = inst_16485;
var inst_16469 = inst_16487;
var inst_16470 = (0);
var state_16526__$1 = (function (){var statearr_16568 = state_16526;
(statearr_16568[(13)] = inst_16469);

(statearr_16568[(14)] = inst_16470);

(statearr_16568[(15)] = inst_16467);

(statearr_16568[(16)] = inst_16468);

return statearr_16568;
})();
var statearr_16569_16627 = state_16526__$1;
(statearr_16569_16627[(2)] = null);

(statearr_16569_16627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (10))){
var inst_16469 = (state_16526[(13)]);
var inst_16470 = (state_16526[(14)]);
var inst_16467 = (state_16526[(15)]);
var inst_16468 = (state_16526[(16)]);
var inst_16475 = cljs.core._nth.call(null,inst_16468,inst_16470);
var inst_16476 = cljs.core.async.muxch_STAR_.call(null,inst_16475);
var inst_16477 = cljs.core.async.close_BANG_.call(null,inst_16476);
var inst_16478 = (inst_16470 + (1));
var tmp16564 = inst_16469;
var tmp16565 = inst_16467;
var tmp16566 = inst_16468;
var inst_16467__$1 = tmp16565;
var inst_16468__$1 = tmp16566;
var inst_16469__$1 = tmp16564;
var inst_16470__$1 = inst_16478;
var state_16526__$1 = (function (){var statearr_16570 = state_16526;
(statearr_16570[(13)] = inst_16469__$1);

(statearr_16570[(14)] = inst_16470__$1);

(statearr_16570[(15)] = inst_16467__$1);

(statearr_16570[(17)] = inst_16477);

(statearr_16570[(16)] = inst_16468__$1);

return statearr_16570;
})();
var statearr_16571_16635 = state_16526__$1;
(statearr_16571_16635[(2)] = null);

(statearr_16571_16635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (18))){
var inst_16496 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16572_16637 = state_16526__$1;
(statearr_16572_16637[(2)] = inst_16496);

(statearr_16572_16637[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (8))){
var inst_16469 = (state_16526[(13)]);
var inst_16470 = (state_16526[(14)]);
var inst_16472 = (inst_16470 < inst_16469);
var inst_16473 = inst_16472;
var state_16526__$1 = state_16526;
if(cljs.core.truth_(inst_16473)){
var statearr_16573_16641 = state_16526__$1;
(statearr_16573_16641[(1)] = (10));

} else {
var statearr_16574_16642 = state_16526__$1;
(statearr_16574_16642[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16600,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14368__auto___16600,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16578 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16578[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16578[(1)] = (1));

return statearr_16578;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16526){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16579){if((e16579 instanceof Object)){
var ex__14240__auto__ = e16579;
var statearr_16580_16643 = state_16526;
(statearr_16580_16643[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16526);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16579;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16644 = state_16526;
state_16526 = G__16644;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16526){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16600,mults,ensure_mult,p))
})();
var state__14370__auto__ = (function (){var statearr_16581 = f__14369__auto__.call(null);
(statearr_16581[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16600);

return statearr_16581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16600,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16646 = [];
var len__7107__auto___16649 = arguments.length;
var i__7108__auto___16650 = (0);
while(true){
if((i__7108__auto___16650 < len__7107__auto___16649)){
args16646.push((arguments[i__7108__auto___16650]));

var G__16651 = (i__7108__auto___16650 + (1));
i__7108__auto___16650 = G__16651;
continue;
} else {
}
break;
}

var G__16648 = args16646.length;
switch (G__16648) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16646.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16653 = [];
var len__7107__auto___16664 = arguments.length;
var i__7108__auto___16665 = (0);
while(true){
if((i__7108__auto___16665 < len__7107__auto___16664)){
args16653.push((arguments[i__7108__auto___16665]));

var G__16666 = (i__7108__auto___16665 + (1));
i__7108__auto___16665 = G__16666;
continue;
} else {
}
break;
}

var G__16659 = args16653.length;
switch (G__16659) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16653.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16672 = [];
var len__7107__auto___16752 = arguments.length;
var i__7108__auto___16753 = (0);
while(true){
if((i__7108__auto___16753 < len__7107__auto___16752)){
args16672.push((arguments[i__7108__auto___16753]));

var G__16754 = (i__7108__auto___16753 + (1));
i__7108__auto___16753 = G__16754;
continue;
} else {
}
break;
}

var G__16674 = args16672.length;
switch (G__16674) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16672.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14368__auto___16760 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16713){
var state_val_16714 = (state_16713[(1)]);
if((state_val_16714 === (7))){
var state_16713__$1 = state_16713;
var statearr_16716_16762 = state_16713__$1;
(statearr_16716_16762[(2)] = null);

(statearr_16716_16762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (1))){
var state_16713__$1 = state_16713;
var statearr_16717_16763 = state_16713__$1;
(statearr_16717_16763[(2)] = null);

(statearr_16717_16763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (4))){
var inst_16677 = (state_16713[(7)]);
var inst_16679 = (inst_16677 < cnt);
var state_16713__$1 = state_16713;
if(cljs.core.truth_(inst_16679)){
var statearr_16718_16764 = state_16713__$1;
(statearr_16718_16764[(1)] = (6));

} else {
var statearr_16719_16765 = state_16713__$1;
(statearr_16719_16765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (15))){
var inst_16709 = (state_16713[(2)]);
var state_16713__$1 = state_16713;
var statearr_16720_16766 = state_16713__$1;
(statearr_16720_16766[(2)] = inst_16709);

(statearr_16720_16766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (13))){
var inst_16702 = cljs.core.async.close_BANG_.call(null,out);
var state_16713__$1 = state_16713;
var statearr_16721_16767 = state_16713__$1;
(statearr_16721_16767[(2)] = inst_16702);

(statearr_16721_16767[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (6))){
var state_16713__$1 = state_16713;
var statearr_16722_16768 = state_16713__$1;
(statearr_16722_16768[(2)] = null);

(statearr_16722_16768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (3))){
var inst_16711 = (state_16713[(2)]);
var state_16713__$1 = state_16713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16713__$1,inst_16711);
} else {
if((state_val_16714 === (12))){
var inst_16699 = (state_16713[(8)]);
var inst_16699__$1 = (state_16713[(2)]);
var inst_16700 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16699__$1);
var state_16713__$1 = (function (){var statearr_16723 = state_16713;
(statearr_16723[(8)] = inst_16699__$1);

return statearr_16723;
})();
if(cljs.core.truth_(inst_16700)){
var statearr_16724_16769 = state_16713__$1;
(statearr_16724_16769[(1)] = (13));

} else {
var statearr_16726_16770 = state_16713__$1;
(statearr_16726_16770[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (2))){
var inst_16676 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16677 = (0);
var state_16713__$1 = (function (){var statearr_16729 = state_16713;
(statearr_16729[(9)] = inst_16676);

(statearr_16729[(7)] = inst_16677);

return statearr_16729;
})();
var statearr_16730_16771 = state_16713__$1;
(statearr_16730_16771[(2)] = null);

(statearr_16730_16771[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (11))){
var inst_16677 = (state_16713[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16713,(10),Object,null,(9));
var inst_16686 = chs__$1.call(null,inst_16677);
var inst_16687 = done.call(null,inst_16677);
var inst_16688 = cljs.core.async.take_BANG_.call(null,inst_16686,inst_16687);
var state_16713__$1 = state_16713;
var statearr_16732_16772 = state_16713__$1;
(statearr_16732_16772[(2)] = inst_16688);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16713__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (9))){
var inst_16677 = (state_16713[(7)]);
var inst_16690 = (state_16713[(2)]);
var inst_16691 = (inst_16677 + (1));
var inst_16677__$1 = inst_16691;
var state_16713__$1 = (function (){var statearr_16733 = state_16713;
(statearr_16733[(10)] = inst_16690);

(statearr_16733[(7)] = inst_16677__$1);

return statearr_16733;
})();
var statearr_16734_16773 = state_16713__$1;
(statearr_16734_16773[(2)] = null);

(statearr_16734_16773[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (5))){
var inst_16697 = (state_16713[(2)]);
var state_16713__$1 = (function (){var statearr_16735 = state_16713;
(statearr_16735[(11)] = inst_16697);

return statearr_16735;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16713__$1,(12),dchan);
} else {
if((state_val_16714 === (14))){
var inst_16699 = (state_16713[(8)]);
var inst_16704 = cljs.core.apply.call(null,f,inst_16699);
var state_16713__$1 = state_16713;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16713__$1,(16),out,inst_16704);
} else {
if((state_val_16714 === (16))){
var inst_16706 = (state_16713[(2)]);
var state_16713__$1 = (function (){var statearr_16737 = state_16713;
(statearr_16737[(12)] = inst_16706);

return statearr_16737;
})();
var statearr_16738_16775 = state_16713__$1;
(statearr_16738_16775[(2)] = null);

(statearr_16738_16775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (10))){
var inst_16681 = (state_16713[(2)]);
var inst_16682 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16713__$1 = (function (){var statearr_16739 = state_16713;
(statearr_16739[(13)] = inst_16681);

return statearr_16739;
})();
var statearr_16740_16776 = state_16713__$1;
(statearr_16740_16776[(2)] = inst_16682);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16713__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16714 === (8))){
var inst_16695 = (state_16713[(2)]);
var state_16713__$1 = state_16713;
var statearr_16741_16777 = state_16713__$1;
(statearr_16741_16777[(2)] = inst_16695);

(statearr_16741_16777[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16745[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16745[(1)] = (1));

return statearr_16745;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16713){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16746){if((e16746 instanceof Object)){
var ex__14240__auto__ = e16746;
var statearr_16747_16779 = state_16713;
(statearr_16747_16779[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16713);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16780 = state_16713;
state_16713 = G__16780;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16713){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_16748 = f__14369__auto__.call(null);
(statearr_16748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16760);

return statearr_16748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16760,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16785 = [];
var len__7107__auto___16850 = arguments.length;
var i__7108__auto___16851 = (0);
while(true){
if((i__7108__auto___16851 < len__7107__auto___16850)){
args16785.push((arguments[i__7108__auto___16851]));

var G__16852 = (i__7108__auto___16851 + (1));
i__7108__auto___16851 = G__16852;
continue;
} else {
}
break;
}

var G__16790 = args16785.length;
switch (G__16790) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16785.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16854 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16854,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16854,out){
return (function (state_16822){
var state_val_16823 = (state_16822[(1)]);
if((state_val_16823 === (7))){
var inst_16802 = (state_16822[(7)]);
var inst_16801 = (state_16822[(8)]);
var inst_16801__$1 = (state_16822[(2)]);
var inst_16802__$1 = cljs.core.nth.call(null,inst_16801__$1,(0),null);
var inst_16803 = cljs.core.nth.call(null,inst_16801__$1,(1),null);
var inst_16804 = (inst_16802__$1 == null);
var state_16822__$1 = (function (){var statearr_16824 = state_16822;
(statearr_16824[(9)] = inst_16803);

(statearr_16824[(7)] = inst_16802__$1);

(statearr_16824[(8)] = inst_16801__$1);

return statearr_16824;
})();
if(cljs.core.truth_(inst_16804)){
var statearr_16825_16855 = state_16822__$1;
(statearr_16825_16855[(1)] = (8));

} else {
var statearr_16826_16856 = state_16822__$1;
(statearr_16826_16856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (1))){
var inst_16792 = cljs.core.vec.call(null,chs);
var inst_16793 = inst_16792;
var state_16822__$1 = (function (){var statearr_16827 = state_16822;
(statearr_16827[(10)] = inst_16793);

return statearr_16827;
})();
var statearr_16828_16857 = state_16822__$1;
(statearr_16828_16857[(2)] = null);

(statearr_16828_16857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (4))){
var inst_16793 = (state_16822[(10)]);
var state_16822__$1 = state_16822;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16822__$1,(7),inst_16793);
} else {
if((state_val_16823 === (6))){
var inst_16818 = (state_16822[(2)]);
var state_16822__$1 = state_16822;
var statearr_16832_16858 = state_16822__$1;
(statearr_16832_16858[(2)] = inst_16818);

(statearr_16832_16858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (3))){
var inst_16820 = (state_16822[(2)]);
var state_16822__$1 = state_16822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16822__$1,inst_16820);
} else {
if((state_val_16823 === (2))){
var inst_16793 = (state_16822[(10)]);
var inst_16795 = cljs.core.count.call(null,inst_16793);
var inst_16797 = (inst_16795 > (0));
var state_16822__$1 = state_16822;
if(cljs.core.truth_(inst_16797)){
var statearr_16834_16859 = state_16822__$1;
(statearr_16834_16859[(1)] = (4));

} else {
var statearr_16835_16860 = state_16822__$1;
(statearr_16835_16860[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (11))){
var inst_16793 = (state_16822[(10)]);
var inst_16811 = (state_16822[(2)]);
var tmp16833 = inst_16793;
var inst_16793__$1 = tmp16833;
var state_16822__$1 = (function (){var statearr_16836 = state_16822;
(statearr_16836[(10)] = inst_16793__$1);

(statearr_16836[(11)] = inst_16811);

return statearr_16836;
})();
var statearr_16837_16861 = state_16822__$1;
(statearr_16837_16861[(2)] = null);

(statearr_16837_16861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (9))){
var inst_16802 = (state_16822[(7)]);
var state_16822__$1 = state_16822;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16822__$1,(11),out,inst_16802);
} else {
if((state_val_16823 === (5))){
var inst_16816 = cljs.core.async.close_BANG_.call(null,out);
var state_16822__$1 = state_16822;
var statearr_16838_16862 = state_16822__$1;
(statearr_16838_16862[(2)] = inst_16816);

(statearr_16838_16862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (10))){
var inst_16814 = (state_16822[(2)]);
var state_16822__$1 = state_16822;
var statearr_16839_16863 = state_16822__$1;
(statearr_16839_16863[(2)] = inst_16814);

(statearr_16839_16863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16823 === (8))){
var inst_16793 = (state_16822[(10)]);
var inst_16803 = (state_16822[(9)]);
var inst_16802 = (state_16822[(7)]);
var inst_16801 = (state_16822[(8)]);
var inst_16806 = (function (){var cs = inst_16793;
var vec__16799 = inst_16801;
var v = inst_16802;
var c = inst_16803;
return ((function (cs,vec__16799,v,c,inst_16793,inst_16803,inst_16802,inst_16801,state_val_16823,c__14368__auto___16854,out){
return (function (p1__16784_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16784_SHARP_);
});
;})(cs,vec__16799,v,c,inst_16793,inst_16803,inst_16802,inst_16801,state_val_16823,c__14368__auto___16854,out))
})();
var inst_16807 = cljs.core.filterv.call(null,inst_16806,inst_16793);
var inst_16793__$1 = inst_16807;
var state_16822__$1 = (function (){var statearr_16840 = state_16822;
(statearr_16840[(10)] = inst_16793__$1);

return statearr_16840;
})();
var statearr_16841_16865 = state_16822__$1;
(statearr_16841_16865[(2)] = null);

(statearr_16841_16865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16854,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16854,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16845 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16845[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16845[(1)] = (1));

return statearr_16845;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16822){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16846){if((e16846 instanceof Object)){
var ex__14240__auto__ = e16846;
var statearr_16847_16868 = state_16822;
(statearr_16847_16868[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16822);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16872 = state_16822;
state_16822 = G__16872;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16822){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16854,out))
})();
var state__14370__auto__ = (function (){var statearr_16849 = f__14369__auto__.call(null);
(statearr_16849[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16854);

return statearr_16849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16854,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16874 = [];
var len__7107__auto___16931 = arguments.length;
var i__7108__auto___16932 = (0);
while(true){
if((i__7108__auto___16932 < len__7107__auto___16931)){
args16874.push((arguments[i__7108__auto___16932]));

var G__16933 = (i__7108__auto___16932 + (1));
i__7108__auto___16932 = G__16933;
continue;
} else {
}
break;
}

var G__16879 = args16874.length;
switch (G__16879) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16874.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16935 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16935,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16935,out){
return (function (state_16904){
var state_val_16905 = (state_16904[(1)]);
if((state_val_16905 === (7))){
var inst_16886 = (state_16904[(7)]);
var inst_16886__$1 = (state_16904[(2)]);
var inst_16887 = (inst_16886__$1 == null);
var inst_16888 = cljs.core.not.call(null,inst_16887);
var state_16904__$1 = (function (){var statearr_16907 = state_16904;
(statearr_16907[(7)] = inst_16886__$1);

return statearr_16907;
})();
if(inst_16888){
var statearr_16908_16937 = state_16904__$1;
(statearr_16908_16937[(1)] = (8));

} else {
var statearr_16909_16938 = state_16904__$1;
(statearr_16909_16938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (1))){
var inst_16881 = (0);
var state_16904__$1 = (function (){var statearr_16910 = state_16904;
(statearr_16910[(8)] = inst_16881);

return statearr_16910;
})();
var statearr_16911_16939 = state_16904__$1;
(statearr_16911_16939[(2)] = null);

(statearr_16911_16939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (4))){
var state_16904__$1 = state_16904;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16904__$1,(7),ch);
} else {
if((state_val_16905 === (6))){
var inst_16899 = (state_16904[(2)]);
var state_16904__$1 = state_16904;
var statearr_16912_16940 = state_16904__$1;
(statearr_16912_16940[(2)] = inst_16899);

(statearr_16912_16940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (3))){
var inst_16901 = (state_16904[(2)]);
var inst_16902 = cljs.core.async.close_BANG_.call(null,out);
var state_16904__$1 = (function (){var statearr_16913 = state_16904;
(statearr_16913[(9)] = inst_16901);

return statearr_16913;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16904__$1,inst_16902);
} else {
if((state_val_16905 === (2))){
var inst_16881 = (state_16904[(8)]);
var inst_16883 = (inst_16881 < n);
var state_16904__$1 = state_16904;
if(cljs.core.truth_(inst_16883)){
var statearr_16914_16941 = state_16904__$1;
(statearr_16914_16941[(1)] = (4));

} else {
var statearr_16915_16942 = state_16904__$1;
(statearr_16915_16942[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (11))){
var inst_16881 = (state_16904[(8)]);
var inst_16891 = (state_16904[(2)]);
var inst_16892 = (inst_16881 + (1));
var inst_16881__$1 = inst_16892;
var state_16904__$1 = (function (){var statearr_16916 = state_16904;
(statearr_16916[(10)] = inst_16891);

(statearr_16916[(8)] = inst_16881__$1);

return statearr_16916;
})();
var statearr_16917_16943 = state_16904__$1;
(statearr_16917_16943[(2)] = null);

(statearr_16917_16943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (9))){
var state_16904__$1 = state_16904;
var statearr_16918_16944 = state_16904__$1;
(statearr_16918_16944[(2)] = null);

(statearr_16918_16944[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (5))){
var state_16904__$1 = state_16904;
var statearr_16919_16945 = state_16904__$1;
(statearr_16919_16945[(2)] = null);

(statearr_16919_16945[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (10))){
var inst_16896 = (state_16904[(2)]);
var state_16904__$1 = state_16904;
var statearr_16920_16946 = state_16904__$1;
(statearr_16920_16946[(2)] = inst_16896);

(statearr_16920_16946[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16905 === (8))){
var inst_16886 = (state_16904[(7)]);
var state_16904__$1 = state_16904;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16904__$1,(11),out,inst_16886);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16935,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16935,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16927 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16927[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16927[(1)] = (1));

return statearr_16927;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16904){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16904);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16928){if((e16928 instanceof Object)){
var ex__14240__auto__ = e16928;
var statearr_16929_16947 = state_16904;
(statearr_16929_16947[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16948 = state_16904;
state_16904 = G__16948;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16904){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16935,out))
})();
var state__14370__auto__ = (function (){var statearr_16930 = f__14369__auto__.call(null);
(statearr_16930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16935);

return statearr_16930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16935,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16959 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16959 = (function (map_LT_,f,ch,meta16960){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16960 = meta16960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16961,meta16960__$1){
var self__ = this;
var _16961__$1 = this;
return (new cljs.core.async.t_cljs$core$async16959(self__.map_LT_,self__.f,self__.ch,meta16960__$1));
});

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16961){
var self__ = this;
var _16961__$1 = this;
return self__.meta16960;
});

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16963 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16963 = (function (map_LT_,f,ch,meta16960,_,fn1,meta16964){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16960 = meta16960;
this._ = _;
this.fn1 = fn1;
this.meta16964 = meta16964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16965,meta16964__$1){
var self__ = this;
var _16965__$1 = this;
return (new cljs.core.async.t_cljs$core$async16963(self__.map_LT_,self__.f,self__.ch,self__.meta16960,self__._,self__.fn1,meta16964__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16965){
var self__ = this;
var _16965__$1 = this;
return self__.meta16964;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16949_SHARP_){
return f1.call(null,(((p1__16949_SHARP_ == null))?null:self__.f.call(null,p1__16949_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16960","meta16960",-1924152610,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16959","cljs.core.async/t_cljs$core$async16959",171872562,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16964","meta16964",-2118132505,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16963.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16963.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16963";

cljs.core.async.t_cljs$core$async16963.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16963");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16963 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16963(map_LT___$1,f__$1,ch__$1,meta16960__$1,___$2,fn1__$1,meta16964){
return (new cljs.core.async.t_cljs$core$async16963(map_LT___$1,f__$1,ch__$1,meta16960__$1,___$2,fn1__$1,meta16964));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16963(self__.map_LT_,self__.f,self__.ch,self__.meta16960,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16960","meta16960",-1924152610,null)], null);
});

cljs.core.async.t_cljs$core$async16959.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16959";

cljs.core.async.t_cljs$core$async16959.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16959");
});

cljs.core.async.__GT_t_cljs$core$async16959 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16959(map_LT___$1,f__$1,ch__$1,meta16960){
return (new cljs.core.async.t_cljs$core$async16959(map_LT___$1,f__$1,ch__$1,meta16960));
});

}

return (new cljs.core.async.t_cljs$core$async16959(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16981 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16981 = (function (map_GT_,f,ch,meta16982){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16982 = meta16982;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16983,meta16982__$1){
var self__ = this;
var _16983__$1 = this;
return (new cljs.core.async.t_cljs$core$async16981(self__.map_GT_,self__.f,self__.ch,meta16982__$1));
});

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16983){
var self__ = this;
var _16983__$1 = this;
return self__.meta16982;
});

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16981.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16981.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16982","meta16982",-720608050,null)], null);
});

cljs.core.async.t_cljs$core$async16981.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16981.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16981";

cljs.core.async.t_cljs$core$async16981.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16981");
});

cljs.core.async.__GT_t_cljs$core$async16981 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16981(map_GT___$1,f__$1,ch__$1,meta16982){
return (new cljs.core.async.t_cljs$core$async16981(map_GT___$1,f__$1,ch__$1,meta16982));
});

}

return (new cljs.core.async.t_cljs$core$async16981(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16987 = (function (filter_GT_,p,ch,meta16988){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16988 = meta16988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16989,meta16988__$1){
var self__ = this;
var _16989__$1 = this;
return (new cljs.core.async.t_cljs$core$async16987(self__.filter_GT_,self__.p,self__.ch,meta16988__$1));
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16989){
var self__ = this;
var _16989__$1 = this;
return self__.meta16988;
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16988","meta16988",1905632198,null)], null);
});

cljs.core.async.t_cljs$core$async16987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16987";

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16987");
});

cljs.core.async.__GT_t_cljs$core$async16987 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16987(filter_GT___$1,p__$1,ch__$1,meta16988){
return (new cljs.core.async.t_cljs$core$async16987(filter_GT___$1,p__$1,ch__$1,meta16988));
});

}

return (new cljs.core.async.t_cljs$core$async16987(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16998 = [];
var len__7107__auto___17046 = arguments.length;
var i__7108__auto___17047 = (0);
while(true){
if((i__7108__auto___17047 < len__7107__auto___17046)){
args16998.push((arguments[i__7108__auto___17047]));

var G__17048 = (i__7108__auto___17047 + (1));
i__7108__auto___17047 = G__17048;
continue;
} else {
}
break;
}

var G__17003 = args16998.length;
switch (G__17003) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16998.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17050 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17050,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17050,out){
return (function (state_17024){
var state_val_17025 = (state_17024[(1)]);
if((state_val_17025 === (7))){
var inst_17020 = (state_17024[(2)]);
var state_17024__$1 = state_17024;
var statearr_17026_17051 = state_17024__$1;
(statearr_17026_17051[(2)] = inst_17020);

(statearr_17026_17051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (1))){
var state_17024__$1 = state_17024;
var statearr_17027_17052 = state_17024__$1;
(statearr_17027_17052[(2)] = null);

(statearr_17027_17052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (4))){
var inst_17006 = (state_17024[(7)]);
var inst_17006__$1 = (state_17024[(2)]);
var inst_17007 = (inst_17006__$1 == null);
var state_17024__$1 = (function (){var statearr_17028 = state_17024;
(statearr_17028[(7)] = inst_17006__$1);

return statearr_17028;
})();
if(cljs.core.truth_(inst_17007)){
var statearr_17029_17053 = state_17024__$1;
(statearr_17029_17053[(1)] = (5));

} else {
var statearr_17030_17054 = state_17024__$1;
(statearr_17030_17054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (6))){
var inst_17006 = (state_17024[(7)]);
var inst_17011 = p.call(null,inst_17006);
var state_17024__$1 = state_17024;
if(cljs.core.truth_(inst_17011)){
var statearr_17031_17055 = state_17024__$1;
(statearr_17031_17055[(1)] = (8));

} else {
var statearr_17032_17056 = state_17024__$1;
(statearr_17032_17056[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (3))){
var inst_17022 = (state_17024[(2)]);
var state_17024__$1 = state_17024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17024__$1,inst_17022);
} else {
if((state_val_17025 === (2))){
var state_17024__$1 = state_17024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17024__$1,(4),ch);
} else {
if((state_val_17025 === (11))){
var inst_17014 = (state_17024[(2)]);
var state_17024__$1 = state_17024;
var statearr_17034_17057 = state_17024__$1;
(statearr_17034_17057[(2)] = inst_17014);

(statearr_17034_17057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (9))){
var state_17024__$1 = state_17024;
var statearr_17035_17058 = state_17024__$1;
(statearr_17035_17058[(2)] = null);

(statearr_17035_17058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (5))){
var inst_17009 = cljs.core.async.close_BANG_.call(null,out);
var state_17024__$1 = state_17024;
var statearr_17036_17059 = state_17024__$1;
(statearr_17036_17059[(2)] = inst_17009);

(statearr_17036_17059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (10))){
var inst_17017 = (state_17024[(2)]);
var state_17024__$1 = (function (){var statearr_17037 = state_17024;
(statearr_17037[(8)] = inst_17017);

return statearr_17037;
})();
var statearr_17038_17060 = state_17024__$1;
(statearr_17038_17060[(2)] = null);

(statearr_17038_17060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17025 === (8))){
var inst_17006 = (state_17024[(7)]);
var state_17024__$1 = state_17024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17024__$1,(11),out,inst_17006);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17050,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17050,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17042 = [null,null,null,null,null,null,null,null,null];
(statearr_17042[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17042[(1)] = (1));

return statearr_17042;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17024){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17043){if((e17043 instanceof Object)){
var ex__14240__auto__ = e17043;
var statearr_17044_17063 = state_17024;
(statearr_17044_17063[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17043;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17065 = state_17024;
state_17024 = G__17065;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17050,out))
})();
var state__14370__auto__ = (function (){var statearr_17045 = f__14369__auto__.call(null);
(statearr_17045[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17050);

return statearr_17045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17050,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17067 = [];
var len__7107__auto___17073 = arguments.length;
var i__7108__auto___17074 = (0);
while(true){
if((i__7108__auto___17074 < len__7107__auto___17073)){
args17067.push((arguments[i__7108__auto___17074]));

var G__17075 = (i__7108__auto___17074 + (1));
i__7108__auto___17074 = G__17075;
continue;
} else {
}
break;
}

var G__17069 = args17067.length;
switch (G__17069) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17067.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_17243){
var state_val_17244 = (state_17243[(1)]);
if((state_val_17244 === (7))){
var inst_17239 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17245_17293 = state_17243__$1;
(statearr_17245_17293[(2)] = inst_17239);

(statearr_17245_17293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (20))){
var inst_17209 = (state_17243[(7)]);
var inst_17220 = (state_17243[(2)]);
var inst_17221 = cljs.core.next.call(null,inst_17209);
var inst_17195 = inst_17221;
var inst_17196 = null;
var inst_17197 = (0);
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17246 = state_17243;
(statearr_17246[(8)] = inst_17197);

(statearr_17246[(9)] = inst_17196);

(statearr_17246[(10)] = inst_17198);

(statearr_17246[(11)] = inst_17195);

(statearr_17246[(12)] = inst_17220);

return statearr_17246;
})();
var statearr_17247_17295 = state_17243__$1;
(statearr_17247_17295[(2)] = null);

(statearr_17247_17295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (1))){
var state_17243__$1 = state_17243;
var statearr_17248_17296 = state_17243__$1;
(statearr_17248_17296[(2)] = null);

(statearr_17248_17296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (4))){
var inst_17184 = (state_17243[(13)]);
var inst_17184__$1 = (state_17243[(2)]);
var inst_17185 = (inst_17184__$1 == null);
var state_17243__$1 = (function (){var statearr_17249 = state_17243;
(statearr_17249[(13)] = inst_17184__$1);

return statearr_17249;
})();
if(cljs.core.truth_(inst_17185)){
var statearr_17250_17297 = state_17243__$1;
(statearr_17250_17297[(1)] = (5));

} else {
var statearr_17251_17298 = state_17243__$1;
(statearr_17251_17298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (15))){
var state_17243__$1 = state_17243;
var statearr_17255_17299 = state_17243__$1;
(statearr_17255_17299[(2)] = null);

(statearr_17255_17299[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (21))){
var state_17243__$1 = state_17243;
var statearr_17256_17300 = state_17243__$1;
(statearr_17256_17300[(2)] = null);

(statearr_17256_17300[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (13))){
var inst_17197 = (state_17243[(8)]);
var inst_17196 = (state_17243[(9)]);
var inst_17198 = (state_17243[(10)]);
var inst_17195 = (state_17243[(11)]);
var inst_17205 = (state_17243[(2)]);
var inst_17206 = (inst_17198 + (1));
var tmp17252 = inst_17197;
var tmp17253 = inst_17196;
var tmp17254 = inst_17195;
var inst_17195__$1 = tmp17254;
var inst_17196__$1 = tmp17253;
var inst_17197__$1 = tmp17252;
var inst_17198__$1 = inst_17206;
var state_17243__$1 = (function (){var statearr_17257 = state_17243;
(statearr_17257[(8)] = inst_17197__$1);

(statearr_17257[(9)] = inst_17196__$1);

(statearr_17257[(10)] = inst_17198__$1);

(statearr_17257[(11)] = inst_17195__$1);

(statearr_17257[(14)] = inst_17205);

return statearr_17257;
})();
var statearr_17258_17301 = state_17243__$1;
(statearr_17258_17301[(2)] = null);

(statearr_17258_17301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (22))){
var state_17243__$1 = state_17243;
var statearr_17259_17302 = state_17243__$1;
(statearr_17259_17302[(2)] = null);

(statearr_17259_17302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (6))){
var inst_17184 = (state_17243[(13)]);
var inst_17193 = f.call(null,inst_17184);
var inst_17194 = cljs.core.seq.call(null,inst_17193);
var inst_17195 = inst_17194;
var inst_17196 = null;
var inst_17197 = (0);
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17260 = state_17243;
(statearr_17260[(8)] = inst_17197);

(statearr_17260[(9)] = inst_17196);

(statearr_17260[(10)] = inst_17198);

(statearr_17260[(11)] = inst_17195);

return statearr_17260;
})();
var statearr_17261_17303 = state_17243__$1;
(statearr_17261_17303[(2)] = null);

(statearr_17261_17303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (17))){
var inst_17209 = (state_17243[(7)]);
var inst_17213 = cljs.core.chunk_first.call(null,inst_17209);
var inst_17214 = cljs.core.chunk_rest.call(null,inst_17209);
var inst_17215 = cljs.core.count.call(null,inst_17213);
var inst_17195 = inst_17214;
var inst_17196 = inst_17213;
var inst_17197 = inst_17215;
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17262 = state_17243;
(statearr_17262[(8)] = inst_17197);

(statearr_17262[(9)] = inst_17196);

(statearr_17262[(10)] = inst_17198);

(statearr_17262[(11)] = inst_17195);

return statearr_17262;
})();
var statearr_17263_17304 = state_17243__$1;
(statearr_17263_17304[(2)] = null);

(statearr_17263_17304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (3))){
var inst_17241 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17243__$1,inst_17241);
} else {
if((state_val_17244 === (12))){
var inst_17229 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17264_17305 = state_17243__$1;
(statearr_17264_17305[(2)] = inst_17229);

(statearr_17264_17305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (2))){
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17243__$1,(4),in$);
} else {
if((state_val_17244 === (23))){
var inst_17237 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17265_17306 = state_17243__$1;
(statearr_17265_17306[(2)] = inst_17237);

(statearr_17265_17306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (19))){
var inst_17224 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17268_17307 = state_17243__$1;
(statearr_17268_17307[(2)] = inst_17224);

(statearr_17268_17307[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (11))){
var inst_17209 = (state_17243[(7)]);
var inst_17195 = (state_17243[(11)]);
var inst_17209__$1 = cljs.core.seq.call(null,inst_17195);
var state_17243__$1 = (function (){var statearr_17270 = state_17243;
(statearr_17270[(7)] = inst_17209__$1);

return statearr_17270;
})();
if(inst_17209__$1){
var statearr_17271_17308 = state_17243__$1;
(statearr_17271_17308[(1)] = (14));

} else {
var statearr_17272_17309 = state_17243__$1;
(statearr_17272_17309[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (9))){
var inst_17231 = (state_17243[(2)]);
var inst_17232 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17243__$1 = (function (){var statearr_17273 = state_17243;
(statearr_17273[(15)] = inst_17231);

return statearr_17273;
})();
if(cljs.core.truth_(inst_17232)){
var statearr_17274_17312 = state_17243__$1;
(statearr_17274_17312[(1)] = (21));

} else {
var statearr_17275_17313 = state_17243__$1;
(statearr_17275_17313[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (5))){
var inst_17187 = cljs.core.async.close_BANG_.call(null,out);
var state_17243__$1 = state_17243;
var statearr_17276_17315 = state_17243__$1;
(statearr_17276_17315[(2)] = inst_17187);

(statearr_17276_17315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (14))){
var inst_17209 = (state_17243[(7)]);
var inst_17211 = cljs.core.chunked_seq_QMARK_.call(null,inst_17209);
var state_17243__$1 = state_17243;
if(inst_17211){
var statearr_17278_17317 = state_17243__$1;
(statearr_17278_17317[(1)] = (17));

} else {
var statearr_17279_17318 = state_17243__$1;
(statearr_17279_17318[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (16))){
var inst_17227 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17280_17319 = state_17243__$1;
(statearr_17280_17319[(2)] = inst_17227);

(statearr_17280_17319[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (10))){
var inst_17196 = (state_17243[(9)]);
var inst_17198 = (state_17243[(10)]);
var inst_17203 = cljs.core._nth.call(null,inst_17196,inst_17198);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17243__$1,(13),out,inst_17203);
} else {
if((state_val_17244 === (18))){
var inst_17209 = (state_17243[(7)]);
var inst_17218 = cljs.core.first.call(null,inst_17209);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17243__$1,(20),out,inst_17218);
} else {
if((state_val_17244 === (8))){
var inst_17197 = (state_17243[(8)]);
var inst_17198 = (state_17243[(10)]);
var inst_17200 = (inst_17198 < inst_17197);
var inst_17201 = inst_17200;
var state_17243__$1 = state_17243;
if(cljs.core.truth_(inst_17201)){
var statearr_17281_17327 = state_17243__$1;
(statearr_17281_17327[(1)] = (10));

} else {
var statearr_17282_17328 = state_17243__$1;
(statearr_17282_17328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17286[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17286[(1)] = (1));

return statearr_17286;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17243){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17287){if((e17287 instanceof Object)){
var ex__14240__auto__ = e17287;
var statearr_17288_17329 = state_17243;
(statearr_17288_17329[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17331 = state_17243;
state_17243 = G__17331;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17243){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_17289 = f__14369__auto__.call(null);
(statearr_17289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_17289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17332 = [];
var len__7107__auto___17335 = arguments.length;
var i__7108__auto___17336 = (0);
while(true){
if((i__7108__auto___17336 < len__7107__auto___17335)){
args17332.push((arguments[i__7108__auto___17336]));

var G__17337 = (i__7108__auto___17336 + (1));
i__7108__auto___17336 = G__17337;
continue;
} else {
}
break;
}

var G__17334 = args17332.length;
switch (G__17334) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17332.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17339 = [];
var len__7107__auto___17342 = arguments.length;
var i__7108__auto___17343 = (0);
while(true){
if((i__7108__auto___17343 < len__7107__auto___17342)){
args17339.push((arguments[i__7108__auto___17343]));

var G__17344 = (i__7108__auto___17343 + (1));
i__7108__auto___17343 = G__17344;
continue;
} else {
}
break;
}

var G__17341 = args17339.length;
switch (G__17341) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17339.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17346 = [];
var len__7107__auto___17397 = arguments.length;
var i__7108__auto___17398 = (0);
while(true){
if((i__7108__auto___17398 < len__7107__auto___17397)){
args17346.push((arguments[i__7108__auto___17398]));

var G__17399 = (i__7108__auto___17398 + (1));
i__7108__auto___17398 = G__17399;
continue;
} else {
}
break;
}

var G__17348 = args17346.length;
switch (G__17348) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17346.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17401,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17401,out){
return (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (7))){
var inst_17367 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17374_17402 = state_17372__$1;
(statearr_17374_17402[(2)] = inst_17367);

(statearr_17374_17402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (1))){
var inst_17349 = null;
var state_17372__$1 = (function (){var statearr_17375 = state_17372;
(statearr_17375[(7)] = inst_17349);

return statearr_17375;
})();
var statearr_17376_17403 = state_17372__$1;
(statearr_17376_17403[(2)] = null);

(statearr_17376_17403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (4))){
var inst_17352 = (state_17372[(8)]);
var inst_17352__$1 = (state_17372[(2)]);
var inst_17353 = (inst_17352__$1 == null);
var inst_17354 = cljs.core.not.call(null,inst_17353);
var state_17372__$1 = (function (){var statearr_17377 = state_17372;
(statearr_17377[(8)] = inst_17352__$1);

return statearr_17377;
})();
if(inst_17354){
var statearr_17378_17404 = state_17372__$1;
(statearr_17378_17404[(1)] = (5));

} else {
var statearr_17379_17406 = state_17372__$1;
(statearr_17379_17406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var state_17372__$1 = state_17372;
var statearr_17380_17407 = state_17372__$1;
(statearr_17380_17407[(2)] = null);

(statearr_17380_17407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (3))){
var inst_17369 = (state_17372[(2)]);
var inst_17370 = cljs.core.async.close_BANG_.call(null,out);
var state_17372__$1 = (function (){var statearr_17381 = state_17372;
(statearr_17381[(9)] = inst_17369);

return statearr_17381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (2))){
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17372__$1,(4),ch);
} else {
if((state_val_17373 === (11))){
var inst_17352 = (state_17372[(8)]);
var inst_17361 = (state_17372[(2)]);
var inst_17349 = inst_17352;
var state_17372__$1 = (function (){var statearr_17382 = state_17372;
(statearr_17382[(7)] = inst_17349);

(statearr_17382[(10)] = inst_17361);

return statearr_17382;
})();
var statearr_17383_17415 = state_17372__$1;
(statearr_17383_17415[(2)] = null);

(statearr_17383_17415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (9))){
var inst_17352 = (state_17372[(8)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17372__$1,(11),out,inst_17352);
} else {
if((state_val_17373 === (5))){
var inst_17349 = (state_17372[(7)]);
var inst_17352 = (state_17372[(8)]);
var inst_17356 = cljs.core._EQ_.call(null,inst_17352,inst_17349);
var state_17372__$1 = state_17372;
if(inst_17356){
var statearr_17385_17417 = state_17372__$1;
(statearr_17385_17417[(1)] = (8));

} else {
var statearr_17386_17422 = state_17372__$1;
(statearr_17386_17422[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (10))){
var inst_17364 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17387_17424 = state_17372__$1;
(statearr_17387_17424[(2)] = inst_17364);

(statearr_17387_17424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (8))){
var inst_17349 = (state_17372[(7)]);
var tmp17384 = inst_17349;
var inst_17349__$1 = tmp17384;
var state_17372__$1 = (function (){var statearr_17388 = state_17372;
(statearr_17388[(7)] = inst_17349__$1);

return statearr_17388;
})();
var statearr_17389_17426 = state_17372__$1;
(statearr_17389_17426[(2)] = null);

(statearr_17389_17426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17401,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17401,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17393 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17393[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17393[(1)] = (1));

return statearr_17393;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17372){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17394){if((e17394 instanceof Object)){
var ex__14240__auto__ = e17394;
var statearr_17395_17429 = state_17372;
(statearr_17395_17429[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17431 = state_17372;
state_17372 = G__17431;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17401,out))
})();
var state__14370__auto__ = (function (){var statearr_17396 = f__14369__auto__.call(null);
(statearr_17396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17401);

return statearr_17396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17401,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17432 = [];
var len__7107__auto___17503 = arguments.length;
var i__7108__auto___17504 = (0);
while(true){
if((i__7108__auto___17504 < len__7107__auto___17503)){
args17432.push((arguments[i__7108__auto___17504]));

var G__17505 = (i__7108__auto___17504 + (1));
i__7108__auto___17504 = G__17505;
continue;
} else {
}
break;
}

var G__17434 = args17432.length;
switch (G__17434) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17432.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17513,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17513,out){
return (function (state_17472){
var state_val_17473 = (state_17472[(1)]);
if((state_val_17473 === (7))){
var inst_17468 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17474_17520 = state_17472__$1;
(statearr_17474_17520[(2)] = inst_17468);

(statearr_17474_17520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (1))){
var inst_17435 = (new Array(n));
var inst_17436 = inst_17435;
var inst_17437 = (0);
var state_17472__$1 = (function (){var statearr_17475 = state_17472;
(statearr_17475[(7)] = inst_17437);

(statearr_17475[(8)] = inst_17436);

return statearr_17475;
})();
var statearr_17476_17524 = state_17472__$1;
(statearr_17476_17524[(2)] = null);

(statearr_17476_17524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (4))){
var inst_17440 = (state_17472[(9)]);
var inst_17440__$1 = (state_17472[(2)]);
var inst_17441 = (inst_17440__$1 == null);
var inst_17442 = cljs.core.not.call(null,inst_17441);
var state_17472__$1 = (function (){var statearr_17477 = state_17472;
(statearr_17477[(9)] = inst_17440__$1);

return statearr_17477;
})();
if(inst_17442){
var statearr_17478_17526 = state_17472__$1;
(statearr_17478_17526[(1)] = (5));

} else {
var statearr_17479_17527 = state_17472__$1;
(statearr_17479_17527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (15))){
var inst_17462 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17480_17528 = state_17472__$1;
(statearr_17480_17528[(2)] = inst_17462);

(statearr_17480_17528[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (13))){
var state_17472__$1 = state_17472;
var statearr_17481_17529 = state_17472__$1;
(statearr_17481_17529[(2)] = null);

(statearr_17481_17529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (6))){
var inst_17437 = (state_17472[(7)]);
var inst_17458 = (inst_17437 > (0));
var state_17472__$1 = state_17472;
if(cljs.core.truth_(inst_17458)){
var statearr_17482_17531 = state_17472__$1;
(statearr_17482_17531[(1)] = (12));

} else {
var statearr_17483_17532 = state_17472__$1;
(statearr_17483_17532[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (3))){
var inst_17470 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17472__$1,inst_17470);
} else {
if((state_val_17473 === (12))){
var inst_17436 = (state_17472[(8)]);
var inst_17460 = cljs.core.vec.call(null,inst_17436);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(15),out,inst_17460);
} else {
if((state_val_17473 === (2))){
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17472__$1,(4),ch);
} else {
if((state_val_17473 === (11))){
var inst_17452 = (state_17472[(2)]);
var inst_17453 = (new Array(n));
var inst_17436 = inst_17453;
var inst_17437 = (0);
var state_17472__$1 = (function (){var statearr_17485 = state_17472;
(statearr_17485[(10)] = inst_17452);

(statearr_17485[(7)] = inst_17437);

(statearr_17485[(8)] = inst_17436);

return statearr_17485;
})();
var statearr_17486_17534 = state_17472__$1;
(statearr_17486_17534[(2)] = null);

(statearr_17486_17534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (9))){
var inst_17436 = (state_17472[(8)]);
var inst_17450 = cljs.core.vec.call(null,inst_17436);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(11),out,inst_17450);
} else {
if((state_val_17473 === (5))){
var inst_17440 = (state_17472[(9)]);
var inst_17445 = (state_17472[(11)]);
var inst_17437 = (state_17472[(7)]);
var inst_17436 = (state_17472[(8)]);
var inst_17444 = (inst_17436[inst_17437] = inst_17440);
var inst_17445__$1 = (inst_17437 + (1));
var inst_17446 = (inst_17445__$1 < n);
var state_17472__$1 = (function (){var statearr_17487 = state_17472;
(statearr_17487[(11)] = inst_17445__$1);

(statearr_17487[(12)] = inst_17444);

return statearr_17487;
})();
if(cljs.core.truth_(inst_17446)){
var statearr_17488_17543 = state_17472__$1;
(statearr_17488_17543[(1)] = (8));

} else {
var statearr_17489_17548 = state_17472__$1;
(statearr_17489_17548[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (14))){
var inst_17465 = (state_17472[(2)]);
var inst_17466 = cljs.core.async.close_BANG_.call(null,out);
var state_17472__$1 = (function (){var statearr_17491 = state_17472;
(statearr_17491[(13)] = inst_17465);

return statearr_17491;
})();
var statearr_17492_17551 = state_17472__$1;
(statearr_17492_17551[(2)] = inst_17466);

(statearr_17492_17551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (10))){
var inst_17456 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17493_17554 = state_17472__$1;
(statearr_17493_17554[(2)] = inst_17456);

(statearr_17493_17554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (8))){
var inst_17445 = (state_17472[(11)]);
var inst_17436 = (state_17472[(8)]);
var tmp17490 = inst_17436;
var inst_17436__$1 = tmp17490;
var inst_17437 = inst_17445;
var state_17472__$1 = (function (){var statearr_17494 = state_17472;
(statearr_17494[(7)] = inst_17437);

(statearr_17494[(8)] = inst_17436__$1);

return statearr_17494;
})();
var statearr_17495_17555 = state_17472__$1;
(statearr_17495_17555[(2)] = null);

(statearr_17495_17555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17513,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17513,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17499[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17499[(1)] = (1));

return statearr_17499;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17472){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17500){if((e17500 instanceof Object)){
var ex__14240__auto__ = e17500;
var statearr_17501_17557 = state_17472;
(statearr_17501_17557[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17500;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17558 = state_17472;
state_17472 = G__17558;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17472){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17513,out))
})();
var state__14370__auto__ = (function (){var statearr_17502 = f__14369__auto__.call(null);
(statearr_17502[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17513);

return statearr_17502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17513,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17559 = [];
var len__7107__auto___17636 = arguments.length;
var i__7108__auto___17637 = (0);
while(true){
if((i__7108__auto___17637 < len__7107__auto___17636)){
args17559.push((arguments[i__7108__auto___17637]));

var G__17639 = (i__7108__auto___17637 + (1));
i__7108__auto___17637 = G__17639;
continue;
} else {
}
break;
}

var G__17561 = args17559.length;
switch (G__17561) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17559.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17641 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17641,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17641,out){
return (function (state_17603){
var state_val_17604 = (state_17603[(1)]);
if((state_val_17604 === (7))){
var inst_17599 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17605_17645 = state_17603__$1;
(statearr_17605_17645[(2)] = inst_17599);

(statearr_17605_17645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (1))){
var inst_17562 = [];
var inst_17563 = inst_17562;
var inst_17564 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17603__$1 = (function (){var statearr_17606 = state_17603;
(statearr_17606[(7)] = inst_17563);

(statearr_17606[(8)] = inst_17564);

return statearr_17606;
})();
var statearr_17607_17646 = state_17603__$1;
(statearr_17607_17646[(2)] = null);

(statearr_17607_17646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (4))){
var inst_17567 = (state_17603[(9)]);
var inst_17567__$1 = (state_17603[(2)]);
var inst_17568 = (inst_17567__$1 == null);
var inst_17569 = cljs.core.not.call(null,inst_17568);
var state_17603__$1 = (function (){var statearr_17608 = state_17603;
(statearr_17608[(9)] = inst_17567__$1);

return statearr_17608;
})();
if(inst_17569){
var statearr_17609_17647 = state_17603__$1;
(statearr_17609_17647[(1)] = (5));

} else {
var statearr_17610_17648 = state_17603__$1;
(statearr_17610_17648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (15))){
var inst_17593 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17611_17649 = state_17603__$1;
(statearr_17611_17649[(2)] = inst_17593);

(statearr_17611_17649[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (13))){
var state_17603__$1 = state_17603;
var statearr_17612_17651 = state_17603__$1;
(statearr_17612_17651[(2)] = null);

(statearr_17612_17651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (6))){
var inst_17563 = (state_17603[(7)]);
var inst_17588 = inst_17563.length;
var inst_17589 = (inst_17588 > (0));
var state_17603__$1 = state_17603;
if(cljs.core.truth_(inst_17589)){
var statearr_17613_17652 = state_17603__$1;
(statearr_17613_17652[(1)] = (12));

} else {
var statearr_17614_17653 = state_17603__$1;
(statearr_17614_17653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (3))){
var inst_17601 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17603__$1,inst_17601);
} else {
if((state_val_17604 === (12))){
var inst_17563 = (state_17603[(7)]);
var inst_17591 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(15),out,inst_17591);
} else {
if((state_val_17604 === (2))){
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17603__$1,(4),ch);
} else {
if((state_val_17604 === (11))){
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17581 = (state_17603[(2)]);
var inst_17582 = [];
var inst_17583 = inst_17582.push(inst_17567);
var inst_17563 = inst_17582;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17615 = state_17603;
(statearr_17615[(7)] = inst_17563);

(statearr_17615[(8)] = inst_17564);

(statearr_17615[(11)] = inst_17583);

(statearr_17615[(12)] = inst_17581);

return statearr_17615;
})();
var statearr_17616_17654 = state_17603__$1;
(statearr_17616_17654[(2)] = null);

(statearr_17616_17654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (9))){
var inst_17563 = (state_17603[(7)]);
var inst_17579 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(11),out,inst_17579);
} else {
if((state_val_17604 === (5))){
var inst_17571 = (state_17603[(10)]);
var inst_17564 = (state_17603[(8)]);
var inst_17567 = (state_17603[(9)]);
var inst_17571__$1 = f.call(null,inst_17567);
var inst_17572 = cljs.core._EQ_.call(null,inst_17571__$1,inst_17564);
var inst_17573 = cljs.core.keyword_identical_QMARK_.call(null,inst_17564,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17574 = (inst_17572) || (inst_17573);
var state_17603__$1 = (function (){var statearr_17617 = state_17603;
(statearr_17617[(10)] = inst_17571__$1);

return statearr_17617;
})();
if(cljs.core.truth_(inst_17574)){
var statearr_17618_17655 = state_17603__$1;
(statearr_17618_17655[(1)] = (8));

} else {
var statearr_17619_17656 = state_17603__$1;
(statearr_17619_17656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (14))){
var inst_17596 = (state_17603[(2)]);
var inst_17597 = cljs.core.async.close_BANG_.call(null,out);
var state_17603__$1 = (function (){var statearr_17621 = state_17603;
(statearr_17621[(13)] = inst_17596);

return statearr_17621;
})();
var statearr_17622_17657 = state_17603__$1;
(statearr_17622_17657[(2)] = inst_17597);

(statearr_17622_17657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (10))){
var inst_17586 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17623_17658 = state_17603__$1;
(statearr_17623_17658[(2)] = inst_17586);

(statearr_17623_17658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (8))){
var inst_17563 = (state_17603[(7)]);
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17576 = inst_17563.push(inst_17567);
var tmp17620 = inst_17563;
var inst_17563__$1 = tmp17620;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17624 = state_17603;
(statearr_17624[(7)] = inst_17563__$1);

(statearr_17624[(14)] = inst_17576);

(statearr_17624[(8)] = inst_17564);

return statearr_17624;
})();
var statearr_17625_17659 = state_17603__$1;
(statearr_17625_17659[(2)] = null);

(statearr_17625_17659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17641,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17641,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17629[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17629[(1)] = (1));

return statearr_17629;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17603){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17632){if((e17632 instanceof Object)){
var ex__14240__auto__ = e17632;
var statearr_17633_17660 = state_17603;
(statearr_17633_17660[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17603);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17632;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17661 = state_17603;
state_17603 = G__17661;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17603){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17641,out))
})();
var state__14370__auto__ = (function (){var statearr_17635 = f__14369__auto__.call(null);
(statearr_17635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17641);

return statearr_17635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17641,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1462537983804