;   Copyright (c)  Sylvain Tedoldi. All rights reserved.
;   The use and distribution terms for this software are covered by the
;   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;   which can be found in the file epl-v10.html at the root of this distribution.
;   By using this software in any fashion, you are agreeing to be bound by
;   the terms of this license.
;   You must not remove this notice, or any other, from this software.
;

(ns cubanostack.components.bus
  (:require
    [com.stuartsierra.component :as c]
    [cubanostack.components.wrapper-manager :as wrapper-manager]))



(defprotocol Bus
  (send! [this topic]
         [this topic payload]))



(defrecord Bus* [WrapperManager]
  c/Lifecycle

  (start [this]
    this)

  (stop [this]
    this)

  Bus

  (send! [this topic]
    (send! this topic nil))

  (send! [this topic payload]
    (let [handler (wrapper-manager/wrap-with
                    WrapperManager
                    topic)]
      (handler payload))
    this))


(defn new-bus []
  (map->Bus* {}))
