// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14416 = [];
var len__7107__auto___14425 = arguments.length;
var i__7108__auto___14426 = (0);
while(true){
if((i__7108__auto___14426 < len__7107__auto___14425)){
args14416.push((arguments[i__7108__auto___14426]));

var G__14428 = (i__7108__auto___14426 + (1));
i__7108__auto___14426 = G__14428;
continue;
} else {
}
break;
}

var G__14418 = args14416.length;
switch (G__14418) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14416.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14419 = (function (f,blockable,meta14420){
this.f = f;
this.blockable = blockable;
this.meta14420 = meta14420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14421,meta14420__$1){
var self__ = this;
var _14421__$1 = this;
return (new cljs.core.async.t_cljs$core$async14419(self__.f,self__.blockable,meta14420__$1));
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14421){
var self__ = this;
var _14421__$1 = this;
return self__.meta14420;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14420","meta14420",1333243082,null)], null);
});

cljs.core.async.t_cljs$core$async14419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14419";

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14419");
});

cljs.core.async.__GT_t_cljs$core$async14419 = (function cljs$core$async$__GT_t_cljs$core$async14419(f__$1,blockable__$1,meta14420){
return (new cljs.core.async.t_cljs$core$async14419(f__$1,blockable__$1,meta14420));
});

}

return (new cljs.core.async.t_cljs$core$async14419(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14435 = [];
var len__7107__auto___14442 = arguments.length;
var i__7108__auto___14443 = (0);
while(true){
if((i__7108__auto___14443 < len__7107__auto___14442)){
args14435.push((arguments[i__7108__auto___14443]));

var G__14444 = (i__7108__auto___14443 + (1));
i__7108__auto___14443 = G__14444;
continue;
} else {
}
break;
}

var G__14437 = args14435.length;
switch (G__14437) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14435.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14451 = [];
var len__7107__auto___14454 = arguments.length;
var i__7108__auto___14455 = (0);
while(true){
if((i__7108__auto___14455 < len__7107__auto___14454)){
args14451.push((arguments[i__7108__auto___14455]));

var G__14456 = (i__7108__auto___14455 + (1));
i__7108__auto___14455 = G__14456;
continue;
} else {
}
break;
}

var G__14453 = args14451.length;
switch (G__14453) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14451.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14462 = [];
var len__7107__auto___14471 = arguments.length;
var i__7108__auto___14472 = (0);
while(true){
if((i__7108__auto___14472 < len__7107__auto___14471)){
args14462.push((arguments[i__7108__auto___14472]));

var G__14473 = (i__7108__auto___14472 + (1));
i__7108__auto___14472 = G__14473;
continue;
} else {
}
break;
}

var G__14470 = args14462.length;
switch (G__14470) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14462.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14478 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14478);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14478,ret){
return (function (){
return fn1.call(null,val_14478);
});})(val_14478,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14479 = [];
var len__7107__auto___14488 = arguments.length;
var i__7108__auto___14489 = (0);
while(true){
if((i__7108__auto___14489 < len__7107__auto___14488)){
args14479.push((arguments[i__7108__auto___14489]));

var G__14490 = (i__7108__auto___14489 + (1));
i__7108__auto___14489 = G__14490;
continue;
} else {
}
break;
}

var G__14485 = args14479.length;
switch (G__14485) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14479.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14498 = n;
var x_14499 = (0);
while(true){
if((x_14499 < n__6952__auto___14498)){
(a[x_14499] = (0));

var G__14500 = (x_14499 + (1));
x_14499 = G__14500;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14502 = (i + (1));
i = G__14502;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14506 = (function (alt_flag,flag,meta14507){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14507 = meta14507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14508,meta14507__$1){
var self__ = this;
var _14508__$1 = this;
return (new cljs.core.async.t_cljs$core$async14506(self__.alt_flag,self__.flag,meta14507__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14508){
var self__ = this;
var _14508__$1 = this;
return self__.meta14507;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14507","meta14507",-708852072,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14506";

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14506");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14506 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507){
return (new cljs.core.async.t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14506(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_handler,flag,cb,meta14513){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_handler,self__.flag,self__.cb,meta14513__$1));
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14512.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});

cljs.core.async.__GT_t_cljs$core$async14512 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513));
});

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14520_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14520_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14521_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14521_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14526 = (i + (1));
i = G__14526;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14535 = arguments.length;
var i__7108__auto___14536 = (0);
while(true){
if((i__7108__auto___14536 < len__7107__auto___14535)){
args__7114__auto__.push((arguments[i__7108__auto___14536]));

var G__14537 = (i__7108__auto___14536 + (1));
i__7108__auto___14536 = G__14537;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14531){
var map__14532 = p__14531;
var map__14532__$1 = ((((!((map__14532 == null)))?((((map__14532.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14532.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14532):map__14532);
var opts = map__14532__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14528){
var G__14529 = cljs.core.first.call(null,seq14528);
var seq14528__$1 = cljs.core.next.call(null,seq14528);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14529,seq14528__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14538 = [];
var len__7107__auto___14595 = arguments.length;
var i__7108__auto___14596 = (0);
while(true){
if((i__7108__auto___14596 < len__7107__auto___14595)){
args14538.push((arguments[i__7108__auto___14596]));

var G__14597 = (i__7108__auto___14596 + (1));
i__7108__auto___14596 = G__14597;
continue;
} else {
}
break;
}

var G__14540 = args14538.length;
switch (G__14540) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14538.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14368__auto___14599 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___14599){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___14599){
return (function (state_14564){
var state_val_14565 = (state_14564[(1)]);
if((state_val_14565 === (7))){
var inst_14560 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14568_14600 = state_14564__$1;
(statearr_14568_14600[(2)] = inst_14560);

(statearr_14568_14600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (1))){
var state_14564__$1 = state_14564;
var statearr_14569_14601 = state_14564__$1;
(statearr_14569_14601[(2)] = null);

(statearr_14569_14601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (4))){
var inst_14543 = (state_14564[(7)]);
var inst_14543__$1 = (state_14564[(2)]);
var inst_14544 = (inst_14543__$1 == null);
var state_14564__$1 = (function (){var statearr_14571 = state_14564;
(statearr_14571[(7)] = inst_14543__$1);

return statearr_14571;
})();
if(cljs.core.truth_(inst_14544)){
var statearr_14572_14604 = state_14564__$1;
(statearr_14572_14604[(1)] = (5));

} else {
var statearr_14573_14605 = state_14564__$1;
(statearr_14573_14605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (13))){
var state_14564__$1 = state_14564;
var statearr_14577_14606 = state_14564__$1;
(statearr_14577_14606[(2)] = null);

(statearr_14577_14606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (6))){
var inst_14543 = (state_14564[(7)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14564__$1,(11),to,inst_14543);
} else {
if((state_val_14565 === (3))){
var inst_14562 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14564__$1,inst_14562);
} else {
if((state_val_14565 === (12))){
var state_14564__$1 = state_14564;
var statearr_14579_14607 = state_14564__$1;
(statearr_14579_14607[(2)] = null);

(statearr_14579_14607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (2))){
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14564__$1,(4),from);
} else {
if((state_val_14565 === (11))){
var inst_14553 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
if(cljs.core.truth_(inst_14553)){
var statearr_14580_14609 = state_14564__$1;
(statearr_14580_14609[(1)] = (12));

} else {
var statearr_14581_14611 = state_14564__$1;
(statearr_14581_14611[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (9))){
var state_14564__$1 = state_14564;
var statearr_14582_14613 = state_14564__$1;
(statearr_14582_14613[(2)] = null);

(statearr_14582_14613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (5))){
var state_14564__$1 = state_14564;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14583_14614 = state_14564__$1;
(statearr_14583_14614[(1)] = (8));

} else {
var statearr_14584_14615 = state_14564__$1;
(statearr_14584_14615[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (14))){
var inst_14558 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14585_14616 = state_14564__$1;
(statearr_14585_14616[(2)] = inst_14558);

(statearr_14585_14616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (10))){
var inst_14550 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14586_14617 = state_14564__$1;
(statearr_14586_14617[(2)] = inst_14550);

(statearr_14586_14617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (8))){
var inst_14547 = cljs.core.async.close_BANG_.call(null,to);
var state_14564__$1 = state_14564;
var statearr_14587_14618 = state_14564__$1;
(statearr_14587_14618[(2)] = inst_14547);

(statearr_14587_14618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___14599))
;
return ((function (switch__14236__auto__,c__14368__auto___14599){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14591 = [null,null,null,null,null,null,null,null];
(statearr_14591[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14591[(1)] = (1));

return statearr_14591;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14564){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14592){if((e14592 instanceof Object)){
var ex__14240__auto__ = e14592;
var statearr_14593_14619 = state_14564;
(statearr_14593_14619[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14620 = state_14564;
state_14564 = G__14620;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___14599))
})();
var state__14370__auto__ = (function (){var statearr_14594 = f__14369__auto__.call(null);
(statearr_14594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___14599);

return statearr_14594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___14599))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14834){
var vec__14835 = p__14834;
var v = cljs.core.nth.call(null,vec__14835,(0),null);
var p = cljs.core.nth.call(null,vec__14835,(1),null);
var job = vec__14835;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14368__auto___15025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function (state_14840){
var state_val_14841 = (state_14840[(1)]);
if((state_val_14841 === (1))){
var state_14840__$1 = state_14840;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14840__$1,(2),res,v);
} else {
if((state_val_14841 === (2))){
var inst_14837 = (state_14840[(2)]);
var inst_14838 = cljs.core.async.close_BANG_.call(null,res);
var state_14840__$1 = (function (){var statearr_14842 = state_14840;
(statearr_14842[(7)] = inst_14837);

return statearr_14842;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14840__$1,inst_14838);
} else {
return null;
}
}
});})(c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14846 = [null,null,null,null,null,null,null,null];
(statearr_14846[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14846[(1)] = (1));

return statearr_14846;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14840){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14847){if((e14847 instanceof Object)){
var ex__14240__auto__ = e14847;
var statearr_14848_15026 = state_14840;
(statearr_14848_15026[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14840);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14847;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_14840;
state_14840 = G__15027;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14840){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
})();
var state__14370__auto__ = (function (){var statearr_14849 = f__14369__auto__.call(null);
(statearr_14849[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15025);

return statearr_14849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15025,res,vec__14835,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14850){
var vec__14851 = p__14850;
var v = cljs.core.nth.call(null,vec__14851,(0),null);
var p = cljs.core.nth.call(null,vec__14851,(1),null);
var job = vec__14851;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15028 = n;
var __15029 = (0);
while(true){
if((__15029 < n__6952__auto___15028)){
var G__14852_15030 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14852_15030) {
case "compute":
var c__14368__auto___15032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14865){
var state_val_14866 = (state_14865[(1)]);
if((state_val_14866 === (1))){
var state_14865__$1 = state_14865;
var statearr_14867_15033 = state_14865__$1;
(statearr_14867_15033[(2)] = null);

(statearr_14867_15033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (2))){
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14865__$1,(4),jobs);
} else {
if((state_val_14866 === (3))){
var inst_14863 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14865__$1,inst_14863);
} else {
if((state_val_14866 === (4))){
var inst_14855 = (state_14865[(2)]);
var inst_14856 = process.call(null,inst_14855);
var state_14865__$1 = state_14865;
if(cljs.core.truth_(inst_14856)){
var statearr_14868_15034 = state_14865__$1;
(statearr_14868_15034[(1)] = (5));

} else {
var statearr_14869_15035 = state_14865__$1;
(statearr_14869_15035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (5))){
var state_14865__$1 = state_14865;
var statearr_14870_15036 = state_14865__$1;
(statearr_14870_15036[(2)] = null);

(statearr_14870_15036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (6))){
var state_14865__$1 = state_14865;
var statearr_14871_15037 = state_14865__$1;
(statearr_14871_15037[(2)] = null);

(statearr_14871_15037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (7))){
var inst_14861 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
var statearr_14872_15038 = state_14865__$1;
(statearr_14872_15038[(2)] = inst_14861);

(statearr_14872_15038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14879 = [null,null,null,null,null,null,null];
(statearr_14879[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14879[(1)] = (1));

return statearr_14879;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14865){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14880){if((e14880 instanceof Object)){
var ex__14240__auto__ = e14880;
var statearr_14881_15039 = state_14865;
(statearr_14881_15039[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14865);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14880;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15040 = state_14865;
state_14865 = G__15040;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14865){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14882 = f__14369__auto__.call(null);
(statearr_14882[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15032);

return statearr_14882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15032,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
case "async":
var c__14368__auto___15041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14896){
var state_val_14897 = (state_14896[(1)]);
if((state_val_14897 === (1))){
var state_14896__$1 = state_14896;
var statearr_14898_15042 = state_14896__$1;
(statearr_14898_15042[(2)] = null);

(statearr_14898_15042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14897 === (2))){
var state_14896__$1 = state_14896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14896__$1,(4),jobs);
} else {
if((state_val_14897 === (3))){
var inst_14894 = (state_14896[(2)]);
var state_14896__$1 = state_14896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14896__$1,inst_14894);
} else {
if((state_val_14897 === (4))){
var inst_14886 = (state_14896[(2)]);
var inst_14887 = async.call(null,inst_14886);
var state_14896__$1 = state_14896;
if(cljs.core.truth_(inst_14887)){
var statearr_14899_15045 = state_14896__$1;
(statearr_14899_15045[(1)] = (5));

} else {
var statearr_14900_15046 = state_14896__$1;
(statearr_14900_15046[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14897 === (5))){
var state_14896__$1 = state_14896;
var statearr_14901_15047 = state_14896__$1;
(statearr_14901_15047[(2)] = null);

(statearr_14901_15047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14897 === (6))){
var state_14896__$1 = state_14896;
var statearr_14902_15048 = state_14896__$1;
(statearr_14902_15048[(2)] = null);

(statearr_14902_15048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14897 === (7))){
var inst_14892 = (state_14896[(2)]);
var state_14896__$1 = state_14896;
var statearr_14903_15049 = state_14896__$1;
(statearr_14903_15049[(2)] = inst_14892);

(statearr_14903_15049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14910 = [null,null,null,null,null,null,null];
(statearr_14910[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14910[(1)] = (1));

return statearr_14910;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14896){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14911){if((e14911 instanceof Object)){
var ex__14240__auto__ = e14911;
var statearr_14912_15050 = state_14896;
(statearr_14912_15050[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14896);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14911;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15051 = state_14896;
state_14896 = G__15051;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14896){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14913 = f__14369__auto__.call(null);
(statearr_14913[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15041);

return statearr_14913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15041,G__14852_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15052 = (__15029 + (1));
__15029 = G__15052;
continue;
} else {
}
break;
}

var c__14368__auto___15053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15053,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15053,jobs,results,process,async){
return (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14938_15055 = state_14936__$1;
(statearr_14938_15055[(2)] = null);

(statearr_14938_15055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14936__$1,(4),from);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (4))){
var inst_14916 = (state_14936[(7)]);
var inst_14916__$1 = (state_14936[(2)]);
var inst_14917 = (inst_14916__$1 == null);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(7)] = inst_14916__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14917)){
var statearr_14940_15057 = state_14936__$1;
(statearr_14940_15057[(1)] = (5));

} else {
var statearr_14941_15058 = state_14936__$1;
(statearr_14941_15058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var inst_14919 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14936__$1 = state_14936;
var statearr_14942_15059 = state_14936__$1;
(statearr_14942_15059[(2)] = inst_14919);

(statearr_14942_15059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14921 = (state_14936[(8)]);
var inst_14916 = (state_14936[(7)]);
var inst_14921__$1 = cljs.core.async.chan.call(null,(1));
var inst_14922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14923 = [inst_14916,inst_14921__$1];
var inst_14924 = (new cljs.core.PersistentVector(null,2,(5),inst_14922,inst_14923,null));
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14921__$1);

return statearr_14943;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(8),jobs,inst_14924);
} else {
if((state_val_14937 === (7))){
var inst_14932 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14944_15060 = state_14936__$1;
(statearr_14944_15060[(2)] = inst_14932);

(statearr_14944_15060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14921 = (state_14936[(8)]);
var inst_14926 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14945 = state_14936;
(statearr_14945[(9)] = inst_14926);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(9),results,inst_14921);
} else {
if((state_val_14937 === (9))){
var inst_14928 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14946 = state_14936;
(statearr_14946[(10)] = inst_14928);

return statearr_14946;
})();
var statearr_14947_15061 = state_14936__$1;
(statearr_14947_15061[(2)] = null);

(statearr_14947_15061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15053,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto___15053,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14951[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14951[(1)] = (1));

return statearr_14951;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14936){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14952){if((e14952 instanceof Object)){
var ex__14240__auto__ = e14952;
var statearr_14953_15071 = state_14936;
(statearr_14953_15071[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15073 = state_14936;
state_14936 = G__15073;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15053,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14954 = f__14369__auto__.call(null);
(statearr_14954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15053);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15053,jobs,results,process,async))
);


var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15074 = state_14992__$1;
(statearr_14994_15074[(2)] = inst_14988);

(statearr_14994_15074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15075 = state_14992__$1;
(statearr_14995_15075[(2)] = null);

(statearr_14995_15075[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15076 = state_14992__$1;
(statearr_14996_15076[(2)] = null);

(statearr_14996_15076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14957 = (state_14992[(7)]);
var inst_14957__$1 = (state_14992[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14957__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14958)){
var statearr_14998_15077 = state_14992__$1;
(statearr_14998_15077[(1)] = (5));

} else {
var statearr_14999_15078 = state_14992__$1;
(statearr_14999_15078[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14970 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14970);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15079 = state_14992__$1;
(statearr_15000_15079[(2)] = inst_14983);

(statearr_15000_15079[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15080 = state_14992__$1;
(statearr_15002_15080[(2)] = null);

(statearr_15002_15080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14957 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14957);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15081 = state_14992__$1;
(statearr_15003_15081[(1)] = (19));

} else {
var statearr_15004_15082 = state_14992__$1;
(statearr_15004_15082[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14967 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14967);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15083 = state_14992__$1;
(statearr_15005_15083[(2)] = null);

(statearr_15005_15083[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14967 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14967);

return statearr_15006;
})();
var statearr_15007_15084 = state_14992__$1;
(statearr_15007_15084[(2)] = null);

(statearr_15007_15084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15085 = state_14992__$1;
(statearr_15008_15085[(2)] = null);

(statearr_15008_15085[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15086 = state_14992__$1;
(statearr_15009_15086[(1)] = (8));

} else {
var statearr_15010_15087 = state_14992__$1;
(statearr_15010_15087[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14970 = (state_14992[(8)]);
var inst_14970__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14970__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14970__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15090 = state_14992__$1;
(statearr_15012_15090[(1)] = (15));

} else {
var statearr_15013_15091 = state_14992__$1;
(statearr_15013_15091[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15092 = state_14992__$1;
(statearr_15014_15092[(2)] = inst_14972);

(statearr_15014_15092[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14964 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15093 = state_14992__$1;
(statearr_15015_15093[(2)] = inst_14964);

(statearr_15015_15093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15096 = state_14992__$1;
(statearr_15016_15096[(2)] = inst_14975);

(statearr_15016_15096[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14961 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15098 = state_14992__$1;
(statearr_15017_15098[(2)] = inst_14961);

(statearr_15017_15098[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15100 = state_14992;
(statearr_15023_15100[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15101 = state_14992;
state_14992 = G__15101;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_15024 = f__14369__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,jobs,results,process,async))
);

return c__14368__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15102 = [];
var len__7107__auto___15108 = arguments.length;
var i__7108__auto___15109 = (0);
while(true){
if((i__7108__auto___15109 < len__7107__auto___15108)){
args15102.push((arguments[i__7108__auto___15109]));

var G__15110 = (i__7108__auto___15109 + (1));
i__7108__auto___15109 = G__15110;
continue;
} else {
}
break;
}

var G__15107 = args15102.length;
switch (G__15107) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15102.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15113 = [];
var len__7107__auto___15116 = arguments.length;
var i__7108__auto___15117 = (0);
while(true){
if((i__7108__auto___15117 < len__7107__auto___15116)){
args15113.push((arguments[i__7108__auto___15117]));

var G__15118 = (i__7108__auto___15117 + (1));
i__7108__auto___15117 = G__15118;
continue;
} else {
}
break;
}

var G__15115 = args15113.length;
switch (G__15115) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15113.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15120 = [];
var len__7107__auto___15173 = arguments.length;
var i__7108__auto___15174 = (0);
while(true){
if((i__7108__auto___15174 < len__7107__auto___15173)){
args15120.push((arguments[i__7108__auto___15174]));

var G__15175 = (i__7108__auto___15174 + (1));
i__7108__auto___15174 = G__15175;
continue;
} else {
}
break;
}

var G__15122 = args15120.length;
switch (G__15122) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15120.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14368__auto___15177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15177,tc,fc){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15177,tc,fc){
return (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15144 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15150_15182 = state_15148__$1;
(statearr_15150_15182[(2)] = inst_15144);

(statearr_15150_15182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (1))){
var state_15148__$1 = state_15148;
var statearr_15151_15187 = state_15148__$1;
(statearr_15151_15187[(2)] = null);

(statearr_15151_15187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (4))){
var inst_15125 = (state_15148[(7)]);
var inst_15125__$1 = (state_15148[(2)]);
var inst_15126 = (inst_15125__$1 == null);
var state_15148__$1 = (function (){var statearr_15152 = state_15148;
(statearr_15152[(7)] = inst_15125__$1);

return statearr_15152;
})();
if(cljs.core.truth_(inst_15126)){
var statearr_15153_15192 = state_15148__$1;
(statearr_15153_15192[(1)] = (5));

} else {
var statearr_15154_15194 = state_15148__$1;
(statearr_15154_15194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (13))){
var state_15148__$1 = state_15148;
var statearr_15155_15199 = state_15148__$1;
(statearr_15155_15199[(2)] = null);

(statearr_15155_15199[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (6))){
var inst_15125 = (state_15148[(7)]);
var inst_15131 = p.call(null,inst_15125);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15131)){
var statearr_15156_15207 = state_15148__$1;
(statearr_15156_15207[(1)] = (9));

} else {
var statearr_15157_15208 = state_15148__$1;
(statearr_15157_15208[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (12))){
var state_15148__$1 = state_15148;
var statearr_15158_15214 = state_15148__$1;
(statearr_15158_15214[(2)] = null);

(statearr_15158_15214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (2))){
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15148__$1,(4),ch);
} else {
if((state_val_15149 === (11))){
var inst_15125 = (state_15148[(7)]);
var inst_15135 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15148__$1,(8),inst_15135,inst_15125);
} else {
if((state_val_15149 === (9))){
var state_15148__$1 = state_15148;
var statearr_15159_15215 = state_15148__$1;
(statearr_15159_15215[(2)] = tc);

(statearr_15159_15215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (5))){
var inst_15128 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15129 = cljs.core.async.close_BANG_.call(null,fc);
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(8)] = inst_15128);

return statearr_15160;
})();
var statearr_15161_15216 = state_15148__$1;
(statearr_15161_15216[(2)] = inst_15129);

(statearr_15161_15216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (14))){
var inst_15142 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15162_15217 = state_15148__$1;
(statearr_15162_15217[(2)] = inst_15142);

(statearr_15162_15217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (10))){
var state_15148__$1 = state_15148;
var statearr_15163_15218 = state_15148__$1;
(statearr_15163_15218[(2)] = fc);

(statearr_15163_15218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (8))){
var inst_15137 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15137)){
var statearr_15164_15219 = state_15148__$1;
(statearr_15164_15219[(1)] = (12));

} else {
var statearr_15165_15220 = state_15148__$1;
(statearr_15165_15220[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15177,tc,fc))
;
return ((function (switch__14236__auto__,c__14368__auto___15177,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15169 = [null,null,null,null,null,null,null,null,null];
(statearr_15169[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15169[(1)] = (1));

return statearr_15169;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15148){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15170){if((e15170 instanceof Object)){
var ex__14240__auto__ = e15170;
var statearr_15171_15221 = state_15148;
(statearr_15171_15221[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15148);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15224 = state_15148;
state_15148 = G__15224;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15177,tc,fc))
})();
var state__14370__auto__ = (function (){var statearr_15172 = f__14369__auto__.call(null);
(statearr_15172[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15177);

return statearr_15172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15177,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15294){
var state_val_15295 = (state_15294[(1)]);
if((state_val_15295 === (7))){
var inst_15290 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
var statearr_15296_15320 = state_15294__$1;
(statearr_15296_15320[(2)] = inst_15290);

(statearr_15296_15320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (1))){
var inst_15272 = init;
var state_15294__$1 = (function (){var statearr_15297 = state_15294;
(statearr_15297[(7)] = inst_15272);

return statearr_15297;
})();
var statearr_15298_15322 = state_15294__$1;
(statearr_15298_15322[(2)] = null);

(statearr_15298_15322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (4))){
var inst_15276 = (state_15294[(8)]);
var inst_15276__$1 = (state_15294[(2)]);
var inst_15277 = (inst_15276__$1 == null);
var state_15294__$1 = (function (){var statearr_15299 = state_15294;
(statearr_15299[(8)] = inst_15276__$1);

return statearr_15299;
})();
if(cljs.core.truth_(inst_15277)){
var statearr_15300_15323 = state_15294__$1;
(statearr_15300_15323[(1)] = (5));

} else {
var statearr_15301_15324 = state_15294__$1;
(statearr_15301_15324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (6))){
var inst_15272 = (state_15294[(7)]);
var inst_15276 = (state_15294[(8)]);
var inst_15280 = (state_15294[(9)]);
var inst_15280__$1 = f.call(null,inst_15272,inst_15276);
var inst_15281 = cljs.core.reduced_QMARK_.call(null,inst_15280__$1);
var state_15294__$1 = (function (){var statearr_15302 = state_15294;
(statearr_15302[(9)] = inst_15280__$1);

return statearr_15302;
})();
if(inst_15281){
var statearr_15303_15325 = state_15294__$1;
(statearr_15303_15325[(1)] = (8));

} else {
var statearr_15304_15326 = state_15294__$1;
(statearr_15304_15326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (3))){
var inst_15292 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15294__$1,inst_15292);
} else {
if((state_val_15295 === (2))){
var state_15294__$1 = state_15294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15294__$1,(4),ch);
} else {
if((state_val_15295 === (9))){
var inst_15280 = (state_15294[(9)]);
var inst_15272 = inst_15280;
var state_15294__$1 = (function (){var statearr_15305 = state_15294;
(statearr_15305[(7)] = inst_15272);

return statearr_15305;
})();
var statearr_15306_15327 = state_15294__$1;
(statearr_15306_15327[(2)] = null);

(statearr_15306_15327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (5))){
var inst_15272 = (state_15294[(7)]);
var state_15294__$1 = state_15294;
var statearr_15310_15328 = state_15294__$1;
(statearr_15310_15328[(2)] = inst_15272);

(statearr_15310_15328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (10))){
var inst_15287 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
var statearr_15311_15329 = state_15294__$1;
(statearr_15311_15329[(2)] = inst_15287);

(statearr_15311_15329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (8))){
var inst_15280 = (state_15294[(9)]);
var inst_15283 = cljs.core.deref.call(null,inst_15280);
var state_15294__$1 = state_15294;
var statearr_15312_15330 = state_15294__$1;
(statearr_15312_15330[(2)] = inst_15283);

(statearr_15312_15330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15316 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15316[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15316[(1)] = (1));

return statearr_15316;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15294){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15317){if((e15317 instanceof Object)){
var ex__14240__auto__ = e15317;
var statearr_15318_15331 = state_15294;
(statearr_15318_15331[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15317;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15332 = state_15294;
state_15294 = G__15332;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15294){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15319 = f__14369__auto__.call(null);
(statearr_15319[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15333 = [];
var len__7107__auto___15386 = arguments.length;
var i__7108__auto___15387 = (0);
while(true){
if((i__7108__auto___15387 < len__7107__auto___15386)){
args15333.push((arguments[i__7108__auto___15387]));

var G__15389 = (i__7108__auto___15387 + (1));
i__7108__auto___15387 = G__15389;
continue;
} else {
}
break;
}

var G__15335 = args15333.length;
switch (G__15335) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15333.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15360){
var state_val_15361 = (state_15360[(1)]);
if((state_val_15361 === (7))){
var inst_15342 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15362_15393 = state_15360__$1;
(statearr_15362_15393[(2)] = inst_15342);

(statearr_15362_15393[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (1))){
var inst_15336 = cljs.core.seq.call(null,coll);
var inst_15337 = inst_15336;
var state_15360__$1 = (function (){var statearr_15363 = state_15360;
(statearr_15363[(7)] = inst_15337);

return statearr_15363;
})();
var statearr_15364_15397 = state_15360__$1;
(statearr_15364_15397[(2)] = null);

(statearr_15364_15397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (4))){
var inst_15337 = (state_15360[(7)]);
var inst_15340 = cljs.core.first.call(null,inst_15337);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15360__$1,(7),ch,inst_15340);
} else {
if((state_val_15361 === (13))){
var inst_15354 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15365_15398 = state_15360__$1;
(statearr_15365_15398[(2)] = inst_15354);

(statearr_15365_15398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (6))){
var inst_15345 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15345)){
var statearr_15366_15399 = state_15360__$1;
(statearr_15366_15399[(1)] = (8));

} else {
var statearr_15367_15400 = state_15360__$1;
(statearr_15367_15400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (3))){
var inst_15358 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15360__$1,inst_15358);
} else {
if((state_val_15361 === (12))){
var state_15360__$1 = state_15360;
var statearr_15368_15401 = state_15360__$1;
(statearr_15368_15401[(2)] = null);

(statearr_15368_15401[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (2))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15337)){
var statearr_15369_15402 = state_15360__$1;
(statearr_15369_15402[(1)] = (4));

} else {
var statearr_15370_15403 = state_15360__$1;
(statearr_15370_15403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (11))){
var inst_15351 = cljs.core.async.close_BANG_.call(null,ch);
var state_15360__$1 = state_15360;
var statearr_15371_15404 = state_15360__$1;
(statearr_15371_15404[(2)] = inst_15351);

(statearr_15371_15404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (9))){
var state_15360__$1 = state_15360;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15372_15405 = state_15360__$1;
(statearr_15372_15405[(1)] = (11));

} else {
var statearr_15373_15406 = state_15360__$1;
(statearr_15373_15406[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (5))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
var statearr_15374_15407 = state_15360__$1;
(statearr_15374_15407[(2)] = inst_15337);

(statearr_15374_15407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (10))){
var inst_15356 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15375_15408 = state_15360__$1;
(statearr_15375_15408[(2)] = inst_15356);

(statearr_15375_15408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (8))){
var inst_15337 = (state_15360[(7)]);
var inst_15347 = cljs.core.next.call(null,inst_15337);
var inst_15337__$1 = inst_15347;
var state_15360__$1 = (function (){var statearr_15376 = state_15360;
(statearr_15376[(7)] = inst_15337__$1);

return statearr_15376;
})();
var statearr_15377_15409 = state_15360__$1;
(statearr_15377_15409[(2)] = null);

(statearr_15377_15409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15381 = [null,null,null,null,null,null,null,null];
(statearr_15381[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15381[(1)] = (1));

return statearr_15381;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15360){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15382){if((e15382 instanceof Object)){
var ex__14240__auto__ = e15382;
var statearr_15383_15415 = state_15360;
(statearr_15383_15415[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15417 = state_15360;
state_15360 = G__15417;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15384 = f__14369__auto__.call(null);
(statearr_15384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15649 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15649 = (function (mult,ch,cs,meta15650){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15650 = meta15650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15651,meta15650__$1){
var self__ = this;
var _15651__$1 = this;
return (new cljs.core.async.t_cljs$core$async15649(self__.mult,self__.ch,self__.cs,meta15650__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15651){
var self__ = this;
var _15651__$1 = this;
return self__.meta15650;
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15650","meta15650",521006785,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15649.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15649";

cljs.core.async.t_cljs$core$async15649.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15649");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15649 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15649(mult__$1,ch__$1,cs__$1,meta15650){
return (new cljs.core.async.t_cljs$core$async15649(mult__$1,ch__$1,cs__$1,meta15650));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15649(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14368__auto___15891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15891,cs,m,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15891,cs,m,dchan,dctr,done){
return (function (state_15792){
var state_val_15793 = (state_15792[(1)]);
if((state_val_15793 === (7))){
var inst_15788 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15794_15892 = state_15792__$1;
(statearr_15794_15892[(2)] = inst_15788);

(statearr_15794_15892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (20))){
var inst_15690 = (state_15792[(7)]);
var inst_15700 = cljs.core.first.call(null,inst_15690);
var inst_15701 = cljs.core.nth.call(null,inst_15700,(0),null);
var inst_15702 = cljs.core.nth.call(null,inst_15700,(1),null);
var state_15792__$1 = (function (){var statearr_15795 = state_15792;
(statearr_15795[(8)] = inst_15701);

return statearr_15795;
})();
if(cljs.core.truth_(inst_15702)){
var statearr_15796_15893 = state_15792__$1;
(statearr_15796_15893[(1)] = (22));

} else {
var statearr_15797_15894 = state_15792__$1;
(statearr_15797_15894[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (27))){
var inst_15661 = (state_15792[(9)]);
var inst_15732 = (state_15792[(10)]);
var inst_15730 = (state_15792[(11)]);
var inst_15737 = (state_15792[(12)]);
var inst_15737__$1 = cljs.core._nth.call(null,inst_15730,inst_15732);
var inst_15738 = cljs.core.async.put_BANG_.call(null,inst_15737__$1,inst_15661,done);
var state_15792__$1 = (function (){var statearr_15798 = state_15792;
(statearr_15798[(12)] = inst_15737__$1);

return statearr_15798;
})();
if(cljs.core.truth_(inst_15738)){
var statearr_15799_15895 = state_15792__$1;
(statearr_15799_15895[(1)] = (30));

} else {
var statearr_15800_15896 = state_15792__$1;
(statearr_15800_15896[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (1))){
var state_15792__$1 = state_15792;
var statearr_15801_15897 = state_15792__$1;
(statearr_15801_15897[(2)] = null);

(statearr_15801_15897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (24))){
var inst_15690 = (state_15792[(7)]);
var inst_15707 = (state_15792[(2)]);
var inst_15708 = cljs.core.next.call(null,inst_15690);
var inst_15670 = inst_15708;
var inst_15671 = null;
var inst_15672 = (0);
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15803 = state_15792;
(statearr_15803[(13)] = inst_15671);

(statearr_15803[(14)] = inst_15707);

(statearr_15803[(15)] = inst_15673);

(statearr_15803[(16)] = inst_15670);

(statearr_15803[(17)] = inst_15672);

return statearr_15803;
})();
var statearr_15804_15898 = state_15792__$1;
(statearr_15804_15898[(2)] = null);

(statearr_15804_15898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (39))){
var state_15792__$1 = state_15792;
var statearr_15808_15899 = state_15792__$1;
(statearr_15808_15899[(2)] = null);

(statearr_15808_15899[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (4))){
var inst_15661 = (state_15792[(9)]);
var inst_15661__$1 = (state_15792[(2)]);
var inst_15662 = (inst_15661__$1 == null);
var state_15792__$1 = (function (){var statearr_15809 = state_15792;
(statearr_15809[(9)] = inst_15661__$1);

return statearr_15809;
})();
if(cljs.core.truth_(inst_15662)){
var statearr_15810_15900 = state_15792__$1;
(statearr_15810_15900[(1)] = (5));

} else {
var statearr_15811_15901 = state_15792__$1;
(statearr_15811_15901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (15))){
var inst_15671 = (state_15792[(13)]);
var inst_15673 = (state_15792[(15)]);
var inst_15670 = (state_15792[(16)]);
var inst_15672 = (state_15792[(17)]);
var inst_15686 = (state_15792[(2)]);
var inst_15687 = (inst_15673 + (1));
var tmp15805 = inst_15671;
var tmp15806 = inst_15670;
var tmp15807 = inst_15672;
var inst_15670__$1 = tmp15806;
var inst_15671__$1 = tmp15805;
var inst_15672__$1 = tmp15807;
var inst_15673__$1 = inst_15687;
var state_15792__$1 = (function (){var statearr_15812 = state_15792;
(statearr_15812[(13)] = inst_15671__$1);

(statearr_15812[(15)] = inst_15673__$1);

(statearr_15812[(16)] = inst_15670__$1);

(statearr_15812[(18)] = inst_15686);

(statearr_15812[(17)] = inst_15672__$1);

return statearr_15812;
})();
var statearr_15813_15902 = state_15792__$1;
(statearr_15813_15902[(2)] = null);

(statearr_15813_15902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (21))){
var inst_15711 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15817_15903 = state_15792__$1;
(statearr_15817_15903[(2)] = inst_15711);

(statearr_15817_15903[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (31))){
var inst_15737 = (state_15792[(12)]);
var inst_15741 = done.call(null,null);
var inst_15742 = cljs.core.async.untap_STAR_.call(null,m,inst_15737);
var state_15792__$1 = (function (){var statearr_15818 = state_15792;
(statearr_15818[(19)] = inst_15741);

return statearr_15818;
})();
var statearr_15819_15908 = state_15792__$1;
(statearr_15819_15908[(2)] = inst_15742);

(statearr_15819_15908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (32))){
var inst_15729 = (state_15792[(20)]);
var inst_15732 = (state_15792[(10)]);
var inst_15730 = (state_15792[(11)]);
var inst_15731 = (state_15792[(21)]);
var inst_15744 = (state_15792[(2)]);
var inst_15745 = (inst_15732 + (1));
var tmp15814 = inst_15729;
var tmp15815 = inst_15730;
var tmp15816 = inst_15731;
var inst_15729__$1 = tmp15814;
var inst_15730__$1 = tmp15815;
var inst_15731__$1 = tmp15816;
var inst_15732__$1 = inst_15745;
var state_15792__$1 = (function (){var statearr_15820 = state_15792;
(statearr_15820[(20)] = inst_15729__$1);

(statearr_15820[(10)] = inst_15732__$1);

(statearr_15820[(11)] = inst_15730__$1);

(statearr_15820[(21)] = inst_15731__$1);

(statearr_15820[(22)] = inst_15744);

return statearr_15820;
})();
var statearr_15821_15911 = state_15792__$1;
(statearr_15821_15911[(2)] = null);

(statearr_15821_15911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (40))){
var inst_15760 = (state_15792[(23)]);
var inst_15764 = done.call(null,null);
var inst_15765 = cljs.core.async.untap_STAR_.call(null,m,inst_15760);
var state_15792__$1 = (function (){var statearr_15822 = state_15792;
(statearr_15822[(24)] = inst_15764);

return statearr_15822;
})();
var statearr_15823_15912 = state_15792__$1;
(statearr_15823_15912[(2)] = inst_15765);

(statearr_15823_15912[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (33))){
var inst_15751 = (state_15792[(25)]);
var inst_15753 = cljs.core.chunked_seq_QMARK_.call(null,inst_15751);
var state_15792__$1 = state_15792;
if(inst_15753){
var statearr_15824_15916 = state_15792__$1;
(statearr_15824_15916[(1)] = (36));

} else {
var statearr_15825_15917 = state_15792__$1;
(statearr_15825_15917[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (13))){
var inst_15680 = (state_15792[(26)]);
var inst_15683 = cljs.core.async.close_BANG_.call(null,inst_15680);
var state_15792__$1 = state_15792;
var statearr_15826_15918 = state_15792__$1;
(statearr_15826_15918[(2)] = inst_15683);

(statearr_15826_15918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (22))){
var inst_15701 = (state_15792[(8)]);
var inst_15704 = cljs.core.async.close_BANG_.call(null,inst_15701);
var state_15792__$1 = state_15792;
var statearr_15827_15919 = state_15792__$1;
(statearr_15827_15919[(2)] = inst_15704);

(statearr_15827_15919[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (36))){
var inst_15751 = (state_15792[(25)]);
var inst_15755 = cljs.core.chunk_first.call(null,inst_15751);
var inst_15756 = cljs.core.chunk_rest.call(null,inst_15751);
var inst_15757 = cljs.core.count.call(null,inst_15755);
var inst_15729 = inst_15756;
var inst_15730 = inst_15755;
var inst_15731 = inst_15757;
var inst_15732 = (0);
var state_15792__$1 = (function (){var statearr_15828 = state_15792;
(statearr_15828[(20)] = inst_15729);

(statearr_15828[(10)] = inst_15732);

(statearr_15828[(11)] = inst_15730);

(statearr_15828[(21)] = inst_15731);

return statearr_15828;
})();
var statearr_15829_15921 = state_15792__$1;
(statearr_15829_15921[(2)] = null);

(statearr_15829_15921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (41))){
var inst_15751 = (state_15792[(25)]);
var inst_15767 = (state_15792[(2)]);
var inst_15768 = cljs.core.next.call(null,inst_15751);
var inst_15729 = inst_15768;
var inst_15730 = null;
var inst_15731 = (0);
var inst_15732 = (0);
var state_15792__$1 = (function (){var statearr_15830 = state_15792;
(statearr_15830[(20)] = inst_15729);

(statearr_15830[(10)] = inst_15732);

(statearr_15830[(11)] = inst_15730);

(statearr_15830[(21)] = inst_15731);

(statearr_15830[(27)] = inst_15767);

return statearr_15830;
})();
var statearr_15831_15922 = state_15792__$1;
(statearr_15831_15922[(2)] = null);

(statearr_15831_15922[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (43))){
var state_15792__$1 = state_15792;
var statearr_15832_15923 = state_15792__$1;
(statearr_15832_15923[(2)] = null);

(statearr_15832_15923[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (29))){
var inst_15776 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15833_15924 = state_15792__$1;
(statearr_15833_15924[(2)] = inst_15776);

(statearr_15833_15924[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (44))){
var inst_15785 = (state_15792[(2)]);
var state_15792__$1 = (function (){var statearr_15834 = state_15792;
(statearr_15834[(28)] = inst_15785);

return statearr_15834;
})();
var statearr_15835_15925 = state_15792__$1;
(statearr_15835_15925[(2)] = null);

(statearr_15835_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (6))){
var inst_15721 = (state_15792[(29)]);
var inst_15720 = cljs.core.deref.call(null,cs);
var inst_15721__$1 = cljs.core.keys.call(null,inst_15720);
var inst_15722 = cljs.core.count.call(null,inst_15721__$1);
var inst_15723 = cljs.core.reset_BANG_.call(null,dctr,inst_15722);
var inst_15728 = cljs.core.seq.call(null,inst_15721__$1);
var inst_15729 = inst_15728;
var inst_15730 = null;
var inst_15731 = (0);
var inst_15732 = (0);
var state_15792__$1 = (function (){var statearr_15836 = state_15792;
(statearr_15836[(29)] = inst_15721__$1);

(statearr_15836[(30)] = inst_15723);

(statearr_15836[(20)] = inst_15729);

(statearr_15836[(10)] = inst_15732);

(statearr_15836[(11)] = inst_15730);

(statearr_15836[(21)] = inst_15731);

return statearr_15836;
})();
var statearr_15837_15926 = state_15792__$1;
(statearr_15837_15926[(2)] = null);

(statearr_15837_15926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (28))){
var inst_15729 = (state_15792[(20)]);
var inst_15751 = (state_15792[(25)]);
var inst_15751__$1 = cljs.core.seq.call(null,inst_15729);
var state_15792__$1 = (function (){var statearr_15838 = state_15792;
(statearr_15838[(25)] = inst_15751__$1);

return statearr_15838;
})();
if(inst_15751__$1){
var statearr_15839_15927 = state_15792__$1;
(statearr_15839_15927[(1)] = (33));

} else {
var statearr_15840_15928 = state_15792__$1;
(statearr_15840_15928[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (25))){
var inst_15732 = (state_15792[(10)]);
var inst_15731 = (state_15792[(21)]);
var inst_15734 = (inst_15732 < inst_15731);
var inst_15735 = inst_15734;
var state_15792__$1 = state_15792;
if(cljs.core.truth_(inst_15735)){
var statearr_15841_15929 = state_15792__$1;
(statearr_15841_15929[(1)] = (27));

} else {
var statearr_15842_15930 = state_15792__$1;
(statearr_15842_15930[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (34))){
var state_15792__$1 = state_15792;
var statearr_15843_15931 = state_15792__$1;
(statearr_15843_15931[(2)] = null);

(statearr_15843_15931[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (17))){
var state_15792__$1 = state_15792;
var statearr_15844_15932 = state_15792__$1;
(statearr_15844_15932[(2)] = null);

(statearr_15844_15932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (3))){
var inst_15790 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15792__$1,inst_15790);
} else {
if((state_val_15793 === (12))){
var inst_15716 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15845_15933 = state_15792__$1;
(statearr_15845_15933[(2)] = inst_15716);

(statearr_15845_15933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (2))){
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15792__$1,(4),ch);
} else {
if((state_val_15793 === (23))){
var state_15792__$1 = state_15792;
var statearr_15846_15934 = state_15792__$1;
(statearr_15846_15934[(2)] = null);

(statearr_15846_15934[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (35))){
var inst_15774 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15847_15935 = state_15792__$1;
(statearr_15847_15935[(2)] = inst_15774);

(statearr_15847_15935[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (19))){
var inst_15690 = (state_15792[(7)]);
var inst_15694 = cljs.core.chunk_first.call(null,inst_15690);
var inst_15695 = cljs.core.chunk_rest.call(null,inst_15690);
var inst_15696 = cljs.core.count.call(null,inst_15694);
var inst_15670 = inst_15695;
var inst_15671 = inst_15694;
var inst_15672 = inst_15696;
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15848 = state_15792;
(statearr_15848[(13)] = inst_15671);

(statearr_15848[(15)] = inst_15673);

(statearr_15848[(16)] = inst_15670);

(statearr_15848[(17)] = inst_15672);

return statearr_15848;
})();
var statearr_15849_15937 = state_15792__$1;
(statearr_15849_15937[(2)] = null);

(statearr_15849_15937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (11))){
var inst_15670 = (state_15792[(16)]);
var inst_15690 = (state_15792[(7)]);
var inst_15690__$1 = cljs.core.seq.call(null,inst_15670);
var state_15792__$1 = (function (){var statearr_15850 = state_15792;
(statearr_15850[(7)] = inst_15690__$1);

return statearr_15850;
})();
if(inst_15690__$1){
var statearr_15851_15939 = state_15792__$1;
(statearr_15851_15939[(1)] = (16));

} else {
var statearr_15852_15941 = state_15792__$1;
(statearr_15852_15941[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (9))){
var inst_15718 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15853_15942 = state_15792__$1;
(statearr_15853_15942[(2)] = inst_15718);

(statearr_15853_15942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (5))){
var inst_15668 = cljs.core.deref.call(null,cs);
var inst_15669 = cljs.core.seq.call(null,inst_15668);
var inst_15670 = inst_15669;
var inst_15671 = null;
var inst_15672 = (0);
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15854 = state_15792;
(statearr_15854[(13)] = inst_15671);

(statearr_15854[(15)] = inst_15673);

(statearr_15854[(16)] = inst_15670);

(statearr_15854[(17)] = inst_15672);

return statearr_15854;
})();
var statearr_15855_15947 = state_15792__$1;
(statearr_15855_15947[(2)] = null);

(statearr_15855_15947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (14))){
var state_15792__$1 = state_15792;
var statearr_15856_15952 = state_15792__$1;
(statearr_15856_15952[(2)] = null);

(statearr_15856_15952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (45))){
var inst_15782 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15857_15954 = state_15792__$1;
(statearr_15857_15954[(2)] = inst_15782);

(statearr_15857_15954[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (26))){
var inst_15721 = (state_15792[(29)]);
var inst_15778 = (state_15792[(2)]);
var inst_15779 = cljs.core.seq.call(null,inst_15721);
var state_15792__$1 = (function (){var statearr_15858 = state_15792;
(statearr_15858[(31)] = inst_15778);

return statearr_15858;
})();
if(inst_15779){
var statearr_15859_15956 = state_15792__$1;
(statearr_15859_15956[(1)] = (42));

} else {
var statearr_15860_15957 = state_15792__$1;
(statearr_15860_15957[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (16))){
var inst_15690 = (state_15792[(7)]);
var inst_15692 = cljs.core.chunked_seq_QMARK_.call(null,inst_15690);
var state_15792__$1 = state_15792;
if(inst_15692){
var statearr_15861_15958 = state_15792__$1;
(statearr_15861_15958[(1)] = (19));

} else {
var statearr_15862_15959 = state_15792__$1;
(statearr_15862_15959[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (38))){
var inst_15771 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15863_15960 = state_15792__$1;
(statearr_15863_15960[(2)] = inst_15771);

(statearr_15863_15960[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (30))){
var state_15792__$1 = state_15792;
var statearr_15864_15964 = state_15792__$1;
(statearr_15864_15964[(2)] = null);

(statearr_15864_15964[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (10))){
var inst_15671 = (state_15792[(13)]);
var inst_15673 = (state_15792[(15)]);
var inst_15679 = cljs.core._nth.call(null,inst_15671,inst_15673);
var inst_15680 = cljs.core.nth.call(null,inst_15679,(0),null);
var inst_15681 = cljs.core.nth.call(null,inst_15679,(1),null);
var state_15792__$1 = (function (){var statearr_15865 = state_15792;
(statearr_15865[(26)] = inst_15680);

return statearr_15865;
})();
if(cljs.core.truth_(inst_15681)){
var statearr_15866_15965 = state_15792__$1;
(statearr_15866_15965[(1)] = (13));

} else {
var statearr_15867_15966 = state_15792__$1;
(statearr_15867_15966[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (18))){
var inst_15714 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15868_15967 = state_15792__$1;
(statearr_15868_15967[(2)] = inst_15714);

(statearr_15868_15967[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (42))){
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15792__$1,(45),dchan);
} else {
if((state_val_15793 === (37))){
var inst_15661 = (state_15792[(9)]);
var inst_15751 = (state_15792[(25)]);
var inst_15760 = (state_15792[(23)]);
var inst_15760__$1 = cljs.core.first.call(null,inst_15751);
var inst_15761 = cljs.core.async.put_BANG_.call(null,inst_15760__$1,inst_15661,done);
var state_15792__$1 = (function (){var statearr_15869 = state_15792;
(statearr_15869[(23)] = inst_15760__$1);

return statearr_15869;
})();
if(cljs.core.truth_(inst_15761)){
var statearr_15872_15969 = state_15792__$1;
(statearr_15872_15969[(1)] = (39));

} else {
var statearr_15874_15970 = state_15792__$1;
(statearr_15874_15970[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (8))){
var inst_15673 = (state_15792[(15)]);
var inst_15672 = (state_15792[(17)]);
var inst_15675 = (inst_15673 < inst_15672);
var inst_15676 = inst_15675;
var state_15792__$1 = state_15792;
if(cljs.core.truth_(inst_15676)){
var statearr_15876_15971 = state_15792__$1;
(statearr_15876_15971[(1)] = (10));

} else {
var statearr_15877_15972 = state_15792__$1;
(statearr_15877_15972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15891,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___15891,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15883[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15883[(1)] = (1));

return statearr_15883;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15792){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15884){if((e15884 instanceof Object)){
var ex__14240__auto__ = e15884;
var statearr_15885_15973 = state_15792;
(statearr_15885_15973[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15974 = state_15792;
state_15792 = G__15974;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15792){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15891,cs,m,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_15886 = f__14369__auto__.call(null);
(statearr_15886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15891);

return statearr_15886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15891,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15975 = [];
var len__7107__auto___15978 = arguments.length;
var i__7108__auto___15979 = (0);
while(true){
if((i__7108__auto___15979 < len__7107__auto___15978)){
args15975.push((arguments[i__7108__auto___15979]));

var G__15980 = (i__7108__auto___15979 + (1));
i__7108__auto___15979 = G__15980;
continue;
} else {
}
break;
}

var G__15977 = args15975.length;
switch (G__15977) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15975.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___16005 = arguments.length;
var i__7108__auto___16006 = (0);
while(true){
if((i__7108__auto___16006 < len__7107__auto___16005)){
args__7114__auto__.push((arguments[i__7108__auto___16006]));

var G__16007 = (i__7108__auto___16006 + (1));
i__7108__auto___16006 = G__16007;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15999){
var map__16000 = p__15999;
var map__16000__$1 = ((((!((map__16000 == null)))?((((map__16000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16000):map__16000);
var opts = map__16000__$1;
var statearr_16002_16008 = state;
(statearr_16002_16008[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__16000,map__16000__$1,opts){
return (function (val){
var statearr_16003_16009 = state;
(statearr_16003_16009[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__16000,map__16000__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16004_16010 = state;
(statearr_16004_16010[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15995){
var G__15996 = cljs.core.first.call(null,seq15995);
var seq15995__$1 = cljs.core.next.call(null,seq15995);
var G__15997 = cljs.core.first.call(null,seq15995__$1);
var seq15995__$2 = cljs.core.next.call(null,seq15995__$1);
var G__15998 = cljs.core.first.call(null,seq15995__$2);
var seq15995__$3 = cljs.core.next.call(null,seq15995__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15996,G__15997,G__15998,seq15995__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16193 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16193 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16194){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16194 = meta16194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16195,meta16194__$1){
var self__ = this;
var _16195__$1 = this;
return (new cljs.core.async.t_cljs$core$async16193(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16194__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16195){
var self__ = this;
var _16195__$1 = this;
return self__.meta16194;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16194","meta16194",280876592,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16193";

cljs.core.async.t_cljs$core$async16193.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16193");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16193 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16193(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16194){
return (new cljs.core.async.t_cljs$core$async16193(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16194));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16193(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16377 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16298){
var state_val_16299 = (state_16298[(1)]);
if((state_val_16299 === (7))){
var inst_16216 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16300_16379 = state_16298__$1;
(statearr_16300_16379[(2)] = inst_16216);

(statearr_16300_16379[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (20))){
var inst_16228 = (state_16298[(7)]);
var state_16298__$1 = state_16298;
var statearr_16301_16380 = state_16298__$1;
(statearr_16301_16380[(2)] = inst_16228);

(statearr_16301_16380[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (27))){
var state_16298__$1 = state_16298;
var statearr_16302_16381 = state_16298__$1;
(statearr_16302_16381[(2)] = null);

(statearr_16302_16381[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (1))){
var inst_16199 = (state_16298[(8)]);
var inst_16199__$1 = calc_state.call(null);
var inst_16201 = (inst_16199__$1 == null);
var inst_16202 = cljs.core.not.call(null,inst_16201);
var state_16298__$1 = (function (){var statearr_16303 = state_16298;
(statearr_16303[(8)] = inst_16199__$1);

return statearr_16303;
})();
if(inst_16202){
var statearr_16304_16382 = state_16298__$1;
(statearr_16304_16382[(1)] = (2));

} else {
var statearr_16305_16383 = state_16298__$1;
(statearr_16305_16383[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (24))){
var inst_16272 = (state_16298[(9)]);
var inst_16258 = (state_16298[(10)]);
var inst_16251 = (state_16298[(11)]);
var inst_16272__$1 = inst_16251.call(null,inst_16258);
var state_16298__$1 = (function (){var statearr_16306 = state_16298;
(statearr_16306[(9)] = inst_16272__$1);

return statearr_16306;
})();
if(cljs.core.truth_(inst_16272__$1)){
var statearr_16307_16384 = state_16298__$1;
(statearr_16307_16384[(1)] = (29));

} else {
var statearr_16308_16385 = state_16298__$1;
(statearr_16308_16385[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (4))){
var inst_16219 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16219)){
var statearr_16309_16386 = state_16298__$1;
(statearr_16309_16386[(1)] = (8));

} else {
var statearr_16310_16387 = state_16298__$1;
(statearr_16310_16387[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (15))){
var inst_16245 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16245)){
var statearr_16311_16388 = state_16298__$1;
(statearr_16311_16388[(1)] = (19));

} else {
var statearr_16312_16389 = state_16298__$1;
(statearr_16312_16389[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (21))){
var inst_16250 = (state_16298[(12)]);
var inst_16250__$1 = (state_16298[(2)]);
var inst_16251 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16252 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16253 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16298__$1 = (function (){var statearr_16313 = state_16298;
(statearr_16313[(13)] = inst_16252);

(statearr_16313[(11)] = inst_16251);

(statearr_16313[(12)] = inst_16250__$1);

return statearr_16313;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16298__$1,(22),inst_16253);
} else {
if((state_val_16299 === (31))){
var inst_16280 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16280)){
var statearr_16316_16390 = state_16298__$1;
(statearr_16316_16390[(1)] = (32));

} else {
var statearr_16317_16391 = state_16298__$1;
(statearr_16317_16391[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (32))){
var inst_16257 = (state_16298[(14)]);
var state_16298__$1 = state_16298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16298__$1,(35),out,inst_16257);
} else {
if((state_val_16299 === (33))){
var inst_16250 = (state_16298[(12)]);
var inst_16228 = inst_16250;
var state_16298__$1 = (function (){var statearr_16319 = state_16298;
(statearr_16319[(7)] = inst_16228);

return statearr_16319;
})();
var statearr_16320_16396 = state_16298__$1;
(statearr_16320_16396[(2)] = null);

(statearr_16320_16396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (13))){
var inst_16228 = (state_16298[(7)]);
var inst_16235 = inst_16228.cljs$lang$protocol_mask$partition0$;
var inst_16236 = (inst_16235 & (64));
var inst_16237 = inst_16228.cljs$core$ISeq$;
var inst_16238 = (inst_16236) || (inst_16237);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16238)){
var statearr_16321_16398 = state_16298__$1;
(statearr_16321_16398[(1)] = (16));

} else {
var statearr_16322_16399 = state_16298__$1;
(statearr_16322_16399[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (22))){
var inst_16257 = (state_16298[(14)]);
var inst_16258 = (state_16298[(10)]);
var inst_16256 = (state_16298[(2)]);
var inst_16257__$1 = cljs.core.nth.call(null,inst_16256,(0),null);
var inst_16258__$1 = cljs.core.nth.call(null,inst_16256,(1),null);
var inst_16259 = (inst_16257__$1 == null);
var inst_16260 = cljs.core._EQ_.call(null,inst_16258__$1,change);
var inst_16261 = (inst_16259) || (inst_16260);
var state_16298__$1 = (function (){var statearr_16324 = state_16298;
(statearr_16324[(14)] = inst_16257__$1);

(statearr_16324[(10)] = inst_16258__$1);

return statearr_16324;
})();
if(cljs.core.truth_(inst_16261)){
var statearr_16325_16403 = state_16298__$1;
(statearr_16325_16403[(1)] = (23));

} else {
var statearr_16326_16404 = state_16298__$1;
(statearr_16326_16404[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (36))){
var inst_16250 = (state_16298[(12)]);
var inst_16228 = inst_16250;
var state_16298__$1 = (function (){var statearr_16327 = state_16298;
(statearr_16327[(7)] = inst_16228);

return statearr_16327;
})();
var statearr_16328_16409 = state_16298__$1;
(statearr_16328_16409[(2)] = null);

(statearr_16328_16409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (29))){
var inst_16272 = (state_16298[(9)]);
var state_16298__$1 = state_16298;
var statearr_16329_16410 = state_16298__$1;
(statearr_16329_16410[(2)] = inst_16272);

(statearr_16329_16410[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (6))){
var state_16298__$1 = state_16298;
var statearr_16330_16411 = state_16298__$1;
(statearr_16330_16411[(2)] = false);

(statearr_16330_16411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (28))){
var inst_16268 = (state_16298[(2)]);
var inst_16269 = calc_state.call(null);
var inst_16228 = inst_16269;
var state_16298__$1 = (function (){var statearr_16331 = state_16298;
(statearr_16331[(7)] = inst_16228);

(statearr_16331[(15)] = inst_16268);

return statearr_16331;
})();
var statearr_16332_16412 = state_16298__$1;
(statearr_16332_16412[(2)] = null);

(statearr_16332_16412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (25))){
var inst_16294 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16333_16413 = state_16298__$1;
(statearr_16333_16413[(2)] = inst_16294);

(statearr_16333_16413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (34))){
var inst_16292 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16334_16414 = state_16298__$1;
(statearr_16334_16414[(2)] = inst_16292);

(statearr_16334_16414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (17))){
var state_16298__$1 = state_16298;
var statearr_16335_16415 = state_16298__$1;
(statearr_16335_16415[(2)] = false);

(statearr_16335_16415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (3))){
var state_16298__$1 = state_16298;
var statearr_16336_16417 = state_16298__$1;
(statearr_16336_16417[(2)] = false);

(statearr_16336_16417[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (12))){
var inst_16296 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16298__$1,inst_16296);
} else {
if((state_val_16299 === (2))){
var inst_16199 = (state_16298[(8)]);
var inst_16206 = inst_16199.cljs$lang$protocol_mask$partition0$;
var inst_16210 = (inst_16206 & (64));
var inst_16211 = inst_16199.cljs$core$ISeq$;
var inst_16212 = (inst_16210) || (inst_16211);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16212)){
var statearr_16337_16418 = state_16298__$1;
(statearr_16337_16418[(1)] = (5));

} else {
var statearr_16338_16419 = state_16298__$1;
(statearr_16338_16419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (23))){
var inst_16257 = (state_16298[(14)]);
var inst_16263 = (inst_16257 == null);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16263)){
var statearr_16342_16420 = state_16298__$1;
(statearr_16342_16420[(1)] = (26));

} else {
var statearr_16343_16421 = state_16298__$1;
(statearr_16343_16421[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (35))){
var inst_16283 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16283)){
var statearr_16344_16422 = state_16298__$1;
(statearr_16344_16422[(1)] = (36));

} else {
var statearr_16345_16423 = state_16298__$1;
(statearr_16345_16423[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (19))){
var inst_16228 = (state_16298[(7)]);
var inst_16247 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16228);
var state_16298__$1 = state_16298;
var statearr_16346_16424 = state_16298__$1;
(statearr_16346_16424[(2)] = inst_16247);

(statearr_16346_16424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (11))){
var inst_16228 = (state_16298[(7)]);
var inst_16232 = (inst_16228 == null);
var inst_16233 = cljs.core.not.call(null,inst_16232);
var state_16298__$1 = state_16298;
if(inst_16233){
var statearr_16347_16425 = state_16298__$1;
(statearr_16347_16425[(1)] = (13));

} else {
var statearr_16348_16426 = state_16298__$1;
(statearr_16348_16426[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (9))){
var inst_16199 = (state_16298[(8)]);
var state_16298__$1 = state_16298;
var statearr_16349_16427 = state_16298__$1;
(statearr_16349_16427[(2)] = inst_16199);

(statearr_16349_16427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (5))){
var state_16298__$1 = state_16298;
var statearr_16350_16428 = state_16298__$1;
(statearr_16350_16428[(2)] = true);

(statearr_16350_16428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (14))){
var state_16298__$1 = state_16298;
var statearr_16351_16429 = state_16298__$1;
(statearr_16351_16429[(2)] = false);

(statearr_16351_16429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (26))){
var inst_16258 = (state_16298[(10)]);
var inst_16265 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16258);
var state_16298__$1 = state_16298;
var statearr_16352_16430 = state_16298__$1;
(statearr_16352_16430[(2)] = inst_16265);

(statearr_16352_16430[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (16))){
var state_16298__$1 = state_16298;
var statearr_16353_16431 = state_16298__$1;
(statearr_16353_16431[(2)] = true);

(statearr_16353_16431[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (38))){
var inst_16288 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16354_16432 = state_16298__$1;
(statearr_16354_16432[(2)] = inst_16288);

(statearr_16354_16432[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (30))){
var inst_16258 = (state_16298[(10)]);
var inst_16252 = (state_16298[(13)]);
var inst_16251 = (state_16298[(11)]);
var inst_16275 = cljs.core.empty_QMARK_.call(null,inst_16251);
var inst_16276 = inst_16252.call(null,inst_16258);
var inst_16277 = cljs.core.not.call(null,inst_16276);
var inst_16278 = (inst_16275) && (inst_16277);
var state_16298__$1 = state_16298;
var statearr_16355_16433 = state_16298__$1;
(statearr_16355_16433[(2)] = inst_16278);

(statearr_16355_16433[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (10))){
var inst_16199 = (state_16298[(8)]);
var inst_16224 = (state_16298[(2)]);
var inst_16225 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16226 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16227 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16228 = inst_16199;
var state_16298__$1 = (function (){var statearr_16356 = state_16298;
(statearr_16356[(16)] = inst_16227);

(statearr_16356[(17)] = inst_16225);

(statearr_16356[(7)] = inst_16228);

(statearr_16356[(18)] = inst_16226);

return statearr_16356;
})();
var statearr_16357_16434 = state_16298__$1;
(statearr_16357_16434[(2)] = null);

(statearr_16357_16434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (18))){
var inst_16242 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16359_16436 = state_16298__$1;
(statearr_16359_16436[(2)] = inst_16242);

(statearr_16359_16436[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (37))){
var state_16298__$1 = state_16298;
var statearr_16360_16437 = state_16298__$1;
(statearr_16360_16437[(2)] = null);

(statearr_16360_16437[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16299 === (8))){
var inst_16199 = (state_16298[(8)]);
var inst_16221 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16199);
var state_16298__$1 = state_16298;
var statearr_16361_16438 = state_16298__$1;
(statearr_16361_16438[(2)] = inst_16221);

(statearr_16361_16438[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16365[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16365[(1)] = (1));

return statearr_16365;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16298){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16366){if((e16366 instanceof Object)){
var ex__14240__auto__ = e16366;
var statearr_16367_16439 = state_16298;
(statearr_16367_16439[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16366;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16441 = state_16298;
state_16298 = G__16441;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16298){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14370__auto__ = (function (){var statearr_16368 = f__14369__auto__.call(null);
(statearr_16368[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16377);

return statearr_16368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16377,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16450 = [];
var len__7107__auto___16466 = arguments.length;
var i__7108__auto___16467 = (0);
while(true){
if((i__7108__auto___16467 < len__7107__auto___16466)){
args16450.push((arguments[i__7108__auto___16467]));

var G__16468 = (i__7108__auto___16467 + (1));
i__7108__auto___16467 = G__16468;
continue;
} else {
}
break;
}

var G__16452 = args16450.length;
switch (G__16452) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16450.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16472 = [];
var len__7107__auto___16599 = arguments.length;
var i__7108__auto___16604 = (0);
while(true){
if((i__7108__auto___16604 < len__7107__auto___16599)){
args16472.push((arguments[i__7108__auto___16604]));

var G__16605 = (i__7108__auto___16604 + (1));
i__7108__auto___16604 = G__16605;
continue;
} else {
}
break;
}

var G__16474 = args16472.length;
switch (G__16474) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16472.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16471_SHARP_){
if(cljs.core.truth_(p1__16471_SHARP_.call(null,topic))){
return p1__16471_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16471_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16475 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16475 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16476){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16476 = meta16476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16477,meta16476__$1){
var self__ = this;
var _16477__$1 = this;
return (new cljs.core.async.t_cljs$core$async16475(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16476__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16477){
var self__ = this;
var _16477__$1 = this;
return self__.meta16476;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16476","meta16476",-1432060876,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16475";

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16475");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16475 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476){
return (new cljs.core.async.t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16475(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16615,mults,ensure_mult,p){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16615,mults,ensure_mult,p){
return (function (state_16549){
var state_val_16550 = (state_16549[(1)]);
if((state_val_16550 === (7))){
var inst_16545 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16551_16616 = state_16549__$1;
(statearr_16551_16616[(2)] = inst_16545);

(statearr_16551_16616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (20))){
var state_16549__$1 = state_16549;
var statearr_16552_16617 = state_16549__$1;
(statearr_16552_16617[(2)] = null);

(statearr_16552_16617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (1))){
var state_16549__$1 = state_16549;
var statearr_16553_16618 = state_16549__$1;
(statearr_16553_16618[(2)] = null);

(statearr_16553_16618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (24))){
var inst_16528 = (state_16549[(7)]);
var inst_16537 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16528);
var state_16549__$1 = state_16549;
var statearr_16555_16619 = state_16549__$1;
(statearr_16555_16619[(2)] = inst_16537);

(statearr_16555_16619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (4))){
var inst_16480 = (state_16549[(8)]);
var inst_16480__$1 = (state_16549[(2)]);
var inst_16481 = (inst_16480__$1 == null);
var state_16549__$1 = (function (){var statearr_16556 = state_16549;
(statearr_16556[(8)] = inst_16480__$1);

return statearr_16556;
})();
if(cljs.core.truth_(inst_16481)){
var statearr_16557_16624 = state_16549__$1;
(statearr_16557_16624[(1)] = (5));

} else {
var statearr_16558_16625 = state_16549__$1;
(statearr_16558_16625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (15))){
var inst_16522 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16559_16628 = state_16549__$1;
(statearr_16559_16628[(2)] = inst_16522);

(statearr_16559_16628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (21))){
var inst_16542 = (state_16549[(2)]);
var state_16549__$1 = (function (){var statearr_16560 = state_16549;
(statearr_16560[(9)] = inst_16542);

return statearr_16560;
})();
var statearr_16561_16631 = state_16549__$1;
(statearr_16561_16631[(2)] = null);

(statearr_16561_16631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (13))){
var inst_16504 = (state_16549[(10)]);
var inst_16506 = cljs.core.chunked_seq_QMARK_.call(null,inst_16504);
var state_16549__$1 = state_16549;
if(inst_16506){
var statearr_16562_16634 = state_16549__$1;
(statearr_16562_16634[(1)] = (16));

} else {
var statearr_16563_16635 = state_16549__$1;
(statearr_16563_16635[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (22))){
var inst_16534 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
if(cljs.core.truth_(inst_16534)){
var statearr_16564_16638 = state_16549__$1;
(statearr_16564_16638[(1)] = (23));

} else {
var statearr_16565_16639 = state_16549__$1;
(statearr_16565_16639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (6))){
var inst_16528 = (state_16549[(7)]);
var inst_16480 = (state_16549[(8)]);
var inst_16530 = (state_16549[(11)]);
var inst_16528__$1 = topic_fn.call(null,inst_16480);
var inst_16529 = cljs.core.deref.call(null,mults);
var inst_16530__$1 = cljs.core.get.call(null,inst_16529,inst_16528__$1);
var state_16549__$1 = (function (){var statearr_16566 = state_16549;
(statearr_16566[(7)] = inst_16528__$1);

(statearr_16566[(11)] = inst_16530__$1);

return statearr_16566;
})();
if(cljs.core.truth_(inst_16530__$1)){
var statearr_16567_16640 = state_16549__$1;
(statearr_16567_16640[(1)] = (19));

} else {
var statearr_16568_16641 = state_16549__$1;
(statearr_16568_16641[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (25))){
var inst_16539 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16569_16642 = state_16549__$1;
(statearr_16569_16642[(2)] = inst_16539);

(statearr_16569_16642[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (17))){
var inst_16504 = (state_16549[(10)]);
var inst_16513 = cljs.core.first.call(null,inst_16504);
var inst_16514 = cljs.core.async.muxch_STAR_.call(null,inst_16513);
var inst_16515 = cljs.core.async.close_BANG_.call(null,inst_16514);
var inst_16516 = cljs.core.next.call(null,inst_16504);
var inst_16490 = inst_16516;
var inst_16491 = null;
var inst_16492 = (0);
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16570 = state_16549;
(statearr_16570[(12)] = inst_16492);

(statearr_16570[(13)] = inst_16491);

(statearr_16570[(14)] = inst_16515);

(statearr_16570[(15)] = inst_16493);

(statearr_16570[(16)] = inst_16490);

return statearr_16570;
})();
var statearr_16571_16643 = state_16549__$1;
(statearr_16571_16643[(2)] = null);

(statearr_16571_16643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (3))){
var inst_16547 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16549__$1,inst_16547);
} else {
if((state_val_16550 === (12))){
var inst_16524 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16572_16644 = state_16549__$1;
(statearr_16572_16644[(2)] = inst_16524);

(statearr_16572_16644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (2))){
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16549__$1,(4),ch);
} else {
if((state_val_16550 === (23))){
var state_16549__$1 = state_16549;
var statearr_16573_16646 = state_16549__$1;
(statearr_16573_16646[(2)] = null);

(statearr_16573_16646[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (19))){
var inst_16480 = (state_16549[(8)]);
var inst_16530 = (state_16549[(11)]);
var inst_16532 = cljs.core.async.muxch_STAR_.call(null,inst_16530);
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16549__$1,(22),inst_16532,inst_16480);
} else {
if((state_val_16550 === (11))){
var inst_16504 = (state_16549[(10)]);
var inst_16490 = (state_16549[(16)]);
var inst_16504__$1 = cljs.core.seq.call(null,inst_16490);
var state_16549__$1 = (function (){var statearr_16574 = state_16549;
(statearr_16574[(10)] = inst_16504__$1);

return statearr_16574;
})();
if(inst_16504__$1){
var statearr_16575_16647 = state_16549__$1;
(statearr_16575_16647[(1)] = (13));

} else {
var statearr_16576_16648 = state_16549__$1;
(statearr_16576_16648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (9))){
var inst_16526 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16577_16649 = state_16549__$1;
(statearr_16577_16649[(2)] = inst_16526);

(statearr_16577_16649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (5))){
var inst_16487 = cljs.core.deref.call(null,mults);
var inst_16488 = cljs.core.vals.call(null,inst_16487);
var inst_16489 = cljs.core.seq.call(null,inst_16488);
var inst_16490 = inst_16489;
var inst_16491 = null;
var inst_16492 = (0);
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16578 = state_16549;
(statearr_16578[(12)] = inst_16492);

(statearr_16578[(13)] = inst_16491);

(statearr_16578[(15)] = inst_16493);

(statearr_16578[(16)] = inst_16490);

return statearr_16578;
})();
var statearr_16579_16653 = state_16549__$1;
(statearr_16579_16653[(2)] = null);

(statearr_16579_16653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (14))){
var state_16549__$1 = state_16549;
var statearr_16583_16655 = state_16549__$1;
(statearr_16583_16655[(2)] = null);

(statearr_16583_16655[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (16))){
var inst_16504 = (state_16549[(10)]);
var inst_16508 = cljs.core.chunk_first.call(null,inst_16504);
var inst_16509 = cljs.core.chunk_rest.call(null,inst_16504);
var inst_16510 = cljs.core.count.call(null,inst_16508);
var inst_16490 = inst_16509;
var inst_16491 = inst_16508;
var inst_16492 = inst_16510;
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16584 = state_16549;
(statearr_16584[(12)] = inst_16492);

(statearr_16584[(13)] = inst_16491);

(statearr_16584[(15)] = inst_16493);

(statearr_16584[(16)] = inst_16490);

return statearr_16584;
})();
var statearr_16585_16657 = state_16549__$1;
(statearr_16585_16657[(2)] = null);

(statearr_16585_16657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (10))){
var inst_16492 = (state_16549[(12)]);
var inst_16491 = (state_16549[(13)]);
var inst_16493 = (state_16549[(15)]);
var inst_16490 = (state_16549[(16)]);
var inst_16498 = cljs.core._nth.call(null,inst_16491,inst_16493);
var inst_16499 = cljs.core.async.muxch_STAR_.call(null,inst_16498);
var inst_16500 = cljs.core.async.close_BANG_.call(null,inst_16499);
var inst_16501 = (inst_16493 + (1));
var tmp16580 = inst_16492;
var tmp16581 = inst_16491;
var tmp16582 = inst_16490;
var inst_16490__$1 = tmp16582;
var inst_16491__$1 = tmp16581;
var inst_16492__$1 = tmp16580;
var inst_16493__$1 = inst_16501;
var state_16549__$1 = (function (){var statearr_16586 = state_16549;
(statearr_16586[(12)] = inst_16492__$1);

(statearr_16586[(13)] = inst_16491__$1);

(statearr_16586[(15)] = inst_16493__$1);

(statearr_16586[(16)] = inst_16490__$1);

(statearr_16586[(17)] = inst_16500);

return statearr_16586;
})();
var statearr_16587_16661 = state_16549__$1;
(statearr_16587_16661[(2)] = null);

(statearr_16587_16661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (18))){
var inst_16519 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16588_16662 = state_16549__$1;
(statearr_16588_16662[(2)] = inst_16519);

(statearr_16588_16662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (8))){
var inst_16492 = (state_16549[(12)]);
var inst_16493 = (state_16549[(15)]);
var inst_16495 = (inst_16493 < inst_16492);
var inst_16496 = inst_16495;
var state_16549__$1 = state_16549;
if(cljs.core.truth_(inst_16496)){
var statearr_16589_16667 = state_16549__$1;
(statearr_16589_16667[(1)] = (10));

} else {
var statearr_16590_16668 = state_16549__$1;
(statearr_16590_16668[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16615,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14368__auto___16615,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16595[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16595[(1)] = (1));

return statearr_16595;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16549){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16596){if((e16596 instanceof Object)){
var ex__14240__auto__ = e16596;
var statearr_16597_16669 = state_16549;
(statearr_16597_16669[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16670 = state_16549;
state_16549 = G__16670;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16615,mults,ensure_mult,p))
})();
var state__14370__auto__ = (function (){var statearr_16598 = f__14369__auto__.call(null);
(statearr_16598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16615);

return statearr_16598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16615,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16671 = [];
var len__7107__auto___16675 = arguments.length;
var i__7108__auto___16676 = (0);
while(true){
if((i__7108__auto___16676 < len__7107__auto___16675)){
args16671.push((arguments[i__7108__auto___16676]));

var G__16677 = (i__7108__auto___16676 + (1));
i__7108__auto___16676 = G__16677;
continue;
} else {
}
break;
}

var G__16674 = args16671.length;
switch (G__16674) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16671.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16679 = [];
var len__7107__auto___16682 = arguments.length;
var i__7108__auto___16683 = (0);
while(true){
if((i__7108__auto___16683 < len__7107__auto___16682)){
args16679.push((arguments[i__7108__auto___16683]));

var G__16684 = (i__7108__auto___16683 + (1));
i__7108__auto___16683 = G__16684;
continue;
} else {
}
break;
}

var G__16681 = args16679.length;
switch (G__16681) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16679.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16686 = [];
var len__7107__auto___16767 = arguments.length;
var i__7108__auto___16768 = (0);
while(true){
if((i__7108__auto___16768 < len__7107__auto___16767)){
args16686.push((arguments[i__7108__auto___16768]));

var G__16769 = (i__7108__auto___16768 + (1));
i__7108__auto___16768 = G__16769;
continue;
} else {
}
break;
}

var G__16688 = args16686.length;
switch (G__16688) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16686.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14368__auto___16774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16728){
var state_val_16729 = (state_16728[(1)]);
if((state_val_16729 === (7))){
var state_16728__$1 = state_16728;
var statearr_16730_16775 = state_16728__$1;
(statearr_16730_16775[(2)] = null);

(statearr_16730_16775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (1))){
var state_16728__$1 = state_16728;
var statearr_16731_16777 = state_16728__$1;
(statearr_16731_16777[(2)] = null);

(statearr_16731_16777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (4))){
var inst_16691 = (state_16728[(7)]);
var inst_16694 = (inst_16691 < cnt);
var state_16728__$1 = state_16728;
if(cljs.core.truth_(inst_16694)){
var statearr_16732_16778 = state_16728__$1;
(statearr_16732_16778[(1)] = (6));

} else {
var statearr_16733_16779 = state_16728__$1;
(statearr_16733_16779[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (15))){
var inst_16724 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
var statearr_16734_16780 = state_16728__$1;
(statearr_16734_16780[(2)] = inst_16724);

(statearr_16734_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (13))){
var inst_16717 = cljs.core.async.close_BANG_.call(null,out);
var state_16728__$1 = state_16728;
var statearr_16735_16781 = state_16728__$1;
(statearr_16735_16781[(2)] = inst_16717);

(statearr_16735_16781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (6))){
var state_16728__$1 = state_16728;
var statearr_16736_16782 = state_16728__$1;
(statearr_16736_16782[(2)] = null);

(statearr_16736_16782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (3))){
var inst_16726 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16728__$1,inst_16726);
} else {
if((state_val_16729 === (12))){
var inst_16714 = (state_16728[(8)]);
var inst_16714__$1 = (state_16728[(2)]);
var inst_16715 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16714__$1);
var state_16728__$1 = (function (){var statearr_16738 = state_16728;
(statearr_16738[(8)] = inst_16714__$1);

return statearr_16738;
})();
if(cljs.core.truth_(inst_16715)){
var statearr_16739_16783 = state_16728__$1;
(statearr_16739_16783[(1)] = (13));

} else {
var statearr_16740_16784 = state_16728__$1;
(statearr_16740_16784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (2))){
var inst_16690 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16691 = (0);
var state_16728__$1 = (function (){var statearr_16741 = state_16728;
(statearr_16741[(9)] = inst_16690);

(statearr_16741[(7)] = inst_16691);

return statearr_16741;
})();
var statearr_16742_16785 = state_16728__$1;
(statearr_16742_16785[(2)] = null);

(statearr_16742_16785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (11))){
var inst_16691 = (state_16728[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16728,(10),Object,null,(9));
var inst_16701 = chs__$1.call(null,inst_16691);
var inst_16702 = done.call(null,inst_16691);
var inst_16703 = cljs.core.async.take_BANG_.call(null,inst_16701,inst_16702);
var state_16728__$1 = state_16728;
var statearr_16746_16786 = state_16728__$1;
(statearr_16746_16786[(2)] = inst_16703);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (9))){
var inst_16691 = (state_16728[(7)]);
var inst_16705 = (state_16728[(2)]);
var inst_16706 = (inst_16691 + (1));
var inst_16691__$1 = inst_16706;
var state_16728__$1 = (function (){var statearr_16747 = state_16728;
(statearr_16747[(10)] = inst_16705);

(statearr_16747[(7)] = inst_16691__$1);

return statearr_16747;
})();
var statearr_16748_16787 = state_16728__$1;
(statearr_16748_16787[(2)] = null);

(statearr_16748_16787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (5))){
var inst_16712 = (state_16728[(2)]);
var state_16728__$1 = (function (){var statearr_16749 = state_16728;
(statearr_16749[(11)] = inst_16712);

return statearr_16749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16728__$1,(12),dchan);
} else {
if((state_val_16729 === (14))){
var inst_16714 = (state_16728[(8)]);
var inst_16719 = cljs.core.apply.call(null,f,inst_16714);
var state_16728__$1 = state_16728;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16728__$1,(16),out,inst_16719);
} else {
if((state_val_16729 === (16))){
var inst_16721 = (state_16728[(2)]);
var state_16728__$1 = (function (){var statearr_16750 = state_16728;
(statearr_16750[(12)] = inst_16721);

return statearr_16750;
})();
var statearr_16751_16788 = state_16728__$1;
(statearr_16751_16788[(2)] = null);

(statearr_16751_16788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (10))){
var inst_16696 = (state_16728[(2)]);
var inst_16697 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16728__$1 = (function (){var statearr_16752 = state_16728;
(statearr_16752[(13)] = inst_16696);

return statearr_16752;
})();
var statearr_16753_16789 = state_16728__$1;
(statearr_16753_16789[(2)] = inst_16697);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (8))){
var inst_16710 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
var statearr_16755_16790 = state_16728__$1;
(statearr_16755_16790[(2)] = inst_16710);

(statearr_16755_16790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16762 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16762[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16762[(1)] = (1));

return statearr_16762;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16728){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16763){if((e16763 instanceof Object)){
var ex__14240__auto__ = e16763;
var statearr_16764_16791 = state_16728;
(statearr_16764_16791[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16763;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16792 = state_16728;
state_16728 = G__16792;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16728){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_16766 = f__14369__auto__.call(null);
(statearr_16766[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16774);

return statearr_16766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16797 = [];
var len__7107__auto___16865 = arguments.length;
var i__7108__auto___16866 = (0);
while(true){
if((i__7108__auto___16866 < len__7107__auto___16865)){
args16797.push((arguments[i__7108__auto___16866]));

var G__16867 = (i__7108__auto___16866 + (1));
i__7108__auto___16866 = G__16867;
continue;
} else {
}
break;
}

var G__16799 = args16797.length;
switch (G__16799) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16797.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16869,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16869,out){
return (function (state_16833){
var state_val_16834 = (state_16833[(1)]);
if((state_val_16834 === (7))){
var inst_16808 = (state_16833[(7)]);
var inst_16810 = (state_16833[(8)]);
var inst_16808__$1 = (state_16833[(2)]);
var inst_16810__$1 = cljs.core.nth.call(null,inst_16808__$1,(0),null);
var inst_16811 = cljs.core.nth.call(null,inst_16808__$1,(1),null);
var inst_16812 = (inst_16810__$1 == null);
var state_16833__$1 = (function (){var statearr_16835 = state_16833;
(statearr_16835[(7)] = inst_16808__$1);

(statearr_16835[(9)] = inst_16811);

(statearr_16835[(8)] = inst_16810__$1);

return statearr_16835;
})();
if(cljs.core.truth_(inst_16812)){
var statearr_16836_16871 = state_16833__$1;
(statearr_16836_16871[(1)] = (8));

} else {
var statearr_16837_16872 = state_16833__$1;
(statearr_16837_16872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (1))){
var inst_16800 = cljs.core.vec.call(null,chs);
var inst_16801 = inst_16800;
var state_16833__$1 = (function (){var statearr_16838 = state_16833;
(statearr_16838[(10)] = inst_16801);

return statearr_16838;
})();
var statearr_16839_16873 = state_16833__$1;
(statearr_16839_16873[(2)] = null);

(statearr_16839_16873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (4))){
var inst_16801 = (state_16833[(10)]);
var state_16833__$1 = state_16833;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16833__$1,(7),inst_16801);
} else {
if((state_val_16834 === (6))){
var inst_16828 = (state_16833[(2)]);
var state_16833__$1 = state_16833;
var statearr_16840_16874 = state_16833__$1;
(statearr_16840_16874[(2)] = inst_16828);

(statearr_16840_16874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (3))){
var inst_16830 = (state_16833[(2)]);
var state_16833__$1 = state_16833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16833__$1,inst_16830);
} else {
if((state_val_16834 === (2))){
var inst_16801 = (state_16833[(10)]);
var inst_16803 = cljs.core.count.call(null,inst_16801);
var inst_16804 = (inst_16803 > (0));
var state_16833__$1 = state_16833;
if(cljs.core.truth_(inst_16804)){
var statearr_16843_16875 = state_16833__$1;
(statearr_16843_16875[(1)] = (4));

} else {
var statearr_16844_16876 = state_16833__$1;
(statearr_16844_16876[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (11))){
var inst_16801 = (state_16833[(10)]);
var inst_16821 = (state_16833[(2)]);
var tmp16841 = inst_16801;
var inst_16801__$1 = tmp16841;
var state_16833__$1 = (function (){var statearr_16845 = state_16833;
(statearr_16845[(11)] = inst_16821);

(statearr_16845[(10)] = inst_16801__$1);

return statearr_16845;
})();
var statearr_16846_16877 = state_16833__$1;
(statearr_16846_16877[(2)] = null);

(statearr_16846_16877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (9))){
var inst_16810 = (state_16833[(8)]);
var state_16833__$1 = state_16833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16833__$1,(11),out,inst_16810);
} else {
if((state_val_16834 === (5))){
var inst_16826 = cljs.core.async.close_BANG_.call(null,out);
var state_16833__$1 = state_16833;
var statearr_16851_16878 = state_16833__$1;
(statearr_16851_16878[(2)] = inst_16826);

(statearr_16851_16878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (10))){
var inst_16824 = (state_16833[(2)]);
var state_16833__$1 = state_16833;
var statearr_16852_16879 = state_16833__$1;
(statearr_16852_16879[(2)] = inst_16824);

(statearr_16852_16879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16834 === (8))){
var inst_16808 = (state_16833[(7)]);
var inst_16811 = (state_16833[(9)]);
var inst_16810 = (state_16833[(8)]);
var inst_16801 = (state_16833[(10)]);
var inst_16815 = (function (){var cs = inst_16801;
var vec__16806 = inst_16808;
var v = inst_16810;
var c = inst_16811;
return ((function (cs,vec__16806,v,c,inst_16808,inst_16811,inst_16810,inst_16801,state_val_16834,c__14368__auto___16869,out){
return (function (p1__16795_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16795_SHARP_);
});
;})(cs,vec__16806,v,c,inst_16808,inst_16811,inst_16810,inst_16801,state_val_16834,c__14368__auto___16869,out))
})();
var inst_16816 = cljs.core.filterv.call(null,inst_16815,inst_16801);
var inst_16801__$1 = inst_16816;
var state_16833__$1 = (function (){var statearr_16853 = state_16833;
(statearr_16853[(10)] = inst_16801__$1);

return statearr_16853;
})();
var statearr_16854_16880 = state_16833__$1;
(statearr_16854_16880[(2)] = null);

(statearr_16854_16880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16869,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16869,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16858 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16858[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16858[(1)] = (1));

return statearr_16858;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16833){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16859){if((e16859 instanceof Object)){
var ex__14240__auto__ = e16859;
var statearr_16860_16881 = state_16833;
(statearr_16860_16881[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16833);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16882 = state_16833;
state_16833 = G__16882;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16833){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16869,out))
})();
var state__14370__auto__ = (function (){var statearr_16861 = f__14369__auto__.call(null);
(statearr_16861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16869);

return statearr_16861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16869,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16884 = [];
var len__7107__auto___16940 = arguments.length;
var i__7108__auto___16941 = (0);
while(true){
if((i__7108__auto___16941 < len__7107__auto___16940)){
args16884.push((arguments[i__7108__auto___16941]));

var G__16942 = (i__7108__auto___16941 + (1));
i__7108__auto___16941 = G__16942;
continue;
} else {
}
break;
}

var G__16886 = args16884.length;
switch (G__16886) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16884.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16948 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16948,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16948,out){
return (function (state_16913){
var state_val_16914 = (state_16913[(1)]);
if((state_val_16914 === (7))){
var inst_16894 = (state_16913[(7)]);
var inst_16894__$1 = (state_16913[(2)]);
var inst_16895 = (inst_16894__$1 == null);
var inst_16896 = cljs.core.not.call(null,inst_16895);
var state_16913__$1 = (function (){var statearr_16915 = state_16913;
(statearr_16915[(7)] = inst_16894__$1);

return statearr_16915;
})();
if(inst_16896){
var statearr_16916_16949 = state_16913__$1;
(statearr_16916_16949[(1)] = (8));

} else {
var statearr_16917_16953 = state_16913__$1;
(statearr_16917_16953[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (1))){
var inst_16889 = (0);
var state_16913__$1 = (function (){var statearr_16918 = state_16913;
(statearr_16918[(8)] = inst_16889);

return statearr_16918;
})();
var statearr_16919_16954 = state_16913__$1;
(statearr_16919_16954[(2)] = null);

(statearr_16919_16954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (4))){
var state_16913__$1 = state_16913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16913__$1,(7),ch);
} else {
if((state_val_16914 === (6))){
var inst_16908 = (state_16913[(2)]);
var state_16913__$1 = state_16913;
var statearr_16920_16955 = state_16913__$1;
(statearr_16920_16955[(2)] = inst_16908);

(statearr_16920_16955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (3))){
var inst_16910 = (state_16913[(2)]);
var inst_16911 = cljs.core.async.close_BANG_.call(null,out);
var state_16913__$1 = (function (){var statearr_16921 = state_16913;
(statearr_16921[(9)] = inst_16910);

return statearr_16921;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16913__$1,inst_16911);
} else {
if((state_val_16914 === (2))){
var inst_16889 = (state_16913[(8)]);
var inst_16891 = (inst_16889 < n);
var state_16913__$1 = state_16913;
if(cljs.core.truth_(inst_16891)){
var statearr_16922_16956 = state_16913__$1;
(statearr_16922_16956[(1)] = (4));

} else {
var statearr_16923_16958 = state_16913__$1;
(statearr_16923_16958[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (11))){
var inst_16889 = (state_16913[(8)]);
var inst_16899 = (state_16913[(2)]);
var inst_16900 = (inst_16889 + (1));
var inst_16889__$1 = inst_16900;
var state_16913__$1 = (function (){var statearr_16924 = state_16913;
(statearr_16924[(8)] = inst_16889__$1);

(statearr_16924[(10)] = inst_16899);

return statearr_16924;
})();
var statearr_16925_16959 = state_16913__$1;
(statearr_16925_16959[(2)] = null);

(statearr_16925_16959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (9))){
var state_16913__$1 = state_16913;
var statearr_16926_16960 = state_16913__$1;
(statearr_16926_16960[(2)] = null);

(statearr_16926_16960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (5))){
var state_16913__$1 = state_16913;
var statearr_16928_16961 = state_16913__$1;
(statearr_16928_16961[(2)] = null);

(statearr_16928_16961[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (10))){
var inst_16905 = (state_16913[(2)]);
var state_16913__$1 = state_16913;
var statearr_16930_16962 = state_16913__$1;
(statearr_16930_16962[(2)] = inst_16905);

(statearr_16930_16962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16914 === (8))){
var inst_16894 = (state_16913[(7)]);
var state_16913__$1 = state_16913;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16913__$1,(11),out,inst_16894);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16948,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16948,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16936 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16936[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16936[(1)] = (1));

return statearr_16936;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16913){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16937){if((e16937 instanceof Object)){
var ex__14240__auto__ = e16937;
var statearr_16938_16963 = state_16913;
(statearr_16938_16963[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16913);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16964 = state_16913;
state_16913 = G__16964;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16948,out))
})();
var state__14370__auto__ = (function (){var statearr_16939 = f__14369__auto__.call(null);
(statearr_16939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16948);

return statearr_16939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16948,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16972 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16972 = (function (map_LT_,f,ch,meta16973){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16974,meta16973__$1){
var self__ = this;
var _16974__$1 = this;
return (new cljs.core.async.t_cljs$core$async16972(self__.map_LT_,self__.f,self__.ch,meta16973__$1));
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16974){
var self__ = this;
var _16974__$1 = this;
return self__.meta16973;
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16975 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16975 = (function (map_LT_,f,ch,meta16973,_,fn1,meta16976){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this._ = _;
this.fn1 = fn1;
this.meta16976 = meta16976;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16977,meta16976__$1){
var self__ = this;
var _16977__$1 = this;
return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,self__._,self__.fn1,meta16976__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16977){
var self__ = this;
var _16977__$1 = this;
return self__.meta16976;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16965_SHARP_){
return f1.call(null,(((p1__16965_SHARP_ == null))?null:self__.f.call(null,p1__16965_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16972","cljs.core.async/t_cljs$core$async16972",1733444675,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16976","meta16976",163212366,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16975";

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16975");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16975 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976){
return (new cljs.core.async.t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16972.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null)], null);
});

cljs.core.async.t_cljs$core$async16972.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16972";

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16972");
});

cljs.core.async.__GT_t_cljs$core$async16972 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973){
return (new cljs.core.async.t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973));
});

}

return (new cljs.core.async.t_cljs$core$async16972(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16993 = (function (map_GT_,f,ch,meta16994){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16994 = meta16994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16995,meta16994__$1){
var self__ = this;
var _16995__$1 = this;
return (new cljs.core.async.t_cljs$core$async16993(self__.map_GT_,self__.f,self__.ch,meta16994__$1));
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16995){
var self__ = this;
var _16995__$1 = this;
return self__.meta16994;
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16994","meta16994",-1938814879,null)], null);
});

cljs.core.async.t_cljs$core$async16993.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16993";

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16993");
});

cljs.core.async.__GT_t_cljs$core$async16993 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994){
return (new cljs.core.async.t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994));
});

}

return (new cljs.core.async.t_cljs$core$async16993(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17002 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17002 = (function (filter_GT_,p,ch,meta17003){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta17003 = meta17003;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17004,meta17003__$1){
var self__ = this;
var _17004__$1 = this;
return (new cljs.core.async.t_cljs$core$async17002(self__.filter_GT_,self__.p,self__.ch,meta17003__$1));
});

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17004){
var self__ = this;
var _17004__$1 = this;
return self__.meta17003;
});

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async17002.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17002.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17003","meta17003",-1313374062,null)], null);
});

cljs.core.async.t_cljs$core$async17002.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17002.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17002";

cljs.core.async.t_cljs$core$async17002.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async17002");
});

cljs.core.async.__GT_t_cljs$core$async17002 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17002(filter_GT___$1,p__$1,ch__$1,meta17003){
return (new cljs.core.async.t_cljs$core$async17002(filter_GT___$1,p__$1,ch__$1,meta17003));
});

}

return (new cljs.core.async.t_cljs$core$async17002(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17010 = [];
var len__7107__auto___17054 = arguments.length;
var i__7108__auto___17055 = (0);
while(true){
if((i__7108__auto___17055 < len__7107__auto___17054)){
args17010.push((arguments[i__7108__auto___17055]));

var G__17056 = (i__7108__auto___17055 + (1));
i__7108__auto___17055 = G__17056;
continue;
} else {
}
break;
}

var G__17012 = args17010.length;
switch (G__17012) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17010.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17061 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17061,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17061,out){
return (function (state_17033){
var state_val_17034 = (state_17033[(1)]);
if((state_val_17034 === (7))){
var inst_17029 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17035_17063 = state_17033__$1;
(statearr_17035_17063[(2)] = inst_17029);

(statearr_17035_17063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (1))){
var state_17033__$1 = state_17033;
var statearr_17036_17064 = state_17033__$1;
(statearr_17036_17064[(2)] = null);

(statearr_17036_17064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (4))){
var inst_17015 = (state_17033[(7)]);
var inst_17015__$1 = (state_17033[(2)]);
var inst_17016 = (inst_17015__$1 == null);
var state_17033__$1 = (function (){var statearr_17037 = state_17033;
(statearr_17037[(7)] = inst_17015__$1);

return statearr_17037;
})();
if(cljs.core.truth_(inst_17016)){
var statearr_17038_17068 = state_17033__$1;
(statearr_17038_17068[(1)] = (5));

} else {
var statearr_17039_17069 = state_17033__$1;
(statearr_17039_17069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (6))){
var inst_17015 = (state_17033[(7)]);
var inst_17020 = p.call(null,inst_17015);
var state_17033__$1 = state_17033;
if(cljs.core.truth_(inst_17020)){
var statearr_17040_17070 = state_17033__$1;
(statearr_17040_17070[(1)] = (8));

} else {
var statearr_17041_17071 = state_17033__$1;
(statearr_17041_17071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (3))){
var inst_17031 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17033__$1,inst_17031);
} else {
if((state_val_17034 === (2))){
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17033__$1,(4),ch);
} else {
if((state_val_17034 === (11))){
var inst_17023 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17042_17073 = state_17033__$1;
(statearr_17042_17073[(2)] = inst_17023);

(statearr_17042_17073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (9))){
var state_17033__$1 = state_17033;
var statearr_17043_17074 = state_17033__$1;
(statearr_17043_17074[(2)] = null);

(statearr_17043_17074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (5))){
var inst_17018 = cljs.core.async.close_BANG_.call(null,out);
var state_17033__$1 = state_17033;
var statearr_17044_17075 = state_17033__$1;
(statearr_17044_17075[(2)] = inst_17018);

(statearr_17044_17075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (10))){
var inst_17026 = (state_17033[(2)]);
var state_17033__$1 = (function (){var statearr_17045 = state_17033;
(statearr_17045[(8)] = inst_17026);

return statearr_17045;
})();
var statearr_17046_17076 = state_17033__$1;
(statearr_17046_17076[(2)] = null);

(statearr_17046_17076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (8))){
var inst_17015 = (state_17033[(7)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17033__$1,(11),out,inst_17015);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17061,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17061,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17050 = [null,null,null,null,null,null,null,null,null];
(statearr_17050[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17050[(1)] = (1));

return statearr_17050;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17033){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17051){if((e17051 instanceof Object)){
var ex__14240__auto__ = e17051;
var statearr_17052_17077 = state_17033;
(statearr_17052_17077[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17078 = state_17033;
state_17033 = G__17078;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17033){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17061,out))
})();
var state__14370__auto__ = (function (){var statearr_17053 = f__14369__auto__.call(null);
(statearr_17053[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17061);

return statearr_17053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17061,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17079 = [];
var len__7107__auto___17082 = arguments.length;
var i__7108__auto___17083 = (0);
while(true){
if((i__7108__auto___17083 < len__7107__auto___17082)){
args17079.push((arguments[i__7108__auto___17083]));

var G__17084 = (i__7108__auto___17083 + (1));
i__7108__auto___17083 = G__17084;
continue;
} else {
}
break;
}

var G__17081 = args17079.length;
switch (G__17081) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17079.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_17263){
var state_val_17264 = (state_17263[(1)]);
if((state_val_17264 === (7))){
var inst_17259 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17265_17306 = state_17263__$1;
(statearr_17265_17306[(2)] = inst_17259);

(statearr_17265_17306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (20))){
var inst_17229 = (state_17263[(7)]);
var inst_17240 = (state_17263[(2)]);
var inst_17241 = cljs.core.next.call(null,inst_17229);
var inst_17214 = inst_17241;
var inst_17215 = null;
var inst_17216 = (0);
var inst_17217 = (0);
var state_17263__$1 = (function (){var statearr_17266 = state_17263;
(statearr_17266[(8)] = inst_17214);

(statearr_17266[(9)] = inst_17215);

(statearr_17266[(10)] = inst_17217);

(statearr_17266[(11)] = inst_17240);

(statearr_17266[(12)] = inst_17216);

return statearr_17266;
})();
var statearr_17267_17307 = state_17263__$1;
(statearr_17267_17307[(2)] = null);

(statearr_17267_17307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (1))){
var state_17263__$1 = state_17263;
var statearr_17268_17308 = state_17263__$1;
(statearr_17268_17308[(2)] = null);

(statearr_17268_17308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (4))){
var inst_17203 = (state_17263[(13)]);
var inst_17203__$1 = (state_17263[(2)]);
var inst_17204 = (inst_17203__$1 == null);
var state_17263__$1 = (function (){var statearr_17269 = state_17263;
(statearr_17269[(13)] = inst_17203__$1);

return statearr_17269;
})();
if(cljs.core.truth_(inst_17204)){
var statearr_17270_17309 = state_17263__$1;
(statearr_17270_17309[(1)] = (5));

} else {
var statearr_17271_17310 = state_17263__$1;
(statearr_17271_17310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (15))){
var state_17263__$1 = state_17263;
var statearr_17275_17311 = state_17263__$1;
(statearr_17275_17311[(2)] = null);

(statearr_17275_17311[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (21))){
var state_17263__$1 = state_17263;
var statearr_17276_17312 = state_17263__$1;
(statearr_17276_17312[(2)] = null);

(statearr_17276_17312[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (13))){
var inst_17214 = (state_17263[(8)]);
var inst_17215 = (state_17263[(9)]);
var inst_17217 = (state_17263[(10)]);
var inst_17216 = (state_17263[(12)]);
var inst_17225 = (state_17263[(2)]);
var inst_17226 = (inst_17217 + (1));
var tmp17272 = inst_17214;
var tmp17273 = inst_17215;
var tmp17274 = inst_17216;
var inst_17214__$1 = tmp17272;
var inst_17215__$1 = tmp17273;
var inst_17216__$1 = tmp17274;
var inst_17217__$1 = inst_17226;
var state_17263__$1 = (function (){var statearr_17277 = state_17263;
(statearr_17277[(14)] = inst_17225);

(statearr_17277[(8)] = inst_17214__$1);

(statearr_17277[(9)] = inst_17215__$1);

(statearr_17277[(10)] = inst_17217__$1);

(statearr_17277[(12)] = inst_17216__$1);

return statearr_17277;
})();
var statearr_17278_17313 = state_17263__$1;
(statearr_17278_17313[(2)] = null);

(statearr_17278_17313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (22))){
var state_17263__$1 = state_17263;
var statearr_17279_17314 = state_17263__$1;
(statearr_17279_17314[(2)] = null);

(statearr_17279_17314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (6))){
var inst_17203 = (state_17263[(13)]);
var inst_17212 = f.call(null,inst_17203);
var inst_17213 = cljs.core.seq.call(null,inst_17212);
var inst_17214 = inst_17213;
var inst_17215 = null;
var inst_17216 = (0);
var inst_17217 = (0);
var state_17263__$1 = (function (){var statearr_17280 = state_17263;
(statearr_17280[(8)] = inst_17214);

(statearr_17280[(9)] = inst_17215);

(statearr_17280[(10)] = inst_17217);

(statearr_17280[(12)] = inst_17216);

return statearr_17280;
})();
var statearr_17281_17315 = state_17263__$1;
(statearr_17281_17315[(2)] = null);

(statearr_17281_17315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (17))){
var inst_17229 = (state_17263[(7)]);
var inst_17233 = cljs.core.chunk_first.call(null,inst_17229);
var inst_17234 = cljs.core.chunk_rest.call(null,inst_17229);
var inst_17235 = cljs.core.count.call(null,inst_17233);
var inst_17214 = inst_17234;
var inst_17215 = inst_17233;
var inst_17216 = inst_17235;
var inst_17217 = (0);
var state_17263__$1 = (function (){var statearr_17282 = state_17263;
(statearr_17282[(8)] = inst_17214);

(statearr_17282[(9)] = inst_17215);

(statearr_17282[(10)] = inst_17217);

(statearr_17282[(12)] = inst_17216);

return statearr_17282;
})();
var statearr_17283_17317 = state_17263__$1;
(statearr_17283_17317[(2)] = null);

(statearr_17283_17317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (3))){
var inst_17261 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17263__$1,inst_17261);
} else {
if((state_val_17264 === (12))){
var inst_17249 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17284_17322 = state_17263__$1;
(statearr_17284_17322[(2)] = inst_17249);

(statearr_17284_17322[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (2))){
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17263__$1,(4),in$);
} else {
if((state_val_17264 === (23))){
var inst_17257 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17285_17324 = state_17263__$1;
(statearr_17285_17324[(2)] = inst_17257);

(statearr_17285_17324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (19))){
var inst_17244 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17286_17325 = state_17263__$1;
(statearr_17286_17325[(2)] = inst_17244);

(statearr_17286_17325[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (11))){
var inst_17229 = (state_17263[(7)]);
var inst_17214 = (state_17263[(8)]);
var inst_17229__$1 = cljs.core.seq.call(null,inst_17214);
var state_17263__$1 = (function (){var statearr_17287 = state_17263;
(statearr_17287[(7)] = inst_17229__$1);

return statearr_17287;
})();
if(inst_17229__$1){
var statearr_17288_17327 = state_17263__$1;
(statearr_17288_17327[(1)] = (14));

} else {
var statearr_17289_17328 = state_17263__$1;
(statearr_17289_17328[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (9))){
var inst_17251 = (state_17263[(2)]);
var inst_17252 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17263__$1 = (function (){var statearr_17290 = state_17263;
(statearr_17290[(15)] = inst_17251);

return statearr_17290;
})();
if(cljs.core.truth_(inst_17252)){
var statearr_17291_17330 = state_17263__$1;
(statearr_17291_17330[(1)] = (21));

} else {
var statearr_17292_17331 = state_17263__$1;
(statearr_17292_17331[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (5))){
var inst_17206 = cljs.core.async.close_BANG_.call(null,out);
var state_17263__$1 = state_17263;
var statearr_17293_17332 = state_17263__$1;
(statearr_17293_17332[(2)] = inst_17206);

(statearr_17293_17332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (14))){
var inst_17229 = (state_17263[(7)]);
var inst_17231 = cljs.core.chunked_seq_QMARK_.call(null,inst_17229);
var state_17263__$1 = state_17263;
if(inst_17231){
var statearr_17294_17334 = state_17263__$1;
(statearr_17294_17334[(1)] = (17));

} else {
var statearr_17295_17335 = state_17263__$1;
(statearr_17295_17335[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (16))){
var inst_17247 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17296_17336 = state_17263__$1;
(statearr_17296_17336[(2)] = inst_17247);

(statearr_17296_17336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (10))){
var inst_17215 = (state_17263[(9)]);
var inst_17217 = (state_17263[(10)]);
var inst_17223 = cljs.core._nth.call(null,inst_17215,inst_17217);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17263__$1,(13),out,inst_17223);
} else {
if((state_val_17264 === (18))){
var inst_17229 = (state_17263[(7)]);
var inst_17238 = cljs.core.first.call(null,inst_17229);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17263__$1,(20),out,inst_17238);
} else {
if((state_val_17264 === (8))){
var inst_17217 = (state_17263[(10)]);
var inst_17216 = (state_17263[(12)]);
var inst_17220 = (inst_17217 < inst_17216);
var inst_17221 = inst_17220;
var state_17263__$1 = state_17263;
if(cljs.core.truth_(inst_17221)){
var statearr_17297_17344 = state_17263__$1;
(statearr_17297_17344[(1)] = (10));

} else {
var statearr_17298_17345 = state_17263__$1;
(statearr_17298_17345[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17302[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17302[(1)] = (1));

return statearr_17302;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17263){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17303){if((e17303 instanceof Object)){
var ex__14240__auto__ = e17303;
var statearr_17304_17347 = state_17263;
(statearr_17304_17347[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17348 = state_17263;
state_17263 = G__17348;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17263){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_17305 = f__14369__auto__.call(null);
(statearr_17305[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_17305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17350 = [];
var len__7107__auto___17353 = arguments.length;
var i__7108__auto___17354 = (0);
while(true){
if((i__7108__auto___17354 < len__7107__auto___17353)){
args17350.push((arguments[i__7108__auto___17354]));

var G__17355 = (i__7108__auto___17354 + (1));
i__7108__auto___17354 = G__17355;
continue;
} else {
}
break;
}

var G__17352 = args17350.length;
switch (G__17352) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17350.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17357 = [];
var len__7107__auto___17360 = arguments.length;
var i__7108__auto___17361 = (0);
while(true){
if((i__7108__auto___17361 < len__7107__auto___17360)){
args17357.push((arguments[i__7108__auto___17361]));

var G__17363 = (i__7108__auto___17361 + (1));
i__7108__auto___17361 = G__17363;
continue;
} else {
}
break;
}

var G__17359 = args17357.length;
switch (G__17359) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17357.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17365 = [];
var len__7107__auto___17430 = arguments.length;
var i__7108__auto___17432 = (0);
while(true){
if((i__7108__auto___17432 < len__7107__auto___17430)){
args17365.push((arguments[i__7108__auto___17432]));

var G__17434 = (i__7108__auto___17432 + (1));
i__7108__auto___17432 = G__17434;
continue;
} else {
}
break;
}

var G__17367 = args17365.length;
switch (G__17367) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17365.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17436,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17436,out){
return (function (state_17395){
var state_val_17396 = (state_17395[(1)]);
if((state_val_17396 === (7))){
var inst_17386 = (state_17395[(2)]);
var state_17395__$1 = state_17395;
var statearr_17398_17437 = state_17395__$1;
(statearr_17398_17437[(2)] = inst_17386);

(statearr_17398_17437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (1))){
var inst_17368 = null;
var state_17395__$1 = (function (){var statearr_17399 = state_17395;
(statearr_17399[(7)] = inst_17368);

return statearr_17399;
})();
var statearr_17400_17439 = state_17395__$1;
(statearr_17400_17439[(2)] = null);

(statearr_17400_17439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (4))){
var inst_17371 = (state_17395[(8)]);
var inst_17371__$1 = (state_17395[(2)]);
var inst_17372 = (inst_17371__$1 == null);
var inst_17373 = cljs.core.not.call(null,inst_17372);
var state_17395__$1 = (function (){var statearr_17402 = state_17395;
(statearr_17402[(8)] = inst_17371__$1);

return statearr_17402;
})();
if(inst_17373){
var statearr_17403_17441 = state_17395__$1;
(statearr_17403_17441[(1)] = (5));

} else {
var statearr_17404_17442 = state_17395__$1;
(statearr_17404_17442[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (6))){
var state_17395__$1 = state_17395;
var statearr_17405_17443 = state_17395__$1;
(statearr_17405_17443[(2)] = null);

(statearr_17405_17443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (3))){
var inst_17388 = (state_17395[(2)]);
var inst_17389 = cljs.core.async.close_BANG_.call(null,out);
var state_17395__$1 = (function (){var statearr_17406 = state_17395;
(statearr_17406[(9)] = inst_17388);

return statearr_17406;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17395__$1,inst_17389);
} else {
if((state_val_17396 === (2))){
var state_17395__$1 = state_17395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17395__$1,(4),ch);
} else {
if((state_val_17396 === (11))){
var inst_17371 = (state_17395[(8)]);
var inst_17380 = (state_17395[(2)]);
var inst_17368 = inst_17371;
var state_17395__$1 = (function (){var statearr_17407 = state_17395;
(statearr_17407[(7)] = inst_17368);

(statearr_17407[(10)] = inst_17380);

return statearr_17407;
})();
var statearr_17408_17448 = state_17395__$1;
(statearr_17408_17448[(2)] = null);

(statearr_17408_17448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (9))){
var inst_17371 = (state_17395[(8)]);
var state_17395__$1 = state_17395;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17395__$1,(11),out,inst_17371);
} else {
if((state_val_17396 === (5))){
var inst_17371 = (state_17395[(8)]);
var inst_17368 = (state_17395[(7)]);
var inst_17375 = cljs.core._EQ_.call(null,inst_17371,inst_17368);
var state_17395__$1 = state_17395;
if(inst_17375){
var statearr_17410_17452 = state_17395__$1;
(statearr_17410_17452[(1)] = (8));

} else {
var statearr_17411_17454 = state_17395__$1;
(statearr_17411_17454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (10))){
var inst_17383 = (state_17395[(2)]);
var state_17395__$1 = state_17395;
var statearr_17412_17459 = state_17395__$1;
(statearr_17412_17459[(2)] = inst_17383);

(statearr_17412_17459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17396 === (8))){
var inst_17368 = (state_17395[(7)]);
var tmp17409 = inst_17368;
var inst_17368__$1 = tmp17409;
var state_17395__$1 = (function (){var statearr_17413 = state_17395;
(statearr_17413[(7)] = inst_17368__$1);

return statearr_17413;
})();
var statearr_17415_17462 = state_17395__$1;
(statearr_17415_17462[(2)] = null);

(statearr_17415_17462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17436,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17436,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17420 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17420[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17420[(1)] = (1));

return statearr_17420;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17395){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17425){if((e17425 instanceof Object)){
var ex__14240__auto__ = e17425;
var statearr_17426_17465 = state_17395;
(statearr_17426_17465[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17395);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17466 = state_17395;
state_17395 = G__17466;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17395){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17436,out))
})();
var state__14370__auto__ = (function (){var statearr_17428 = f__14369__auto__.call(null);
(statearr_17428[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17436);

return statearr_17428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17436,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17468 = [];
var len__7107__auto___17541 = arguments.length;
var i__7108__auto___17542 = (0);
while(true){
if((i__7108__auto___17542 < len__7107__auto___17541)){
args17468.push((arguments[i__7108__auto___17542]));

var G__17544 = (i__7108__auto___17542 + (1));
i__7108__auto___17542 = G__17544;
continue;
} else {
}
break;
}

var G__17470 = args17468.length;
switch (G__17470) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17468.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17546 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17546,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17546,out){
return (function (state_17508){
var state_val_17509 = (state_17508[(1)]);
if((state_val_17509 === (7))){
var inst_17504 = (state_17508[(2)]);
var state_17508__$1 = state_17508;
var statearr_17510_17550 = state_17508__$1;
(statearr_17510_17550[(2)] = inst_17504);

(statearr_17510_17550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (1))){
var inst_17471 = (new Array(n));
var inst_17472 = inst_17471;
var inst_17473 = (0);
var state_17508__$1 = (function (){var statearr_17511 = state_17508;
(statearr_17511[(7)] = inst_17473);

(statearr_17511[(8)] = inst_17472);

return statearr_17511;
})();
var statearr_17512_17551 = state_17508__$1;
(statearr_17512_17551[(2)] = null);

(statearr_17512_17551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (4))){
var inst_17476 = (state_17508[(9)]);
var inst_17476__$1 = (state_17508[(2)]);
var inst_17477 = (inst_17476__$1 == null);
var inst_17478 = cljs.core.not.call(null,inst_17477);
var state_17508__$1 = (function (){var statearr_17513 = state_17508;
(statearr_17513[(9)] = inst_17476__$1);

return statearr_17513;
})();
if(inst_17478){
var statearr_17514_17552 = state_17508__$1;
(statearr_17514_17552[(1)] = (5));

} else {
var statearr_17515_17553 = state_17508__$1;
(statearr_17515_17553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (15))){
var inst_17498 = (state_17508[(2)]);
var state_17508__$1 = state_17508;
var statearr_17516_17554 = state_17508__$1;
(statearr_17516_17554[(2)] = inst_17498);

(statearr_17516_17554[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (13))){
var state_17508__$1 = state_17508;
var statearr_17517_17555 = state_17508__$1;
(statearr_17517_17555[(2)] = null);

(statearr_17517_17555[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (6))){
var inst_17473 = (state_17508[(7)]);
var inst_17494 = (inst_17473 > (0));
var state_17508__$1 = state_17508;
if(cljs.core.truth_(inst_17494)){
var statearr_17518_17556 = state_17508__$1;
(statearr_17518_17556[(1)] = (12));

} else {
var statearr_17519_17557 = state_17508__$1;
(statearr_17519_17557[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (3))){
var inst_17506 = (state_17508[(2)]);
var state_17508__$1 = state_17508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17508__$1,inst_17506);
} else {
if((state_val_17509 === (12))){
var inst_17472 = (state_17508[(8)]);
var inst_17496 = cljs.core.vec.call(null,inst_17472);
var state_17508__$1 = state_17508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17508__$1,(15),out,inst_17496);
} else {
if((state_val_17509 === (2))){
var state_17508__$1 = state_17508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17508__$1,(4),ch);
} else {
if((state_val_17509 === (11))){
var inst_17488 = (state_17508[(2)]);
var inst_17489 = (new Array(n));
var inst_17472 = inst_17489;
var inst_17473 = (0);
var state_17508__$1 = (function (){var statearr_17520 = state_17508;
(statearr_17520[(7)] = inst_17473);

(statearr_17520[(8)] = inst_17472);

(statearr_17520[(10)] = inst_17488);

return statearr_17520;
})();
var statearr_17521_17559 = state_17508__$1;
(statearr_17521_17559[(2)] = null);

(statearr_17521_17559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (9))){
var inst_17472 = (state_17508[(8)]);
var inst_17486 = cljs.core.vec.call(null,inst_17472);
var state_17508__$1 = state_17508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17508__$1,(11),out,inst_17486);
} else {
if((state_val_17509 === (5))){
var inst_17481 = (state_17508[(11)]);
var inst_17473 = (state_17508[(7)]);
var inst_17472 = (state_17508[(8)]);
var inst_17476 = (state_17508[(9)]);
var inst_17480 = (inst_17472[inst_17473] = inst_17476);
var inst_17481__$1 = (inst_17473 + (1));
var inst_17482 = (inst_17481__$1 < n);
var state_17508__$1 = (function (){var statearr_17522 = state_17508;
(statearr_17522[(11)] = inst_17481__$1);

(statearr_17522[(12)] = inst_17480);

return statearr_17522;
})();
if(cljs.core.truth_(inst_17482)){
var statearr_17523_17560 = state_17508__$1;
(statearr_17523_17560[(1)] = (8));

} else {
var statearr_17524_17561 = state_17508__$1;
(statearr_17524_17561[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (14))){
var inst_17501 = (state_17508[(2)]);
var inst_17502 = cljs.core.async.close_BANG_.call(null,out);
var state_17508__$1 = (function (){var statearr_17526 = state_17508;
(statearr_17526[(13)] = inst_17501);

return statearr_17526;
})();
var statearr_17527_17562 = state_17508__$1;
(statearr_17527_17562[(2)] = inst_17502);

(statearr_17527_17562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (10))){
var inst_17492 = (state_17508[(2)]);
var state_17508__$1 = state_17508;
var statearr_17528_17563 = state_17508__$1;
(statearr_17528_17563[(2)] = inst_17492);

(statearr_17528_17563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17509 === (8))){
var inst_17481 = (state_17508[(11)]);
var inst_17472 = (state_17508[(8)]);
var tmp17525 = inst_17472;
var inst_17472__$1 = tmp17525;
var inst_17473 = inst_17481;
var state_17508__$1 = (function (){var statearr_17529 = state_17508;
(statearr_17529[(7)] = inst_17473);

(statearr_17529[(8)] = inst_17472__$1);

return statearr_17529;
})();
var statearr_17530_17564 = state_17508__$1;
(statearr_17530_17564[(2)] = null);

(statearr_17530_17564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17546,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17546,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17536[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17536[(1)] = (1));

return statearr_17536;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17508){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17537){if((e17537 instanceof Object)){
var ex__14240__auto__ = e17537;
var statearr_17538_17565 = state_17508;
(statearr_17538_17565[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17566 = state_17508;
state_17508 = G__17566;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17508){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17546,out))
})();
var state__14370__auto__ = (function (){var statearr_17540 = f__14369__auto__.call(null);
(statearr_17540[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17546);

return statearr_17540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17546,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17567 = [];
var len__7107__auto___17648 = arguments.length;
var i__7108__auto___17649 = (0);
while(true){
if((i__7108__auto___17649 < len__7107__auto___17648)){
args17567.push((arguments[i__7108__auto___17649]));

var G__17650 = (i__7108__auto___17649 + (1));
i__7108__auto___17649 = G__17650;
continue;
} else {
}
break;
}

var G__17569 = args17567.length;
switch (G__17569) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17567.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17652,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17652,out){
return (function (state_17611){
var state_val_17612 = (state_17611[(1)]);
if((state_val_17612 === (7))){
var inst_17607 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17613_17654 = state_17611__$1;
(statearr_17613_17654[(2)] = inst_17607);

(statearr_17613_17654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (1))){
var inst_17570 = [];
var inst_17571 = inst_17570;
var inst_17572 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17611__$1 = (function (){var statearr_17616 = state_17611;
(statearr_17616[(7)] = inst_17571);

(statearr_17616[(8)] = inst_17572);

return statearr_17616;
})();
var statearr_17617_17655 = state_17611__$1;
(statearr_17617_17655[(2)] = null);

(statearr_17617_17655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (4))){
var inst_17575 = (state_17611[(9)]);
var inst_17575__$1 = (state_17611[(2)]);
var inst_17576 = (inst_17575__$1 == null);
var inst_17577 = cljs.core.not.call(null,inst_17576);
var state_17611__$1 = (function (){var statearr_17618 = state_17611;
(statearr_17618[(9)] = inst_17575__$1);

return statearr_17618;
})();
if(inst_17577){
var statearr_17620_17656 = state_17611__$1;
(statearr_17620_17656[(1)] = (5));

} else {
var statearr_17621_17657 = state_17611__$1;
(statearr_17621_17657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (15))){
var inst_17601 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17622_17658 = state_17611__$1;
(statearr_17622_17658[(2)] = inst_17601);

(statearr_17622_17658[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (13))){
var state_17611__$1 = state_17611;
var statearr_17623_17659 = state_17611__$1;
(statearr_17623_17659[(2)] = null);

(statearr_17623_17659[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (6))){
var inst_17571 = (state_17611[(7)]);
var inst_17596 = inst_17571.length;
var inst_17597 = (inst_17596 > (0));
var state_17611__$1 = state_17611;
if(cljs.core.truth_(inst_17597)){
var statearr_17624_17660 = state_17611__$1;
(statearr_17624_17660[(1)] = (12));

} else {
var statearr_17625_17661 = state_17611__$1;
(statearr_17625_17661[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (3))){
var inst_17609 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17611__$1,inst_17609);
} else {
if((state_val_17612 === (12))){
var inst_17571 = (state_17611[(7)]);
var inst_17599 = cljs.core.vec.call(null,inst_17571);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17611__$1,(15),out,inst_17599);
} else {
if((state_val_17612 === (2))){
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17611__$1,(4),ch);
} else {
if((state_val_17612 === (11))){
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17589 = (state_17611[(2)]);
var inst_17590 = [];
var inst_17591 = inst_17590.push(inst_17575);
var inst_17571 = inst_17590;
var inst_17572 = inst_17579;
var state_17611__$1 = (function (){var statearr_17627 = state_17611;
(statearr_17627[(7)] = inst_17571);

(statearr_17627[(8)] = inst_17572);

(statearr_17627[(11)] = inst_17591);

(statearr_17627[(12)] = inst_17589);

return statearr_17627;
})();
var statearr_17628_17662 = state_17611__$1;
(statearr_17628_17662[(2)] = null);

(statearr_17628_17662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (9))){
var inst_17571 = (state_17611[(7)]);
var inst_17587 = cljs.core.vec.call(null,inst_17571);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17611__$1,(11),out,inst_17587);
} else {
if((state_val_17612 === (5))){
var inst_17572 = (state_17611[(8)]);
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17579__$1 = f.call(null,inst_17575);
var inst_17580 = cljs.core._EQ_.call(null,inst_17579__$1,inst_17572);
var inst_17581 = cljs.core.keyword_identical_QMARK_.call(null,inst_17572,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17582 = (inst_17580) || (inst_17581);
var state_17611__$1 = (function (){var statearr_17629 = state_17611;
(statearr_17629[(10)] = inst_17579__$1);

return statearr_17629;
})();
if(cljs.core.truth_(inst_17582)){
var statearr_17630_17663 = state_17611__$1;
(statearr_17630_17663[(1)] = (8));

} else {
var statearr_17631_17664 = state_17611__$1;
(statearr_17631_17664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (14))){
var inst_17604 = (state_17611[(2)]);
var inst_17605 = cljs.core.async.close_BANG_.call(null,out);
var state_17611__$1 = (function (){var statearr_17633 = state_17611;
(statearr_17633[(13)] = inst_17604);

return statearr_17633;
})();
var statearr_17634_17665 = state_17611__$1;
(statearr_17634_17665[(2)] = inst_17605);

(statearr_17634_17665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (10))){
var inst_17594 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17635_17666 = state_17611__$1;
(statearr_17635_17666[(2)] = inst_17594);

(statearr_17635_17666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (8))){
var inst_17571 = (state_17611[(7)]);
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17584 = inst_17571.push(inst_17575);
var tmp17632 = inst_17571;
var inst_17571__$1 = tmp17632;
var inst_17572 = inst_17579;
var state_17611__$1 = (function (){var statearr_17636 = state_17611;
(statearr_17636[(14)] = inst_17584);

(statearr_17636[(7)] = inst_17571__$1);

(statearr_17636[(8)] = inst_17572);

return statearr_17636;
})();
var statearr_17637_17667 = state_17611__$1;
(statearr_17637_17667[(2)] = null);

(statearr_17637_17667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17652,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17652,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17644[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17644[(1)] = (1));

return statearr_17644;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17611){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17645){if((e17645 instanceof Object)){
var ex__14240__auto__ = e17645;
var statearr_17646_17675 = state_17611;
(statearr_17646_17675[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17676 = state_17611;
state_17611 = G__17676;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17611){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17652,out))
})();
var state__14370__auto__ = (function (){var statearr_17647 = f__14369__auto__.call(null);
(statearr_17647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17652);

return statearr_17647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17652,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472560496197