// Compiled by ClojureScript 1.7.228 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__12382_12389 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__12383_12390 = null;
var count__12384_12391 = (0);
var i__12385_12392 = (0);
while(true){
if((i__12385_12392 < count__12384_12391)){
var k_12396 = cljs.core._nth.call(null,chunk__12383_12390,i__12385_12392);
var v_12397 = (b[k_12396]);
(a[k_12396] = v_12397);

var G__12398 = seq__12382_12389;
var G__12399 = chunk__12383_12390;
var G__12400 = count__12384_12391;
var G__12401 = (i__12385_12392 + (1));
seq__12382_12389 = G__12398;
chunk__12383_12390 = G__12399;
count__12384_12391 = G__12400;
i__12385_12392 = G__12401;
continue;
} else {
var temp__4657__auto___12410 = cljs.core.seq.call(null,seq__12382_12389);
if(temp__4657__auto___12410){
var seq__12382_12411__$1 = temp__4657__auto___12410;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12382_12411__$1)){
var c__6852__auto___12413 = cljs.core.chunk_first.call(null,seq__12382_12411__$1);
var G__12415 = cljs.core.chunk_rest.call(null,seq__12382_12411__$1);
var G__12416 = c__6852__auto___12413;
var G__12417 = cljs.core.count.call(null,c__6852__auto___12413);
var G__12418 = (0);
seq__12382_12389 = G__12415;
chunk__12383_12390 = G__12416;
count__12384_12391 = G__12417;
i__12385_12392 = G__12418;
continue;
} else {
var k_12419 = cljs.core.first.call(null,seq__12382_12411__$1);
var v_12421 = (b[k_12419]);
(a[k_12419] = v_12421);

var G__12425 = cljs.core.next.call(null,seq__12382_12411__$1);
var G__12426 = null;
var G__12427 = (0);
var G__12428 = (0);
seq__12382_12389 = G__12425;
chunk__12383_12390 = G__12426;
count__12384_12391 = G__12427;
i__12385_12392 = G__12428;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args12459 = [];
var len__7107__auto___12469 = arguments.length;
var i__7108__auto___12470 = (0);
while(true){
if((i__7108__auto___12470 < len__7107__auto___12469)){
args12459.push((arguments[i__7108__auto___12470]));

var G__12471 = (i__7108__auto___12470 + (1));
i__7108__auto___12470 = G__12471;
continue;
} else {
}
break;
}

var G__12464 = args12459.length;
switch (G__12464) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12459.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__12475 = (i + (2));
var G__12476 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__12475;
ret = G__12476;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__12502_12517 = cljs.core.seq.call(null,v);
var chunk__12503_12518 = null;
var count__12504_12519 = (0);
var i__12505_12520 = (0);
while(true){
if((i__12505_12520 < count__12504_12519)){
var x_12523 = cljs.core._nth.call(null,chunk__12503_12518,i__12505_12520);
ret.push(x_12523);

var G__12525 = seq__12502_12517;
var G__12526 = chunk__12503_12518;
var G__12527 = count__12504_12519;
var G__12528 = (i__12505_12520 + (1));
seq__12502_12517 = G__12525;
chunk__12503_12518 = G__12526;
count__12504_12519 = G__12527;
i__12505_12520 = G__12528;
continue;
} else {
var temp__4657__auto___12532 = cljs.core.seq.call(null,seq__12502_12517);
if(temp__4657__auto___12532){
var seq__12502_12549__$1 = temp__4657__auto___12532;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12502_12549__$1)){
var c__6852__auto___12550 = cljs.core.chunk_first.call(null,seq__12502_12549__$1);
var G__12551 = cljs.core.chunk_rest.call(null,seq__12502_12549__$1);
var G__12552 = c__6852__auto___12550;
var G__12553 = cljs.core.count.call(null,c__6852__auto___12550);
var G__12554 = (0);
seq__12502_12517 = G__12551;
chunk__12503_12518 = G__12552;
count__12504_12519 = G__12553;
i__12505_12520 = G__12554;
continue;
} else {
var x_12557 = cljs.core.first.call(null,seq__12502_12549__$1);
ret.push(x_12557);

var G__12559 = cljs.core.next.call(null,seq__12502_12549__$1);
var G__12560 = null;
var G__12561 = (0);
var G__12562 = (0);
seq__12502_12517 = G__12559;
chunk__12503_12518 = G__12560;
count__12504_12519 = G__12561;
i__12505_12520 = G__12562;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__12565_12573 = cljs.core.seq.call(null,v);
var chunk__12566_12574 = null;
var count__12567_12575 = (0);
var i__12568_12576 = (0);
while(true){
if((i__12568_12576 < count__12567_12575)){
var x_12577 = cljs.core._nth.call(null,chunk__12566_12574,i__12568_12576);
ret.push(x_12577);

var G__12578 = seq__12565_12573;
var G__12579 = chunk__12566_12574;
var G__12580 = count__12567_12575;
var G__12581 = (i__12568_12576 + (1));
seq__12565_12573 = G__12578;
chunk__12566_12574 = G__12579;
count__12567_12575 = G__12580;
i__12568_12576 = G__12581;
continue;
} else {
var temp__4657__auto___12582 = cljs.core.seq.call(null,seq__12565_12573);
if(temp__4657__auto___12582){
var seq__12565_12583__$1 = temp__4657__auto___12582;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12565_12583__$1)){
var c__6852__auto___12584 = cljs.core.chunk_first.call(null,seq__12565_12583__$1);
var G__12585 = cljs.core.chunk_rest.call(null,seq__12565_12583__$1);
var G__12586 = c__6852__auto___12584;
var G__12587 = cljs.core.count.call(null,c__6852__auto___12584);
var G__12588 = (0);
seq__12565_12573 = G__12585;
chunk__12566_12574 = G__12586;
count__12567_12575 = G__12587;
i__12568_12576 = G__12588;
continue;
} else {
var x_12589 = cljs.core.first.call(null,seq__12565_12583__$1);
ret.push(x_12589);

var G__12590 = cljs.core.next.call(null,seq__12565_12583__$1);
var G__12591 = null;
var G__12592 = (0);
var G__12593 = (0);
seq__12565_12573 = G__12590;
chunk__12566_12574 = G__12591;
count__12567_12575 = G__12592;
i__12568_12576 = G__12593;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__12598_12631 = cljs.core.seq.call(null,v);
var chunk__12599_12632 = null;
var count__12600_12633 = (0);
var i__12601_12634 = (0);
while(true){
if((i__12601_12634 < count__12600_12633)){
var x_12635 = cljs.core._nth.call(null,chunk__12599_12632,i__12601_12634);
ret.push(x_12635);

var G__12636 = seq__12598_12631;
var G__12637 = chunk__12599_12632;
var G__12638 = count__12600_12633;
var G__12639 = (i__12601_12634 + (1));
seq__12598_12631 = G__12636;
chunk__12599_12632 = G__12637;
count__12600_12633 = G__12638;
i__12601_12634 = G__12639;
continue;
} else {
var temp__4657__auto___12640 = cljs.core.seq.call(null,seq__12598_12631);
if(temp__4657__auto___12640){
var seq__12598_12649__$1 = temp__4657__auto___12640;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12598_12649__$1)){
var c__6852__auto___12650 = cljs.core.chunk_first.call(null,seq__12598_12649__$1);
var G__12651 = cljs.core.chunk_rest.call(null,seq__12598_12649__$1);
var G__12652 = c__6852__auto___12650;
var G__12653 = cljs.core.count.call(null,c__6852__auto___12650);
var G__12654 = (0);
seq__12598_12631 = G__12651;
chunk__12599_12632 = G__12652;
count__12600_12633 = G__12653;
i__12601_12634 = G__12654;
continue;
} else {
var x_12655 = cljs.core.first.call(null,seq__12598_12649__$1);
ret.push(x_12655);

var G__12656 = cljs.core.next.call(null,seq__12598_12649__$1);
var G__12657 = null;
var G__12658 = (0);
var G__12659 = (0);
seq__12598_12631 = G__12656;
chunk__12599_12632 = G__12657;
count__12600_12633 = G__12658;
i__12601_12634 = G__12659;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args12660 = [];
var len__7107__auto___12688 = arguments.length;
var i__7108__auto___12689 = (0);
while(true){
if((i__7108__auto___12689 < len__7107__auto___12688)){
args12660.push((arguments[i__7108__auto___12689]));

var G__12690 = (i__7108__auto___12689 + (1));
i__7108__auto___12689 = G__12690;
continue;
} else {
}
break;
}

var G__12662 = args12660.length;
switch (G__12662) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12660.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__12675 = obj;
G__12675.push(kfn.call(null,k),vfn.call(null,v));

return G__12675;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x12679 = cljs.core.clone.call(null,handlers);
x12679.forEach = ((function (x12679,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__12680 = cljs.core.seq.call(null,coll);
var chunk__12681 = null;
var count__12682 = (0);
var i__12683 = (0);
while(true){
if((i__12683 < count__12682)){
var vec__12684 = cljs.core._nth.call(null,chunk__12681,i__12683);
var k = cljs.core.nth.call(null,vec__12684,(0),null);
var v = cljs.core.nth.call(null,vec__12684,(1),null);
f.call(null,v,k);

var G__12700 = seq__12680;
var G__12701 = chunk__12681;
var G__12702 = count__12682;
var G__12703 = (i__12683 + (1));
seq__12680 = G__12700;
chunk__12681 = G__12701;
count__12682 = G__12702;
i__12683 = G__12703;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__12680);
if(temp__4657__auto__){
var seq__12680__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12680__$1)){
var c__6852__auto__ = cljs.core.chunk_first.call(null,seq__12680__$1);
var G__12704 = cljs.core.chunk_rest.call(null,seq__12680__$1);
var G__12705 = c__6852__auto__;
var G__12706 = cljs.core.count.call(null,c__6852__auto__);
var G__12707 = (0);
seq__12680 = G__12704;
chunk__12681 = G__12705;
count__12682 = G__12706;
i__12683 = G__12707;
continue;
} else {
var vec__12687 = cljs.core.first.call(null,seq__12680__$1);
var k = cljs.core.nth.call(null,vec__12687,(0),null);
var v = cljs.core.nth.call(null,vec__12687,(1),null);
f.call(null,v,k);

var G__12711 = cljs.core.next.call(null,seq__12680__$1);
var G__12712 = null;
var G__12713 = (0);
var G__12714 = (0);
seq__12680 = G__12711;
chunk__12681 = G__12712;
count__12682 = G__12713;
i__12683 = G__12714;
continue;
}
} else {
return null;
}
}
break;
}
});})(x12679,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x12679;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args12719 = [];
var len__7107__auto___12739 = arguments.length;
var i__7108__auto___12740 = (0);
while(true){
if((i__7108__auto___12740 < len__7107__auto___12739)){
args12719.push((arguments[i__7108__auto___12740]));

var G__12741 = (i__7108__auto___12740 + (1));
i__7108__auto___12740 = G__12741;
continue;
} else {
}
break;
}

var G__12723 = args12719.length;
switch (G__12723) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12719.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit12727 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit12727 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta12728){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta12728 = meta12728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit12727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12729,meta12728__$1){
var self__ = this;
var _12729__$1 = this;
return (new cognitect.transit.t_cognitect$transit12727(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta12728__$1));
});

cognitect.transit.t_cognitect$transit12727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12729){
var self__ = this;
var _12729__$1 = this;
return self__.meta12728;
});

cognitect.transit.t_cognitect$transit12727.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit12727.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit12727.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit12727.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(self__.verbose_handler_fn){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit12727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta12728","meta12728",-1358061942,null)], null);
});

cognitect.transit.t_cognitect$transit12727.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit12727.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit12727";

cognitect.transit.t_cognitect$transit12727.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cognitect.transit/t_cognitect$transit12727");
});

cognitect.transit.__GT_t_cognitect$transit12727 = (function cognitect$transit$__GT_t_cognitect$transit12727(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta12728){
return (new cognitect.transit.t_cognitect$transit12727(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta12728));
});

}

return (new cognitect.transit.t_cognitect$transit12727(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__6049__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1472560492860