// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14427 = [];
var len__7107__auto___14435 = arguments.length;
var i__7108__auto___14436 = (0);
while(true){
if((i__7108__auto___14436 < len__7107__auto___14435)){
args14427.push((arguments[i__7108__auto___14436]));

var G__14439 = (i__7108__auto___14436 + (1));
i__7108__auto___14436 = G__14439;
continue;
} else {
}
break;
}

var G__14429 = args14427.length;
switch (G__14429) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14427.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14430 = (function (f,blockable,meta14431){
this.f = f;
this.blockable = blockable;
this.meta14431 = meta14431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14432,meta14431__$1){
var self__ = this;
var _14432__$1 = this;
return (new cljs.core.async.t_cljs$core$async14430(self__.f,self__.blockable,meta14431__$1));
});

cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14432){
var self__ = this;
var _14432__$1 = this;
return self__.meta14431;
});

cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14430.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14431","meta14431",-833996315,null)], null);
});

cljs.core.async.t_cljs$core$async14430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14430";

cljs.core.async.t_cljs$core$async14430.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14430");
});

cljs.core.async.__GT_t_cljs$core$async14430 = (function cljs$core$async$__GT_t_cljs$core$async14430(f__$1,blockable__$1,meta14431){
return (new cljs.core.async.t_cljs$core$async14430(f__$1,blockable__$1,meta14431));
});

}

return (new cljs.core.async.t_cljs$core$async14430(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14448 = [];
var len__7107__auto___14457 = arguments.length;
var i__7108__auto___14458 = (0);
while(true){
if((i__7108__auto___14458 < len__7107__auto___14457)){
args14448.push((arguments[i__7108__auto___14458]));

var G__14459 = (i__7108__auto___14458 + (1));
i__7108__auto___14458 = G__14459;
continue;
} else {
}
break;
}

var G__14454 = args14448.length;
switch (G__14454) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14448.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14464 = [];
var len__7107__auto___14467 = arguments.length;
var i__7108__auto___14468 = (0);
while(true){
if((i__7108__auto___14468 < len__7107__auto___14467)){
args14464.push((arguments[i__7108__auto___14468]));

var G__14469 = (i__7108__auto___14468 + (1));
i__7108__auto___14468 = G__14469;
continue;
} else {
}
break;
}

var G__14466 = args14464.length;
switch (G__14466) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14464.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14477 = [];
var len__7107__auto___14483 = arguments.length;
var i__7108__auto___14484 = (0);
while(true){
if((i__7108__auto___14484 < len__7107__auto___14483)){
args14477.push((arguments[i__7108__auto___14484]));

var G__14485 = (i__7108__auto___14484 + (1));
i__7108__auto___14484 = G__14485;
continue;
} else {
}
break;
}

var G__14479 = args14477.length;
switch (G__14479) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14477.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14490 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14490);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14490,ret){
return (function (){
return fn1.call(null,val_14490);
});})(val_14490,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14492 = [];
var len__7107__auto___14495 = arguments.length;
var i__7108__auto___14496 = (0);
while(true){
if((i__7108__auto___14496 < len__7107__auto___14495)){
args14492.push((arguments[i__7108__auto___14496]));

var G__14497 = (i__7108__auto___14496 + (1));
i__7108__auto___14496 = G__14497;
continue;
} else {
}
break;
}

var G__14494 = args14492.length;
switch (G__14494) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14492.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14499 = n;
var x_14500 = (0);
while(true){
if((x_14500 < n__6952__auto___14499)){
(a[x_14500] = (0));

var G__14501 = (x_14500 + (1));
x_14500 = G__14501;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14502 = (i + (1));
i = G__14502;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14506 = (function (alt_flag,flag,meta14507){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14507 = meta14507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14508,meta14507__$1){
var self__ = this;
var _14508__$1 = this;
return (new cljs.core.async.t_cljs$core$async14506(self__.alt_flag,self__.flag,meta14507__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14508){
var self__ = this;
var _14508__$1 = this;
return self__.meta14507;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14507","meta14507",-708852072,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14506";

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14506");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14506 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507){
return (new cljs.core.async.t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14506(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14518 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14518 = (function (alt_handler,flag,cb,meta14519){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14519 = meta14519;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14520,meta14519__$1){
var self__ = this;
var _14520__$1 = this;
return (new cljs.core.async.t_cljs$core$async14518(self__.alt_handler,self__.flag,self__.cb,meta14519__$1));
});

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14520){
var self__ = this;
var _14520__$1 = this;
return self__.meta14519;
});

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14518.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14519","meta14519",-316517557,null)], null);
});

cljs.core.async.t_cljs$core$async14518.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14518.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14518";

cljs.core.async.t_cljs$core$async14518.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14518");
});

cljs.core.async.__GT_t_cljs$core$async14518 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14518(alt_handler__$1,flag__$1,cb__$1,meta14519){
return (new cljs.core.async.t_cljs$core$async14518(alt_handler__$1,flag__$1,cb__$1,meta14519));
});

}

return (new cljs.core.async.t_cljs$core$async14518(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14527_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14527_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14528_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14528_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14536 = (i + (1));
i = G__14536;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14545 = arguments.length;
var i__7108__auto___14546 = (0);
while(true){
if((i__7108__auto___14546 < len__7107__auto___14545)){
args__7114__auto__.push((arguments[i__7108__auto___14546]));

var G__14549 = (i__7108__auto___14546 + (1));
i__7108__auto___14546 = G__14549;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14541){
var map__14542 = p__14541;
var map__14542__$1 = ((((!((map__14542 == null)))?((((map__14542.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14542.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14542):map__14542);
var opts = map__14542__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14537){
var G__14538 = cljs.core.first.call(null,seq14537);
var seq14537__$1 = cljs.core.next.call(null,seq14537);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14538,seq14537__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14559 = [];
var len__7107__auto___14630 = arguments.length;
var i__7108__auto___14631 = (0);
while(true){
if((i__7108__auto___14631 < len__7107__auto___14630)){
args14559.push((arguments[i__7108__auto___14631]));

var G__14632 = (i__7108__auto___14631 + (1));
i__7108__auto___14631 = G__14632;
continue;
} else {
}
break;
}

var G__14562 = args14559.length;
switch (G__14562) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14559.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14375__auto___14634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___14634){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___14634){
return (function (state_14599){
var state_val_14600 = (state_14599[(1)]);
if((state_val_14600 === (7))){
var inst_14592 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14606_14635 = state_14599__$1;
(statearr_14606_14635[(2)] = inst_14592);

(statearr_14606_14635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (1))){
var state_14599__$1 = state_14599;
var statearr_14607_14636 = state_14599__$1;
(statearr_14607_14636[(2)] = null);

(statearr_14607_14636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (4))){
var inst_14573 = (state_14599[(7)]);
var inst_14573__$1 = (state_14599[(2)]);
var inst_14574 = (inst_14573__$1 == null);
var state_14599__$1 = (function (){var statearr_14608 = state_14599;
(statearr_14608[(7)] = inst_14573__$1);

return statearr_14608;
})();
if(cljs.core.truth_(inst_14574)){
var statearr_14609_14637 = state_14599__$1;
(statearr_14609_14637[(1)] = (5));

} else {
var statearr_14610_14638 = state_14599__$1;
(statearr_14610_14638[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (13))){
var state_14599__$1 = state_14599;
var statearr_14611_14639 = state_14599__$1;
(statearr_14611_14639[(2)] = null);

(statearr_14611_14639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (6))){
var inst_14573 = (state_14599[(7)]);
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14599__$1,(11),to,inst_14573);
} else {
if((state_val_14600 === (3))){
var inst_14596 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14599__$1,inst_14596);
} else {
if((state_val_14600 === (12))){
var state_14599__$1 = state_14599;
var statearr_14612_14640 = state_14599__$1;
(statearr_14612_14640[(2)] = null);

(statearr_14612_14640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (2))){
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14599__$1,(4),from);
} else {
if((state_val_14600 === (11))){
var inst_14585 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
if(cljs.core.truth_(inst_14585)){
var statearr_14613_14644 = state_14599__$1;
(statearr_14613_14644[(1)] = (12));

} else {
var statearr_14615_14645 = state_14599__$1;
(statearr_14615_14645[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (9))){
var state_14599__$1 = state_14599;
var statearr_14617_14647 = state_14599__$1;
(statearr_14617_14647[(2)] = null);

(statearr_14617_14647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (5))){
var state_14599__$1 = state_14599;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14618_14648 = state_14599__$1;
(statearr_14618_14648[(1)] = (8));

} else {
var statearr_14619_14649 = state_14599__$1;
(statearr_14619_14649[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (14))){
var inst_14590 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14620_14650 = state_14599__$1;
(statearr_14620_14650[(2)] = inst_14590);

(statearr_14620_14650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (10))){
var inst_14582 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14621_14654 = state_14599__$1;
(statearr_14621_14654[(2)] = inst_14582);

(statearr_14621_14654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (8))){
var inst_14579 = cljs.core.async.close_BANG_.call(null,to);
var state_14599__$1 = state_14599;
var statearr_14622_14655 = state_14599__$1;
(statearr_14622_14655[(2)] = inst_14579);

(statearr_14622_14655[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___14634))
;
return ((function (switch__14236__auto__,c__14375__auto___14634){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14626 = [null,null,null,null,null,null,null,null];
(statearr_14626[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14626[(1)] = (1));

return statearr_14626;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14599){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14627){if((e14627 instanceof Object)){
var ex__14240__auto__ = e14627;
var statearr_14628_14657 = state_14599;
(statearr_14628_14657[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14599);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14658 = state_14599;
state_14599 = G__14658;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___14634))
})();
var state__14377__auto__ = (function (){var statearr_14629 = f__14376__auto__.call(null);
(statearr_14629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___14634);

return statearr_14629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___14634))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14842){
var vec__14843 = p__14842;
var v = cljs.core.nth.call(null,vec__14843,(0),null);
var p = cljs.core.nth.call(null,vec__14843,(1),null);
var job = vec__14843;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14375__auto___15029 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results){
return (function (state_14848){
var state_val_14849 = (state_14848[(1)]);
if((state_val_14849 === (1))){
var state_14848__$1 = state_14848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14848__$1,(2),res,v);
} else {
if((state_val_14849 === (2))){
var inst_14845 = (state_14848[(2)]);
var inst_14846 = cljs.core.async.close_BANG_.call(null,res);
var state_14848__$1 = (function (){var statearr_14850 = state_14848;
(statearr_14850[(7)] = inst_14845);

return statearr_14850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14848__$1,inst_14846);
} else {
return null;
}
}
});})(c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null,null];
(statearr_14854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14848){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14855){if((e14855 instanceof Object)){
var ex__14240__auto__ = e14855;
var statearr_14856_15036 = state_14848;
(statearr_14856_15036[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15041 = state_14848;
state_14848 = G__15041;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results))
})();
var state__14377__auto__ = (function (){var statearr_14857 = f__14376__auto__.call(null);
(statearr_14857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15029);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15029,res,vec__14843,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14858){
var vec__14859 = p__14858;
var v = cljs.core.nth.call(null,vec__14859,(0),null);
var p = cljs.core.nth.call(null,vec__14859,(1),null);
var job = vec__14859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15042 = n;
var __15043 = (0);
while(true){
if((__15043 < n__6952__auto___15042)){
var G__14860_15044 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14860_15044) {
case "compute":
var c__14375__auto___15046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15043,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (__15043,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function (state_14873){
var state_val_14874 = (state_14873[(1)]);
if((state_val_14874 === (1))){
var state_14873__$1 = state_14873;
var statearr_14875_15047 = state_14873__$1;
(statearr_14875_15047[(2)] = null);

(statearr_14875_15047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (2))){
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14873__$1,(4),jobs);
} else {
if((state_val_14874 === (3))){
var inst_14871 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14873__$1,inst_14871);
} else {
if((state_val_14874 === (4))){
var inst_14863 = (state_14873[(2)]);
var inst_14864 = process.call(null,inst_14863);
var state_14873__$1 = state_14873;
if(cljs.core.truth_(inst_14864)){
var statearr_14876_15048 = state_14873__$1;
(statearr_14876_15048[(1)] = (5));

} else {
var statearr_14877_15049 = state_14873__$1;
(statearr_14877_15049[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (5))){
var state_14873__$1 = state_14873;
var statearr_14878_15050 = state_14873__$1;
(statearr_14878_15050[(2)] = null);

(statearr_14878_15050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (6))){
var state_14873__$1 = state_14873;
var statearr_14879_15051 = state_14873__$1;
(statearr_14879_15051[(2)] = null);

(statearr_14879_15051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (7))){
var inst_14869 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
var statearr_14880_15052 = state_14873__$1;
(statearr_14880_15052[(2)] = inst_14869);

(statearr_14880_15052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15043,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
;
return ((function (__15043,switch__14236__auto__,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14884 = [null,null,null,null,null,null,null];
(statearr_14884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14884[(1)] = (1));

return statearr_14884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14873){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14885){if((e14885 instanceof Object)){
var ex__14240__auto__ = e14885;
var statearr_14886_15053 = state_14873;
(statearr_14886_15053[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15054 = state_14873;
state_14873 = G__15054;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15043,switch__14236__auto__,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14887 = f__14376__auto__.call(null);
(statearr_14887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15046);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(__15043,c__14375__auto___15046,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
);


break;
case "async":
var c__14375__auto___15057 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15043,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (__15043,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function (state_14900){
var state_val_14901 = (state_14900[(1)]);
if((state_val_14901 === (1))){
var state_14900__$1 = state_14900;
var statearr_14902_15058 = state_14900__$1;
(statearr_14902_15058[(2)] = null);

(statearr_14902_15058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (2))){
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14900__$1,(4),jobs);
} else {
if((state_val_14901 === (3))){
var inst_14898 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14900__$1,inst_14898);
} else {
if((state_val_14901 === (4))){
var inst_14890 = (state_14900[(2)]);
var inst_14891 = async.call(null,inst_14890);
var state_14900__$1 = state_14900;
if(cljs.core.truth_(inst_14891)){
var statearr_14903_15061 = state_14900__$1;
(statearr_14903_15061[(1)] = (5));

} else {
var statearr_14904_15062 = state_14900__$1;
(statearr_14904_15062[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (5))){
var state_14900__$1 = state_14900;
var statearr_14905_15064 = state_14900__$1;
(statearr_14905_15064[(2)] = null);

(statearr_14905_15064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (6))){
var state_14900__$1 = state_14900;
var statearr_14906_15065 = state_14900__$1;
(statearr_14906_15065[(2)] = null);

(statearr_14906_15065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (7))){
var inst_14896 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
var statearr_14907_15067 = state_14900__$1;
(statearr_14907_15067[(2)] = inst_14896);

(statearr_14907_15067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15043,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
;
return ((function (__15043,switch__14236__auto__,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14913 = [null,null,null,null,null,null,null];
(statearr_14913[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14913[(1)] = (1));

return statearr_14913;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14900){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14914){if((e14914 instanceof Object)){
var ex__14240__auto__ = e14914;
var statearr_14915_15068 = state_14900;
(statearr_14915_15068[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15069 = state_14900;
state_14900 = G__15069;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15043,switch__14236__auto__,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14916 = f__14376__auto__.call(null);
(statearr_14916[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15057);

return statearr_14916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(__15043,c__14375__auto___15057,G__14860_15044,n__6952__auto___15042,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15070 = (__15043 + (1));
__15043 = G__15070;
continue;
} else {
}
break;
}

var c__14375__auto___15071 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15071,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15071,jobs,results,process,async){
return (function (state_14938){
var state_val_14939 = (state_14938[(1)]);
if((state_val_14939 === (1))){
var state_14938__$1 = state_14938;
var statearr_14940_15072 = state_14938__$1;
(statearr_14940_15072[(2)] = null);

(statearr_14940_15072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (2))){
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14938__$1,(4),from);
} else {
if((state_val_14939 === (3))){
var inst_14936 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14938__$1,inst_14936);
} else {
if((state_val_14939 === (4))){
var inst_14919 = (state_14938[(7)]);
var inst_14919__$1 = (state_14938[(2)]);
var inst_14920 = (inst_14919__$1 == null);
var state_14938__$1 = (function (){var statearr_14941 = state_14938;
(statearr_14941[(7)] = inst_14919__$1);

return statearr_14941;
})();
if(inst_14920){
var statearr_14942_15076 = state_14938__$1;
(statearr_14942_15076[(1)] = (5));

} else {
var statearr_14943_15077 = state_14938__$1;
(statearr_14943_15077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (5))){
var inst_14922 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14938__$1 = state_14938;
var statearr_14944_15078 = state_14938__$1;
(statearr_14944_15078[(2)] = inst_14922);

(statearr_14944_15078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (6))){
var inst_14919 = (state_14938[(7)]);
var inst_14924 = (state_14938[(8)]);
var inst_14924__$1 = cljs.core.async.chan.call(null,(1));
var inst_14925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14926 = [inst_14919,inst_14924__$1];
var inst_14927 = (new cljs.core.PersistentVector(null,2,(5),inst_14925,inst_14926,null));
var state_14938__$1 = (function (){var statearr_14945 = state_14938;
(statearr_14945[(8)] = inst_14924__$1);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14938__$1,(8),jobs,inst_14927);
} else {
if((state_val_14939 === (7))){
var inst_14934 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14946_15079 = state_14938__$1;
(statearr_14946_15079[(2)] = inst_14934);

(statearr_14946_15079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (8))){
var inst_14924 = (state_14938[(8)]);
var inst_14929 = (state_14938[(2)]);
var state_14938__$1 = (function (){var statearr_14947 = state_14938;
(statearr_14947[(9)] = inst_14929);

return statearr_14947;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14938__$1,(9),results,inst_14924);
} else {
if((state_val_14939 === (9))){
var inst_14931 = (state_14938[(2)]);
var state_14938__$1 = (function (){var statearr_14948 = state_14938;
(statearr_14948[(10)] = inst_14931);

return statearr_14948;
})();
var statearr_14949_15080 = state_14938__$1;
(statearr_14949_15080[(2)] = null);

(statearr_14949_15080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15071,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14375__auto___15071,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14953 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14953[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14953[(1)] = (1));

return statearr_14953;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14938){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14954){if((e14954 instanceof Object)){
var ex__14240__auto__ = e14954;
var statearr_14955_15081 = state_14938;
(statearr_14955_15081[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14938);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14954;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15082 = state_14938;
state_14938 = G__15082;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14938){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15071,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14956 = f__14376__auto__.call(null);
(statearr_14956[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15071);

return statearr_14956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15071,jobs,results,process,async))
);


var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__,jobs,results,process,async){
return (function (state_14994){
var state_val_14995 = (state_14994[(1)]);
if((state_val_14995 === (7))){
var inst_14990 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
var statearr_14996_15084 = state_14994__$1;
(statearr_14996_15084[(2)] = inst_14990);

(statearr_14996_15084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (20))){
var state_14994__$1 = state_14994;
var statearr_14997_15085 = state_14994__$1;
(statearr_14997_15085[(2)] = null);

(statearr_14997_15085[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (1))){
var state_14994__$1 = state_14994;
var statearr_14998_15086 = state_14994__$1;
(statearr_14998_15086[(2)] = null);

(statearr_14998_15086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (4))){
var inst_14959 = (state_14994[(7)]);
var inst_14959__$1 = (state_14994[(2)]);
var inst_14960 = (inst_14959__$1 == null);
var state_14994__$1 = (function (){var statearr_14999 = state_14994;
(statearr_14999[(7)] = inst_14959__$1);

return statearr_14999;
})();
if(cljs.core.truth_(inst_14960)){
var statearr_15000_15087 = state_14994__$1;
(statearr_15000_15087[(1)] = (5));

} else {
var statearr_15001_15088 = state_14994__$1;
(statearr_15001_15088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (15))){
var inst_14972 = (state_14994[(8)]);
var state_14994__$1 = state_14994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14994__$1,(18),to,inst_14972);
} else {
if((state_val_14995 === (21))){
var inst_14985 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
var statearr_15002_15089 = state_14994__$1;
(statearr_15002_15089[(2)] = inst_14985);

(statearr_15002_15089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (13))){
var inst_14987 = (state_14994[(2)]);
var state_14994__$1 = (function (){var statearr_15003 = state_14994;
(statearr_15003[(9)] = inst_14987);

return statearr_15003;
})();
var statearr_15004_15090 = state_14994__$1;
(statearr_15004_15090[(2)] = null);

(statearr_15004_15090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (6))){
var inst_14959 = (state_14994[(7)]);
var state_14994__$1 = state_14994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14994__$1,(11),inst_14959);
} else {
if((state_val_14995 === (17))){
var inst_14980 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
if(cljs.core.truth_(inst_14980)){
var statearr_15005_15091 = state_14994__$1;
(statearr_15005_15091[(1)] = (19));

} else {
var statearr_15006_15092 = state_14994__$1;
(statearr_15006_15092[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (3))){
var inst_14992 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14994__$1,inst_14992);
} else {
if((state_val_14995 === (12))){
var inst_14969 = (state_14994[(10)]);
var state_14994__$1 = state_14994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14994__$1,(14),inst_14969);
} else {
if((state_val_14995 === (2))){
var state_14994__$1 = state_14994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14994__$1,(4),results);
} else {
if((state_val_14995 === (19))){
var state_14994__$1 = state_14994;
var statearr_15008_15093 = state_14994__$1;
(statearr_15008_15093[(2)] = null);

(statearr_15008_15093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (11))){
var inst_14969 = (state_14994[(2)]);
var state_14994__$1 = (function (){var statearr_15010 = state_14994;
(statearr_15010[(10)] = inst_14969);

return statearr_15010;
})();
var statearr_15011_15094 = state_14994__$1;
(statearr_15011_15094[(2)] = null);

(statearr_15011_15094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (9))){
var state_14994__$1 = state_14994;
var statearr_15012_15095 = state_14994__$1;
(statearr_15012_15095[(2)] = null);

(statearr_15012_15095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (5))){
var state_14994__$1 = state_14994;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15013_15096 = state_14994__$1;
(statearr_15013_15096[(1)] = (8));

} else {
var statearr_15014_15097 = state_14994__$1;
(statearr_15014_15097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (14))){
var inst_14974 = (state_14994[(11)]);
var inst_14972 = (state_14994[(8)]);
var inst_14972__$1 = (state_14994[(2)]);
var inst_14973 = (inst_14972__$1 == null);
var inst_14974__$1 = cljs.core.not.call(null,inst_14973);
var state_14994__$1 = (function (){var statearr_15015 = state_14994;
(statearr_15015[(11)] = inst_14974__$1);

(statearr_15015[(8)] = inst_14972__$1);

return statearr_15015;
})();
if(inst_14974__$1){
var statearr_15016_15098 = state_14994__$1;
(statearr_15016_15098[(1)] = (15));

} else {
var statearr_15017_15099 = state_14994__$1;
(statearr_15017_15099[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (16))){
var inst_14974 = (state_14994[(11)]);
var state_14994__$1 = state_14994;
var statearr_15018_15100 = state_14994__$1;
(statearr_15018_15100[(2)] = inst_14974);

(statearr_15018_15100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (10))){
var inst_14966 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
var statearr_15019_15101 = state_14994__$1;
(statearr_15019_15101[(2)] = inst_14966);

(statearr_15019_15101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (18))){
var inst_14977 = (state_14994[(2)]);
var state_14994__$1 = state_14994;
var statearr_15020_15102 = state_14994__$1;
(statearr_15020_15102[(2)] = inst_14977);

(statearr_15020_15102[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14995 === (8))){
var inst_14963 = cljs.core.async.close_BANG_.call(null,to);
var state_14994__$1 = state_14994;
var statearr_15021_15103 = state_14994__$1;
(statearr_15021_15103[(2)] = inst_14963);

(statearr_15021_15103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14375__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15025 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15025[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15025[(1)] = (1));

return statearr_15025;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14994){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15026){if((e15026 instanceof Object)){
var ex__14240__auto__ = e15026;
var statearr_15027_15104 = state_14994;
(statearr_15027_15104[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14994);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15105 = state_14994;
state_14994 = G__15105;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14994){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_15028 = f__14376__auto__.call(null);
(statearr_15028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__,jobs,results,process,async))
);

return c__14375__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15106 = [];
var len__7107__auto___15109 = arguments.length;
var i__7108__auto___15110 = (0);
while(true){
if((i__7108__auto___15110 < len__7107__auto___15109)){
args15106.push((arguments[i__7108__auto___15110]));

var G__15111 = (i__7108__auto___15110 + (1));
i__7108__auto___15110 = G__15111;
continue;
} else {
}
break;
}

var G__15108 = args15106.length;
switch (G__15108) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15106.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15130 = [];
var len__7107__auto___15145 = arguments.length;
var i__7108__auto___15146 = (0);
while(true){
if((i__7108__auto___15146 < len__7107__auto___15145)){
args15130.push((arguments[i__7108__auto___15146]));

var G__15147 = (i__7108__auto___15146 + (1));
i__7108__auto___15146 = G__15147;
continue;
} else {
}
break;
}

var G__15144 = args15130.length;
switch (G__15144) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15130.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15149 = [];
var len__7107__auto___15206 = arguments.length;
var i__7108__auto___15207 = (0);
while(true){
if((i__7108__auto___15207 < len__7107__auto___15206)){
args15149.push((arguments[i__7108__auto___15207]));

var G__15208 = (i__7108__auto___15207 + (1));
i__7108__auto___15207 = G__15208;
continue;
} else {
}
break;
}

var G__15153 = args15149.length;
switch (G__15153) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15149.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14375__auto___15212 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15212,tc,fc){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15212,tc,fc){
return (function (state_15181){
var state_val_15182 = (state_15181[(1)]);
if((state_val_15182 === (7))){
var inst_15176 = (state_15181[(2)]);
var state_15181__$1 = state_15181;
var statearr_15183_15215 = state_15181__$1;
(statearr_15183_15215[(2)] = inst_15176);

(statearr_15183_15215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (1))){
var state_15181__$1 = state_15181;
var statearr_15184_15216 = state_15181__$1;
(statearr_15184_15216[(2)] = null);

(statearr_15184_15216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (4))){
var inst_15157 = (state_15181[(7)]);
var inst_15157__$1 = (state_15181[(2)]);
var inst_15158 = (inst_15157__$1 == null);
var state_15181__$1 = (function (){var statearr_15185 = state_15181;
(statearr_15185[(7)] = inst_15157__$1);

return statearr_15185;
})();
if(cljs.core.truth_(inst_15158)){
var statearr_15186_15217 = state_15181__$1;
(statearr_15186_15217[(1)] = (5));

} else {
var statearr_15187_15218 = state_15181__$1;
(statearr_15187_15218[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (13))){
var state_15181__$1 = state_15181;
var statearr_15188_15219 = state_15181__$1;
(statearr_15188_15219[(2)] = null);

(statearr_15188_15219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (6))){
var inst_15157 = (state_15181[(7)]);
var inst_15163 = p.call(null,inst_15157);
var state_15181__$1 = state_15181;
if(cljs.core.truth_(inst_15163)){
var statearr_15189_15220 = state_15181__$1;
(statearr_15189_15220[(1)] = (9));

} else {
var statearr_15190_15221 = state_15181__$1;
(statearr_15190_15221[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (3))){
var inst_15178 = (state_15181[(2)]);
var state_15181__$1 = state_15181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15181__$1,inst_15178);
} else {
if((state_val_15182 === (12))){
var state_15181__$1 = state_15181;
var statearr_15191_15225 = state_15181__$1;
(statearr_15191_15225[(2)] = null);

(statearr_15191_15225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (2))){
var state_15181__$1 = state_15181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15181__$1,(4),ch);
} else {
if((state_val_15182 === (11))){
var inst_15157 = (state_15181[(7)]);
var inst_15167 = (state_15181[(2)]);
var state_15181__$1 = state_15181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15181__$1,(8),inst_15167,inst_15157);
} else {
if((state_val_15182 === (9))){
var state_15181__$1 = state_15181;
var statearr_15192_15226 = state_15181__$1;
(statearr_15192_15226[(2)] = tc);

(statearr_15192_15226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (5))){
var inst_15160 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15161 = cljs.core.async.close_BANG_.call(null,fc);
var state_15181__$1 = (function (){var statearr_15193 = state_15181;
(statearr_15193[(8)] = inst_15160);

return statearr_15193;
})();
var statearr_15194_15227 = state_15181__$1;
(statearr_15194_15227[(2)] = inst_15161);

(statearr_15194_15227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (14))){
var inst_15174 = (state_15181[(2)]);
var state_15181__$1 = state_15181;
var statearr_15195_15229 = state_15181__$1;
(statearr_15195_15229[(2)] = inst_15174);

(statearr_15195_15229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (10))){
var state_15181__$1 = state_15181;
var statearr_15196_15230 = state_15181__$1;
(statearr_15196_15230[(2)] = fc);

(statearr_15196_15230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15182 === (8))){
var inst_15169 = (state_15181[(2)]);
var state_15181__$1 = state_15181;
if(cljs.core.truth_(inst_15169)){
var statearr_15197_15231 = state_15181__$1;
(statearr_15197_15231[(1)] = (12));

} else {
var statearr_15198_15232 = state_15181__$1;
(statearr_15198_15232[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15212,tc,fc))
;
return ((function (switch__14236__auto__,c__14375__auto___15212,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15202 = [null,null,null,null,null,null,null,null,null];
(statearr_15202[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15202[(1)] = (1));

return statearr_15202;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15181){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15203){if((e15203 instanceof Object)){
var ex__14240__auto__ = e15203;
var statearr_15204_15233 = state_15181;
(statearr_15204_15233[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15203;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15234 = state_15181;
state_15181 = G__15234;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15212,tc,fc))
})();
var state__14377__auto__ = (function (){var statearr_15205 = f__14376__auto__.call(null);
(statearr_15205[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15212);

return statearr_15205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15212,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_15298){
var state_val_15299 = (state_15298[(1)]);
if((state_val_15299 === (7))){
var inst_15294 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15300_15325 = state_15298__$1;
(statearr_15300_15325[(2)] = inst_15294);

(statearr_15300_15325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (1))){
var inst_15278 = init;
var state_15298__$1 = (function (){var statearr_15301 = state_15298;
(statearr_15301[(7)] = inst_15278);

return statearr_15301;
})();
var statearr_15302_15329 = state_15298__$1;
(statearr_15302_15329[(2)] = null);

(statearr_15302_15329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (4))){
var inst_15281 = (state_15298[(8)]);
var inst_15281__$1 = (state_15298[(2)]);
var inst_15282 = (inst_15281__$1 == null);
var state_15298__$1 = (function (){var statearr_15303 = state_15298;
(statearr_15303[(8)] = inst_15281__$1);

return statearr_15303;
})();
if(cljs.core.truth_(inst_15282)){
var statearr_15304_15330 = state_15298__$1;
(statearr_15304_15330[(1)] = (5));

} else {
var statearr_15305_15331 = state_15298__$1;
(statearr_15305_15331[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (6))){
var inst_15285 = (state_15298[(9)]);
var inst_15281 = (state_15298[(8)]);
var inst_15278 = (state_15298[(7)]);
var inst_15285__$1 = f.call(null,inst_15278,inst_15281);
var inst_15286 = cljs.core.reduced_QMARK_.call(null,inst_15285__$1);
var state_15298__$1 = (function (){var statearr_15306 = state_15298;
(statearr_15306[(9)] = inst_15285__$1);

return statearr_15306;
})();
if(inst_15286){
var statearr_15307_15332 = state_15298__$1;
(statearr_15307_15332[(1)] = (8));

} else {
var statearr_15308_15333 = state_15298__$1;
(statearr_15308_15333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (3))){
var inst_15296 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15298__$1,inst_15296);
} else {
if((state_val_15299 === (2))){
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15298__$1,(4),ch);
} else {
if((state_val_15299 === (9))){
var inst_15285 = (state_15298[(9)]);
var inst_15278 = inst_15285;
var state_15298__$1 = (function (){var statearr_15309 = state_15298;
(statearr_15309[(7)] = inst_15278);

return statearr_15309;
})();
var statearr_15310_15334 = state_15298__$1;
(statearr_15310_15334[(2)] = null);

(statearr_15310_15334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (5))){
var inst_15278 = (state_15298[(7)]);
var state_15298__$1 = state_15298;
var statearr_15311_15335 = state_15298__$1;
(statearr_15311_15335[(2)] = inst_15278);

(statearr_15311_15335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (10))){
var inst_15292 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15312_15336 = state_15298__$1;
(statearr_15312_15336[(2)] = inst_15292);

(statearr_15312_15336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (8))){
var inst_15285 = (state_15298[(9)]);
var inst_15288 = cljs.core.deref.call(null,inst_15285);
var state_15298__$1 = state_15298;
var statearr_15313_15337 = state_15298__$1;
(statearr_15313_15337[(2)] = inst_15288);

(statearr_15313_15337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15318 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15318[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15318[(1)] = (1));

return statearr_15318;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15298){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15319){if((e15319 instanceof Object)){
var ex__14240__auto__ = e15319;
var statearr_15321_15338 = state_15298;
(statearr_15321_15338[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15319;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15339 = state_15298;
state_15298 = G__15339;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15298){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_15322 = f__14376__auto__.call(null);
(statearr_15322[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15340 = [];
var len__7107__auto___15398 = arguments.length;
var i__7108__auto___15399 = (0);
while(true){
if((i__7108__auto___15399 < len__7107__auto___15398)){
args15340.push((arguments[i__7108__auto___15399]));

var G__15400 = (i__7108__auto___15399 + (1));
i__7108__auto___15399 = G__15400;
continue;
} else {
}
break;
}

var G__15342 = args15340.length;
switch (G__15342) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15340.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_15367){
var state_val_15368 = (state_15367[(1)]);
if((state_val_15368 === (7))){
var inst_15349 = (state_15367[(2)]);
var state_15367__$1 = state_15367;
var statearr_15369_15405 = state_15367__$1;
(statearr_15369_15405[(2)] = inst_15349);

(statearr_15369_15405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (1))){
var inst_15343 = cljs.core.seq.call(null,coll);
var inst_15344 = inst_15343;
var state_15367__$1 = (function (){var statearr_15370 = state_15367;
(statearr_15370[(7)] = inst_15344);

return statearr_15370;
})();
var statearr_15371_15406 = state_15367__$1;
(statearr_15371_15406[(2)] = null);

(statearr_15371_15406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (4))){
var inst_15344 = (state_15367[(7)]);
var inst_15347 = cljs.core.first.call(null,inst_15344);
var state_15367__$1 = state_15367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15367__$1,(7),ch,inst_15347);
} else {
if((state_val_15368 === (13))){
var inst_15361 = (state_15367[(2)]);
var state_15367__$1 = state_15367;
var statearr_15372_15408 = state_15367__$1;
(statearr_15372_15408[(2)] = inst_15361);

(statearr_15372_15408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (6))){
var inst_15352 = (state_15367[(2)]);
var state_15367__$1 = state_15367;
if(cljs.core.truth_(inst_15352)){
var statearr_15373_15409 = state_15367__$1;
(statearr_15373_15409[(1)] = (8));

} else {
var statearr_15374_15410 = state_15367__$1;
(statearr_15374_15410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (3))){
var inst_15365 = (state_15367[(2)]);
var state_15367__$1 = state_15367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15367__$1,inst_15365);
} else {
if((state_val_15368 === (12))){
var state_15367__$1 = state_15367;
var statearr_15375_15411 = state_15367__$1;
(statearr_15375_15411[(2)] = null);

(statearr_15375_15411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (2))){
var inst_15344 = (state_15367[(7)]);
var state_15367__$1 = state_15367;
if(cljs.core.truth_(inst_15344)){
var statearr_15376_15412 = state_15367__$1;
(statearr_15376_15412[(1)] = (4));

} else {
var statearr_15377_15413 = state_15367__$1;
(statearr_15377_15413[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (11))){
var inst_15358 = cljs.core.async.close_BANG_.call(null,ch);
var state_15367__$1 = state_15367;
var statearr_15378_15414 = state_15367__$1;
(statearr_15378_15414[(2)] = inst_15358);

(statearr_15378_15414[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (9))){
var state_15367__$1 = state_15367;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15379_15415 = state_15367__$1;
(statearr_15379_15415[(1)] = (11));

} else {
var statearr_15380_15416 = state_15367__$1;
(statearr_15380_15416[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (5))){
var inst_15344 = (state_15367[(7)]);
var state_15367__$1 = state_15367;
var statearr_15381_15417 = state_15367__$1;
(statearr_15381_15417[(2)] = inst_15344);

(statearr_15381_15417[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (10))){
var inst_15363 = (state_15367[(2)]);
var state_15367__$1 = state_15367;
var statearr_15384_15418 = state_15367__$1;
(statearr_15384_15418[(2)] = inst_15363);

(statearr_15384_15418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15368 === (8))){
var inst_15344 = (state_15367[(7)]);
var inst_15354 = cljs.core.next.call(null,inst_15344);
var inst_15344__$1 = inst_15354;
var state_15367__$1 = (function (){var statearr_15387 = state_15367;
(statearr_15387[(7)] = inst_15344__$1);

return statearr_15387;
})();
var statearr_15388_15419 = state_15367__$1;
(statearr_15388_15419[(2)] = null);

(statearr_15388_15419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15393 = [null,null,null,null,null,null,null,null];
(statearr_15393[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15393[(1)] = (1));

return statearr_15393;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15367){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15394){if((e15394 instanceof Object)){
var ex__14240__auto__ = e15394;
var statearr_15395_15420 = state_15367;
(statearr_15395_15420[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15421 = state_15367;
state_15367 = G__15421;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_15397 = f__14376__auto__.call(null);
(statearr_15397[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15660 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15660 = (function (mult,ch,cs,meta15661){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15661 = meta15661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15662,meta15661__$1){
var self__ = this;
var _15662__$1 = this;
return (new cljs.core.async.t_cljs$core$async15660(self__.mult,self__.ch,self__.cs,meta15661__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15662){
var self__ = this;
var _15662__$1 = this;
return self__.meta15661;
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15661","meta15661",1191156954,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15660.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15660.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15660";

cljs.core.async.t_cljs$core$async15660.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15660");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15660 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15660(mult__$1,ch__$1,cs__$1,meta15661){
return (new cljs.core.async.t_cljs$core$async15660(mult__$1,ch__$1,cs__$1,meta15661));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15660(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14375__auto___15891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15891,cs,m,dchan,dctr,done){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15891,cs,m,dchan,dctr,done){
return (function (state_15793){
var state_val_15794 = (state_15793[(1)]);
if((state_val_15794 === (7))){
var inst_15789 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15795_15892 = state_15793__$1;
(statearr_15795_15892[(2)] = inst_15789);

(statearr_15795_15892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (20))){
var inst_15694 = (state_15793[(7)]);
var inst_15704 = cljs.core.first.call(null,inst_15694);
var inst_15705 = cljs.core.nth.call(null,inst_15704,(0),null);
var inst_15706 = cljs.core.nth.call(null,inst_15704,(1),null);
var state_15793__$1 = (function (){var statearr_15796 = state_15793;
(statearr_15796[(8)] = inst_15705);

return statearr_15796;
})();
if(cljs.core.truth_(inst_15706)){
var statearr_15797_15893 = state_15793__$1;
(statearr_15797_15893[(1)] = (22));

} else {
var statearr_15798_15894 = state_15793__$1;
(statearr_15798_15894[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (27))){
var inst_15734 = (state_15793[(9)]);
var inst_15736 = (state_15793[(10)]);
var inst_15741 = (state_15793[(11)]);
var inst_15665 = (state_15793[(12)]);
var inst_15741__$1 = cljs.core._nth.call(null,inst_15734,inst_15736);
var inst_15742 = cljs.core.async.put_BANG_.call(null,inst_15741__$1,inst_15665,done);
var state_15793__$1 = (function (){var statearr_15799 = state_15793;
(statearr_15799[(11)] = inst_15741__$1);

return statearr_15799;
})();
if(cljs.core.truth_(inst_15742)){
var statearr_15800_15895 = state_15793__$1;
(statearr_15800_15895[(1)] = (30));

} else {
var statearr_15801_15896 = state_15793__$1;
(statearr_15801_15896[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (1))){
var state_15793__$1 = state_15793;
var statearr_15802_15897 = state_15793__$1;
(statearr_15802_15897[(2)] = null);

(statearr_15802_15897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (24))){
var inst_15694 = (state_15793[(7)]);
var inst_15711 = (state_15793[(2)]);
var inst_15712 = cljs.core.next.call(null,inst_15694);
var inst_15674 = inst_15712;
var inst_15675 = null;
var inst_15676 = (0);
var inst_15677 = (0);
var state_15793__$1 = (function (){var statearr_15803 = state_15793;
(statearr_15803[(13)] = inst_15675);

(statearr_15803[(14)] = inst_15676);

(statearr_15803[(15)] = inst_15674);

(statearr_15803[(16)] = inst_15677);

(statearr_15803[(17)] = inst_15711);

return statearr_15803;
})();
var statearr_15804_15898 = state_15793__$1;
(statearr_15804_15898[(2)] = null);

(statearr_15804_15898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (39))){
var state_15793__$1 = state_15793;
var statearr_15808_15899 = state_15793__$1;
(statearr_15808_15899[(2)] = null);

(statearr_15808_15899[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (4))){
var inst_15665 = (state_15793[(12)]);
var inst_15665__$1 = (state_15793[(2)]);
var inst_15666 = (inst_15665__$1 == null);
var state_15793__$1 = (function (){var statearr_15809 = state_15793;
(statearr_15809[(12)] = inst_15665__$1);

return statearr_15809;
})();
if(cljs.core.truth_(inst_15666)){
var statearr_15810_15900 = state_15793__$1;
(statearr_15810_15900[(1)] = (5));

} else {
var statearr_15811_15901 = state_15793__$1;
(statearr_15811_15901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (15))){
var inst_15675 = (state_15793[(13)]);
var inst_15676 = (state_15793[(14)]);
var inst_15674 = (state_15793[(15)]);
var inst_15677 = (state_15793[(16)]);
var inst_15690 = (state_15793[(2)]);
var inst_15691 = (inst_15677 + (1));
var tmp15805 = inst_15675;
var tmp15806 = inst_15676;
var tmp15807 = inst_15674;
var inst_15674__$1 = tmp15807;
var inst_15675__$1 = tmp15805;
var inst_15676__$1 = tmp15806;
var inst_15677__$1 = inst_15691;
var state_15793__$1 = (function (){var statearr_15812 = state_15793;
(statearr_15812[(13)] = inst_15675__$1);

(statearr_15812[(14)] = inst_15676__$1);

(statearr_15812[(15)] = inst_15674__$1);

(statearr_15812[(16)] = inst_15677__$1);

(statearr_15812[(18)] = inst_15690);

return statearr_15812;
})();
var statearr_15813_15908 = state_15793__$1;
(statearr_15813_15908[(2)] = null);

(statearr_15813_15908[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (21))){
var inst_15715 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15817_15909 = state_15793__$1;
(statearr_15817_15909[(2)] = inst_15715);

(statearr_15817_15909[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (31))){
var inst_15741 = (state_15793[(11)]);
var inst_15745 = done.call(null,null);
var inst_15746 = cljs.core.async.untap_STAR_.call(null,m,inst_15741);
var state_15793__$1 = (function (){var statearr_15818 = state_15793;
(statearr_15818[(19)] = inst_15745);

return statearr_15818;
})();
var statearr_15819_15913 = state_15793__$1;
(statearr_15819_15913[(2)] = inst_15746);

(statearr_15819_15913[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (32))){
var inst_15734 = (state_15793[(9)]);
var inst_15736 = (state_15793[(10)]);
var inst_15733 = (state_15793[(20)]);
var inst_15735 = (state_15793[(21)]);
var inst_15748 = (state_15793[(2)]);
var inst_15749 = (inst_15736 + (1));
var tmp15814 = inst_15734;
var tmp15815 = inst_15733;
var tmp15816 = inst_15735;
var inst_15733__$1 = tmp15815;
var inst_15734__$1 = tmp15814;
var inst_15735__$1 = tmp15816;
var inst_15736__$1 = inst_15749;
var state_15793__$1 = (function (){var statearr_15820 = state_15793;
(statearr_15820[(22)] = inst_15748);

(statearr_15820[(9)] = inst_15734__$1);

(statearr_15820[(10)] = inst_15736__$1);

(statearr_15820[(20)] = inst_15733__$1);

(statearr_15820[(21)] = inst_15735__$1);

return statearr_15820;
})();
var statearr_15821_15914 = state_15793__$1;
(statearr_15821_15914[(2)] = null);

(statearr_15821_15914[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (40))){
var inst_15761 = (state_15793[(23)]);
var inst_15765 = done.call(null,null);
var inst_15766 = cljs.core.async.untap_STAR_.call(null,m,inst_15761);
var state_15793__$1 = (function (){var statearr_15822 = state_15793;
(statearr_15822[(24)] = inst_15765);

return statearr_15822;
})();
var statearr_15823_15916 = state_15793__$1;
(statearr_15823_15916[(2)] = inst_15766);

(statearr_15823_15916[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (33))){
var inst_15752 = (state_15793[(25)]);
var inst_15754 = cljs.core.chunked_seq_QMARK_.call(null,inst_15752);
var state_15793__$1 = state_15793;
if(inst_15754){
var statearr_15824_15917 = state_15793__$1;
(statearr_15824_15917[(1)] = (36));

} else {
var statearr_15825_15918 = state_15793__$1;
(statearr_15825_15918[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (13))){
var inst_15684 = (state_15793[(26)]);
var inst_15687 = cljs.core.async.close_BANG_.call(null,inst_15684);
var state_15793__$1 = state_15793;
var statearr_15826_15919 = state_15793__$1;
(statearr_15826_15919[(2)] = inst_15687);

(statearr_15826_15919[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (22))){
var inst_15705 = (state_15793[(8)]);
var inst_15708 = cljs.core.async.close_BANG_.call(null,inst_15705);
var state_15793__$1 = state_15793;
var statearr_15827_15920 = state_15793__$1;
(statearr_15827_15920[(2)] = inst_15708);

(statearr_15827_15920[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (36))){
var inst_15752 = (state_15793[(25)]);
var inst_15756 = cljs.core.chunk_first.call(null,inst_15752);
var inst_15757 = cljs.core.chunk_rest.call(null,inst_15752);
var inst_15758 = cljs.core.count.call(null,inst_15756);
var inst_15733 = inst_15757;
var inst_15734 = inst_15756;
var inst_15735 = inst_15758;
var inst_15736 = (0);
var state_15793__$1 = (function (){var statearr_15828 = state_15793;
(statearr_15828[(9)] = inst_15734);

(statearr_15828[(10)] = inst_15736);

(statearr_15828[(20)] = inst_15733);

(statearr_15828[(21)] = inst_15735);

return statearr_15828;
})();
var statearr_15829_15921 = state_15793__$1;
(statearr_15829_15921[(2)] = null);

(statearr_15829_15921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (41))){
var inst_15752 = (state_15793[(25)]);
var inst_15768 = (state_15793[(2)]);
var inst_15769 = cljs.core.next.call(null,inst_15752);
var inst_15733 = inst_15769;
var inst_15734 = null;
var inst_15735 = (0);
var inst_15736 = (0);
var state_15793__$1 = (function (){var statearr_15830 = state_15793;
(statearr_15830[(9)] = inst_15734);

(statearr_15830[(10)] = inst_15736);

(statearr_15830[(20)] = inst_15733);

(statearr_15830[(27)] = inst_15768);

(statearr_15830[(21)] = inst_15735);

return statearr_15830;
})();
var statearr_15831_15922 = state_15793__$1;
(statearr_15831_15922[(2)] = null);

(statearr_15831_15922[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (43))){
var state_15793__$1 = state_15793;
var statearr_15832_15923 = state_15793__$1;
(statearr_15832_15923[(2)] = null);

(statearr_15832_15923[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (29))){
var inst_15777 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15833_15924 = state_15793__$1;
(statearr_15833_15924[(2)] = inst_15777);

(statearr_15833_15924[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (44))){
var inst_15786 = (state_15793[(2)]);
var state_15793__$1 = (function (){var statearr_15834 = state_15793;
(statearr_15834[(28)] = inst_15786);

return statearr_15834;
})();
var statearr_15835_15925 = state_15793__$1;
(statearr_15835_15925[(2)] = null);

(statearr_15835_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (6))){
var inst_15725 = (state_15793[(29)]);
var inst_15724 = cljs.core.deref.call(null,cs);
var inst_15725__$1 = cljs.core.keys.call(null,inst_15724);
var inst_15726 = cljs.core.count.call(null,inst_15725__$1);
var inst_15727 = cljs.core.reset_BANG_.call(null,dctr,inst_15726);
var inst_15732 = cljs.core.seq.call(null,inst_15725__$1);
var inst_15733 = inst_15732;
var inst_15734 = null;
var inst_15735 = (0);
var inst_15736 = (0);
var state_15793__$1 = (function (){var statearr_15836 = state_15793;
(statearr_15836[(29)] = inst_15725__$1);

(statearr_15836[(9)] = inst_15734);

(statearr_15836[(10)] = inst_15736);

(statearr_15836[(20)] = inst_15733);

(statearr_15836[(21)] = inst_15735);

(statearr_15836[(30)] = inst_15727);

return statearr_15836;
})();
var statearr_15837_15926 = state_15793__$1;
(statearr_15837_15926[(2)] = null);

(statearr_15837_15926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (28))){
var inst_15752 = (state_15793[(25)]);
var inst_15733 = (state_15793[(20)]);
var inst_15752__$1 = cljs.core.seq.call(null,inst_15733);
var state_15793__$1 = (function (){var statearr_15838 = state_15793;
(statearr_15838[(25)] = inst_15752__$1);

return statearr_15838;
})();
if(inst_15752__$1){
var statearr_15839_15927 = state_15793__$1;
(statearr_15839_15927[(1)] = (33));

} else {
var statearr_15840_15928 = state_15793__$1;
(statearr_15840_15928[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (25))){
var inst_15736 = (state_15793[(10)]);
var inst_15735 = (state_15793[(21)]);
var inst_15738 = (inst_15736 < inst_15735);
var inst_15739 = inst_15738;
var state_15793__$1 = state_15793;
if(cljs.core.truth_(inst_15739)){
var statearr_15841_15930 = state_15793__$1;
(statearr_15841_15930[(1)] = (27));

} else {
var statearr_15842_15931 = state_15793__$1;
(statearr_15842_15931[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (34))){
var state_15793__$1 = state_15793;
var statearr_15843_15933 = state_15793__$1;
(statearr_15843_15933[(2)] = null);

(statearr_15843_15933[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (17))){
var state_15793__$1 = state_15793;
var statearr_15844_15935 = state_15793__$1;
(statearr_15844_15935[(2)] = null);

(statearr_15844_15935[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (3))){
var inst_15791 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15793__$1,inst_15791);
} else {
if((state_val_15794 === (12))){
var inst_15720 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15845_15939 = state_15793__$1;
(statearr_15845_15939[(2)] = inst_15720);

(statearr_15845_15939[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (2))){
var state_15793__$1 = state_15793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15793__$1,(4),ch);
} else {
if((state_val_15794 === (23))){
var state_15793__$1 = state_15793;
var statearr_15846_15941 = state_15793__$1;
(statearr_15846_15941[(2)] = null);

(statearr_15846_15941[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (35))){
var inst_15775 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15847_15946 = state_15793__$1;
(statearr_15847_15946[(2)] = inst_15775);

(statearr_15847_15946[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (19))){
var inst_15694 = (state_15793[(7)]);
var inst_15698 = cljs.core.chunk_first.call(null,inst_15694);
var inst_15699 = cljs.core.chunk_rest.call(null,inst_15694);
var inst_15700 = cljs.core.count.call(null,inst_15698);
var inst_15674 = inst_15699;
var inst_15675 = inst_15698;
var inst_15676 = inst_15700;
var inst_15677 = (0);
var state_15793__$1 = (function (){var statearr_15848 = state_15793;
(statearr_15848[(13)] = inst_15675);

(statearr_15848[(14)] = inst_15676);

(statearr_15848[(15)] = inst_15674);

(statearr_15848[(16)] = inst_15677);

return statearr_15848;
})();
var statearr_15849_15949 = state_15793__$1;
(statearr_15849_15949[(2)] = null);

(statearr_15849_15949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (11))){
var inst_15694 = (state_15793[(7)]);
var inst_15674 = (state_15793[(15)]);
var inst_15694__$1 = cljs.core.seq.call(null,inst_15674);
var state_15793__$1 = (function (){var statearr_15850 = state_15793;
(statearr_15850[(7)] = inst_15694__$1);

return statearr_15850;
})();
if(inst_15694__$1){
var statearr_15851_15953 = state_15793__$1;
(statearr_15851_15953[(1)] = (16));

} else {
var statearr_15852_15954 = state_15793__$1;
(statearr_15852_15954[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (9))){
var inst_15722 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15853_15955 = state_15793__$1;
(statearr_15853_15955[(2)] = inst_15722);

(statearr_15853_15955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (5))){
var inst_15672 = cljs.core.deref.call(null,cs);
var inst_15673 = cljs.core.seq.call(null,inst_15672);
var inst_15674 = inst_15673;
var inst_15675 = null;
var inst_15676 = (0);
var inst_15677 = (0);
var state_15793__$1 = (function (){var statearr_15854 = state_15793;
(statearr_15854[(13)] = inst_15675);

(statearr_15854[(14)] = inst_15676);

(statearr_15854[(15)] = inst_15674);

(statearr_15854[(16)] = inst_15677);

return statearr_15854;
})();
var statearr_15855_15956 = state_15793__$1;
(statearr_15855_15956[(2)] = null);

(statearr_15855_15956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (14))){
var state_15793__$1 = state_15793;
var statearr_15856_15957 = state_15793__$1;
(statearr_15856_15957[(2)] = null);

(statearr_15856_15957[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (45))){
var inst_15783 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15857_15958 = state_15793__$1;
(statearr_15857_15958[(2)] = inst_15783);

(statearr_15857_15958[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (26))){
var inst_15725 = (state_15793[(29)]);
var inst_15779 = (state_15793[(2)]);
var inst_15780 = cljs.core.seq.call(null,inst_15725);
var state_15793__$1 = (function (){var statearr_15858 = state_15793;
(statearr_15858[(31)] = inst_15779);

return statearr_15858;
})();
if(inst_15780){
var statearr_15859_15959 = state_15793__$1;
(statearr_15859_15959[(1)] = (42));

} else {
var statearr_15860_15960 = state_15793__$1;
(statearr_15860_15960[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (16))){
var inst_15694 = (state_15793[(7)]);
var inst_15696 = cljs.core.chunked_seq_QMARK_.call(null,inst_15694);
var state_15793__$1 = state_15793;
if(inst_15696){
var statearr_15861_15961 = state_15793__$1;
(statearr_15861_15961[(1)] = (19));

} else {
var statearr_15862_15962 = state_15793__$1;
(statearr_15862_15962[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (38))){
var inst_15772 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15863_15963 = state_15793__$1;
(statearr_15863_15963[(2)] = inst_15772);

(statearr_15863_15963[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (30))){
var state_15793__$1 = state_15793;
var statearr_15864_15965 = state_15793__$1;
(statearr_15864_15965[(2)] = null);

(statearr_15864_15965[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (10))){
var inst_15675 = (state_15793[(13)]);
var inst_15677 = (state_15793[(16)]);
var inst_15683 = cljs.core._nth.call(null,inst_15675,inst_15677);
var inst_15684 = cljs.core.nth.call(null,inst_15683,(0),null);
var inst_15685 = cljs.core.nth.call(null,inst_15683,(1),null);
var state_15793__$1 = (function (){var statearr_15867 = state_15793;
(statearr_15867[(26)] = inst_15684);

return statearr_15867;
})();
if(cljs.core.truth_(inst_15685)){
var statearr_15870_15966 = state_15793__$1;
(statearr_15870_15966[(1)] = (13));

} else {
var statearr_15871_15967 = state_15793__$1;
(statearr_15871_15967[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (18))){
var inst_15718 = (state_15793[(2)]);
var state_15793__$1 = state_15793;
var statearr_15872_15968 = state_15793__$1;
(statearr_15872_15968[(2)] = inst_15718);

(statearr_15872_15968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (42))){
var state_15793__$1 = state_15793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15793__$1,(45),dchan);
} else {
if((state_val_15794 === (37))){
var inst_15752 = (state_15793[(25)]);
var inst_15761 = (state_15793[(23)]);
var inst_15665 = (state_15793[(12)]);
var inst_15761__$1 = cljs.core.first.call(null,inst_15752);
var inst_15762 = cljs.core.async.put_BANG_.call(null,inst_15761__$1,inst_15665,done);
var state_15793__$1 = (function (){var statearr_15874 = state_15793;
(statearr_15874[(23)] = inst_15761__$1);

return statearr_15874;
})();
if(cljs.core.truth_(inst_15762)){
var statearr_15875_15969 = state_15793__$1;
(statearr_15875_15969[(1)] = (39));

} else {
var statearr_15876_15970 = state_15793__$1;
(statearr_15876_15970[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15794 === (8))){
var inst_15676 = (state_15793[(14)]);
var inst_15677 = (state_15793[(16)]);
var inst_15679 = (inst_15677 < inst_15676);
var inst_15680 = inst_15679;
var state_15793__$1 = state_15793;
if(cljs.core.truth_(inst_15680)){
var statearr_15877_15971 = state_15793__$1;
(statearr_15877_15971[(1)] = (10));

} else {
var statearr_15878_15972 = state_15793__$1;
(statearr_15878_15972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15891,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14375__auto___15891,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15883[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15883[(1)] = (1));

return statearr_15883;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15793){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15884){if((e15884 instanceof Object)){
var ex__14240__auto__ = e15884;
var statearr_15885_15973 = state_15793;
(statearr_15885_15973[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15793);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15974 = state_15793;
state_15793 = G__15974;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15793){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15891,cs,m,dchan,dctr,done))
})();
var state__14377__auto__ = (function (){var statearr_15886 = f__14376__auto__.call(null);
(statearr_15886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15891);

return statearr_15886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15891,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15975 = [];
var len__7107__auto___15978 = arguments.length;
var i__7108__auto___15979 = (0);
while(true){
if((i__7108__auto___15979 < len__7107__auto___15978)){
args15975.push((arguments[i__7108__auto___15979]));

var G__15980 = (i__7108__auto___15979 + (1));
i__7108__auto___15979 = G__15980;
continue;
} else {
}
break;
}

var G__15977 = args15975.length;
switch (G__15977) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15975.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___16005 = arguments.length;
var i__7108__auto___16006 = (0);
while(true){
if((i__7108__auto___16006 < len__7107__auto___16005)){
args__7114__auto__.push((arguments[i__7108__auto___16006]));

var G__16007 = (i__7108__auto___16006 + (1));
i__7108__auto___16006 = G__16007;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15999){
var map__16000 = p__15999;
var map__16000__$1 = ((((!((map__16000 == null)))?((((map__16000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16000):map__16000);
var opts = map__16000__$1;
var statearr_16002_16008 = state;
(statearr_16002_16008[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__16000,map__16000__$1,opts){
return (function (val){
var statearr_16003_16009 = state;
(statearr_16003_16009[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__16000,map__16000__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16004_16010 = state;
(statearr_16004_16010[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15995){
var G__15996 = cljs.core.first.call(null,seq15995);
var seq15995__$1 = cljs.core.next.call(null,seq15995);
var G__15997 = cljs.core.first.call(null,seq15995__$1);
var seq15995__$2 = cljs.core.next.call(null,seq15995__$1);
var G__15998 = cljs.core.first.call(null,seq15995__$2);
var seq15995__$3 = cljs.core.next.call(null,seq15995__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15996,G__15997,G__15998,seq15995__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16191 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16192){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16192 = meta16192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16193,meta16192__$1){
var self__ = this;
var _16193__$1 = this;
return (new cljs.core.async.t_cljs$core$async16191(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16192__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16193){
var self__ = this;
var _16193__$1 = this;
return self__.meta16192;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16192","meta16192",-224500958,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16191";

cljs.core.async.t_cljs$core$async16191.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16191");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16191 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16191(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16192){
return (new cljs.core.async.t_cljs$core$async16191(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16192));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16191(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14375__auto___16369 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16293){
var state_val_16294 = (state_16293[(1)]);
if((state_val_16294 === (7))){
var inst_16211 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
var statearr_16295_16375 = state_16293__$1;
(statearr_16295_16375[(2)] = inst_16211);

(statearr_16295_16375[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (20))){
var inst_16223 = (state_16293[(7)]);
var state_16293__$1 = state_16293;
var statearr_16296_16376 = state_16293__$1;
(statearr_16296_16376[(2)] = inst_16223);

(statearr_16296_16376[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (27))){
var state_16293__$1 = state_16293;
var statearr_16297_16380 = state_16293__$1;
(statearr_16297_16380[(2)] = null);

(statearr_16297_16380[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (1))){
var inst_16199 = (state_16293[(8)]);
var inst_16199__$1 = calc_state.call(null);
var inst_16201 = (inst_16199__$1 == null);
var inst_16202 = cljs.core.not.call(null,inst_16201);
var state_16293__$1 = (function (){var statearr_16298 = state_16293;
(statearr_16298[(8)] = inst_16199__$1);

return statearr_16298;
})();
if(inst_16202){
var statearr_16299_16381 = state_16293__$1;
(statearr_16299_16381[(1)] = (2));

} else {
var statearr_16300_16382 = state_16293__$1;
(statearr_16300_16382[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (24))){
var inst_16267 = (state_16293[(9)]);
var inst_16246 = (state_16293[(10)]);
var inst_16253 = (state_16293[(11)]);
var inst_16267__$1 = inst_16246.call(null,inst_16253);
var state_16293__$1 = (function (){var statearr_16301 = state_16293;
(statearr_16301[(9)] = inst_16267__$1);

return statearr_16301;
})();
if(cljs.core.truth_(inst_16267__$1)){
var statearr_16302_16383 = state_16293__$1;
(statearr_16302_16383[(1)] = (29));

} else {
var statearr_16303_16384 = state_16293__$1;
(statearr_16303_16384[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (4))){
var inst_16214 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16214)){
var statearr_16304_16385 = state_16293__$1;
(statearr_16304_16385[(1)] = (8));

} else {
var statearr_16305_16386 = state_16293__$1;
(statearr_16305_16386[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (15))){
var inst_16240 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16240)){
var statearr_16306_16387 = state_16293__$1;
(statearr_16306_16387[(1)] = (19));

} else {
var statearr_16307_16388 = state_16293__$1;
(statearr_16307_16388[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (21))){
var inst_16245 = (state_16293[(12)]);
var inst_16245__$1 = (state_16293[(2)]);
var inst_16246 = cljs.core.get.call(null,inst_16245__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16247 = cljs.core.get.call(null,inst_16245__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16248 = cljs.core.get.call(null,inst_16245__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16293__$1 = (function (){var statearr_16308 = state_16293;
(statearr_16308[(10)] = inst_16246);

(statearr_16308[(13)] = inst_16247);

(statearr_16308[(12)] = inst_16245__$1);

return statearr_16308;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16293__$1,(22),inst_16248);
} else {
if((state_val_16294 === (31))){
var inst_16275 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16275)){
var statearr_16309_16390 = state_16293__$1;
(statearr_16309_16390[(1)] = (32));

} else {
var statearr_16310_16391 = state_16293__$1;
(statearr_16310_16391[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (32))){
var inst_16252 = (state_16293[(14)]);
var state_16293__$1 = state_16293;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16293__$1,(35),out,inst_16252);
} else {
if((state_val_16294 === (33))){
var inst_16245 = (state_16293[(12)]);
var inst_16223 = inst_16245;
var state_16293__$1 = (function (){var statearr_16311 = state_16293;
(statearr_16311[(7)] = inst_16223);

return statearr_16311;
})();
var statearr_16312_16392 = state_16293__$1;
(statearr_16312_16392[(2)] = null);

(statearr_16312_16392[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (13))){
var inst_16223 = (state_16293[(7)]);
var inst_16230 = inst_16223.cljs$lang$protocol_mask$partition0$;
var inst_16231 = (inst_16230 & (64));
var inst_16232 = inst_16223.cljs$core$ISeq$;
var inst_16233 = (inst_16231) || (inst_16232);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16233)){
var statearr_16313_16393 = state_16293__$1;
(statearr_16313_16393[(1)] = (16));

} else {
var statearr_16314_16394 = state_16293__$1;
(statearr_16314_16394[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (22))){
var inst_16253 = (state_16293[(11)]);
var inst_16252 = (state_16293[(14)]);
var inst_16251 = (state_16293[(2)]);
var inst_16252__$1 = cljs.core.nth.call(null,inst_16251,(0),null);
var inst_16253__$1 = cljs.core.nth.call(null,inst_16251,(1),null);
var inst_16254 = (inst_16252__$1 == null);
var inst_16255 = cljs.core._EQ_.call(null,inst_16253__$1,change);
var inst_16256 = (inst_16254) || (inst_16255);
var state_16293__$1 = (function (){var statearr_16320 = state_16293;
(statearr_16320[(11)] = inst_16253__$1);

(statearr_16320[(14)] = inst_16252__$1);

return statearr_16320;
})();
if(cljs.core.truth_(inst_16256)){
var statearr_16321_16395 = state_16293__$1;
(statearr_16321_16395[(1)] = (23));

} else {
var statearr_16322_16396 = state_16293__$1;
(statearr_16322_16396[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (36))){
var inst_16245 = (state_16293[(12)]);
var inst_16223 = inst_16245;
var state_16293__$1 = (function (){var statearr_16323 = state_16293;
(statearr_16323[(7)] = inst_16223);

return statearr_16323;
})();
var statearr_16324_16397 = state_16293__$1;
(statearr_16324_16397[(2)] = null);

(statearr_16324_16397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (29))){
var inst_16267 = (state_16293[(9)]);
var state_16293__$1 = state_16293;
var statearr_16325_16398 = state_16293__$1;
(statearr_16325_16398[(2)] = inst_16267);

(statearr_16325_16398[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (6))){
var state_16293__$1 = state_16293;
var statearr_16326_16399 = state_16293__$1;
(statearr_16326_16399[(2)] = false);

(statearr_16326_16399[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (28))){
var inst_16263 = (state_16293[(2)]);
var inst_16264 = calc_state.call(null);
var inst_16223 = inst_16264;
var state_16293__$1 = (function (){var statearr_16327 = state_16293;
(statearr_16327[(15)] = inst_16263);

(statearr_16327[(7)] = inst_16223);

return statearr_16327;
})();
var statearr_16328_16400 = state_16293__$1;
(statearr_16328_16400[(2)] = null);

(statearr_16328_16400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (25))){
var inst_16289 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
var statearr_16329_16401 = state_16293__$1;
(statearr_16329_16401[(2)] = inst_16289);

(statearr_16329_16401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (34))){
var inst_16287 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
var statearr_16330_16406 = state_16293__$1;
(statearr_16330_16406[(2)] = inst_16287);

(statearr_16330_16406[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (17))){
var state_16293__$1 = state_16293;
var statearr_16331_16408 = state_16293__$1;
(statearr_16331_16408[(2)] = false);

(statearr_16331_16408[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (3))){
var state_16293__$1 = state_16293;
var statearr_16332_16409 = state_16293__$1;
(statearr_16332_16409[(2)] = false);

(statearr_16332_16409[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (12))){
var inst_16291 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16293__$1,inst_16291);
} else {
if((state_val_16294 === (2))){
var inst_16199 = (state_16293[(8)]);
var inst_16204 = inst_16199.cljs$lang$protocol_mask$partition0$;
var inst_16205 = (inst_16204 & (64));
var inst_16206 = inst_16199.cljs$core$ISeq$;
var inst_16207 = (inst_16205) || (inst_16206);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16207)){
var statearr_16333_16410 = state_16293__$1;
(statearr_16333_16410[(1)] = (5));

} else {
var statearr_16334_16414 = state_16293__$1;
(statearr_16334_16414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (23))){
var inst_16252 = (state_16293[(14)]);
var inst_16258 = (inst_16252 == null);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16258)){
var statearr_16335_16415 = state_16293__$1;
(statearr_16335_16415[(1)] = (26));

} else {
var statearr_16336_16420 = state_16293__$1;
(statearr_16336_16420[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (35))){
var inst_16278 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
if(cljs.core.truth_(inst_16278)){
var statearr_16337_16421 = state_16293__$1;
(statearr_16337_16421[(1)] = (36));

} else {
var statearr_16338_16422 = state_16293__$1;
(statearr_16338_16422[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (19))){
var inst_16223 = (state_16293[(7)]);
var inst_16242 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16223);
var state_16293__$1 = state_16293;
var statearr_16339_16423 = state_16293__$1;
(statearr_16339_16423[(2)] = inst_16242);

(statearr_16339_16423[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (11))){
var inst_16223 = (state_16293[(7)]);
var inst_16227 = (inst_16223 == null);
var inst_16228 = cljs.core.not.call(null,inst_16227);
var state_16293__$1 = state_16293;
if(inst_16228){
var statearr_16340_16424 = state_16293__$1;
(statearr_16340_16424[(1)] = (13));

} else {
var statearr_16341_16425 = state_16293__$1;
(statearr_16341_16425[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (9))){
var inst_16199 = (state_16293[(8)]);
var state_16293__$1 = state_16293;
var statearr_16342_16427 = state_16293__$1;
(statearr_16342_16427[(2)] = inst_16199);

(statearr_16342_16427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (5))){
var state_16293__$1 = state_16293;
var statearr_16343_16428 = state_16293__$1;
(statearr_16343_16428[(2)] = true);

(statearr_16343_16428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (14))){
var state_16293__$1 = state_16293;
var statearr_16344_16429 = state_16293__$1;
(statearr_16344_16429[(2)] = false);

(statearr_16344_16429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (26))){
var inst_16253 = (state_16293[(11)]);
var inst_16260 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16253);
var state_16293__$1 = state_16293;
var statearr_16345_16430 = state_16293__$1;
(statearr_16345_16430[(2)] = inst_16260);

(statearr_16345_16430[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (16))){
var state_16293__$1 = state_16293;
var statearr_16346_16431 = state_16293__$1;
(statearr_16346_16431[(2)] = true);

(statearr_16346_16431[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (38))){
var inst_16283 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
var statearr_16347_16432 = state_16293__$1;
(statearr_16347_16432[(2)] = inst_16283);

(statearr_16347_16432[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (30))){
var inst_16246 = (state_16293[(10)]);
var inst_16247 = (state_16293[(13)]);
var inst_16253 = (state_16293[(11)]);
var inst_16270 = cljs.core.empty_QMARK_.call(null,inst_16246);
var inst_16271 = inst_16247.call(null,inst_16253);
var inst_16272 = cljs.core.not.call(null,inst_16271);
var inst_16273 = (inst_16270) && (inst_16272);
var state_16293__$1 = state_16293;
var statearr_16348_16433 = state_16293__$1;
(statearr_16348_16433[(2)] = inst_16273);

(statearr_16348_16433[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (10))){
var inst_16199 = (state_16293[(8)]);
var inst_16219 = (state_16293[(2)]);
var inst_16220 = cljs.core.get.call(null,inst_16219,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16221 = cljs.core.get.call(null,inst_16219,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16222 = cljs.core.get.call(null,inst_16219,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16223 = inst_16199;
var state_16293__$1 = (function (){var statearr_16349 = state_16293;
(statearr_16349[(16)] = inst_16221);

(statearr_16349[(17)] = inst_16220);

(statearr_16349[(18)] = inst_16222);

(statearr_16349[(7)] = inst_16223);

return statearr_16349;
})();
var statearr_16352_16434 = state_16293__$1;
(statearr_16352_16434[(2)] = null);

(statearr_16352_16434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (18))){
var inst_16237 = (state_16293[(2)]);
var state_16293__$1 = state_16293;
var statearr_16353_16435 = state_16293__$1;
(statearr_16353_16435[(2)] = inst_16237);

(statearr_16353_16435[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (37))){
var state_16293__$1 = state_16293;
var statearr_16354_16436 = state_16293__$1;
(statearr_16354_16436[(2)] = null);

(statearr_16354_16436[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16294 === (8))){
var inst_16199 = (state_16293[(8)]);
var inst_16216 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16199);
var state_16293__$1 = state_16293;
var statearr_16355_16437 = state_16293__$1;
(statearr_16355_16437[(2)] = inst_16216);

(statearr_16355_16437[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16361[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16361[(1)] = (1));

return statearr_16361;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16293){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16293);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16362){if((e16362 instanceof Object)){
var ex__14240__auto__ = e16362;
var statearr_16363_16438 = state_16293;
(statearr_16363_16438[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16293);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16439 = state_16293;
state_16293 = G__16439;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16293){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14377__auto__ = (function (){var statearr_16364 = f__14376__auto__.call(null);
(statearr_16364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16369);

return statearr_16364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16446 = [];
var len__7107__auto___16456 = arguments.length;
var i__7108__auto___16457 = (0);
while(true){
if((i__7108__auto___16457 < len__7107__auto___16456)){
args16446.push((arguments[i__7108__auto___16457]));

var G__16462 = (i__7108__auto___16457 + (1));
i__7108__auto___16457 = G__16462;
continue;
} else {
}
break;
}

var G__16451 = args16446.length;
switch (G__16451) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16446.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16472 = [];
var len__7107__auto___16598 = arguments.length;
var i__7108__auto___16599 = (0);
while(true){
if((i__7108__auto___16599 < len__7107__auto___16598)){
args16472.push((arguments[i__7108__auto___16599]));

var G__16600 = (i__7108__auto___16599 + (1));
i__7108__auto___16599 = G__16600;
continue;
} else {
}
break;
}

var G__16474 = args16472.length;
switch (G__16474) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16472.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16471_SHARP_){
if(cljs.core.truth_(p1__16471_SHARP_.call(null,topic))){
return p1__16471_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16471_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16475 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16475 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16476){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16476 = meta16476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16477,meta16476__$1){
var self__ = this;
var _16477__$1 = this;
return (new cljs.core.async.t_cljs$core$async16475(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16476__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16477){
var self__ = this;
var _16477__$1 = this;
return self__.meta16476;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16476","meta16476",-1432060876,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16475";

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16475");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16475 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476){
return (new cljs.core.async.t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16475(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14375__auto___16614 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16614,mults,ensure_mult,p){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16614,mults,ensure_mult,p){
return (function (state_16549){
var state_val_16550 = (state_16549[(1)]);
if((state_val_16550 === (7))){
var inst_16545 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16551_16616 = state_16549__$1;
(statearr_16551_16616[(2)] = inst_16545);

(statearr_16551_16616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (20))){
var state_16549__$1 = state_16549;
var statearr_16552_16617 = state_16549__$1;
(statearr_16552_16617[(2)] = null);

(statearr_16552_16617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (1))){
var state_16549__$1 = state_16549;
var statearr_16553_16618 = state_16549__$1;
(statearr_16553_16618[(2)] = null);

(statearr_16553_16618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (24))){
var inst_16528 = (state_16549[(7)]);
var inst_16537 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16528);
var state_16549__$1 = state_16549;
var statearr_16554_16619 = state_16549__$1;
(statearr_16554_16619[(2)] = inst_16537);

(statearr_16554_16619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (4))){
var inst_16480 = (state_16549[(8)]);
var inst_16480__$1 = (state_16549[(2)]);
var inst_16481 = (inst_16480__$1 == null);
var state_16549__$1 = (function (){var statearr_16555 = state_16549;
(statearr_16555[(8)] = inst_16480__$1);

return statearr_16555;
})();
if(cljs.core.truth_(inst_16481)){
var statearr_16556_16620 = state_16549__$1;
(statearr_16556_16620[(1)] = (5));

} else {
var statearr_16557_16621 = state_16549__$1;
(statearr_16557_16621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (15))){
var inst_16522 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16558_16622 = state_16549__$1;
(statearr_16558_16622[(2)] = inst_16522);

(statearr_16558_16622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (21))){
var inst_16542 = (state_16549[(2)]);
var state_16549__$1 = (function (){var statearr_16559 = state_16549;
(statearr_16559[(9)] = inst_16542);

return statearr_16559;
})();
var statearr_16560_16623 = state_16549__$1;
(statearr_16560_16623[(2)] = null);

(statearr_16560_16623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (13))){
var inst_16504 = (state_16549[(10)]);
var inst_16506 = cljs.core.chunked_seq_QMARK_.call(null,inst_16504);
var state_16549__$1 = state_16549;
if(inst_16506){
var statearr_16561_16624 = state_16549__$1;
(statearr_16561_16624[(1)] = (16));

} else {
var statearr_16562_16625 = state_16549__$1;
(statearr_16562_16625[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (22))){
var inst_16534 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
if(cljs.core.truth_(inst_16534)){
var statearr_16563_16626 = state_16549__$1;
(statearr_16563_16626[(1)] = (23));

} else {
var statearr_16564_16627 = state_16549__$1;
(statearr_16564_16627[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (6))){
var inst_16528 = (state_16549[(7)]);
var inst_16480 = (state_16549[(8)]);
var inst_16530 = (state_16549[(11)]);
var inst_16528__$1 = topic_fn.call(null,inst_16480);
var inst_16529 = cljs.core.deref.call(null,mults);
var inst_16530__$1 = cljs.core.get.call(null,inst_16529,inst_16528__$1);
var state_16549__$1 = (function (){var statearr_16565 = state_16549;
(statearr_16565[(7)] = inst_16528__$1);

(statearr_16565[(11)] = inst_16530__$1);

return statearr_16565;
})();
if(cljs.core.truth_(inst_16530__$1)){
var statearr_16566_16628 = state_16549__$1;
(statearr_16566_16628[(1)] = (19));

} else {
var statearr_16567_16629 = state_16549__$1;
(statearr_16567_16629[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (25))){
var inst_16539 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16568_16630 = state_16549__$1;
(statearr_16568_16630[(2)] = inst_16539);

(statearr_16568_16630[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (17))){
var inst_16504 = (state_16549[(10)]);
var inst_16513 = cljs.core.first.call(null,inst_16504);
var inst_16514 = cljs.core.async.muxch_STAR_.call(null,inst_16513);
var inst_16515 = cljs.core.async.close_BANG_.call(null,inst_16514);
var inst_16516 = cljs.core.next.call(null,inst_16504);
var inst_16490 = inst_16516;
var inst_16491 = null;
var inst_16492 = (0);
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16569 = state_16549;
(statearr_16569[(12)] = inst_16492);

(statearr_16569[(13)] = inst_16491);

(statearr_16569[(14)] = inst_16515);

(statearr_16569[(15)] = inst_16493);

(statearr_16569[(16)] = inst_16490);

return statearr_16569;
})();
var statearr_16570_16639 = state_16549__$1;
(statearr_16570_16639[(2)] = null);

(statearr_16570_16639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (3))){
var inst_16547 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16549__$1,inst_16547);
} else {
if((state_val_16550 === (12))){
var inst_16524 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16571_16643 = state_16549__$1;
(statearr_16571_16643[(2)] = inst_16524);

(statearr_16571_16643[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (2))){
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16549__$1,(4),ch);
} else {
if((state_val_16550 === (23))){
var state_16549__$1 = state_16549;
var statearr_16572_16645 = state_16549__$1;
(statearr_16572_16645[(2)] = null);

(statearr_16572_16645[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (19))){
var inst_16480 = (state_16549[(8)]);
var inst_16530 = (state_16549[(11)]);
var inst_16532 = cljs.core.async.muxch_STAR_.call(null,inst_16530);
var state_16549__$1 = state_16549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16549__$1,(22),inst_16532,inst_16480);
} else {
if((state_val_16550 === (11))){
var inst_16504 = (state_16549[(10)]);
var inst_16490 = (state_16549[(16)]);
var inst_16504__$1 = cljs.core.seq.call(null,inst_16490);
var state_16549__$1 = (function (){var statearr_16573 = state_16549;
(statearr_16573[(10)] = inst_16504__$1);

return statearr_16573;
})();
if(inst_16504__$1){
var statearr_16574_16646 = state_16549__$1;
(statearr_16574_16646[(1)] = (13));

} else {
var statearr_16575_16647 = state_16549__$1;
(statearr_16575_16647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (9))){
var inst_16526 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16577_16648 = state_16549__$1;
(statearr_16577_16648[(2)] = inst_16526);

(statearr_16577_16648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (5))){
var inst_16487 = cljs.core.deref.call(null,mults);
var inst_16488 = cljs.core.vals.call(null,inst_16487);
var inst_16489 = cljs.core.seq.call(null,inst_16488);
var inst_16490 = inst_16489;
var inst_16491 = null;
var inst_16492 = (0);
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16578 = state_16549;
(statearr_16578[(12)] = inst_16492);

(statearr_16578[(13)] = inst_16491);

(statearr_16578[(15)] = inst_16493);

(statearr_16578[(16)] = inst_16490);

return statearr_16578;
})();
var statearr_16579_16650 = state_16549__$1;
(statearr_16579_16650[(2)] = null);

(statearr_16579_16650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (14))){
var state_16549__$1 = state_16549;
var statearr_16583_16651 = state_16549__$1;
(statearr_16583_16651[(2)] = null);

(statearr_16583_16651[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (16))){
var inst_16504 = (state_16549[(10)]);
var inst_16508 = cljs.core.chunk_first.call(null,inst_16504);
var inst_16509 = cljs.core.chunk_rest.call(null,inst_16504);
var inst_16510 = cljs.core.count.call(null,inst_16508);
var inst_16490 = inst_16509;
var inst_16491 = inst_16508;
var inst_16492 = inst_16510;
var inst_16493 = (0);
var state_16549__$1 = (function (){var statearr_16584 = state_16549;
(statearr_16584[(12)] = inst_16492);

(statearr_16584[(13)] = inst_16491);

(statearr_16584[(15)] = inst_16493);

(statearr_16584[(16)] = inst_16490);

return statearr_16584;
})();
var statearr_16585_16653 = state_16549__$1;
(statearr_16585_16653[(2)] = null);

(statearr_16585_16653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (10))){
var inst_16492 = (state_16549[(12)]);
var inst_16491 = (state_16549[(13)]);
var inst_16493 = (state_16549[(15)]);
var inst_16490 = (state_16549[(16)]);
var inst_16498 = cljs.core._nth.call(null,inst_16491,inst_16493);
var inst_16499 = cljs.core.async.muxch_STAR_.call(null,inst_16498);
var inst_16500 = cljs.core.async.close_BANG_.call(null,inst_16499);
var inst_16501 = (inst_16493 + (1));
var tmp16580 = inst_16492;
var tmp16581 = inst_16491;
var tmp16582 = inst_16490;
var inst_16490__$1 = tmp16582;
var inst_16491__$1 = tmp16581;
var inst_16492__$1 = tmp16580;
var inst_16493__$1 = inst_16501;
var state_16549__$1 = (function (){var statearr_16586 = state_16549;
(statearr_16586[(12)] = inst_16492__$1);

(statearr_16586[(13)] = inst_16491__$1);

(statearr_16586[(15)] = inst_16493__$1);

(statearr_16586[(16)] = inst_16490__$1);

(statearr_16586[(17)] = inst_16500);

return statearr_16586;
})();
var statearr_16587_16658 = state_16549__$1;
(statearr_16587_16658[(2)] = null);

(statearr_16587_16658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (18))){
var inst_16519 = (state_16549[(2)]);
var state_16549__$1 = state_16549;
var statearr_16588_16659 = state_16549__$1;
(statearr_16588_16659[(2)] = inst_16519);

(statearr_16588_16659[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (8))){
var inst_16492 = (state_16549[(12)]);
var inst_16493 = (state_16549[(15)]);
var inst_16495 = (inst_16493 < inst_16492);
var inst_16496 = inst_16495;
var state_16549__$1 = state_16549;
if(cljs.core.truth_(inst_16496)){
var statearr_16589_16660 = state_16549__$1;
(statearr_16589_16660[(1)] = (10));

} else {
var statearr_16590_16664 = state_16549__$1;
(statearr_16590_16664[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16614,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14375__auto___16614,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16594[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16594[(1)] = (1));

return statearr_16594;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16549){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16595){if((e16595 instanceof Object)){
var ex__14240__auto__ = e16595;
var statearr_16596_16669 = state_16549;
(statearr_16596_16669[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16670 = state_16549;
state_16549 = G__16670;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16614,mults,ensure_mult,p))
})();
var state__14377__auto__ = (function (){var statearr_16597 = f__14376__auto__.call(null);
(statearr_16597[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16614);

return statearr_16597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16614,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16671 = [];
var len__7107__auto___16675 = arguments.length;
var i__7108__auto___16676 = (0);
while(true){
if((i__7108__auto___16676 < len__7107__auto___16675)){
args16671.push((arguments[i__7108__auto___16676]));

var G__16677 = (i__7108__auto___16676 + (1));
i__7108__auto___16676 = G__16677;
continue;
} else {
}
break;
}

var G__16673 = args16671.length;
switch (G__16673) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16671.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16679 = [];
var len__7107__auto___16682 = arguments.length;
var i__7108__auto___16683 = (0);
while(true){
if((i__7108__auto___16683 < len__7107__auto___16682)){
args16679.push((arguments[i__7108__auto___16683]));

var G__16684 = (i__7108__auto___16683 + (1));
i__7108__auto___16683 = G__16684;
continue;
} else {
}
break;
}

var G__16681 = args16679.length;
switch (G__16681) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16679.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16686 = [];
var len__7107__auto___16766 = arguments.length;
var i__7108__auto___16767 = (0);
while(true){
if((i__7108__auto___16767 < len__7107__auto___16766)){
args16686.push((arguments[i__7108__auto___16767]));

var G__16768 = (i__7108__auto___16767 + (1));
i__7108__auto___16767 = G__16768;
continue;
} else {
}
break;
}

var G__16688 = args16686.length;
switch (G__16688) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16686.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14375__auto___16774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16728){
var state_val_16729 = (state_16728[(1)]);
if((state_val_16729 === (7))){
var state_16728__$1 = state_16728;
var statearr_16730_16775 = state_16728__$1;
(statearr_16730_16775[(2)] = null);

(statearr_16730_16775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (1))){
var state_16728__$1 = state_16728;
var statearr_16731_16776 = state_16728__$1;
(statearr_16731_16776[(2)] = null);

(statearr_16731_16776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (4))){
var inst_16691 = (state_16728[(7)]);
var inst_16693 = (inst_16691 < cnt);
var state_16728__$1 = state_16728;
if(cljs.core.truth_(inst_16693)){
var statearr_16732_16777 = state_16728__$1;
(statearr_16732_16777[(1)] = (6));

} else {
var statearr_16733_16778 = state_16728__$1;
(statearr_16733_16778[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (15))){
var inst_16724 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
var statearr_16734_16780 = state_16728__$1;
(statearr_16734_16780[(2)] = inst_16724);

(statearr_16734_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (13))){
var inst_16717 = cljs.core.async.close_BANG_.call(null,out);
var state_16728__$1 = state_16728;
var statearr_16735_16781 = state_16728__$1;
(statearr_16735_16781[(2)] = inst_16717);

(statearr_16735_16781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (6))){
var state_16728__$1 = state_16728;
var statearr_16736_16782 = state_16728__$1;
(statearr_16736_16782[(2)] = null);

(statearr_16736_16782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (3))){
var inst_16726 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16728__$1,inst_16726);
} else {
if((state_val_16729 === (12))){
var inst_16714 = (state_16728[(8)]);
var inst_16714__$1 = (state_16728[(2)]);
var inst_16715 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16714__$1);
var state_16728__$1 = (function (){var statearr_16738 = state_16728;
(statearr_16738[(8)] = inst_16714__$1);

return statearr_16738;
})();
if(cljs.core.truth_(inst_16715)){
var statearr_16739_16783 = state_16728__$1;
(statearr_16739_16783[(1)] = (13));

} else {
var statearr_16740_16784 = state_16728__$1;
(statearr_16740_16784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (2))){
var inst_16690 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16691 = (0);
var state_16728__$1 = (function (){var statearr_16741 = state_16728;
(statearr_16741[(9)] = inst_16690);

(statearr_16741[(7)] = inst_16691);

return statearr_16741;
})();
var statearr_16742_16785 = state_16728__$1;
(statearr_16742_16785[(2)] = null);

(statearr_16742_16785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (11))){
var inst_16691 = (state_16728[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16728,(10),Object,null,(9));
var inst_16701 = chs__$1.call(null,inst_16691);
var inst_16702 = done.call(null,inst_16691);
var inst_16703 = cljs.core.async.take_BANG_.call(null,inst_16701,inst_16702);
var state_16728__$1 = state_16728;
var statearr_16743_16786 = state_16728__$1;
(statearr_16743_16786[(2)] = inst_16703);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (9))){
var inst_16691 = (state_16728[(7)]);
var inst_16705 = (state_16728[(2)]);
var inst_16706 = (inst_16691 + (1));
var inst_16691__$1 = inst_16706;
var state_16728__$1 = (function (){var statearr_16744 = state_16728;
(statearr_16744[(10)] = inst_16705);

(statearr_16744[(7)] = inst_16691__$1);

return statearr_16744;
})();
var statearr_16745_16787 = state_16728__$1;
(statearr_16745_16787[(2)] = null);

(statearr_16745_16787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (5))){
var inst_16712 = (state_16728[(2)]);
var state_16728__$1 = (function (){var statearr_16747 = state_16728;
(statearr_16747[(11)] = inst_16712);

return statearr_16747;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16728__$1,(12),dchan);
} else {
if((state_val_16729 === (14))){
var inst_16714 = (state_16728[(8)]);
var inst_16719 = cljs.core.apply.call(null,f,inst_16714);
var state_16728__$1 = state_16728;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16728__$1,(16),out,inst_16719);
} else {
if((state_val_16729 === (16))){
var inst_16721 = (state_16728[(2)]);
var state_16728__$1 = (function (){var statearr_16750 = state_16728;
(statearr_16750[(12)] = inst_16721);

return statearr_16750;
})();
var statearr_16751_16788 = state_16728__$1;
(statearr_16751_16788[(2)] = null);

(statearr_16751_16788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (10))){
var inst_16695 = (state_16728[(2)]);
var inst_16697 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16728__$1 = (function (){var statearr_16752 = state_16728;
(statearr_16752[(13)] = inst_16695);

return statearr_16752;
})();
var statearr_16753_16789 = state_16728__$1;
(statearr_16753_16789[(2)] = inst_16697);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16729 === (8))){
var inst_16710 = (state_16728[(2)]);
var state_16728__$1 = state_16728;
var statearr_16754_16790 = state_16728__$1;
(statearr_16754_16790[(2)] = inst_16710);

(statearr_16754_16790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16758[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16758[(1)] = (1));

return statearr_16758;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16728){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16760){if((e16760 instanceof Object)){
var ex__14240__auto__ = e16760;
var statearr_16763_16791 = state_16728;
(statearr_16763_16791[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16760;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16792 = state_16728;
state_16728 = G__16792;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16728){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14377__auto__ = (function (){var statearr_16764 = f__14376__auto__.call(null);
(statearr_16764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16774);

return statearr_16764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16795 = [];
var len__7107__auto___16862 = arguments.length;
var i__7108__auto___16863 = (0);
while(true){
if((i__7108__auto___16863 < len__7107__auto___16862)){
args16795.push((arguments[i__7108__auto___16863]));

var G__16864 = (i__7108__auto___16863 + (1));
i__7108__auto___16863 = G__16864;
continue;
} else {
}
break;
}

var G__16798 = args16795.length;
switch (G__16798) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16795.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___16869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16869,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16869,out){
return (function (state_16832){
var state_val_16833 = (state_16832[(1)]);
if((state_val_16833 === (7))){
var inst_16809 = (state_16832[(7)]);
var inst_16808 = (state_16832[(8)]);
var inst_16808__$1 = (state_16832[(2)]);
var inst_16809__$1 = cljs.core.nth.call(null,inst_16808__$1,(0),null);
var inst_16811 = cljs.core.nth.call(null,inst_16808__$1,(1),null);
var inst_16812 = (inst_16809__$1 == null);
var state_16832__$1 = (function (){var statearr_16835 = state_16832;
(statearr_16835[(7)] = inst_16809__$1);

(statearr_16835[(8)] = inst_16808__$1);

(statearr_16835[(9)] = inst_16811);

return statearr_16835;
})();
if(cljs.core.truth_(inst_16812)){
var statearr_16836_16870 = state_16832__$1;
(statearr_16836_16870[(1)] = (8));

} else {
var statearr_16837_16871 = state_16832__$1;
(statearr_16837_16871[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (1))){
var inst_16800 = cljs.core.vec.call(null,chs);
var inst_16801 = inst_16800;
var state_16832__$1 = (function (){var statearr_16838 = state_16832;
(statearr_16838[(10)] = inst_16801);

return statearr_16838;
})();
var statearr_16839_16873 = state_16832__$1;
(statearr_16839_16873[(2)] = null);

(statearr_16839_16873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (4))){
var inst_16801 = (state_16832[(10)]);
var state_16832__$1 = state_16832;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16832__$1,(7),inst_16801);
} else {
if((state_val_16833 === (6))){
var inst_16828 = (state_16832[(2)]);
var state_16832__$1 = state_16832;
var statearr_16840_16874 = state_16832__$1;
(statearr_16840_16874[(2)] = inst_16828);

(statearr_16840_16874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (3))){
var inst_16830 = (state_16832[(2)]);
var state_16832__$1 = state_16832;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16832__$1,inst_16830);
} else {
if((state_val_16833 === (2))){
var inst_16801 = (state_16832[(10)]);
var inst_16803 = cljs.core.count.call(null,inst_16801);
var inst_16804 = (inst_16803 > (0));
var state_16832__$1 = state_16832;
if(cljs.core.truth_(inst_16804)){
var statearr_16842_16875 = state_16832__$1;
(statearr_16842_16875[(1)] = (4));

} else {
var statearr_16843_16876 = state_16832__$1;
(statearr_16843_16876[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (11))){
var inst_16801 = (state_16832[(10)]);
var inst_16820 = (state_16832[(2)]);
var tmp16841 = inst_16801;
var inst_16801__$1 = tmp16841;
var state_16832__$1 = (function (){var statearr_16844 = state_16832;
(statearr_16844[(10)] = inst_16801__$1);

(statearr_16844[(11)] = inst_16820);

return statearr_16844;
})();
var statearr_16845_16877 = state_16832__$1;
(statearr_16845_16877[(2)] = null);

(statearr_16845_16877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (9))){
var inst_16809 = (state_16832[(7)]);
var state_16832__$1 = state_16832;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16832__$1,(11),out,inst_16809);
} else {
if((state_val_16833 === (5))){
var inst_16826 = cljs.core.async.close_BANG_.call(null,out);
var state_16832__$1 = state_16832;
var statearr_16850_16878 = state_16832__$1;
(statearr_16850_16878[(2)] = inst_16826);

(statearr_16850_16878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (10))){
var inst_16823 = (state_16832[(2)]);
var state_16832__$1 = state_16832;
var statearr_16851_16879 = state_16832__$1;
(statearr_16851_16879[(2)] = inst_16823);

(statearr_16851_16879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16833 === (8))){
var inst_16809 = (state_16832[(7)]);
var inst_16808 = (state_16832[(8)]);
var inst_16811 = (state_16832[(9)]);
var inst_16801 = (state_16832[(10)]);
var inst_16815 = (function (){var cs = inst_16801;
var vec__16806 = inst_16808;
var v = inst_16809;
var c = inst_16811;
return ((function (cs,vec__16806,v,c,inst_16809,inst_16808,inst_16811,inst_16801,state_val_16833,c__14375__auto___16869,out){
return (function (p1__16794_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16794_SHARP_);
});
;})(cs,vec__16806,v,c,inst_16809,inst_16808,inst_16811,inst_16801,state_val_16833,c__14375__auto___16869,out))
})();
var inst_16816 = cljs.core.filterv.call(null,inst_16815,inst_16801);
var inst_16801__$1 = inst_16816;
var state_16832__$1 = (function (){var statearr_16852 = state_16832;
(statearr_16852[(10)] = inst_16801__$1);

return statearr_16852;
})();
var statearr_16853_16880 = state_16832__$1;
(statearr_16853_16880[(2)] = null);

(statearr_16853_16880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16869,out))
;
return ((function (switch__14236__auto__,c__14375__auto___16869,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16858 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16858[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16858[(1)] = (1));

return statearr_16858;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16832){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16832);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16859){if((e16859 instanceof Object)){
var ex__14240__auto__ = e16859;
var statearr_16860_16881 = state_16832;
(statearr_16860_16881[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16832);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16882 = state_16832;
state_16832 = G__16882;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16832){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16869,out))
})();
var state__14377__auto__ = (function (){var statearr_16861 = f__14376__auto__.call(null);
(statearr_16861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16869);

return statearr_16861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16869,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16883 = [];
var len__7107__auto___16940 = arguments.length;
var i__7108__auto___16941 = (0);
while(true){
if((i__7108__auto___16941 < len__7107__auto___16940)){
args16883.push((arguments[i__7108__auto___16941]));

var G__16942 = (i__7108__auto___16941 + (1));
i__7108__auto___16941 = G__16942;
continue;
} else {
}
break;
}

var G__16886 = args16883.length;
switch (G__16886) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16883.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___16947 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16947,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16947,out){
return (function (state_16910){
var state_val_16911 = (state_16910[(1)]);
if((state_val_16911 === (7))){
var inst_16892 = (state_16910[(7)]);
var inst_16892__$1 = (state_16910[(2)]);
var inst_16893 = (inst_16892__$1 == null);
var inst_16894 = cljs.core.not.call(null,inst_16893);
var state_16910__$1 = (function (){var statearr_16915 = state_16910;
(statearr_16915[(7)] = inst_16892__$1);

return statearr_16915;
})();
if(inst_16894){
var statearr_16916_16949 = state_16910__$1;
(statearr_16916_16949[(1)] = (8));

} else {
var statearr_16917_16950 = state_16910__$1;
(statearr_16917_16950[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (1))){
var inst_16887 = (0);
var state_16910__$1 = (function (){var statearr_16918 = state_16910;
(statearr_16918[(8)] = inst_16887);

return statearr_16918;
})();
var statearr_16919_16954 = state_16910__$1;
(statearr_16919_16954[(2)] = null);

(statearr_16919_16954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (4))){
var state_16910__$1 = state_16910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16910__$1,(7),ch);
} else {
if((state_val_16911 === (6))){
var inst_16905 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16920_16955 = state_16910__$1;
(statearr_16920_16955[(2)] = inst_16905);

(statearr_16920_16955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (3))){
var inst_16907 = (state_16910[(2)]);
var inst_16908 = cljs.core.async.close_BANG_.call(null,out);
var state_16910__$1 = (function (){var statearr_16921 = state_16910;
(statearr_16921[(9)] = inst_16907);

return statearr_16921;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16910__$1,inst_16908);
} else {
if((state_val_16911 === (2))){
var inst_16887 = (state_16910[(8)]);
var inst_16889 = (inst_16887 < n);
var state_16910__$1 = state_16910;
if(cljs.core.truth_(inst_16889)){
var statearr_16922_16956 = state_16910__$1;
(statearr_16922_16956[(1)] = (4));

} else {
var statearr_16923_16957 = state_16910__$1;
(statearr_16923_16957[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (11))){
var inst_16887 = (state_16910[(8)]);
var inst_16897 = (state_16910[(2)]);
var inst_16898 = (inst_16887 + (1));
var inst_16887__$1 = inst_16898;
var state_16910__$1 = (function (){var statearr_16924 = state_16910;
(statearr_16924[(8)] = inst_16887__$1);

(statearr_16924[(10)] = inst_16897);

return statearr_16924;
})();
var statearr_16925_16959 = state_16910__$1;
(statearr_16925_16959[(2)] = null);

(statearr_16925_16959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (9))){
var state_16910__$1 = state_16910;
var statearr_16926_16960 = state_16910__$1;
(statearr_16926_16960[(2)] = null);

(statearr_16926_16960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (5))){
var state_16910__$1 = state_16910;
var statearr_16927_16961 = state_16910__$1;
(statearr_16927_16961[(2)] = null);

(statearr_16927_16961[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (10))){
var inst_16902 = (state_16910[(2)]);
var state_16910__$1 = state_16910;
var statearr_16929_16962 = state_16910__$1;
(statearr_16929_16962[(2)] = inst_16902);

(statearr_16929_16962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16911 === (8))){
var inst_16892 = (state_16910[(7)]);
var state_16910__$1 = state_16910;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16910__$1,(11),out,inst_16892);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16947,out))
;
return ((function (switch__14236__auto__,c__14375__auto___16947,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16936 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16936[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16936[(1)] = (1));

return statearr_16936;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16910){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16937){if((e16937 instanceof Object)){
var ex__14240__auto__ = e16937;
var statearr_16938_16963 = state_16910;
(statearr_16938_16963[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16910);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16964 = state_16910;
state_16910 = G__16964;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16947,out))
})();
var state__14377__auto__ = (function (){var statearr_16939 = f__14376__auto__.call(null);
(statearr_16939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16947);

return statearr_16939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16947,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16972 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16972 = (function (map_LT_,f,ch,meta16973){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16974,meta16973__$1){
var self__ = this;
var _16974__$1 = this;
return (new cljs.core.async.t_cljs$core$async16972(self__.map_LT_,self__.f,self__.ch,meta16973__$1));
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16974){
var self__ = this;
var _16974__$1 = this;
return self__.meta16973;
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16975 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16975 = (function (map_LT_,f,ch,meta16973,_,fn1,meta16976){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this._ = _;
this.fn1 = fn1;
this.meta16976 = meta16976;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16977,meta16976__$1){
var self__ = this;
var _16977__$1 = this;
return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,self__._,self__.fn1,meta16976__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16977){
var self__ = this;
var _16977__$1 = this;
return self__.meta16976;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16965_SHARP_){
return f1.call(null,(((p1__16965_SHARP_ == null))?null:self__.f.call(null,p1__16965_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16972","cljs.core.async/t_cljs$core$async16972",1733444675,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16976","meta16976",163212366,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16975";

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16975");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16975 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976){
return (new cljs.core.async.t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16972.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null)], null);
});

cljs.core.async.t_cljs$core$async16972.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16972";

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16972");
});

cljs.core.async.__GT_t_cljs$core$async16972 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973){
return (new cljs.core.async.t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973));
});

}

return (new cljs.core.async.t_cljs$core$async16972(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16993 = (function (map_GT_,f,ch,meta16994){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16994 = meta16994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16995,meta16994__$1){
var self__ = this;
var _16995__$1 = this;
return (new cljs.core.async.t_cljs$core$async16993(self__.map_GT_,self__.f,self__.ch,meta16994__$1));
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16995){
var self__ = this;
var _16995__$1 = this;
return self__.meta16994;
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16994","meta16994",-1938814879,null)], null);
});

cljs.core.async.t_cljs$core$async16993.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16993";

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16993");
});

cljs.core.async.__GT_t_cljs$core$async16993 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994){
return (new cljs.core.async.t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994));
});

}

return (new cljs.core.async.t_cljs$core$async16993(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17003 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17003 = (function (filter_GT_,p,ch,meta17004){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta17004 = meta17004;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17005,meta17004__$1){
var self__ = this;
var _17005__$1 = this;
return (new cljs.core.async.t_cljs$core$async17003(self__.filter_GT_,self__.p,self__.ch,meta17004__$1));
});

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17005){
var self__ = this;
var _17005__$1 = this;
return self__.meta17004;
});

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async17003.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17003.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17004","meta17004",1032209201,null)], null);
});

cljs.core.async.t_cljs$core$async17003.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17003.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17003";

cljs.core.async.t_cljs$core$async17003.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async17003");
});

cljs.core.async.__GT_t_cljs$core$async17003 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17003(filter_GT___$1,p__$1,ch__$1,meta17004){
return (new cljs.core.async.t_cljs$core$async17003(filter_GT___$1,p__$1,ch__$1,meta17004));
});

}

return (new cljs.core.async.t_cljs$core$async17003(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17010 = [];
var len__7107__auto___17054 = arguments.length;
var i__7108__auto___17055 = (0);
while(true){
if((i__7108__auto___17055 < len__7107__auto___17054)){
args17010.push((arguments[i__7108__auto___17055]));

var G__17056 = (i__7108__auto___17055 + (1));
i__7108__auto___17055 = G__17056;
continue;
} else {
}
break;
}

var G__17012 = args17010.length;
switch (G__17012) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17010.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17058 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17058,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17058,out){
return (function (state_17033){
var state_val_17034 = (state_17033[(1)]);
if((state_val_17034 === (7))){
var inst_17029 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17035_17061 = state_17033__$1;
(statearr_17035_17061[(2)] = inst_17029);

(statearr_17035_17061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (1))){
var state_17033__$1 = state_17033;
var statearr_17036_17063 = state_17033__$1;
(statearr_17036_17063[(2)] = null);

(statearr_17036_17063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (4))){
var inst_17015 = (state_17033[(7)]);
var inst_17015__$1 = (state_17033[(2)]);
var inst_17016 = (inst_17015__$1 == null);
var state_17033__$1 = (function (){var statearr_17037 = state_17033;
(statearr_17037[(7)] = inst_17015__$1);

return statearr_17037;
})();
if(cljs.core.truth_(inst_17016)){
var statearr_17038_17065 = state_17033__$1;
(statearr_17038_17065[(1)] = (5));

} else {
var statearr_17039_17066 = state_17033__$1;
(statearr_17039_17066[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (6))){
var inst_17015 = (state_17033[(7)]);
var inst_17020 = p.call(null,inst_17015);
var state_17033__$1 = state_17033;
if(cljs.core.truth_(inst_17020)){
var statearr_17040_17067 = state_17033__$1;
(statearr_17040_17067[(1)] = (8));

} else {
var statearr_17041_17068 = state_17033__$1;
(statearr_17041_17068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (3))){
var inst_17031 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17033__$1,inst_17031);
} else {
if((state_val_17034 === (2))){
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17033__$1,(4),ch);
} else {
if((state_val_17034 === (11))){
var inst_17023 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17042_17072 = state_17033__$1;
(statearr_17042_17072[(2)] = inst_17023);

(statearr_17042_17072[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (9))){
var state_17033__$1 = state_17033;
var statearr_17043_17073 = state_17033__$1;
(statearr_17043_17073[(2)] = null);

(statearr_17043_17073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (5))){
var inst_17018 = cljs.core.async.close_BANG_.call(null,out);
var state_17033__$1 = state_17033;
var statearr_17044_17074 = state_17033__$1;
(statearr_17044_17074[(2)] = inst_17018);

(statearr_17044_17074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (10))){
var inst_17026 = (state_17033[(2)]);
var state_17033__$1 = (function (){var statearr_17045 = state_17033;
(statearr_17045[(8)] = inst_17026);

return statearr_17045;
})();
var statearr_17046_17075 = state_17033__$1;
(statearr_17046_17075[(2)] = null);

(statearr_17046_17075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (8))){
var inst_17015 = (state_17033[(7)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17033__$1,(11),out,inst_17015);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17058,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17058,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17050 = [null,null,null,null,null,null,null,null,null];
(statearr_17050[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17050[(1)] = (1));

return statearr_17050;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17033){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17051){if((e17051 instanceof Object)){
var ex__14240__auto__ = e17051;
var statearr_17052_17077 = state_17033;
(statearr_17052_17077[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17078 = state_17033;
state_17033 = G__17078;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17033){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17058,out))
})();
var state__14377__auto__ = (function (){var statearr_17053 = f__14376__auto__.call(null);
(statearr_17053[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17058);

return statearr_17053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17058,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17079 = [];
var len__7107__auto___17082 = arguments.length;
var i__7108__auto___17083 = (0);
while(true){
if((i__7108__auto___17083 < len__7107__auto___17082)){
args17079.push((arguments[i__7108__auto___17083]));

var G__17084 = (i__7108__auto___17083 + (1));
i__7108__auto___17083 = G__17084;
continue;
} else {
}
break;
}

var G__17081 = args17079.length;
switch (G__17081) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17079.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_17262){
var state_val_17263 = (state_17262[(1)]);
if((state_val_17263 === (7))){
var inst_17258 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
var statearr_17264_17306 = state_17262__$1;
(statearr_17264_17306[(2)] = inst_17258);

(statearr_17264_17306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (20))){
var inst_17228 = (state_17262[(7)]);
var inst_17239 = (state_17262[(2)]);
var inst_17240 = cljs.core.next.call(null,inst_17228);
var inst_17210 = inst_17240;
var inst_17211 = null;
var inst_17212 = (0);
var inst_17213 = (0);
var state_17262__$1 = (function (){var statearr_17265 = state_17262;
(statearr_17265[(8)] = inst_17210);

(statearr_17265[(9)] = inst_17213);

(statearr_17265[(10)] = inst_17239);

(statearr_17265[(11)] = inst_17211);

(statearr_17265[(12)] = inst_17212);

return statearr_17265;
})();
var statearr_17266_17307 = state_17262__$1;
(statearr_17266_17307[(2)] = null);

(statearr_17266_17307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (1))){
var state_17262__$1 = state_17262;
var statearr_17267_17308 = state_17262__$1;
(statearr_17267_17308[(2)] = null);

(statearr_17267_17308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (4))){
var inst_17199 = (state_17262[(13)]);
var inst_17199__$1 = (state_17262[(2)]);
var inst_17200 = (inst_17199__$1 == null);
var state_17262__$1 = (function (){var statearr_17268 = state_17262;
(statearr_17268[(13)] = inst_17199__$1);

return statearr_17268;
})();
if(cljs.core.truth_(inst_17200)){
var statearr_17269_17309 = state_17262__$1;
(statearr_17269_17309[(1)] = (5));

} else {
var statearr_17270_17310 = state_17262__$1;
(statearr_17270_17310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (15))){
var state_17262__$1 = state_17262;
var statearr_17274_17311 = state_17262__$1;
(statearr_17274_17311[(2)] = null);

(statearr_17274_17311[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (21))){
var state_17262__$1 = state_17262;
var statearr_17276_17312 = state_17262__$1;
(statearr_17276_17312[(2)] = null);

(statearr_17276_17312[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (13))){
var inst_17210 = (state_17262[(8)]);
var inst_17213 = (state_17262[(9)]);
var inst_17211 = (state_17262[(11)]);
var inst_17212 = (state_17262[(12)]);
var inst_17224 = (state_17262[(2)]);
var inst_17225 = (inst_17213 + (1));
var tmp17271 = inst_17210;
var tmp17272 = inst_17211;
var tmp17273 = inst_17212;
var inst_17210__$1 = tmp17271;
var inst_17211__$1 = tmp17272;
var inst_17212__$1 = tmp17273;
var inst_17213__$1 = inst_17225;
var state_17262__$1 = (function (){var statearr_17277 = state_17262;
(statearr_17277[(14)] = inst_17224);

(statearr_17277[(8)] = inst_17210__$1);

(statearr_17277[(9)] = inst_17213__$1);

(statearr_17277[(11)] = inst_17211__$1);

(statearr_17277[(12)] = inst_17212__$1);

return statearr_17277;
})();
var statearr_17278_17313 = state_17262__$1;
(statearr_17278_17313[(2)] = null);

(statearr_17278_17313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (22))){
var state_17262__$1 = state_17262;
var statearr_17279_17314 = state_17262__$1;
(statearr_17279_17314[(2)] = null);

(statearr_17279_17314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (6))){
var inst_17199 = (state_17262[(13)]);
var inst_17208 = f.call(null,inst_17199);
var inst_17209 = cljs.core.seq.call(null,inst_17208);
var inst_17210 = inst_17209;
var inst_17211 = null;
var inst_17212 = (0);
var inst_17213 = (0);
var state_17262__$1 = (function (){var statearr_17280 = state_17262;
(statearr_17280[(8)] = inst_17210);

(statearr_17280[(9)] = inst_17213);

(statearr_17280[(11)] = inst_17211);

(statearr_17280[(12)] = inst_17212);

return statearr_17280;
})();
var statearr_17281_17315 = state_17262__$1;
(statearr_17281_17315[(2)] = null);

(statearr_17281_17315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (17))){
var inst_17228 = (state_17262[(7)]);
var inst_17232 = cljs.core.chunk_first.call(null,inst_17228);
var inst_17233 = cljs.core.chunk_rest.call(null,inst_17228);
var inst_17234 = cljs.core.count.call(null,inst_17232);
var inst_17210 = inst_17233;
var inst_17211 = inst_17232;
var inst_17212 = inst_17234;
var inst_17213 = (0);
var state_17262__$1 = (function (){var statearr_17282 = state_17262;
(statearr_17282[(8)] = inst_17210);

(statearr_17282[(9)] = inst_17213);

(statearr_17282[(11)] = inst_17211);

(statearr_17282[(12)] = inst_17212);

return statearr_17282;
})();
var statearr_17283_17316 = state_17262__$1;
(statearr_17283_17316[(2)] = null);

(statearr_17283_17316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (3))){
var inst_17260 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17262__$1,inst_17260);
} else {
if((state_val_17263 === (12))){
var inst_17248 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
var statearr_17284_17317 = state_17262__$1;
(statearr_17284_17317[(2)] = inst_17248);

(statearr_17284_17317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (2))){
var state_17262__$1 = state_17262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17262__$1,(4),in$);
} else {
if((state_val_17263 === (23))){
var inst_17256 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
var statearr_17285_17318 = state_17262__$1;
(statearr_17285_17318[(2)] = inst_17256);

(statearr_17285_17318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (19))){
var inst_17243 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
var statearr_17286_17320 = state_17262__$1;
(statearr_17286_17320[(2)] = inst_17243);

(statearr_17286_17320[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (11))){
var inst_17228 = (state_17262[(7)]);
var inst_17210 = (state_17262[(8)]);
var inst_17228__$1 = cljs.core.seq.call(null,inst_17210);
var state_17262__$1 = (function (){var statearr_17287 = state_17262;
(statearr_17287[(7)] = inst_17228__$1);

return statearr_17287;
})();
if(inst_17228__$1){
var statearr_17288_17325 = state_17262__$1;
(statearr_17288_17325[(1)] = (14));

} else {
var statearr_17289_17326 = state_17262__$1;
(statearr_17289_17326[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (9))){
var inst_17250 = (state_17262[(2)]);
var inst_17251 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17262__$1 = (function (){var statearr_17290 = state_17262;
(statearr_17290[(15)] = inst_17250);

return statearr_17290;
})();
if(cljs.core.truth_(inst_17251)){
var statearr_17291_17329 = state_17262__$1;
(statearr_17291_17329[(1)] = (21));

} else {
var statearr_17292_17330 = state_17262__$1;
(statearr_17292_17330[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (5))){
var inst_17202 = cljs.core.async.close_BANG_.call(null,out);
var state_17262__$1 = state_17262;
var statearr_17293_17332 = state_17262__$1;
(statearr_17293_17332[(2)] = inst_17202);

(statearr_17293_17332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (14))){
var inst_17228 = (state_17262[(7)]);
var inst_17230 = cljs.core.chunked_seq_QMARK_.call(null,inst_17228);
var state_17262__$1 = state_17262;
if(inst_17230){
var statearr_17294_17334 = state_17262__$1;
(statearr_17294_17334[(1)] = (17));

} else {
var statearr_17295_17335 = state_17262__$1;
(statearr_17295_17335[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (16))){
var inst_17246 = (state_17262[(2)]);
var state_17262__$1 = state_17262;
var statearr_17296_17336 = state_17262__$1;
(statearr_17296_17336[(2)] = inst_17246);

(statearr_17296_17336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17263 === (10))){
var inst_17213 = (state_17262[(9)]);
var inst_17211 = (state_17262[(11)]);
var inst_17222 = cljs.core._nth.call(null,inst_17211,inst_17213);
var state_17262__$1 = state_17262;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17262__$1,(13),out,inst_17222);
} else {
if((state_val_17263 === (18))){
var inst_17228 = (state_17262[(7)]);
var inst_17237 = cljs.core.first.call(null,inst_17228);
var state_17262__$1 = state_17262;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17262__$1,(20),out,inst_17237);
} else {
if((state_val_17263 === (8))){
var inst_17213 = (state_17262[(9)]);
var inst_17212 = (state_17262[(12)]);
var inst_17217 = (inst_17213 < inst_17212);
var inst_17219 = inst_17217;
var state_17262__$1 = state_17262;
if(cljs.core.truth_(inst_17219)){
var statearr_17297_17343 = state_17262__$1;
(statearr_17297_17343[(1)] = (10));

} else {
var statearr_17298_17344 = state_17262__$1;
(statearr_17298_17344[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17302[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17302[(1)] = (1));

return statearr_17302;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17262){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17303){if((e17303 instanceof Object)){
var ex__14240__auto__ = e17303;
var statearr_17304_17347 = state_17262;
(statearr_17304_17347[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17349 = state_17262;
state_17262 = G__17349;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17262){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_17305 = f__14376__auto__.call(null);
(statearr_17305[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_17305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17350 = [];
var len__7107__auto___17353 = arguments.length;
var i__7108__auto___17354 = (0);
while(true){
if((i__7108__auto___17354 < len__7107__auto___17353)){
args17350.push((arguments[i__7108__auto___17354]));

var G__17355 = (i__7108__auto___17354 + (1));
i__7108__auto___17354 = G__17355;
continue;
} else {
}
break;
}

var G__17352 = args17350.length;
switch (G__17352) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17350.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17358 = [];
var len__7107__auto___17361 = arguments.length;
var i__7108__auto___17362 = (0);
while(true){
if((i__7108__auto___17362 < len__7107__auto___17361)){
args17358.push((arguments[i__7108__auto___17362]));

var G__17363 = (i__7108__auto___17362 + (1));
i__7108__auto___17362 = G__17363;
continue;
} else {
}
break;
}

var G__17360 = args17358.length;
switch (G__17360) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17358.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17369 = [];
var len__7107__auto___17432 = arguments.length;
var i__7108__auto___17433 = (0);
while(true){
if((i__7108__auto___17433 < len__7107__auto___17432)){
args17369.push((arguments[i__7108__auto___17433]));

var G__17434 = (i__7108__auto___17433 + (1));
i__7108__auto___17433 = G__17434;
continue;
} else {
}
break;
}

var G__17374 = args17369.length;
switch (G__17374) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17369.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17436,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17436,out){
return (function (state_17404){
var state_val_17405 = (state_17404[(1)]);
if((state_val_17405 === (7))){
var inst_17398 = (state_17404[(2)]);
var state_17404__$1 = state_17404;
var statearr_17406_17438 = state_17404__$1;
(statearr_17406_17438[(2)] = inst_17398);

(statearr_17406_17438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (1))){
var inst_17376 = null;
var state_17404__$1 = (function (){var statearr_17407 = state_17404;
(statearr_17407[(7)] = inst_17376);

return statearr_17407;
})();
var statearr_17408_17439 = state_17404__$1;
(statearr_17408_17439[(2)] = null);

(statearr_17408_17439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (4))){
var inst_17383 = (state_17404[(8)]);
var inst_17383__$1 = (state_17404[(2)]);
var inst_17384 = (inst_17383__$1 == null);
var inst_17385 = cljs.core.not.call(null,inst_17384);
var state_17404__$1 = (function (){var statearr_17410 = state_17404;
(statearr_17410[(8)] = inst_17383__$1);

return statearr_17410;
})();
if(inst_17385){
var statearr_17411_17440 = state_17404__$1;
(statearr_17411_17440[(1)] = (5));

} else {
var statearr_17412_17441 = state_17404__$1;
(statearr_17412_17441[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (6))){
var state_17404__$1 = state_17404;
var statearr_17413_17442 = state_17404__$1;
(statearr_17413_17442[(2)] = null);

(statearr_17413_17442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (3))){
var inst_17400 = (state_17404[(2)]);
var inst_17401 = cljs.core.async.close_BANG_.call(null,out);
var state_17404__$1 = (function (){var statearr_17414 = state_17404;
(statearr_17414[(9)] = inst_17400);

return statearr_17414;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17404__$1,inst_17401);
} else {
if((state_val_17405 === (2))){
var state_17404__$1 = state_17404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17404__$1,(4),ch);
} else {
if((state_val_17405 === (11))){
var inst_17383 = (state_17404[(8)]);
var inst_17392 = (state_17404[(2)]);
var inst_17376 = inst_17383;
var state_17404__$1 = (function (){var statearr_17416 = state_17404;
(statearr_17416[(10)] = inst_17392);

(statearr_17416[(7)] = inst_17376);

return statearr_17416;
})();
var statearr_17417_17444 = state_17404__$1;
(statearr_17417_17444[(2)] = null);

(statearr_17417_17444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (9))){
var inst_17383 = (state_17404[(8)]);
var state_17404__$1 = state_17404;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17404__$1,(11),out,inst_17383);
} else {
if((state_val_17405 === (5))){
var inst_17383 = (state_17404[(8)]);
var inst_17376 = (state_17404[(7)]);
var inst_17387 = cljs.core._EQ_.call(null,inst_17383,inst_17376);
var state_17404__$1 = state_17404;
if(inst_17387){
var statearr_17420_17449 = state_17404__$1;
(statearr_17420_17449[(1)] = (8));

} else {
var statearr_17421_17451 = state_17404__$1;
(statearr_17421_17451[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (10))){
var inst_17395 = (state_17404[(2)]);
var state_17404__$1 = state_17404;
var statearr_17422_17452 = state_17404__$1;
(statearr_17422_17452[(2)] = inst_17395);

(statearr_17422_17452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17405 === (8))){
var inst_17376 = (state_17404[(7)]);
var tmp17419 = inst_17376;
var inst_17376__$1 = tmp17419;
var state_17404__$1 = (function (){var statearr_17423 = state_17404;
(statearr_17423[(7)] = inst_17376__$1);

return statearr_17423;
})();
var statearr_17424_17454 = state_17404__$1;
(statearr_17424_17454[(2)] = null);

(statearr_17424_17454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17436,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17436,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17428 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17428[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17428[(1)] = (1));

return statearr_17428;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17404){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17429){if((e17429 instanceof Object)){
var ex__14240__auto__ = e17429;
var statearr_17430_17463 = state_17404;
(statearr_17430_17463[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17404);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17429;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17465 = state_17404;
state_17404 = G__17465;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17404){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17436,out))
})();
var state__14377__auto__ = (function (){var statearr_17431 = f__14376__auto__.call(null);
(statearr_17431[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17436);

return statearr_17431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17436,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17467 = [];
var len__7107__auto___17538 = arguments.length;
var i__7108__auto___17539 = (0);
while(true){
if((i__7108__auto___17539 < len__7107__auto___17538)){
args17467.push((arguments[i__7108__auto___17539]));

var G__17540 = (i__7108__auto___17539 + (1));
i__7108__auto___17539 = G__17540;
continue;
} else {
}
break;
}

var G__17469 = args17467.length;
switch (G__17469) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17467.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17542,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17542,out){
return (function (state_17507){
var state_val_17508 = (state_17507[(1)]);
if((state_val_17508 === (7))){
var inst_17503 = (state_17507[(2)]);
var state_17507__$1 = state_17507;
var statearr_17509_17543 = state_17507__$1;
(statearr_17509_17543[(2)] = inst_17503);

(statearr_17509_17543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (1))){
var inst_17470 = (new Array(n));
var inst_17471 = inst_17470;
var inst_17472 = (0);
var state_17507__$1 = (function (){var statearr_17510 = state_17507;
(statearr_17510[(7)] = inst_17472);

(statearr_17510[(8)] = inst_17471);

return statearr_17510;
})();
var statearr_17511_17544 = state_17507__$1;
(statearr_17511_17544[(2)] = null);

(statearr_17511_17544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (4))){
var inst_17475 = (state_17507[(9)]);
var inst_17475__$1 = (state_17507[(2)]);
var inst_17476 = (inst_17475__$1 == null);
var inst_17477 = cljs.core.not.call(null,inst_17476);
var state_17507__$1 = (function (){var statearr_17512 = state_17507;
(statearr_17512[(9)] = inst_17475__$1);

return statearr_17512;
})();
if(inst_17477){
var statearr_17513_17545 = state_17507__$1;
(statearr_17513_17545[(1)] = (5));

} else {
var statearr_17514_17546 = state_17507__$1;
(statearr_17514_17546[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (15))){
var inst_17497 = (state_17507[(2)]);
var state_17507__$1 = state_17507;
var statearr_17515_17547 = state_17507__$1;
(statearr_17515_17547[(2)] = inst_17497);

(statearr_17515_17547[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (13))){
var state_17507__$1 = state_17507;
var statearr_17516_17548 = state_17507__$1;
(statearr_17516_17548[(2)] = null);

(statearr_17516_17548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (6))){
var inst_17472 = (state_17507[(7)]);
var inst_17493 = (inst_17472 > (0));
var state_17507__$1 = state_17507;
if(cljs.core.truth_(inst_17493)){
var statearr_17517_17549 = state_17507__$1;
(statearr_17517_17549[(1)] = (12));

} else {
var statearr_17518_17550 = state_17507__$1;
(statearr_17518_17550[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (3))){
var inst_17505 = (state_17507[(2)]);
var state_17507__$1 = state_17507;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17507__$1,inst_17505);
} else {
if((state_val_17508 === (12))){
var inst_17471 = (state_17507[(8)]);
var inst_17495 = cljs.core.vec.call(null,inst_17471);
var state_17507__$1 = state_17507;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17507__$1,(15),out,inst_17495);
} else {
if((state_val_17508 === (2))){
var state_17507__$1 = state_17507;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17507__$1,(4),ch);
} else {
if((state_val_17508 === (11))){
var inst_17487 = (state_17507[(2)]);
var inst_17488 = (new Array(n));
var inst_17471 = inst_17488;
var inst_17472 = (0);
var state_17507__$1 = (function (){var statearr_17520 = state_17507;
(statearr_17520[(10)] = inst_17487);

(statearr_17520[(7)] = inst_17472);

(statearr_17520[(8)] = inst_17471);

return statearr_17520;
})();
var statearr_17521_17554 = state_17507__$1;
(statearr_17521_17554[(2)] = null);

(statearr_17521_17554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (9))){
var inst_17471 = (state_17507[(8)]);
var inst_17485 = cljs.core.vec.call(null,inst_17471);
var state_17507__$1 = state_17507;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17507__$1,(11),out,inst_17485);
} else {
if((state_val_17508 === (5))){
var inst_17472 = (state_17507[(7)]);
var inst_17480 = (state_17507[(11)]);
var inst_17471 = (state_17507[(8)]);
var inst_17475 = (state_17507[(9)]);
var inst_17479 = (inst_17471[inst_17472] = inst_17475);
var inst_17480__$1 = (inst_17472 + (1));
var inst_17481 = (inst_17480__$1 < n);
var state_17507__$1 = (function (){var statearr_17522 = state_17507;
(statearr_17522[(11)] = inst_17480__$1);

(statearr_17522[(12)] = inst_17479);

return statearr_17522;
})();
if(cljs.core.truth_(inst_17481)){
var statearr_17523_17556 = state_17507__$1;
(statearr_17523_17556[(1)] = (8));

} else {
var statearr_17524_17557 = state_17507__$1;
(statearr_17524_17557[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (14))){
var inst_17500 = (state_17507[(2)]);
var inst_17501 = cljs.core.async.close_BANG_.call(null,out);
var state_17507__$1 = (function (){var statearr_17526 = state_17507;
(statearr_17526[(13)] = inst_17500);

return statearr_17526;
})();
var statearr_17527_17558 = state_17507__$1;
(statearr_17527_17558[(2)] = inst_17501);

(statearr_17527_17558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (10))){
var inst_17491 = (state_17507[(2)]);
var state_17507__$1 = state_17507;
var statearr_17528_17559 = state_17507__$1;
(statearr_17528_17559[(2)] = inst_17491);

(statearr_17528_17559[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17508 === (8))){
var inst_17480 = (state_17507[(11)]);
var inst_17471 = (state_17507[(8)]);
var tmp17525 = inst_17471;
var inst_17471__$1 = tmp17525;
var inst_17472 = inst_17480;
var state_17507__$1 = (function (){var statearr_17529 = state_17507;
(statearr_17529[(7)] = inst_17472);

(statearr_17529[(8)] = inst_17471__$1);

return statearr_17529;
})();
var statearr_17530_17563 = state_17507__$1;
(statearr_17530_17563[(2)] = null);

(statearr_17530_17563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17542,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17542,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17534 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17534[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17534[(1)] = (1));

return statearr_17534;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17507){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17535){if((e17535 instanceof Object)){
var ex__14240__auto__ = e17535;
var statearr_17536_17564 = state_17507;
(statearr_17536_17564[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17507);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17535;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17565 = state_17507;
state_17507 = G__17565;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17507){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17542,out))
})();
var state__14377__auto__ = (function (){var statearr_17537 = f__14376__auto__.call(null);
(statearr_17537[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17542);

return statearr_17537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17542,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17567 = [];
var len__7107__auto___17641 = arguments.length;
var i__7108__auto___17642 = (0);
while(true){
if((i__7108__auto___17642 < len__7107__auto___17641)){
args17567.push((arguments[i__7108__auto___17642]));

var G__17643 = (i__7108__auto___17642 + (1));
i__7108__auto___17642 = G__17643;
continue;
} else {
}
break;
}

var G__17569 = args17567.length;
switch (G__17569) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17567.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17645 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17645,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17645,out){
return (function (state_17611){
var state_val_17612 = (state_17611[(1)]);
if((state_val_17612 === (7))){
var inst_17607 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17613_17646 = state_17611__$1;
(statearr_17613_17646[(2)] = inst_17607);

(statearr_17613_17646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (1))){
var inst_17570 = [];
var inst_17571 = inst_17570;
var inst_17572 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17611__$1 = (function (){var statearr_17614 = state_17611;
(statearr_17614[(7)] = inst_17571);

(statearr_17614[(8)] = inst_17572);

return statearr_17614;
})();
var statearr_17615_17647 = state_17611__$1;
(statearr_17615_17647[(2)] = null);

(statearr_17615_17647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (4))){
var inst_17575 = (state_17611[(9)]);
var inst_17575__$1 = (state_17611[(2)]);
var inst_17576 = (inst_17575__$1 == null);
var inst_17577 = cljs.core.not.call(null,inst_17576);
var state_17611__$1 = (function (){var statearr_17616 = state_17611;
(statearr_17616[(9)] = inst_17575__$1);

return statearr_17616;
})();
if(inst_17577){
var statearr_17617_17651 = state_17611__$1;
(statearr_17617_17651[(1)] = (5));

} else {
var statearr_17618_17652 = state_17611__$1;
(statearr_17618_17652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (15))){
var inst_17601 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17619_17653 = state_17611__$1;
(statearr_17619_17653[(2)] = inst_17601);

(statearr_17619_17653[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (13))){
var state_17611__$1 = state_17611;
var statearr_17620_17655 = state_17611__$1;
(statearr_17620_17655[(2)] = null);

(statearr_17620_17655[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (6))){
var inst_17571 = (state_17611[(7)]);
var inst_17596 = inst_17571.length;
var inst_17597 = (inst_17596 > (0));
var state_17611__$1 = state_17611;
if(cljs.core.truth_(inst_17597)){
var statearr_17621_17656 = state_17611__$1;
(statearr_17621_17656[(1)] = (12));

} else {
var statearr_17622_17657 = state_17611__$1;
(statearr_17622_17657[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (3))){
var inst_17609 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17611__$1,inst_17609);
} else {
if((state_val_17612 === (12))){
var inst_17571 = (state_17611[(7)]);
var inst_17599 = cljs.core.vec.call(null,inst_17571);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17611__$1,(15),out,inst_17599);
} else {
if((state_val_17612 === (2))){
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17611__$1,(4),ch);
} else {
if((state_val_17612 === (11))){
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17589 = (state_17611[(2)]);
var inst_17590 = [];
var inst_17591 = inst_17590.push(inst_17575);
var inst_17571 = inst_17590;
var inst_17572 = inst_17579;
var state_17611__$1 = (function (){var statearr_17623 = state_17611;
(statearr_17623[(7)] = inst_17571);

(statearr_17623[(8)] = inst_17572);

(statearr_17623[(11)] = inst_17591);

(statearr_17623[(12)] = inst_17589);

return statearr_17623;
})();
var statearr_17624_17661 = state_17611__$1;
(statearr_17624_17661[(2)] = null);

(statearr_17624_17661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (9))){
var inst_17571 = (state_17611[(7)]);
var inst_17587 = cljs.core.vec.call(null,inst_17571);
var state_17611__$1 = state_17611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17611__$1,(11),out,inst_17587);
} else {
if((state_val_17612 === (5))){
var inst_17572 = (state_17611[(8)]);
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17579__$1 = f.call(null,inst_17575);
var inst_17580 = cljs.core._EQ_.call(null,inst_17579__$1,inst_17572);
var inst_17581 = cljs.core.keyword_identical_QMARK_.call(null,inst_17572,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17582 = (inst_17580) || (inst_17581);
var state_17611__$1 = (function (){var statearr_17625 = state_17611;
(statearr_17625[(10)] = inst_17579__$1);

return statearr_17625;
})();
if(cljs.core.truth_(inst_17582)){
var statearr_17626_17663 = state_17611__$1;
(statearr_17626_17663[(1)] = (8));

} else {
var statearr_17627_17664 = state_17611__$1;
(statearr_17627_17664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (14))){
var inst_17604 = (state_17611[(2)]);
var inst_17605 = cljs.core.async.close_BANG_.call(null,out);
var state_17611__$1 = (function (){var statearr_17629 = state_17611;
(statearr_17629[(13)] = inst_17604);

return statearr_17629;
})();
var statearr_17630_17665 = state_17611__$1;
(statearr_17630_17665[(2)] = inst_17605);

(statearr_17630_17665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (10))){
var inst_17594 = (state_17611[(2)]);
var state_17611__$1 = state_17611;
var statearr_17631_17666 = state_17611__$1;
(statearr_17631_17666[(2)] = inst_17594);

(statearr_17631_17666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17612 === (8))){
var inst_17571 = (state_17611[(7)]);
var inst_17575 = (state_17611[(9)]);
var inst_17579 = (state_17611[(10)]);
var inst_17584 = inst_17571.push(inst_17575);
var tmp17628 = inst_17571;
var inst_17571__$1 = tmp17628;
var inst_17572 = inst_17579;
var state_17611__$1 = (function (){var statearr_17632 = state_17611;
(statearr_17632[(14)] = inst_17584);

(statearr_17632[(7)] = inst_17571__$1);

(statearr_17632[(8)] = inst_17572);

return statearr_17632;
})();
var statearr_17633_17667 = state_17611__$1;
(statearr_17633_17667[(2)] = null);

(statearr_17633_17667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17645,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17645,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17637[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17637[(1)] = (1));

return statearr_17637;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17611){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17638){if((e17638 instanceof Object)){
var ex__14240__auto__ = e17638;
var statearr_17639_17668 = state_17611;
(statearr_17639_17668[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17638;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17669 = state_17611;
state_17611 = G__17669;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17611){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17645,out))
})();
var state__14377__auto__ = (function (){var statearr_17640 = f__14376__auto__.call(null);
(statearr_17640[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17645);

return statearr_17640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17645,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472739155519