// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14416 = [];
var len__7107__auto___14422 = arguments.length;
var i__7108__auto___14423 = (0);
while(true){
if((i__7108__auto___14423 < len__7107__auto___14422)){
args14416.push((arguments[i__7108__auto___14423]));

var G__14424 = (i__7108__auto___14423 + (1));
i__7108__auto___14423 = G__14424;
continue;
} else {
}
break;
}

var G__14418 = args14416.length;
switch (G__14418) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14416.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14419 = (function (f,blockable,meta14420){
this.f = f;
this.blockable = blockable;
this.meta14420 = meta14420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14421,meta14420__$1){
var self__ = this;
var _14421__$1 = this;
return (new cljs.core.async.t_cljs$core$async14419(self__.f,self__.blockable,meta14420__$1));
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14421){
var self__ = this;
var _14421__$1 = this;
return self__.meta14420;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14420","meta14420",1333243082,null)], null);
});

cljs.core.async.t_cljs$core$async14419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14419";

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14419");
});

cljs.core.async.__GT_t_cljs$core$async14419 = (function cljs$core$async$__GT_t_cljs$core$async14419(f__$1,blockable__$1,meta14420){
return (new cljs.core.async.t_cljs$core$async14419(f__$1,blockable__$1,meta14420));
});

}

return (new cljs.core.async.t_cljs$core$async14419(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14435 = [];
var len__7107__auto___14438 = arguments.length;
var i__7108__auto___14439 = (0);
while(true){
if((i__7108__auto___14439 < len__7107__auto___14438)){
args14435.push((arguments[i__7108__auto___14439]));

var G__14440 = (i__7108__auto___14439 + (1));
i__7108__auto___14439 = G__14440;
continue;
} else {
}
break;
}

var G__14437 = args14435.length;
switch (G__14437) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14435.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14446 = [];
var len__7107__auto___14454 = arguments.length;
var i__7108__auto___14455 = (0);
while(true){
if((i__7108__auto___14455 < len__7107__auto___14454)){
args14446.push((arguments[i__7108__auto___14455]));

var G__14456 = (i__7108__auto___14455 + (1));
i__7108__auto___14455 = G__14456;
continue;
} else {
}
break;
}

var G__14449 = args14446.length;
switch (G__14449) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14446.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14463 = [];
var len__7107__auto___14471 = arguments.length;
var i__7108__auto___14472 = (0);
while(true){
if((i__7108__auto___14472 < len__7107__auto___14471)){
args14463.push((arguments[i__7108__auto___14472]));

var G__14473 = (i__7108__auto___14472 + (1));
i__7108__auto___14472 = G__14473;
continue;
} else {
}
break;
}

var G__14470 = args14463.length;
switch (G__14470) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14463.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14478 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14478);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14478,ret){
return (function (){
return fn1.call(null,val_14478);
});})(val_14478,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14479 = [];
var len__7107__auto___14486 = arguments.length;
var i__7108__auto___14487 = (0);
while(true){
if((i__7108__auto___14487 < len__7107__auto___14486)){
args14479.push((arguments[i__7108__auto___14487]));

var G__14489 = (i__7108__auto___14487 + (1));
i__7108__auto___14487 = G__14489;
continue;
} else {
}
break;
}

var G__14481 = args14479.length;
switch (G__14481) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14479.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14492 = n;
var x_14496 = (0);
while(true){
if((x_14496 < n__6952__auto___14492)){
(a[x_14496] = (0));

var G__14497 = (x_14496 + (1));
x_14496 = G__14497;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14498 = (i + (1));
i = G__14498;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14505 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14505 = (function (alt_flag,flag,meta14506){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14506 = meta14506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14507,meta14506__$1){
var self__ = this;
var _14507__$1 = this;
return (new cljs.core.async.t_cljs$core$async14505(self__.alt_flag,self__.flag,meta14506__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14507){
var self__ = this;
var _14507__$1 = this;
return self__.meta14506;
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14506","meta14506",2055654220,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14505.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14505";

cljs.core.async.t_cljs$core$async14505.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14505");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14505 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14505(alt_flag__$1,flag__$1,meta14506){
return (new cljs.core.async.t_cljs$core$async14505(alt_flag__$1,flag__$1,meta14506));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14505(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_handler,flag,cb,meta14513){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_handler,self__.flag,self__.cb,meta14513__$1));
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14512.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});

cljs.core.async.__GT_t_cljs$core$async14512 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513));
});

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14515_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14515_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14516_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14516_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14517 = (i + (1));
i = G__14517;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14526 = arguments.length;
var i__7108__auto___14527 = (0);
while(true){
if((i__7108__auto___14527 < len__7107__auto___14526)){
args__7114__auto__.push((arguments[i__7108__auto___14527]));

var G__14528 = (i__7108__auto___14527 + (1));
i__7108__auto___14527 = G__14528;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14523){
var map__14524 = p__14523;
var map__14524__$1 = ((((!((map__14524 == null)))?((((map__14524.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14524.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14524):map__14524);
var opts = map__14524__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14518){
var G__14519 = cljs.core.first.call(null,seq14518);
var seq14518__$1 = cljs.core.next.call(null,seq14518);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14519,seq14518__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14535 = [];
var len__7107__auto___14588 = arguments.length;
var i__7108__auto___14589 = (0);
while(true){
if((i__7108__auto___14589 < len__7107__auto___14588)){
args14535.push((arguments[i__7108__auto___14589]));

var G__14590 = (i__7108__auto___14589 + (1));
i__7108__auto___14589 = G__14590;
continue;
} else {
}
break;
}

var G__14537 = args14535.length;
switch (G__14537) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14535.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14368__auto___14592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___14592){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___14592){
return (function (state_14564){
var state_val_14565 = (state_14564[(1)]);
if((state_val_14565 === (7))){
var inst_14560 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14566_14596 = state_14564__$1;
(statearr_14566_14596[(2)] = inst_14560);

(statearr_14566_14596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (1))){
var state_14564__$1 = state_14564;
var statearr_14567_14598 = state_14564__$1;
(statearr_14567_14598[(2)] = null);

(statearr_14567_14598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (4))){
var inst_14542 = (state_14564[(7)]);
var inst_14542__$1 = (state_14564[(2)]);
var inst_14544 = (inst_14542__$1 == null);
var state_14564__$1 = (function (){var statearr_14568 = state_14564;
(statearr_14568[(7)] = inst_14542__$1);

return statearr_14568;
})();
if(cljs.core.truth_(inst_14544)){
var statearr_14569_14602 = state_14564__$1;
(statearr_14569_14602[(1)] = (5));

} else {
var statearr_14570_14603 = state_14564__$1;
(statearr_14570_14603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (13))){
var state_14564__$1 = state_14564;
var statearr_14571_14604 = state_14564__$1;
(statearr_14571_14604[(2)] = null);

(statearr_14571_14604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (6))){
var inst_14542 = (state_14564[(7)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14564__$1,(11),to,inst_14542);
} else {
if((state_val_14565 === (3))){
var inst_14562 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14564__$1,inst_14562);
} else {
if((state_val_14565 === (12))){
var state_14564__$1 = state_14564;
var statearr_14572_14605 = state_14564__$1;
(statearr_14572_14605[(2)] = null);

(statearr_14572_14605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (2))){
var state_14564__$1 = state_14564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14564__$1,(4),from);
} else {
if((state_val_14565 === (11))){
var inst_14553 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
if(cljs.core.truth_(inst_14553)){
var statearr_14573_14606 = state_14564__$1;
(statearr_14573_14606[(1)] = (12));

} else {
var statearr_14574_14607 = state_14564__$1;
(statearr_14574_14607[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (9))){
var state_14564__$1 = state_14564;
var statearr_14575_14608 = state_14564__$1;
(statearr_14575_14608[(2)] = null);

(statearr_14575_14608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (5))){
var state_14564__$1 = state_14564;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14576_14609 = state_14564__$1;
(statearr_14576_14609[(1)] = (8));

} else {
var statearr_14577_14610 = state_14564__$1;
(statearr_14577_14610[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (14))){
var inst_14558 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14578_14611 = state_14564__$1;
(statearr_14578_14611[(2)] = inst_14558);

(statearr_14578_14611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (10))){
var inst_14550 = (state_14564[(2)]);
var state_14564__$1 = state_14564;
var statearr_14579_14612 = state_14564__$1;
(statearr_14579_14612[(2)] = inst_14550);

(statearr_14579_14612[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14565 === (8))){
var inst_14547 = cljs.core.async.close_BANG_.call(null,to);
var state_14564__$1 = state_14564;
var statearr_14580_14613 = state_14564__$1;
(statearr_14580_14613[(2)] = inst_14547);

(statearr_14580_14613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___14592))
;
return ((function (switch__14236__auto__,c__14368__auto___14592){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14584 = [null,null,null,null,null,null,null,null];
(statearr_14584[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14584[(1)] = (1));

return statearr_14584;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14564){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14585){if((e14585 instanceof Object)){
var ex__14240__auto__ = e14585;
var statearr_14586_14616 = state_14564;
(statearr_14586_14616[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14585;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14617 = state_14564;
state_14564 = G__14617;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___14592))
})();
var state__14370__auto__ = (function (){var statearr_14587 = f__14369__auto__.call(null);
(statearr_14587[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___14592);

return statearr_14587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___14592))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14830){
var vec__14831 = p__14830;
var v = cljs.core.nth.call(null,vec__14831,(0),null);
var p = cljs.core.nth.call(null,vec__14831,(1),null);
var job = vec__14831;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14368__auto___15025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results){
return (function (state_14838){
var state_val_14839 = (state_14838[(1)]);
if((state_val_14839 === (1))){
var state_14838__$1 = state_14838;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14838__$1,(2),res,v);
} else {
if((state_val_14839 === (2))){
var inst_14835 = (state_14838[(2)]);
var inst_14836 = cljs.core.async.close_BANG_.call(null,res);
var state_14838__$1 = (function (){var statearr_14840 = state_14838;
(statearr_14840[(7)] = inst_14835);

return statearr_14840;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14838__$1,inst_14836);
} else {
return null;
}
}
});})(c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14844 = [null,null,null,null,null,null,null,null];
(statearr_14844[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14844[(1)] = (1));

return statearr_14844;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14838){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14845){if((e14845 instanceof Object)){
var ex__14240__auto__ = e14845;
var statearr_14846_15026 = state_14838;
(statearr_14846_15026[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14838);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14845;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_14838;
state_14838 = G__15027;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14838){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results))
})();
var state__14370__auto__ = (function (){var statearr_14847 = f__14369__auto__.call(null);
(statearr_14847[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15025);

return statearr_14847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15025,res,vec__14831,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14848){
var vec__14849 = p__14848;
var v = cljs.core.nth.call(null,vec__14849,(0),null);
var p = cljs.core.nth.call(null,vec__14849,(1),null);
var job = vec__14849;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15028 = n;
var __15029 = (0);
while(true){
if((__15029 < n__6952__auto___15028)){
var G__14850_15030 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14850_15030) {
case "compute":
var c__14368__auto___15032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14864){
var state_val_14865 = (state_14864[(1)]);
if((state_val_14865 === (1))){
var state_14864__$1 = state_14864;
var statearr_14867_15033 = state_14864__$1;
(statearr_14867_15033[(2)] = null);

(statearr_14867_15033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14865 === (2))){
var state_14864__$1 = state_14864;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14864__$1,(4),jobs);
} else {
if((state_val_14865 === (3))){
var inst_14862 = (state_14864[(2)]);
var state_14864__$1 = state_14864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14864__$1,inst_14862);
} else {
if((state_val_14865 === (4))){
var inst_14854 = (state_14864[(2)]);
var inst_14855 = process.call(null,inst_14854);
var state_14864__$1 = state_14864;
if(cljs.core.truth_(inst_14855)){
var statearr_14868_15034 = state_14864__$1;
(statearr_14868_15034[(1)] = (5));

} else {
var statearr_14869_15035 = state_14864__$1;
(statearr_14869_15035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14865 === (5))){
var state_14864__$1 = state_14864;
var statearr_14870_15036 = state_14864__$1;
(statearr_14870_15036[(2)] = null);

(statearr_14870_15036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14865 === (6))){
var state_14864__$1 = state_14864;
var statearr_14871_15037 = state_14864__$1;
(statearr_14871_15037[(2)] = null);

(statearr_14871_15037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14865 === (7))){
var inst_14860 = (state_14864[(2)]);
var state_14864__$1 = state_14864;
var statearr_14872_15038 = state_14864__$1;
(statearr_14872_15038[(2)] = inst_14860);

(statearr_14872_15038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14876 = [null,null,null,null,null,null,null];
(statearr_14876[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14876[(1)] = (1));

return statearr_14876;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14864){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14877){if((e14877 instanceof Object)){
var ex__14240__auto__ = e14877;
var statearr_14878_15039 = state_14864;
(statearr_14878_15039[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15040 = state_14864;
state_14864 = G__15040;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14864){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14879 = f__14369__auto__.call(null);
(statearr_14879[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15032);

return statearr_14879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15032,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
case "async":
var c__14368__auto___15041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14892){
var state_val_14893 = (state_14892[(1)]);
if((state_val_14893 === (1))){
var state_14892__$1 = state_14892;
var statearr_14894_15042 = state_14892__$1;
(statearr_14894_15042[(2)] = null);

(statearr_14894_15042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (2))){
var state_14892__$1 = state_14892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14892__$1,(4),jobs);
} else {
if((state_val_14893 === (3))){
var inst_14890 = (state_14892[(2)]);
var state_14892__$1 = state_14892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14892__$1,inst_14890);
} else {
if((state_val_14893 === (4))){
var inst_14882 = (state_14892[(2)]);
var inst_14883 = async.call(null,inst_14882);
var state_14892__$1 = state_14892;
if(cljs.core.truth_(inst_14883)){
var statearr_14895_15043 = state_14892__$1;
(statearr_14895_15043[(1)] = (5));

} else {
var statearr_14896_15044 = state_14892__$1;
(statearr_14896_15044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (5))){
var state_14892__$1 = state_14892;
var statearr_14897_15045 = state_14892__$1;
(statearr_14897_15045[(2)] = null);

(statearr_14897_15045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (6))){
var state_14892__$1 = state_14892;
var statearr_14898_15046 = state_14892__$1;
(statearr_14898_15046[(2)] = null);

(statearr_14898_15046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14893 === (7))){
var inst_14888 = (state_14892[(2)]);
var state_14892__$1 = state_14892;
var statearr_14899_15047 = state_14892__$1;
(statearr_14899_15047[(2)] = inst_14888);

(statearr_14899_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14903 = [null,null,null,null,null,null,null];
(statearr_14903[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14903[(1)] = (1));

return statearr_14903;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14892){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14904){if((e14904 instanceof Object)){
var ex__14240__auto__ = e14904;
var statearr_14905_15048 = state_14892;
(statearr_14905_15048[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14892);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14904;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15049 = state_14892;
state_14892 = G__15049;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14892){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14906 = f__14369__auto__.call(null);
(statearr_14906[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15041);

return statearr_14906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(__15029,c__14368__auto___15041,G__14850_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15050 = (__15029 + (1));
__15029 = G__15050;
continue;
} else {
}
break;
}

var c__14368__auto___15051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15051,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15051,jobs,results,process,async){
return (function (state_14928){
var state_val_14929 = (state_14928[(1)]);
if((state_val_14929 === (1))){
var state_14928__$1 = state_14928;
var statearr_14930_15052 = state_14928__$1;
(statearr_14930_15052[(2)] = null);

(statearr_14930_15052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14929 === (2))){
var state_14928__$1 = state_14928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14928__$1,(4),from);
} else {
if((state_val_14929 === (3))){
var inst_14926 = (state_14928[(2)]);
var state_14928__$1 = state_14928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14928__$1,inst_14926);
} else {
if((state_val_14929 === (4))){
var inst_14909 = (state_14928[(7)]);
var inst_14909__$1 = (state_14928[(2)]);
var inst_14910 = (inst_14909__$1 == null);
var state_14928__$1 = (function (){var statearr_14933 = state_14928;
(statearr_14933[(7)] = inst_14909__$1);

return statearr_14933;
})();
if(cljs.core.truth_(inst_14910)){
var statearr_14934_15053 = state_14928__$1;
(statearr_14934_15053[(1)] = (5));

} else {
var statearr_14936_15054 = state_14928__$1;
(statearr_14936_15054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14929 === (5))){
var inst_14912 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14928__$1 = state_14928;
var statearr_14937_15055 = state_14928__$1;
(statearr_14937_15055[(2)] = inst_14912);

(statearr_14937_15055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14929 === (6))){
var inst_14914 = (state_14928[(8)]);
var inst_14909 = (state_14928[(7)]);
var inst_14914__$1 = cljs.core.async.chan.call(null,(1));
var inst_14915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14916 = [inst_14909,inst_14914__$1];
var inst_14917 = (new cljs.core.PersistentVector(null,2,(5),inst_14915,inst_14916,null));
var state_14928__$1 = (function (){var statearr_14938 = state_14928;
(statearr_14938[(8)] = inst_14914__$1);

return statearr_14938;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14928__$1,(8),jobs,inst_14917);
} else {
if((state_val_14929 === (7))){
var inst_14924 = (state_14928[(2)]);
var state_14928__$1 = state_14928;
var statearr_14939_15058 = state_14928__$1;
(statearr_14939_15058[(2)] = inst_14924);

(statearr_14939_15058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14929 === (8))){
var inst_14914 = (state_14928[(8)]);
var inst_14919 = (state_14928[(2)]);
var state_14928__$1 = (function (){var statearr_14941 = state_14928;
(statearr_14941[(9)] = inst_14919);

return statearr_14941;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14928__$1,(9),results,inst_14914);
} else {
if((state_val_14929 === (9))){
var inst_14921 = (state_14928[(2)]);
var state_14928__$1 = (function (){var statearr_14942 = state_14928;
(statearr_14942[(10)] = inst_14921);

return statearr_14942;
})();
var statearr_14943_15059 = state_14928__$1;
(statearr_14943_15059[(2)] = null);

(statearr_14943_15059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15051,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto___15051,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14947 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14947[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14947[(1)] = (1));

return statearr_14947;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14928){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14948){if((e14948 instanceof Object)){
var ex__14240__auto__ = e14948;
var statearr_14949_15060 = state_14928;
(statearr_14949_15060[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14948;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15061 = state_14928;
state_14928 = G__15061;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14928){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15051,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_14950 = f__14369__auto__.call(null);
(statearr_14950[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15051);

return statearr_14950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15051,jobs,results,process,async))
);


var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,jobs,results,process,async){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,jobs,results,process,async){
return (function (state_14991){
var state_val_14992 = (state_14991[(1)]);
if((state_val_14992 === (7))){
var inst_14987 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
var statearr_14993_15064 = state_14991__$1;
(statearr_14993_15064[(2)] = inst_14987);

(statearr_14993_15064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (20))){
var state_14991__$1 = state_14991;
var statearr_14994_15065 = state_14991__$1;
(statearr_14994_15065[(2)] = null);

(statearr_14994_15065[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (1))){
var state_14991__$1 = state_14991;
var statearr_14995_15066 = state_14991__$1;
(statearr_14995_15066[(2)] = null);

(statearr_14995_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (4))){
var inst_14953 = (state_14991[(7)]);
var inst_14953__$1 = (state_14991[(2)]);
var inst_14954 = (inst_14953__$1 == null);
var state_14991__$1 = (function (){var statearr_14997 = state_14991;
(statearr_14997[(7)] = inst_14953__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14954)){
var statearr_14998_15067 = state_14991__$1;
(statearr_14998_15067[(1)] = (5));

} else {
var statearr_14999_15068 = state_14991__$1;
(statearr_14999_15068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (15))){
var inst_14969 = (state_14991[(8)]);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14991__$1,(18),to,inst_14969);
} else {
if((state_val_14992 === (21))){
var inst_14982 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
var statearr_15000_15069 = state_14991__$1;
(statearr_15000_15069[(2)] = inst_14982);

(statearr_15000_15069[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (13))){
var inst_14984 = (state_14991[(2)]);
var state_14991__$1 = (function (){var statearr_15001 = state_14991;
(statearr_15001[(9)] = inst_14984);

return statearr_15001;
})();
var statearr_15002_15070 = state_14991__$1;
(statearr_15002_15070[(2)] = null);

(statearr_15002_15070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (6))){
var inst_14953 = (state_14991[(7)]);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14991__$1,(11),inst_14953);
} else {
if((state_val_14992 === (17))){
var inst_14977 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
if(cljs.core.truth_(inst_14977)){
var statearr_15003_15071 = state_14991__$1;
(statearr_15003_15071[(1)] = (19));

} else {
var statearr_15004_15072 = state_14991__$1;
(statearr_15004_15072[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (3))){
var inst_14989 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14991__$1,inst_14989);
} else {
if((state_val_14992 === (12))){
var inst_14966 = (state_14991[(10)]);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14991__$1,(14),inst_14966);
} else {
if((state_val_14992 === (2))){
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14991__$1,(4),results);
} else {
if((state_val_14992 === (19))){
var state_14991__$1 = state_14991;
var statearr_15005_15079 = state_14991__$1;
(statearr_15005_15079[(2)] = null);

(statearr_15005_15079[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (11))){
var inst_14966 = (state_14991[(2)]);
var state_14991__$1 = (function (){var statearr_15006 = state_14991;
(statearr_15006[(10)] = inst_14966);

return statearr_15006;
})();
var statearr_15007_15084 = state_14991__$1;
(statearr_15007_15084[(2)] = null);

(statearr_15007_15084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (9))){
var state_14991__$1 = state_14991;
var statearr_15008_15085 = state_14991__$1;
(statearr_15008_15085[(2)] = null);

(statearr_15008_15085[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (5))){
var state_14991__$1 = state_14991;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15086 = state_14991__$1;
(statearr_15009_15086[(1)] = (8));

} else {
var statearr_15010_15087 = state_14991__$1;
(statearr_15010_15087[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (14))){
var inst_14969 = (state_14991[(8)]);
var inst_14971 = (state_14991[(11)]);
var inst_14969__$1 = (state_14991[(2)]);
var inst_14970 = (inst_14969__$1 == null);
var inst_14971__$1 = cljs.core.not.call(null,inst_14970);
var state_14991__$1 = (function (){var statearr_15011 = state_14991;
(statearr_15011[(8)] = inst_14969__$1);

(statearr_15011[(11)] = inst_14971__$1);

return statearr_15011;
})();
if(inst_14971__$1){
var statearr_15012_15088 = state_14991__$1;
(statearr_15012_15088[(1)] = (15));

} else {
var statearr_15013_15089 = state_14991__$1;
(statearr_15013_15089[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (16))){
var inst_14971 = (state_14991[(11)]);
var state_14991__$1 = state_14991;
var statearr_15014_15090 = state_14991__$1;
(statearr_15014_15090[(2)] = inst_14971);

(statearr_15014_15090[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (10))){
var inst_14963 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
var statearr_15015_15091 = state_14991__$1;
(statearr_15015_15091[(2)] = inst_14963);

(statearr_15015_15091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (18))){
var inst_14974 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
var statearr_15016_15092 = state_14991__$1;
(statearr_15016_15092[(2)] = inst_14974);

(statearr_15016_15092[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (8))){
var inst_14960 = cljs.core.async.close_BANG_.call(null,to);
var state_14991__$1 = state_14991;
var statearr_15017_15093 = state_14991__$1;
(statearr_15017_15093[(2)] = inst_14960);

(statearr_15017_15093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14368__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14991){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15094 = state_14991;
(statearr_15023_15094[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15095 = state_14991;
state_14991 = G__15095;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14991){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,jobs,results,process,async))
})();
var state__14370__auto__ = (function (){var statearr_15024 = f__14369__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,jobs,results,process,async))
);

return c__14368__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15096 = [];
var len__7107__auto___15101 = arguments.length;
var i__7108__auto___15102 = (0);
while(true){
if((i__7108__auto___15102 < len__7107__auto___15101)){
args15096.push((arguments[i__7108__auto___15102]));

var G__15103 = (i__7108__auto___15102 + (1));
i__7108__auto___15102 = G__15103;
continue;
} else {
}
break;
}

var G__15098 = args15096.length;
switch (G__15098) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15096.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15107 = [];
var len__7107__auto___15112 = arguments.length;
var i__7108__auto___15113 = (0);
while(true){
if((i__7108__auto___15113 < len__7107__auto___15112)){
args15107.push((arguments[i__7108__auto___15113]));

var G__15114 = (i__7108__auto___15113 + (1));
i__7108__auto___15113 = G__15114;
continue;
} else {
}
break;
}

var G__15111 = args15107.length;
switch (G__15111) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15107.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15119 = [];
var len__7107__auto___15173 = arguments.length;
var i__7108__auto___15174 = (0);
while(true){
if((i__7108__auto___15174 < len__7107__auto___15173)){
args15119.push((arguments[i__7108__auto___15174]));

var G__15175 = (i__7108__auto___15174 + (1));
i__7108__auto___15174 = G__15175;
continue;
} else {
}
break;
}

var G__15121 = args15119.length;
switch (G__15121) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15119.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14368__auto___15177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15177,tc,fc){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15177,tc,fc){
return (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15144 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15150_15178 = state_15148__$1;
(statearr_15150_15178[(2)] = inst_15144);

(statearr_15150_15178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (1))){
var state_15148__$1 = state_15148;
var statearr_15151_15179 = state_15148__$1;
(statearr_15151_15179[(2)] = null);

(statearr_15151_15179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (4))){
var inst_15125 = (state_15148[(7)]);
var inst_15125__$1 = (state_15148[(2)]);
var inst_15126 = (inst_15125__$1 == null);
var state_15148__$1 = (function (){var statearr_15152 = state_15148;
(statearr_15152[(7)] = inst_15125__$1);

return statearr_15152;
})();
if(cljs.core.truth_(inst_15126)){
var statearr_15153_15180 = state_15148__$1;
(statearr_15153_15180[(1)] = (5));

} else {
var statearr_15154_15181 = state_15148__$1;
(statearr_15154_15181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (13))){
var state_15148__$1 = state_15148;
var statearr_15155_15182 = state_15148__$1;
(statearr_15155_15182[(2)] = null);

(statearr_15155_15182[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (6))){
var inst_15125 = (state_15148[(7)]);
var inst_15131 = p.call(null,inst_15125);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15131)){
var statearr_15156_15183 = state_15148__$1;
(statearr_15156_15183[(1)] = (9));

} else {
var statearr_15157_15184 = state_15148__$1;
(statearr_15157_15184[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (12))){
var state_15148__$1 = state_15148;
var statearr_15158_15185 = state_15148__$1;
(statearr_15158_15185[(2)] = null);

(statearr_15158_15185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (2))){
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15148__$1,(4),ch);
} else {
if((state_val_15149 === (11))){
var inst_15125 = (state_15148[(7)]);
var inst_15135 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15148__$1,(8),inst_15135,inst_15125);
} else {
if((state_val_15149 === (9))){
var state_15148__$1 = state_15148;
var statearr_15159_15186 = state_15148__$1;
(statearr_15159_15186[(2)] = tc);

(statearr_15159_15186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (5))){
var inst_15128 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15129 = cljs.core.async.close_BANG_.call(null,fc);
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(8)] = inst_15128);

return statearr_15160;
})();
var statearr_15161_15187 = state_15148__$1;
(statearr_15161_15187[(2)] = inst_15129);

(statearr_15161_15187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (14))){
var inst_15142 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15162_15188 = state_15148__$1;
(statearr_15162_15188[(2)] = inst_15142);

(statearr_15162_15188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (10))){
var state_15148__$1 = state_15148;
var statearr_15163_15193 = state_15148__$1;
(statearr_15163_15193[(2)] = fc);

(statearr_15163_15193[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (8))){
var inst_15137 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15137)){
var statearr_15164_15194 = state_15148__$1;
(statearr_15164_15194[(1)] = (12));

} else {
var statearr_15165_15195 = state_15148__$1;
(statearr_15165_15195[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15177,tc,fc))
;
return ((function (switch__14236__auto__,c__14368__auto___15177,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15169 = [null,null,null,null,null,null,null,null,null];
(statearr_15169[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15169[(1)] = (1));

return statearr_15169;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15148){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15170){if((e15170 instanceof Object)){
var ex__14240__auto__ = e15170;
var statearr_15171_15210 = state_15148;
(statearr_15171_15210[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15148);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15217 = state_15148;
state_15148 = G__15217;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15177,tc,fc))
})();
var state__14370__auto__ = (function (){var statearr_15172 = f__14369__auto__.call(null);
(statearr_15172[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15177);

return statearr_15172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15177,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15289){
var state_val_15290 = (state_15289[(1)]);
if((state_val_15290 === (7))){
var inst_15285 = (state_15289[(2)]);
var state_15289__$1 = state_15289;
var statearr_15292_15313 = state_15289__$1;
(statearr_15292_15313[(2)] = inst_15285);

(statearr_15292_15313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (1))){
var inst_15266 = init;
var state_15289__$1 = (function (){var statearr_15293 = state_15289;
(statearr_15293[(7)] = inst_15266);

return statearr_15293;
})();
var statearr_15294_15314 = state_15289__$1;
(statearr_15294_15314[(2)] = null);

(statearr_15294_15314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (4))){
var inst_15269 = (state_15289[(8)]);
var inst_15269__$1 = (state_15289[(2)]);
var inst_15270 = (inst_15269__$1 == null);
var state_15289__$1 = (function (){var statearr_15295 = state_15289;
(statearr_15295[(8)] = inst_15269__$1);

return statearr_15295;
})();
if(cljs.core.truth_(inst_15270)){
var statearr_15296_15317 = state_15289__$1;
(statearr_15296_15317[(1)] = (5));

} else {
var statearr_15297_15318 = state_15289__$1;
(statearr_15297_15318[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (6))){
var inst_15266 = (state_15289[(7)]);
var inst_15273 = (state_15289[(9)]);
var inst_15269 = (state_15289[(8)]);
var inst_15273__$1 = f.call(null,inst_15266,inst_15269);
var inst_15274 = cljs.core.reduced_QMARK_.call(null,inst_15273__$1);
var state_15289__$1 = (function (){var statearr_15298 = state_15289;
(statearr_15298[(9)] = inst_15273__$1);

return statearr_15298;
})();
if(inst_15274){
var statearr_15299_15320 = state_15289__$1;
(statearr_15299_15320[(1)] = (8));

} else {
var statearr_15300_15321 = state_15289__$1;
(statearr_15300_15321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (3))){
var inst_15287 = (state_15289[(2)]);
var state_15289__$1 = state_15289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15289__$1,inst_15287);
} else {
if((state_val_15290 === (2))){
var state_15289__$1 = state_15289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15289__$1,(4),ch);
} else {
if((state_val_15290 === (9))){
var inst_15273 = (state_15289[(9)]);
var inst_15266 = inst_15273;
var state_15289__$1 = (function (){var statearr_15301 = state_15289;
(statearr_15301[(7)] = inst_15266);

return statearr_15301;
})();
var statearr_15302_15322 = state_15289__$1;
(statearr_15302_15322[(2)] = null);

(statearr_15302_15322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (5))){
var inst_15266 = (state_15289[(7)]);
var state_15289__$1 = state_15289;
var statearr_15303_15323 = state_15289__$1;
(statearr_15303_15323[(2)] = inst_15266);

(statearr_15303_15323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (10))){
var inst_15280 = (state_15289[(2)]);
var state_15289__$1 = state_15289;
var statearr_15304_15324 = state_15289__$1;
(statearr_15304_15324[(2)] = inst_15280);

(statearr_15304_15324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15290 === (8))){
var inst_15273 = (state_15289[(9)]);
var inst_15276 = cljs.core.deref.call(null,inst_15273);
var state_15289__$1 = state_15289;
var statearr_15305_15325 = state_15289__$1;
(statearr_15305_15325[(2)] = inst_15276);

(statearr_15305_15325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15309 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15309[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15309[(1)] = (1));

return statearr_15309;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15289){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15310){if((e15310 instanceof Object)){
var ex__14240__auto__ = e15310;
var statearr_15311_15327 = state_15289;
(statearr_15311_15327[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15289);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15328 = state_15289;
state_15289 = G__15328;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15289){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15312 = f__14369__auto__.call(null);
(statearr_15312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15332 = [];
var len__7107__auto___15384 = arguments.length;
var i__7108__auto___15385 = (0);
while(true){
if((i__7108__auto___15385 < len__7107__auto___15384)){
args15332.push((arguments[i__7108__auto___15385]));

var G__15386 = (i__7108__auto___15385 + (1));
i__7108__auto___15385 = G__15386;
continue;
} else {
}
break;
}

var G__15334 = args15332.length;
switch (G__15334) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15332.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_15359){
var state_val_15360 = (state_15359[(1)]);
if((state_val_15360 === (7))){
var inst_15341 = (state_15359[(2)]);
var state_15359__$1 = state_15359;
var statearr_15361_15389 = state_15359__$1;
(statearr_15361_15389[(2)] = inst_15341);

(statearr_15361_15389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (1))){
var inst_15335 = cljs.core.seq.call(null,coll);
var inst_15336 = inst_15335;
var state_15359__$1 = (function (){var statearr_15362 = state_15359;
(statearr_15362[(7)] = inst_15336);

return statearr_15362;
})();
var statearr_15363_15390 = state_15359__$1;
(statearr_15363_15390[(2)] = null);

(statearr_15363_15390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (4))){
var inst_15336 = (state_15359[(7)]);
var inst_15339 = cljs.core.first.call(null,inst_15336);
var state_15359__$1 = state_15359;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15359__$1,(7),ch,inst_15339);
} else {
if((state_val_15360 === (13))){
var inst_15353 = (state_15359[(2)]);
var state_15359__$1 = state_15359;
var statearr_15364_15391 = state_15359__$1;
(statearr_15364_15391[(2)] = inst_15353);

(statearr_15364_15391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (6))){
var inst_15344 = (state_15359[(2)]);
var state_15359__$1 = state_15359;
if(cljs.core.truth_(inst_15344)){
var statearr_15365_15392 = state_15359__$1;
(statearr_15365_15392[(1)] = (8));

} else {
var statearr_15366_15393 = state_15359__$1;
(statearr_15366_15393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (3))){
var inst_15357 = (state_15359[(2)]);
var state_15359__$1 = state_15359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15359__$1,inst_15357);
} else {
if((state_val_15360 === (12))){
var state_15359__$1 = state_15359;
var statearr_15367_15394 = state_15359__$1;
(statearr_15367_15394[(2)] = null);

(statearr_15367_15394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (2))){
var inst_15336 = (state_15359[(7)]);
var state_15359__$1 = state_15359;
if(cljs.core.truth_(inst_15336)){
var statearr_15368_15395 = state_15359__$1;
(statearr_15368_15395[(1)] = (4));

} else {
var statearr_15369_15396 = state_15359__$1;
(statearr_15369_15396[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (11))){
var inst_15350 = cljs.core.async.close_BANG_.call(null,ch);
var state_15359__$1 = state_15359;
var statearr_15370_15397 = state_15359__$1;
(statearr_15370_15397[(2)] = inst_15350);

(statearr_15370_15397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (9))){
var state_15359__$1 = state_15359;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15371_15398 = state_15359__$1;
(statearr_15371_15398[(1)] = (11));

} else {
var statearr_15372_15399 = state_15359__$1;
(statearr_15372_15399[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (5))){
var inst_15336 = (state_15359[(7)]);
var state_15359__$1 = state_15359;
var statearr_15373_15400 = state_15359__$1;
(statearr_15373_15400[(2)] = inst_15336);

(statearr_15373_15400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (10))){
var inst_15355 = (state_15359[(2)]);
var state_15359__$1 = state_15359;
var statearr_15374_15401 = state_15359__$1;
(statearr_15374_15401[(2)] = inst_15355);

(statearr_15374_15401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15360 === (8))){
var inst_15336 = (state_15359[(7)]);
var inst_15346 = cljs.core.next.call(null,inst_15336);
var inst_15336__$1 = inst_15346;
var state_15359__$1 = (function (){var statearr_15375 = state_15359;
(statearr_15375[(7)] = inst_15336__$1);

return statearr_15375;
})();
var statearr_15376_15402 = state_15359__$1;
(statearr_15376_15402[(2)] = null);

(statearr_15376_15402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15380 = [null,null,null,null,null,null,null,null];
(statearr_15380[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15380[(1)] = (1));

return statearr_15380;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15359){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15381){if((e15381 instanceof Object)){
var ex__14240__auto__ = e15381;
var statearr_15382_15403 = state_15359;
(statearr_15382_15403[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15404 = state_15359;
state_15359 = G__15404;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15359){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_15383 = f__14369__auto__.call(null);
(statearr_15383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_15383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15643 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15643 = (function (mult,ch,cs,meta15644){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15644 = meta15644;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15645,meta15644__$1){
var self__ = this;
var _15645__$1 = this;
return (new cljs.core.async.t_cljs$core$async15643(self__.mult,self__.ch,self__.cs,meta15644__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15645){
var self__ = this;
var _15645__$1 = this;
return self__.meta15644;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15644","meta15644",-632527378,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15643";

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15643");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15643 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644){
return (new cljs.core.async.t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15643(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14368__auto___15866 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___15866,cs,m,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___15866,cs,m,dchan,dctr,done){
return (function (state_15776){
var state_val_15777 = (state_15776[(1)]);
if((state_val_15777 === (7))){
var inst_15772 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15778_15867 = state_15776__$1;
(statearr_15778_15867[(2)] = inst_15772);

(statearr_15778_15867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (20))){
var inst_15677 = (state_15776[(7)]);
var inst_15687 = cljs.core.first.call(null,inst_15677);
var inst_15688 = cljs.core.nth.call(null,inst_15687,(0),null);
var inst_15689 = cljs.core.nth.call(null,inst_15687,(1),null);
var state_15776__$1 = (function (){var statearr_15779 = state_15776;
(statearr_15779[(8)] = inst_15688);

return statearr_15779;
})();
if(cljs.core.truth_(inst_15689)){
var statearr_15780_15869 = state_15776__$1;
(statearr_15780_15869[(1)] = (22));

} else {
var statearr_15781_15871 = state_15776__$1;
(statearr_15781_15871[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (27))){
var inst_15724 = (state_15776[(9)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15648 = (state_15776[(12)]);
var inst_15724__$1 = cljs.core._nth.call(null,inst_15717,inst_15719);
var inst_15725 = cljs.core.async.put_BANG_.call(null,inst_15724__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15782 = state_15776;
(statearr_15782[(9)] = inst_15724__$1);

return statearr_15782;
})();
if(cljs.core.truth_(inst_15725)){
var statearr_15783_15872 = state_15776__$1;
(statearr_15783_15872[(1)] = (30));

} else {
var statearr_15784_15873 = state_15776__$1;
(statearr_15784_15873[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (1))){
var state_15776__$1 = state_15776;
var statearr_15785_15875 = state_15776__$1;
(statearr_15785_15875[(2)] = null);

(statearr_15785_15875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (24))){
var inst_15677 = (state_15776[(7)]);
var inst_15694 = (state_15776[(2)]);
var inst_15695 = cljs.core.next.call(null,inst_15677);
var inst_15657 = inst_15695;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15786 = state_15776;
(statearr_15786[(13)] = inst_15660);

(statearr_15786[(14)] = inst_15658);

(statearr_15786[(15)] = inst_15694);

(statearr_15786[(16)] = inst_15659);

(statearr_15786[(17)] = inst_15657);

return statearr_15786;
})();
var statearr_15787_15877 = state_15776__$1;
(statearr_15787_15877[(2)] = null);

(statearr_15787_15877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (39))){
var state_15776__$1 = state_15776;
var statearr_15791_15878 = state_15776__$1;
(statearr_15791_15878[(2)] = null);

(statearr_15791_15878[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (4))){
var inst_15648 = (state_15776[(12)]);
var inst_15648__$1 = (state_15776[(2)]);
var inst_15649 = (inst_15648__$1 == null);
var state_15776__$1 = (function (){var statearr_15792 = state_15776;
(statearr_15792[(12)] = inst_15648__$1);

return statearr_15792;
})();
if(cljs.core.truth_(inst_15649)){
var statearr_15793_15879 = state_15776__$1;
(statearr_15793_15879[(1)] = (5));

} else {
var statearr_15794_15880 = state_15776__$1;
(statearr_15794_15880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (15))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15659 = (state_15776[(16)]);
var inst_15657 = (state_15776[(17)]);
var inst_15673 = (state_15776[(2)]);
var inst_15674 = (inst_15660 + (1));
var tmp15788 = inst_15658;
var tmp15789 = inst_15659;
var tmp15790 = inst_15657;
var inst_15657__$1 = tmp15790;
var inst_15658__$1 = tmp15788;
var inst_15659__$1 = tmp15789;
var inst_15660__$1 = inst_15674;
var state_15776__$1 = (function (){var statearr_15795 = state_15776;
(statearr_15795[(13)] = inst_15660__$1);

(statearr_15795[(14)] = inst_15658__$1);

(statearr_15795[(16)] = inst_15659__$1);

(statearr_15795[(18)] = inst_15673);

(statearr_15795[(17)] = inst_15657__$1);

return statearr_15795;
})();
var statearr_15796_15881 = state_15776__$1;
(statearr_15796_15881[(2)] = null);

(statearr_15796_15881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (21))){
var inst_15698 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15800_15882 = state_15776__$1;
(statearr_15800_15882[(2)] = inst_15698);

(statearr_15800_15882[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (31))){
var inst_15724 = (state_15776[(9)]);
var inst_15728 = done.call(null,null);
var inst_15729 = cljs.core.async.untap_STAR_.call(null,m,inst_15724);
var state_15776__$1 = (function (){var statearr_15801 = state_15776;
(statearr_15801[(19)] = inst_15728);

return statearr_15801;
})();
var statearr_15802_15883 = state_15776__$1;
(statearr_15802_15883[(2)] = inst_15729);

(statearr_15802_15883[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (32))){
var inst_15716 = (state_15776[(20)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15718 = (state_15776[(21)]);
var inst_15731 = (state_15776[(2)]);
var inst_15732 = (inst_15719 + (1));
var tmp15797 = inst_15716;
var tmp15798 = inst_15717;
var tmp15799 = inst_15718;
var inst_15716__$1 = tmp15797;
var inst_15717__$1 = tmp15798;
var inst_15718__$1 = tmp15799;
var inst_15719__$1 = inst_15732;
var state_15776__$1 = (function (){var statearr_15803 = state_15776;
(statearr_15803[(20)] = inst_15716__$1);

(statearr_15803[(10)] = inst_15719__$1);

(statearr_15803[(11)] = inst_15717__$1);

(statearr_15803[(22)] = inst_15731);

(statearr_15803[(21)] = inst_15718__$1);

return statearr_15803;
})();
var statearr_15804_15887 = state_15776__$1;
(statearr_15804_15887[(2)] = null);

(statearr_15804_15887[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (40))){
var inst_15744 = (state_15776[(23)]);
var inst_15748 = done.call(null,null);
var inst_15749 = cljs.core.async.untap_STAR_.call(null,m,inst_15744);
var state_15776__$1 = (function (){var statearr_15805 = state_15776;
(statearr_15805[(24)] = inst_15748);

return statearr_15805;
})();
var statearr_15806_15888 = state_15776__$1;
(statearr_15806_15888[(2)] = inst_15749);

(statearr_15806_15888[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (33))){
var inst_15735 = (state_15776[(25)]);
var inst_15737 = cljs.core.chunked_seq_QMARK_.call(null,inst_15735);
var state_15776__$1 = state_15776;
if(inst_15737){
var statearr_15807_15889 = state_15776__$1;
(statearr_15807_15889[(1)] = (36));

} else {
var statearr_15808_15890 = state_15776__$1;
(statearr_15808_15890[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (13))){
var inst_15667 = (state_15776[(26)]);
var inst_15670 = cljs.core.async.close_BANG_.call(null,inst_15667);
var state_15776__$1 = state_15776;
var statearr_15809_15891 = state_15776__$1;
(statearr_15809_15891[(2)] = inst_15670);

(statearr_15809_15891[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (22))){
var inst_15688 = (state_15776[(8)]);
var inst_15691 = cljs.core.async.close_BANG_.call(null,inst_15688);
var state_15776__$1 = state_15776;
var statearr_15810_15894 = state_15776__$1;
(statearr_15810_15894[(2)] = inst_15691);

(statearr_15810_15894[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (36))){
var inst_15735 = (state_15776[(25)]);
var inst_15739 = cljs.core.chunk_first.call(null,inst_15735);
var inst_15740 = cljs.core.chunk_rest.call(null,inst_15735);
var inst_15741 = cljs.core.count.call(null,inst_15739);
var inst_15716 = inst_15740;
var inst_15717 = inst_15739;
var inst_15718 = inst_15741;
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15811 = state_15776;
(statearr_15811[(20)] = inst_15716);

(statearr_15811[(10)] = inst_15719);

(statearr_15811[(11)] = inst_15717);

(statearr_15811[(21)] = inst_15718);

return statearr_15811;
})();
var statearr_15812_15897 = state_15776__$1;
(statearr_15812_15897[(2)] = null);

(statearr_15812_15897[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (41))){
var inst_15735 = (state_15776[(25)]);
var inst_15751 = (state_15776[(2)]);
var inst_15752 = cljs.core.next.call(null,inst_15735);
var inst_15716 = inst_15752;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15813 = state_15776;
(statearr_15813[(20)] = inst_15716);

(statearr_15813[(10)] = inst_15719);

(statearr_15813[(11)] = inst_15717);

(statearr_15813[(27)] = inst_15751);

(statearr_15813[(21)] = inst_15718);

return statearr_15813;
})();
var statearr_15814_15898 = state_15776__$1;
(statearr_15814_15898[(2)] = null);

(statearr_15814_15898[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (43))){
var state_15776__$1 = state_15776;
var statearr_15815_15899 = state_15776__$1;
(statearr_15815_15899[(2)] = null);

(statearr_15815_15899[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (29))){
var inst_15760 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15816_15903 = state_15776__$1;
(statearr_15816_15903[(2)] = inst_15760);

(statearr_15816_15903[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (44))){
var inst_15769 = (state_15776[(2)]);
var state_15776__$1 = (function (){var statearr_15817 = state_15776;
(statearr_15817[(28)] = inst_15769);

return statearr_15817;
})();
var statearr_15818_15904 = state_15776__$1;
(statearr_15818_15904[(2)] = null);

(statearr_15818_15904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (6))){
var inst_15708 = (state_15776[(29)]);
var inst_15707 = cljs.core.deref.call(null,cs);
var inst_15708__$1 = cljs.core.keys.call(null,inst_15707);
var inst_15709 = cljs.core.count.call(null,inst_15708__$1);
var inst_15710 = cljs.core.reset_BANG_.call(null,dctr,inst_15709);
var inst_15715 = cljs.core.seq.call(null,inst_15708__$1);
var inst_15716 = inst_15715;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15819 = state_15776;
(statearr_15819[(20)] = inst_15716);

(statearr_15819[(10)] = inst_15719);

(statearr_15819[(29)] = inst_15708__$1);

(statearr_15819[(11)] = inst_15717);

(statearr_15819[(21)] = inst_15718);

(statearr_15819[(30)] = inst_15710);

return statearr_15819;
})();
var statearr_15820_15905 = state_15776__$1;
(statearr_15820_15905[(2)] = null);

(statearr_15820_15905[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (28))){
var inst_15716 = (state_15776[(20)]);
var inst_15735 = (state_15776[(25)]);
var inst_15735__$1 = cljs.core.seq.call(null,inst_15716);
var state_15776__$1 = (function (){var statearr_15821 = state_15776;
(statearr_15821[(25)] = inst_15735__$1);

return statearr_15821;
})();
if(inst_15735__$1){
var statearr_15822_15906 = state_15776__$1;
(statearr_15822_15906[(1)] = (33));

} else {
var statearr_15823_15907 = state_15776__$1;
(statearr_15823_15907[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (25))){
var inst_15719 = (state_15776[(10)]);
var inst_15718 = (state_15776[(21)]);
var inst_15721 = (inst_15719 < inst_15718);
var inst_15722 = inst_15721;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15722)){
var statearr_15824_15909 = state_15776__$1;
(statearr_15824_15909[(1)] = (27));

} else {
var statearr_15825_15910 = state_15776__$1;
(statearr_15825_15910[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (34))){
var state_15776__$1 = state_15776;
var statearr_15826_15911 = state_15776__$1;
(statearr_15826_15911[(2)] = null);

(statearr_15826_15911[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (17))){
var state_15776__$1 = state_15776;
var statearr_15827_15912 = state_15776__$1;
(statearr_15827_15912[(2)] = null);

(statearr_15827_15912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (3))){
var inst_15774 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15776__$1,inst_15774);
} else {
if((state_val_15777 === (12))){
var inst_15703 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15828_15913 = state_15776__$1;
(statearr_15828_15913[(2)] = inst_15703);

(statearr_15828_15913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (2))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(4),ch);
} else {
if((state_val_15777 === (23))){
var state_15776__$1 = state_15776;
var statearr_15829_15914 = state_15776__$1;
(statearr_15829_15914[(2)] = null);

(statearr_15829_15914[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (35))){
var inst_15758 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15830_15915 = state_15776__$1;
(statearr_15830_15915[(2)] = inst_15758);

(statearr_15830_15915[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (19))){
var inst_15677 = (state_15776[(7)]);
var inst_15681 = cljs.core.chunk_first.call(null,inst_15677);
var inst_15682 = cljs.core.chunk_rest.call(null,inst_15677);
var inst_15683 = cljs.core.count.call(null,inst_15681);
var inst_15657 = inst_15682;
var inst_15658 = inst_15681;
var inst_15659 = inst_15683;
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15831 = state_15776;
(statearr_15831[(13)] = inst_15660);

(statearr_15831[(14)] = inst_15658);

(statearr_15831[(16)] = inst_15659);

(statearr_15831[(17)] = inst_15657);

return statearr_15831;
})();
var statearr_15832_15916 = state_15776__$1;
(statearr_15832_15916[(2)] = null);

(statearr_15832_15916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (11))){
var inst_15677 = (state_15776[(7)]);
var inst_15657 = (state_15776[(17)]);
var inst_15677__$1 = cljs.core.seq.call(null,inst_15657);
var state_15776__$1 = (function (){var statearr_15833 = state_15776;
(statearr_15833[(7)] = inst_15677__$1);

return statearr_15833;
})();
if(inst_15677__$1){
var statearr_15834_15917 = state_15776__$1;
(statearr_15834_15917[(1)] = (16));

} else {
var statearr_15835_15918 = state_15776__$1;
(statearr_15835_15918[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (9))){
var inst_15705 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15836_15919 = state_15776__$1;
(statearr_15836_15919[(2)] = inst_15705);

(statearr_15836_15919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (5))){
var inst_15655 = cljs.core.deref.call(null,cs);
var inst_15656 = cljs.core.seq.call(null,inst_15655);
var inst_15657 = inst_15656;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15837 = state_15776;
(statearr_15837[(13)] = inst_15660);

(statearr_15837[(14)] = inst_15658);

(statearr_15837[(16)] = inst_15659);

(statearr_15837[(17)] = inst_15657);

return statearr_15837;
})();
var statearr_15838_15920 = state_15776__$1;
(statearr_15838_15920[(2)] = null);

(statearr_15838_15920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (14))){
var state_15776__$1 = state_15776;
var statearr_15839_15921 = state_15776__$1;
(statearr_15839_15921[(2)] = null);

(statearr_15839_15921[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (45))){
var inst_15766 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15840_15922 = state_15776__$1;
(statearr_15840_15922[(2)] = inst_15766);

(statearr_15840_15922[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (26))){
var inst_15708 = (state_15776[(29)]);
var inst_15762 = (state_15776[(2)]);
var inst_15763 = cljs.core.seq.call(null,inst_15708);
var state_15776__$1 = (function (){var statearr_15841 = state_15776;
(statearr_15841[(31)] = inst_15762);

return statearr_15841;
})();
if(inst_15763){
var statearr_15842_15923 = state_15776__$1;
(statearr_15842_15923[(1)] = (42));

} else {
var statearr_15843_15924 = state_15776__$1;
(statearr_15843_15924[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (16))){
var inst_15677 = (state_15776[(7)]);
var inst_15679 = cljs.core.chunked_seq_QMARK_.call(null,inst_15677);
var state_15776__$1 = state_15776;
if(inst_15679){
var statearr_15844_15930 = state_15776__$1;
(statearr_15844_15930[(1)] = (19));

} else {
var statearr_15845_15931 = state_15776__$1;
(statearr_15845_15931[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (38))){
var inst_15755 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15846_15932 = state_15776__$1;
(statearr_15846_15932[(2)] = inst_15755);

(statearr_15846_15932[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (30))){
var state_15776__$1 = state_15776;
var statearr_15847_15934 = state_15776__$1;
(statearr_15847_15934[(2)] = null);

(statearr_15847_15934[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (10))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15666 = cljs.core._nth.call(null,inst_15658,inst_15660);
var inst_15667 = cljs.core.nth.call(null,inst_15666,(0),null);
var inst_15668 = cljs.core.nth.call(null,inst_15666,(1),null);
var state_15776__$1 = (function (){var statearr_15848 = state_15776;
(statearr_15848[(26)] = inst_15667);

return statearr_15848;
})();
if(cljs.core.truth_(inst_15668)){
var statearr_15849_15935 = state_15776__$1;
(statearr_15849_15935[(1)] = (13));

} else {
var statearr_15850_15936 = state_15776__$1;
(statearr_15850_15936[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (18))){
var inst_15701 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15851_15940 = state_15776__$1;
(statearr_15851_15940[(2)] = inst_15701);

(statearr_15851_15940[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (42))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(45),dchan);
} else {
if((state_val_15777 === (37))){
var inst_15735 = (state_15776[(25)]);
var inst_15648 = (state_15776[(12)]);
var inst_15744 = (state_15776[(23)]);
var inst_15744__$1 = cljs.core.first.call(null,inst_15735);
var inst_15745 = cljs.core.async.put_BANG_.call(null,inst_15744__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15852 = state_15776;
(statearr_15852[(23)] = inst_15744__$1);

return statearr_15852;
})();
if(cljs.core.truth_(inst_15745)){
var statearr_15853_15941 = state_15776__$1;
(statearr_15853_15941[(1)] = (39));

} else {
var statearr_15854_15942 = state_15776__$1;
(statearr_15854_15942[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (8))){
var inst_15660 = (state_15776[(13)]);
var inst_15659 = (state_15776[(16)]);
var inst_15662 = (inst_15660 < inst_15659);
var inst_15663 = inst_15662;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15663)){
var statearr_15855_15943 = state_15776__$1;
(statearr_15855_15943[(1)] = (10));

} else {
var statearr_15856_15944 = state_15776__$1;
(statearr_15856_15944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___15866,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___15866,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15860[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15860[(1)] = (1));

return statearr_15860;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15776){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15862){if((e15862 instanceof Object)){
var ex__14240__auto__ = e15862;
var statearr_15864_15946 = state_15776;
(statearr_15864_15946[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15947 = state_15776;
state_15776 = G__15947;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15776){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___15866,cs,m,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_15865 = f__14369__auto__.call(null);
(statearr_15865[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___15866);

return statearr_15865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___15866,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15948 = [];
var len__7107__auto___15951 = arguments.length;
var i__7108__auto___15952 = (0);
while(true){
if((i__7108__auto___15952 < len__7107__auto___15951)){
args15948.push((arguments[i__7108__auto___15952]));

var G__15953 = (i__7108__auto___15952 + (1));
i__7108__auto___15952 = G__15953;
continue;
} else {
}
break;
}

var G__15950 = args15948.length;
switch (G__15950) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15948.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___15974 = arguments.length;
var i__7108__auto___15975 = (0);
while(true){
if((i__7108__auto___15975 < len__7107__auto___15974)){
args__7114__auto__.push((arguments[i__7108__auto___15975]));

var G__15976 = (i__7108__auto___15975 + (1));
i__7108__auto___15975 = G__15976;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15968){
var map__15969 = p__15968;
var map__15969__$1 = ((((!((map__15969 == null)))?((((map__15969.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15969.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15969):map__15969);
var opts = map__15969__$1;
var statearr_15971_15978 = state;
(statearr_15971_15978[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15969,map__15969__$1,opts){
return (function (val){
var statearr_15972_15979 = state;
(statearr_15972_15979[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15969,map__15969__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15973_15980 = state;
(statearr_15973_15980[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15964){
var G__15965 = cljs.core.first.call(null,seq15964);
var seq15964__$1 = cljs.core.next.call(null,seq15964);
var G__15966 = cljs.core.first.call(null,seq15964__$1);
var seq15964__$2 = cljs.core.next.call(null,seq15964__$1);
var G__15967 = cljs.core.first.call(null,seq15964__$2);
var seq15964__$3 = cljs.core.next.call(null,seq15964__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15965,G__15966,G__15967,seq15964__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16161 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16161 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16162){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16162 = meta16162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16163,meta16162__$1){
var self__ = this;
var _16163__$1 = this;
return (new cljs.core.async.t_cljs$core$async16161(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16162__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16163){
var self__ = this;
var _16163__$1 = this;
return self__.meta16162;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16162","meta16162",-52997858,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16161.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16161.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16161";

cljs.core.async.t_cljs$core$async16161.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16161");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16161 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16161(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16162){
return (new cljs.core.async.t_cljs$core$async16161(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16162));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16161(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16338 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16261){
var state_val_16262 = (state_16261[(1)]);
if((state_val_16262 === (7))){
var inst_16179 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16263_16341 = state_16261__$1;
(statearr_16263_16341[(2)] = inst_16179);

(statearr_16263_16341[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (20))){
var inst_16191 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
var statearr_16264_16346 = state_16261__$1;
(statearr_16264_16346[(2)] = inst_16191);

(statearr_16264_16346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (27))){
var state_16261__$1 = state_16261;
var statearr_16265_16347 = state_16261__$1;
(statearr_16265_16347[(2)] = null);

(statearr_16265_16347[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (1))){
var inst_16167 = (state_16261[(8)]);
var inst_16167__$1 = calc_state.call(null);
var inst_16169 = (inst_16167__$1 == null);
var inst_16170 = cljs.core.not.call(null,inst_16169);
var state_16261__$1 = (function (){var statearr_16266 = state_16261;
(statearr_16266[(8)] = inst_16167__$1);

return statearr_16266;
})();
if(inst_16170){
var statearr_16267_16353 = state_16261__$1;
(statearr_16267_16353[(1)] = (2));

} else {
var statearr_16268_16354 = state_16261__$1;
(statearr_16268_16354[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (24))){
var inst_16221 = (state_16261[(9)]);
var inst_16214 = (state_16261[(10)]);
var inst_16235 = (state_16261[(11)]);
var inst_16235__$1 = inst_16214.call(null,inst_16221);
var state_16261__$1 = (function (){var statearr_16269 = state_16261;
(statearr_16269[(11)] = inst_16235__$1);

return statearr_16269;
})();
if(cljs.core.truth_(inst_16235__$1)){
var statearr_16270_16356 = state_16261__$1;
(statearr_16270_16356[(1)] = (29));

} else {
var statearr_16271_16357 = state_16261__$1;
(statearr_16271_16357[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (4))){
var inst_16182 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16182)){
var statearr_16272_16361 = state_16261__$1;
(statearr_16272_16361[(1)] = (8));

} else {
var statearr_16273_16362 = state_16261__$1;
(statearr_16273_16362[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (15))){
var inst_16208 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16208)){
var statearr_16274_16363 = state_16261__$1;
(statearr_16274_16363[(1)] = (19));

} else {
var statearr_16275_16364 = state_16261__$1;
(statearr_16275_16364[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (21))){
var inst_16213 = (state_16261[(12)]);
var inst_16213__$1 = (state_16261[(2)]);
var inst_16214 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16215 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16216 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16261__$1 = (function (){var statearr_16276 = state_16261;
(statearr_16276[(13)] = inst_16215);

(statearr_16276[(12)] = inst_16213__$1);

(statearr_16276[(10)] = inst_16214);

return statearr_16276;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16261__$1,(22),inst_16216);
} else {
if((state_val_16262 === (31))){
var inst_16243 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16243)){
var statearr_16277_16366 = state_16261__$1;
(statearr_16277_16366[(1)] = (32));

} else {
var statearr_16278_16367 = state_16261__$1;
(statearr_16278_16367[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (32))){
var inst_16220 = (state_16261[(14)]);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16261__$1,(35),out,inst_16220);
} else {
if((state_val_16262 === (33))){
var inst_16213 = (state_16261[(12)]);
var inst_16191 = inst_16213;
var state_16261__$1 = (function (){var statearr_16279 = state_16261;
(statearr_16279[(7)] = inst_16191);

return statearr_16279;
})();
var statearr_16280_16368 = state_16261__$1;
(statearr_16280_16368[(2)] = null);

(statearr_16280_16368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (13))){
var inst_16191 = (state_16261[(7)]);
var inst_16198 = inst_16191.cljs$lang$protocol_mask$partition0$;
var inst_16199 = (inst_16198 & (64));
var inst_16200 = inst_16191.cljs$core$ISeq$;
var inst_16201 = (inst_16199) || (inst_16200);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16201)){
var statearr_16281_16369 = state_16261__$1;
(statearr_16281_16369[(1)] = (16));

} else {
var statearr_16282_16370 = state_16261__$1;
(statearr_16282_16370[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (22))){
var inst_16221 = (state_16261[(9)]);
var inst_16220 = (state_16261[(14)]);
var inst_16219 = (state_16261[(2)]);
var inst_16220__$1 = cljs.core.nth.call(null,inst_16219,(0),null);
var inst_16221__$1 = cljs.core.nth.call(null,inst_16219,(1),null);
var inst_16222 = (inst_16220__$1 == null);
var inst_16223 = cljs.core._EQ_.call(null,inst_16221__$1,change);
var inst_16224 = (inst_16222) || (inst_16223);
var state_16261__$1 = (function (){var statearr_16283 = state_16261;
(statearr_16283[(9)] = inst_16221__$1);

(statearr_16283[(14)] = inst_16220__$1);

return statearr_16283;
})();
if(cljs.core.truth_(inst_16224)){
var statearr_16284_16371 = state_16261__$1;
(statearr_16284_16371[(1)] = (23));

} else {
var statearr_16285_16372 = state_16261__$1;
(statearr_16285_16372[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (36))){
var inst_16213 = (state_16261[(12)]);
var inst_16191 = inst_16213;
var state_16261__$1 = (function (){var statearr_16286 = state_16261;
(statearr_16286[(7)] = inst_16191);

return statearr_16286;
})();
var statearr_16287_16373 = state_16261__$1;
(statearr_16287_16373[(2)] = null);

(statearr_16287_16373[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (29))){
var inst_16235 = (state_16261[(11)]);
var state_16261__$1 = state_16261;
var statearr_16288_16374 = state_16261__$1;
(statearr_16288_16374[(2)] = inst_16235);

(statearr_16288_16374[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (6))){
var state_16261__$1 = state_16261;
var statearr_16289_16375 = state_16261__$1;
(statearr_16289_16375[(2)] = false);

(statearr_16289_16375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (28))){
var inst_16231 = (state_16261[(2)]);
var inst_16232 = calc_state.call(null);
var inst_16191 = inst_16232;
var state_16261__$1 = (function (){var statearr_16290 = state_16261;
(statearr_16290[(7)] = inst_16191);

(statearr_16290[(15)] = inst_16231);

return statearr_16290;
})();
var statearr_16292_16376 = state_16261__$1;
(statearr_16292_16376[(2)] = null);

(statearr_16292_16376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (25))){
var inst_16257 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16293_16377 = state_16261__$1;
(statearr_16293_16377[(2)] = inst_16257);

(statearr_16293_16377[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (34))){
var inst_16255 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16294_16378 = state_16261__$1;
(statearr_16294_16378[(2)] = inst_16255);

(statearr_16294_16378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (17))){
var state_16261__$1 = state_16261;
var statearr_16295_16379 = state_16261__$1;
(statearr_16295_16379[(2)] = false);

(statearr_16295_16379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (3))){
var state_16261__$1 = state_16261;
var statearr_16296_16380 = state_16261__$1;
(statearr_16296_16380[(2)] = false);

(statearr_16296_16380[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (12))){
var inst_16259 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16261__$1,inst_16259);
} else {
if((state_val_16262 === (2))){
var inst_16167 = (state_16261[(8)]);
var inst_16172 = inst_16167.cljs$lang$protocol_mask$partition0$;
var inst_16173 = (inst_16172 & (64));
var inst_16174 = inst_16167.cljs$core$ISeq$;
var inst_16175 = (inst_16173) || (inst_16174);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16175)){
var statearr_16297_16381 = state_16261__$1;
(statearr_16297_16381[(1)] = (5));

} else {
var statearr_16298_16384 = state_16261__$1;
(statearr_16298_16384[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (23))){
var inst_16220 = (state_16261[(14)]);
var inst_16226 = (inst_16220 == null);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16226)){
var statearr_16300_16385 = state_16261__$1;
(statearr_16300_16385[(1)] = (26));

} else {
var statearr_16301_16386 = state_16261__$1;
(statearr_16301_16386[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (35))){
var inst_16246 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16246)){
var statearr_16303_16387 = state_16261__$1;
(statearr_16303_16387[(1)] = (36));

} else {
var statearr_16305_16388 = state_16261__$1;
(statearr_16305_16388[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (19))){
var inst_16191 = (state_16261[(7)]);
var inst_16210 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16191);
var state_16261__$1 = state_16261;
var statearr_16306_16389 = state_16261__$1;
(statearr_16306_16389[(2)] = inst_16210);

(statearr_16306_16389[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (11))){
var inst_16191 = (state_16261[(7)]);
var inst_16195 = (inst_16191 == null);
var inst_16196 = cljs.core.not.call(null,inst_16195);
var state_16261__$1 = state_16261;
if(inst_16196){
var statearr_16307_16390 = state_16261__$1;
(statearr_16307_16390[(1)] = (13));

} else {
var statearr_16308_16391 = state_16261__$1;
(statearr_16308_16391[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (9))){
var inst_16167 = (state_16261[(8)]);
var state_16261__$1 = state_16261;
var statearr_16309_16392 = state_16261__$1;
(statearr_16309_16392[(2)] = inst_16167);

(statearr_16309_16392[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (5))){
var state_16261__$1 = state_16261;
var statearr_16310_16393 = state_16261__$1;
(statearr_16310_16393[(2)] = true);

(statearr_16310_16393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (14))){
var state_16261__$1 = state_16261;
var statearr_16311_16399 = state_16261__$1;
(statearr_16311_16399[(2)] = false);

(statearr_16311_16399[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (26))){
var inst_16221 = (state_16261[(9)]);
var inst_16228 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16221);
var state_16261__$1 = state_16261;
var statearr_16312_16400 = state_16261__$1;
(statearr_16312_16400[(2)] = inst_16228);

(statearr_16312_16400[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (16))){
var state_16261__$1 = state_16261;
var statearr_16314_16401 = state_16261__$1;
(statearr_16314_16401[(2)] = true);

(statearr_16314_16401[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (38))){
var inst_16251 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16317_16402 = state_16261__$1;
(statearr_16317_16402[(2)] = inst_16251);

(statearr_16317_16402[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (30))){
var inst_16215 = (state_16261[(13)]);
var inst_16221 = (state_16261[(9)]);
var inst_16214 = (state_16261[(10)]);
var inst_16238 = cljs.core.empty_QMARK_.call(null,inst_16214);
var inst_16239 = inst_16215.call(null,inst_16221);
var inst_16240 = cljs.core.not.call(null,inst_16239);
var inst_16241 = (inst_16238) && (inst_16240);
var state_16261__$1 = state_16261;
var statearr_16319_16403 = state_16261__$1;
(statearr_16319_16403[(2)] = inst_16241);

(statearr_16319_16403[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (10))){
var inst_16167 = (state_16261[(8)]);
var inst_16187 = (state_16261[(2)]);
var inst_16188 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16189 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16190 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16191 = inst_16167;
var state_16261__$1 = (function (){var statearr_16320 = state_16261;
(statearr_16320[(16)] = inst_16188);

(statearr_16320[(17)] = inst_16190);

(statearr_16320[(7)] = inst_16191);

(statearr_16320[(18)] = inst_16189);

return statearr_16320;
})();
var statearr_16321_16404 = state_16261__$1;
(statearr_16321_16404[(2)] = null);

(statearr_16321_16404[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (18))){
var inst_16205 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16323_16407 = state_16261__$1;
(statearr_16323_16407[(2)] = inst_16205);

(statearr_16323_16407[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (37))){
var state_16261__$1 = state_16261;
var statearr_16324_16409 = state_16261__$1;
(statearr_16324_16409[(2)] = null);

(statearr_16324_16409[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (8))){
var inst_16167 = (state_16261[(8)]);
var inst_16184 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16167);
var state_16261__$1 = state_16261;
var statearr_16325_16411 = state_16261__$1;
(statearr_16325_16411[(2)] = inst_16184);

(statearr_16325_16411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16329 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16329[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16329[(1)] = (1));

return statearr_16329;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16261){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16330){if((e16330 instanceof Object)){
var ex__14240__auto__ = e16330;
var statearr_16331_16415 = state_16261;
(statearr_16331_16415[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16416 = state_16261;
state_16261 = G__16416;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16261){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14370__auto__ = (function (){var statearr_16332 = f__14369__auto__.call(null);
(statearr_16332[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16338);

return statearr_16332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16338,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16418 = [];
var len__7107__auto___16421 = arguments.length;
var i__7108__auto___16422 = (0);
while(true){
if((i__7108__auto___16422 < len__7107__auto___16421)){
args16418.push((arguments[i__7108__auto___16422]));

var G__16423 = (i__7108__auto___16422 + (1));
i__7108__auto___16422 = G__16423;
continue;
} else {
}
break;
}

var G__16420 = args16418.length;
switch (G__16420) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16418.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16431 = [];
var len__7107__auto___16572 = arguments.length;
var i__7108__auto___16573 = (0);
while(true){
if((i__7108__auto___16573 < len__7107__auto___16572)){
args16431.push((arguments[i__7108__auto___16573]));

var G__16574 = (i__7108__auto___16573 + (1));
i__7108__auto___16573 = G__16574;
continue;
} else {
}
break;
}

var G__16436 = args16431.length;
switch (G__16436) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16431.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16430_SHARP_){
if(cljs.core.truth_(p1__16430_SHARP_.call(null,topic))){
return p1__16430_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16430_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16437 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16437 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16438){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16438 = meta16438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16439,meta16438__$1){
var self__ = this;
var _16439__$1 = this;
return (new cljs.core.async.t_cljs$core$async16437(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16438__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16439){
var self__ = this;
var _16439__$1 = this;
return self__.meta16438;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16438","meta16438",1857156467,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16437.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16437";

cljs.core.async.t_cljs$core$async16437.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16437");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16437 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16437(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16438){
return (new cljs.core.async.t_cljs$core$async16437(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16438));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16437(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14368__auto___16577 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16577,mults,ensure_mult,p){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16577,mults,ensure_mult,p){
return (function (state_16512){
var state_val_16513 = (state_16512[(1)]);
if((state_val_16513 === (7))){
var inst_16508 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16514_16578 = state_16512__$1;
(statearr_16514_16578[(2)] = inst_16508);

(statearr_16514_16578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (20))){
var state_16512__$1 = state_16512;
var statearr_16515_16579 = state_16512__$1;
(statearr_16515_16579[(2)] = null);

(statearr_16515_16579[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (1))){
var state_16512__$1 = state_16512;
var statearr_16516_16580 = state_16512__$1;
(statearr_16516_16580[(2)] = null);

(statearr_16516_16580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (24))){
var inst_16491 = (state_16512[(7)]);
var inst_16500 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16491);
var state_16512__$1 = state_16512;
var statearr_16517_16581 = state_16512__$1;
(statearr_16517_16581[(2)] = inst_16500);

(statearr_16517_16581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (4))){
var inst_16442 = (state_16512[(8)]);
var inst_16442__$1 = (state_16512[(2)]);
var inst_16443 = (inst_16442__$1 == null);
var state_16512__$1 = (function (){var statearr_16518 = state_16512;
(statearr_16518[(8)] = inst_16442__$1);

return statearr_16518;
})();
if(cljs.core.truth_(inst_16443)){
var statearr_16519_16582 = state_16512__$1;
(statearr_16519_16582[(1)] = (5));

} else {
var statearr_16520_16583 = state_16512__$1;
(statearr_16520_16583[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (15))){
var inst_16485 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16521_16584 = state_16512__$1;
(statearr_16521_16584[(2)] = inst_16485);

(statearr_16521_16584[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (21))){
var inst_16505 = (state_16512[(2)]);
var state_16512__$1 = (function (){var statearr_16522 = state_16512;
(statearr_16522[(9)] = inst_16505);

return statearr_16522;
})();
var statearr_16523_16585 = state_16512__$1;
(statearr_16523_16585[(2)] = null);

(statearr_16523_16585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (13))){
var inst_16466 = (state_16512[(10)]);
var inst_16469 = cljs.core.chunked_seq_QMARK_.call(null,inst_16466);
var state_16512__$1 = state_16512;
if(inst_16469){
var statearr_16524_16586 = state_16512__$1;
(statearr_16524_16586[(1)] = (16));

} else {
var statearr_16525_16587 = state_16512__$1;
(statearr_16525_16587[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (22))){
var inst_16497 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
if(cljs.core.truth_(inst_16497)){
var statearr_16526_16588 = state_16512__$1;
(statearr_16526_16588[(1)] = (23));

} else {
var statearr_16527_16589 = state_16512__$1;
(statearr_16527_16589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (6))){
var inst_16442 = (state_16512[(8)]);
var inst_16491 = (state_16512[(7)]);
var inst_16493 = (state_16512[(11)]);
var inst_16491__$1 = topic_fn.call(null,inst_16442);
var inst_16492 = cljs.core.deref.call(null,mults);
var inst_16493__$1 = cljs.core.get.call(null,inst_16492,inst_16491__$1);
var state_16512__$1 = (function (){var statearr_16528 = state_16512;
(statearr_16528[(7)] = inst_16491__$1);

(statearr_16528[(11)] = inst_16493__$1);

return statearr_16528;
})();
if(cljs.core.truth_(inst_16493__$1)){
var statearr_16529_16590 = state_16512__$1;
(statearr_16529_16590[(1)] = (19));

} else {
var statearr_16530_16591 = state_16512__$1;
(statearr_16530_16591[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (25))){
var inst_16502 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16531_16593 = state_16512__$1;
(statearr_16531_16593[(2)] = inst_16502);

(statearr_16531_16593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (17))){
var inst_16466 = (state_16512[(10)]);
var inst_16476 = cljs.core.first.call(null,inst_16466);
var inst_16477 = cljs.core.async.muxch_STAR_.call(null,inst_16476);
var inst_16478 = cljs.core.async.close_BANG_.call(null,inst_16477);
var inst_16479 = cljs.core.next.call(null,inst_16466);
var inst_16452 = inst_16479;
var inst_16453 = null;
var inst_16454 = (0);
var inst_16455 = (0);
var state_16512__$1 = (function (){var statearr_16532 = state_16512;
(statearr_16532[(12)] = inst_16452);

(statearr_16532[(13)] = inst_16453);

(statearr_16532[(14)] = inst_16455);

(statearr_16532[(15)] = inst_16454);

(statearr_16532[(16)] = inst_16478);

return statearr_16532;
})();
var statearr_16533_16594 = state_16512__$1;
(statearr_16533_16594[(2)] = null);

(statearr_16533_16594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (3))){
var inst_16510 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16512__$1,inst_16510);
} else {
if((state_val_16513 === (12))){
var inst_16487 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16534_16595 = state_16512__$1;
(statearr_16534_16595[(2)] = inst_16487);

(statearr_16534_16595[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (2))){
var state_16512__$1 = state_16512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16512__$1,(4),ch);
} else {
if((state_val_16513 === (23))){
var state_16512__$1 = state_16512;
var statearr_16535_16597 = state_16512__$1;
(statearr_16535_16597[(2)] = null);

(statearr_16535_16597[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (19))){
var inst_16442 = (state_16512[(8)]);
var inst_16493 = (state_16512[(11)]);
var inst_16495 = cljs.core.async.muxch_STAR_.call(null,inst_16493);
var state_16512__$1 = state_16512;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16512__$1,(22),inst_16495,inst_16442);
} else {
if((state_val_16513 === (11))){
var inst_16452 = (state_16512[(12)]);
var inst_16466 = (state_16512[(10)]);
var inst_16466__$1 = cljs.core.seq.call(null,inst_16452);
var state_16512__$1 = (function (){var statearr_16536 = state_16512;
(statearr_16536[(10)] = inst_16466__$1);

return statearr_16536;
})();
if(inst_16466__$1){
var statearr_16537_16598 = state_16512__$1;
(statearr_16537_16598[(1)] = (13));

} else {
var statearr_16538_16599 = state_16512__$1;
(statearr_16538_16599[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (9))){
var inst_16489 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16539_16603 = state_16512__$1;
(statearr_16539_16603[(2)] = inst_16489);

(statearr_16539_16603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (5))){
var inst_16449 = cljs.core.deref.call(null,mults);
var inst_16450 = cljs.core.vals.call(null,inst_16449);
var inst_16451 = cljs.core.seq.call(null,inst_16450);
var inst_16452 = inst_16451;
var inst_16453 = null;
var inst_16454 = (0);
var inst_16455 = (0);
var state_16512__$1 = (function (){var statearr_16540 = state_16512;
(statearr_16540[(12)] = inst_16452);

(statearr_16540[(13)] = inst_16453);

(statearr_16540[(14)] = inst_16455);

(statearr_16540[(15)] = inst_16454);

return statearr_16540;
})();
var statearr_16541_16605 = state_16512__$1;
(statearr_16541_16605[(2)] = null);

(statearr_16541_16605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (14))){
var state_16512__$1 = state_16512;
var statearr_16545_16608 = state_16512__$1;
(statearr_16545_16608[(2)] = null);

(statearr_16545_16608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (16))){
var inst_16466 = (state_16512[(10)]);
var inst_16471 = cljs.core.chunk_first.call(null,inst_16466);
var inst_16472 = cljs.core.chunk_rest.call(null,inst_16466);
var inst_16473 = cljs.core.count.call(null,inst_16471);
var inst_16452 = inst_16472;
var inst_16453 = inst_16471;
var inst_16454 = inst_16473;
var inst_16455 = (0);
var state_16512__$1 = (function (){var statearr_16546 = state_16512;
(statearr_16546[(12)] = inst_16452);

(statearr_16546[(13)] = inst_16453);

(statearr_16546[(14)] = inst_16455);

(statearr_16546[(15)] = inst_16454);

return statearr_16546;
})();
var statearr_16547_16610 = state_16512__$1;
(statearr_16547_16610[(2)] = null);

(statearr_16547_16610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (10))){
var inst_16452 = (state_16512[(12)]);
var inst_16453 = (state_16512[(13)]);
var inst_16455 = (state_16512[(14)]);
var inst_16454 = (state_16512[(15)]);
var inst_16460 = cljs.core._nth.call(null,inst_16453,inst_16455);
var inst_16461 = cljs.core.async.muxch_STAR_.call(null,inst_16460);
var inst_16462 = cljs.core.async.close_BANG_.call(null,inst_16461);
var inst_16463 = (inst_16455 + (1));
var tmp16542 = inst_16452;
var tmp16543 = inst_16453;
var tmp16544 = inst_16454;
var inst_16452__$1 = tmp16542;
var inst_16453__$1 = tmp16543;
var inst_16454__$1 = tmp16544;
var inst_16455__$1 = inst_16463;
var state_16512__$1 = (function (){var statearr_16548 = state_16512;
(statearr_16548[(12)] = inst_16452__$1);

(statearr_16548[(17)] = inst_16462);

(statearr_16548[(13)] = inst_16453__$1);

(statearr_16548[(14)] = inst_16455__$1);

(statearr_16548[(15)] = inst_16454__$1);

return statearr_16548;
})();
var statearr_16549_16611 = state_16512__$1;
(statearr_16549_16611[(2)] = null);

(statearr_16549_16611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (18))){
var inst_16482 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16550_16613 = state_16512__$1;
(statearr_16550_16613[(2)] = inst_16482);

(statearr_16550_16613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16513 === (8))){
var inst_16455 = (state_16512[(14)]);
var inst_16454 = (state_16512[(15)]);
var inst_16457 = (inst_16455 < inst_16454);
var inst_16458 = inst_16457;
var state_16512__$1 = state_16512;
if(cljs.core.truth_(inst_16458)){
var statearr_16551_16614 = state_16512__$1;
(statearr_16551_16614[(1)] = (10));

} else {
var statearr_16552_16615 = state_16512__$1;
(statearr_16552_16615[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16577,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14368__auto___16577,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16564[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16564[(1)] = (1));

return statearr_16564;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16512){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16569){if((e16569 instanceof Object)){
var ex__14240__auto__ = e16569;
var statearr_16570_16619 = state_16512;
(statearr_16570_16619[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16620 = state_16512;
state_16512 = G__16620;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16577,mults,ensure_mult,p))
})();
var state__14370__auto__ = (function (){var statearr_16571 = f__14369__auto__.call(null);
(statearr_16571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16577);

return statearr_16571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16577,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16626 = [];
var len__7107__auto___16634 = arguments.length;
var i__7108__auto___16635 = (0);
while(true){
if((i__7108__auto___16635 < len__7107__auto___16634)){
args16626.push((arguments[i__7108__auto___16635]));

var G__16636 = (i__7108__auto___16635 + (1));
i__7108__auto___16635 = G__16636;
continue;
} else {
}
break;
}

var G__16629 = args16626.length;
switch (G__16629) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16626.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16639 = [];
var len__7107__auto___16642 = arguments.length;
var i__7108__auto___16643 = (0);
while(true){
if((i__7108__auto___16643 < len__7107__auto___16642)){
args16639.push((arguments[i__7108__auto___16643]));

var G__16644 = (i__7108__auto___16643 + (1));
i__7108__auto___16643 = G__16644;
continue;
} else {
}
break;
}

var G__16641 = args16639.length;
switch (G__16641) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16639.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16646 = [];
var len__7107__auto___16723 = arguments.length;
var i__7108__auto___16724 = (0);
while(true){
if((i__7108__auto___16724 < len__7107__auto___16723)){
args16646.push((arguments[i__7108__auto___16724]));

var G__16726 = (i__7108__auto___16724 + (1));
i__7108__auto___16724 = G__16726;
continue;
} else {
}
break;
}

var G__16648 = args16646.length;
switch (G__16648) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16646.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14368__auto___16734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16688){
var state_val_16689 = (state_16688[(1)]);
if((state_val_16689 === (7))){
var state_16688__$1 = state_16688;
var statearr_16690_16735 = state_16688__$1;
(statearr_16690_16735[(2)] = null);

(statearr_16690_16735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (1))){
var state_16688__$1 = state_16688;
var statearr_16691_16736 = state_16688__$1;
(statearr_16691_16736[(2)] = null);

(statearr_16691_16736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (4))){
var inst_16651 = (state_16688[(7)]);
var inst_16653 = (inst_16651 < cnt);
var state_16688__$1 = state_16688;
if(cljs.core.truth_(inst_16653)){
var statearr_16692_16738 = state_16688__$1;
(statearr_16692_16738[(1)] = (6));

} else {
var statearr_16693_16739 = state_16688__$1;
(statearr_16693_16739[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (15))){
var inst_16683 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16694_16740 = state_16688__$1;
(statearr_16694_16740[(2)] = inst_16683);

(statearr_16694_16740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (13))){
var inst_16676 = cljs.core.async.close_BANG_.call(null,out);
var state_16688__$1 = state_16688;
var statearr_16695_16741 = state_16688__$1;
(statearr_16695_16741[(2)] = inst_16676);

(statearr_16695_16741[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (6))){
var state_16688__$1 = state_16688;
var statearr_16696_16742 = state_16688__$1;
(statearr_16696_16742[(2)] = null);

(statearr_16696_16742[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (3))){
var inst_16685 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16688__$1,inst_16685);
} else {
if((state_val_16689 === (12))){
var inst_16673 = (state_16688[(8)]);
var inst_16673__$1 = (state_16688[(2)]);
var inst_16674 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16673__$1);
var state_16688__$1 = (function (){var statearr_16697 = state_16688;
(statearr_16697[(8)] = inst_16673__$1);

return statearr_16697;
})();
if(cljs.core.truth_(inst_16674)){
var statearr_16698_16743 = state_16688__$1;
(statearr_16698_16743[(1)] = (13));

} else {
var statearr_16699_16744 = state_16688__$1;
(statearr_16699_16744[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (2))){
var inst_16650 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16651 = (0);
var state_16688__$1 = (function (){var statearr_16700 = state_16688;
(statearr_16700[(9)] = inst_16650);

(statearr_16700[(7)] = inst_16651);

return statearr_16700;
})();
var statearr_16701_16745 = state_16688__$1;
(statearr_16701_16745[(2)] = null);

(statearr_16701_16745[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (11))){
var inst_16651 = (state_16688[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16688,(10),Object,null,(9));
var inst_16660 = chs__$1.call(null,inst_16651);
var inst_16661 = done.call(null,inst_16651);
var inst_16662 = cljs.core.async.take_BANG_.call(null,inst_16660,inst_16661);
var state_16688__$1 = state_16688;
var statearr_16702_16746 = state_16688__$1;
(statearr_16702_16746[(2)] = inst_16662);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16688__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (9))){
var inst_16651 = (state_16688[(7)]);
var inst_16664 = (state_16688[(2)]);
var inst_16665 = (inst_16651 + (1));
var inst_16651__$1 = inst_16665;
var state_16688__$1 = (function (){var statearr_16703 = state_16688;
(statearr_16703[(7)] = inst_16651__$1);

(statearr_16703[(10)] = inst_16664);

return statearr_16703;
})();
var statearr_16704_16753 = state_16688__$1;
(statearr_16704_16753[(2)] = null);

(statearr_16704_16753[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (5))){
var inst_16671 = (state_16688[(2)]);
var state_16688__$1 = (function (){var statearr_16705 = state_16688;
(statearr_16705[(11)] = inst_16671);

return statearr_16705;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16688__$1,(12),dchan);
} else {
if((state_val_16689 === (14))){
var inst_16673 = (state_16688[(8)]);
var inst_16678 = cljs.core.apply.call(null,f,inst_16673);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16688__$1,(16),out,inst_16678);
} else {
if((state_val_16689 === (16))){
var inst_16680 = (state_16688[(2)]);
var state_16688__$1 = (function (){var statearr_16706 = state_16688;
(statearr_16706[(12)] = inst_16680);

return statearr_16706;
})();
var statearr_16707_16759 = state_16688__$1;
(statearr_16707_16759[(2)] = null);

(statearr_16707_16759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (10))){
var inst_16655 = (state_16688[(2)]);
var inst_16656 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16688__$1 = (function (){var statearr_16708 = state_16688;
(statearr_16708[(13)] = inst_16655);

return statearr_16708;
})();
var statearr_16709_16761 = state_16688__$1;
(statearr_16709_16761[(2)] = inst_16656);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16688__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16689 === (8))){
var inst_16669 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16710_16762 = state_16688__$1;
(statearr_16710_16762[(2)] = inst_16669);

(statearr_16710_16762[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16715[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16715[(1)] = (1));

return statearr_16715;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16688){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16716){if((e16716 instanceof Object)){
var ex__14240__auto__ = e16716;
var statearr_16717_16763 = state_16688;
(statearr_16717_16763[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16688);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16765 = state_16688;
state_16688 = G__16765;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16688){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14370__auto__ = (function (){var statearr_16718 = f__14369__auto__.call(null);
(statearr_16718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16734);

return statearr_16718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16734,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16767 = [];
var len__7107__auto___16835 = arguments.length;
var i__7108__auto___16836 = (0);
while(true){
if((i__7108__auto___16836 < len__7107__auto___16835)){
args16767.push((arguments[i__7108__auto___16836]));

var G__16837 = (i__7108__auto___16836 + (1));
i__7108__auto___16836 = G__16837;
continue;
} else {
}
break;
}

var G__16769 = args16767.length;
switch (G__16769) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16767.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16839 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16839,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16839,out){
return (function (state_16802){
var state_val_16803 = (state_16802[(1)]);
if((state_val_16803 === (7))){
var inst_16782 = (state_16802[(7)]);
var inst_16781 = (state_16802[(8)]);
var inst_16781__$1 = (state_16802[(2)]);
var inst_16782__$1 = cljs.core.nth.call(null,inst_16781__$1,(0),null);
var inst_16783 = cljs.core.nth.call(null,inst_16781__$1,(1),null);
var inst_16784 = (inst_16782__$1 == null);
var state_16802__$1 = (function (){var statearr_16804 = state_16802;
(statearr_16804[(9)] = inst_16783);

(statearr_16804[(7)] = inst_16782__$1);

(statearr_16804[(8)] = inst_16781__$1);

return statearr_16804;
})();
if(cljs.core.truth_(inst_16784)){
var statearr_16806_16840 = state_16802__$1;
(statearr_16806_16840[(1)] = (8));

} else {
var statearr_16807_16841 = state_16802__$1;
(statearr_16807_16841[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (1))){
var inst_16771 = cljs.core.vec.call(null,chs);
var inst_16772 = inst_16771;
var state_16802__$1 = (function (){var statearr_16808 = state_16802;
(statearr_16808[(10)] = inst_16772);

return statearr_16808;
})();
var statearr_16809_16843 = state_16802__$1;
(statearr_16809_16843[(2)] = null);

(statearr_16809_16843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (4))){
var inst_16772 = (state_16802[(10)]);
var state_16802__$1 = state_16802;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16802__$1,(7),inst_16772);
} else {
if((state_val_16803 === (6))){
var inst_16798 = (state_16802[(2)]);
var state_16802__$1 = state_16802;
var statearr_16810_16844 = state_16802__$1;
(statearr_16810_16844[(2)] = inst_16798);

(statearr_16810_16844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (3))){
var inst_16800 = (state_16802[(2)]);
var state_16802__$1 = state_16802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16802__$1,inst_16800);
} else {
if((state_val_16803 === (2))){
var inst_16772 = (state_16802[(10)]);
var inst_16776 = cljs.core.count.call(null,inst_16772);
var inst_16777 = (inst_16776 > (0));
var state_16802__$1 = state_16802;
if(cljs.core.truth_(inst_16777)){
var statearr_16812_16845 = state_16802__$1;
(statearr_16812_16845[(1)] = (4));

} else {
var statearr_16813_16846 = state_16802__$1;
(statearr_16813_16846[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (11))){
var inst_16772 = (state_16802[(10)]);
var inst_16791 = (state_16802[(2)]);
var tmp16811 = inst_16772;
var inst_16772__$1 = tmp16811;
var state_16802__$1 = (function (){var statearr_16814 = state_16802;
(statearr_16814[(10)] = inst_16772__$1);

(statearr_16814[(11)] = inst_16791);

return statearr_16814;
})();
var statearr_16815_16847 = state_16802__$1;
(statearr_16815_16847[(2)] = null);

(statearr_16815_16847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (9))){
var inst_16782 = (state_16802[(7)]);
var state_16802__$1 = state_16802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16802__$1,(11),out,inst_16782);
} else {
if((state_val_16803 === (5))){
var inst_16796 = cljs.core.async.close_BANG_.call(null,out);
var state_16802__$1 = state_16802;
var statearr_16820_16848 = state_16802__$1;
(statearr_16820_16848[(2)] = inst_16796);

(statearr_16820_16848[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (10))){
var inst_16794 = (state_16802[(2)]);
var state_16802__$1 = state_16802;
var statearr_16821_16849 = state_16802__$1;
(statearr_16821_16849[(2)] = inst_16794);

(statearr_16821_16849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16803 === (8))){
var inst_16783 = (state_16802[(9)]);
var inst_16772 = (state_16802[(10)]);
var inst_16782 = (state_16802[(7)]);
var inst_16781 = (state_16802[(8)]);
var inst_16786 = (function (){var cs = inst_16772;
var vec__16779 = inst_16781;
var v = inst_16782;
var c = inst_16783;
return ((function (cs,vec__16779,v,c,inst_16783,inst_16772,inst_16782,inst_16781,state_val_16803,c__14368__auto___16839,out){
return (function (p1__16766_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16766_SHARP_);
});
;})(cs,vec__16779,v,c,inst_16783,inst_16772,inst_16782,inst_16781,state_val_16803,c__14368__auto___16839,out))
})();
var inst_16787 = cljs.core.filterv.call(null,inst_16786,inst_16772);
var inst_16772__$1 = inst_16787;
var state_16802__$1 = (function (){var statearr_16822 = state_16802;
(statearr_16822[(10)] = inst_16772__$1);

return statearr_16822;
})();
var statearr_16823_16851 = state_16802__$1;
(statearr_16823_16851[(2)] = null);

(statearr_16823_16851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16839,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16839,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16831 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16831[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16831[(1)] = (1));

return statearr_16831;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16802){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16832){if((e16832 instanceof Object)){
var ex__14240__auto__ = e16832;
var statearr_16833_16852 = state_16802;
(statearr_16833_16852[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16853 = state_16802;
state_16802 = G__16853;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16839,out))
})();
var state__14370__auto__ = (function (){var statearr_16834 = f__14369__auto__.call(null);
(statearr_16834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16839);

return statearr_16834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16839,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16854 = [];
var len__7107__auto___16912 = arguments.length;
var i__7108__auto___16913 = (0);
while(true){
if((i__7108__auto___16913 < len__7107__auto___16912)){
args16854.push((arguments[i__7108__auto___16913]));

var G__16917 = (i__7108__auto___16913 + (1));
i__7108__auto___16913 = G__16917;
continue;
} else {
}
break;
}

var G__16857 = args16854.length;
switch (G__16857) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16854.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___16919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___16919,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___16919,out){
return (function (state_16884){
var state_val_16885 = (state_16884[(1)]);
if((state_val_16885 === (7))){
var inst_16865 = (state_16884[(7)]);
var inst_16865__$1 = (state_16884[(2)]);
var inst_16867 = (inst_16865__$1 == null);
var inst_16868 = cljs.core.not.call(null,inst_16867);
var state_16884__$1 = (function (){var statearr_16886 = state_16884;
(statearr_16886[(7)] = inst_16865__$1);

return statearr_16886;
})();
if(inst_16868){
var statearr_16887_16920 = state_16884__$1;
(statearr_16887_16920[(1)] = (8));

} else {
var statearr_16888_16921 = state_16884__$1;
(statearr_16888_16921[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (1))){
var inst_16860 = (0);
var state_16884__$1 = (function (){var statearr_16892 = state_16884;
(statearr_16892[(8)] = inst_16860);

return statearr_16892;
})();
var statearr_16893_16923 = state_16884__$1;
(statearr_16893_16923[(2)] = null);

(statearr_16893_16923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (4))){
var state_16884__$1 = state_16884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16884__$1,(7),ch);
} else {
if((state_val_16885 === (6))){
var inst_16879 = (state_16884[(2)]);
var state_16884__$1 = state_16884;
var statearr_16895_16924 = state_16884__$1;
(statearr_16895_16924[(2)] = inst_16879);

(statearr_16895_16924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (3))){
var inst_16881 = (state_16884[(2)]);
var inst_16882 = cljs.core.async.close_BANG_.call(null,out);
var state_16884__$1 = (function (){var statearr_16896 = state_16884;
(statearr_16896[(9)] = inst_16881);

return statearr_16896;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16884__$1,inst_16882);
} else {
if((state_val_16885 === (2))){
var inst_16860 = (state_16884[(8)]);
var inst_16862 = (inst_16860 < n);
var state_16884__$1 = state_16884;
if(cljs.core.truth_(inst_16862)){
var statearr_16897_16925 = state_16884__$1;
(statearr_16897_16925[(1)] = (4));

} else {
var statearr_16898_16926 = state_16884__$1;
(statearr_16898_16926[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (11))){
var inst_16860 = (state_16884[(8)]);
var inst_16871 = (state_16884[(2)]);
var inst_16872 = (inst_16860 + (1));
var inst_16860__$1 = inst_16872;
var state_16884__$1 = (function (){var statearr_16899 = state_16884;
(statearr_16899[(8)] = inst_16860__$1);

(statearr_16899[(10)] = inst_16871);

return statearr_16899;
})();
var statearr_16900_16927 = state_16884__$1;
(statearr_16900_16927[(2)] = null);

(statearr_16900_16927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (9))){
var state_16884__$1 = state_16884;
var statearr_16902_16928 = state_16884__$1;
(statearr_16902_16928[(2)] = null);

(statearr_16902_16928[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (5))){
var state_16884__$1 = state_16884;
var statearr_16903_16929 = state_16884__$1;
(statearr_16903_16929[(2)] = null);

(statearr_16903_16929[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (10))){
var inst_16876 = (state_16884[(2)]);
var state_16884__$1 = state_16884;
var statearr_16904_16930 = state_16884__$1;
(statearr_16904_16930[(2)] = inst_16876);

(statearr_16904_16930[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (8))){
var inst_16865 = (state_16884[(7)]);
var state_16884__$1 = state_16884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16884__$1,(11),out,inst_16865);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___16919,out))
;
return ((function (switch__14236__auto__,c__14368__auto___16919,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16908 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16908[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16908[(1)] = (1));

return statearr_16908;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16884){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16909){if((e16909 instanceof Object)){
var ex__14240__auto__ = e16909;
var statearr_16910_16931 = state_16884;
(statearr_16910_16931[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16909;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16932 = state_16884;
state_16884 = G__16932;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16884){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___16919,out))
})();
var state__14370__auto__ = (function (){var statearr_16911 = f__14369__auto__.call(null);
(statearr_16911[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___16919);

return statearr_16911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___16919,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16947 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16947 = (function (map_LT_,f,ch,meta16948){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16948 = meta16948;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16949,meta16948__$1){
var self__ = this;
var _16949__$1 = this;
return (new cljs.core.async.t_cljs$core$async16947(self__.map_LT_,self__.f,self__.ch,meta16948__$1));
});

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16949){
var self__ = this;
var _16949__$1 = this;
return self__.meta16948;
});

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16950 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16950 = (function (map_LT_,f,ch,meta16948,_,fn1,meta16951){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16948 = meta16948;
this._ = _;
this.fn1 = fn1;
this.meta16951 = meta16951;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16952,meta16951__$1){
var self__ = this;
var _16952__$1 = this;
return (new cljs.core.async.t_cljs$core$async16950(self__.map_LT_,self__.f,self__.ch,self__.meta16948,self__._,self__.fn1,meta16951__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16952){
var self__ = this;
var _16952__$1 = this;
return self__.meta16951;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16933_SHARP_){
return f1.call(null,(((p1__16933_SHARP_ == null))?null:self__.f.call(null,p1__16933_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16948","meta16948",-803820723,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16947","cljs.core.async/t_cljs$core$async16947",1223078749,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16951","meta16951",-324207318,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16950.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16950.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16950";

cljs.core.async.t_cljs$core$async16950.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16950");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16950 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16950(map_LT___$1,f__$1,ch__$1,meta16948__$1,___$2,fn1__$1,meta16951){
return (new cljs.core.async.t_cljs$core$async16950(map_LT___$1,f__$1,ch__$1,meta16948__$1,___$2,fn1__$1,meta16951));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16950(self__.map_LT_,self__.f,self__.ch,self__.meta16948,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16947.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16947.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16948","meta16948",-803820723,null)], null);
});

cljs.core.async.t_cljs$core$async16947.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16947.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16947";

cljs.core.async.t_cljs$core$async16947.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16947");
});

cljs.core.async.__GT_t_cljs$core$async16947 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16947(map_LT___$1,f__$1,ch__$1,meta16948){
return (new cljs.core.async.t_cljs$core$async16947(map_LT___$1,f__$1,ch__$1,meta16948));
});

}

return (new cljs.core.async.t_cljs$core$async16947(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16965 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16965 = (function (map_GT_,f,ch,meta16966){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16966 = meta16966;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16967,meta16966__$1){
var self__ = this;
var _16967__$1 = this;
return (new cljs.core.async.t_cljs$core$async16965(self__.map_GT_,self__.f,self__.ch,meta16966__$1));
});

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16967){
var self__ = this;
var _16967__$1 = this;
return self__.meta16966;
});

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16965.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16965.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16966","meta16966",-1602129733,null)], null);
});

cljs.core.async.t_cljs$core$async16965.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16965.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16965";

cljs.core.async.t_cljs$core$async16965.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16965");
});

cljs.core.async.__GT_t_cljs$core$async16965 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16965(map_GT___$1,f__$1,ch__$1,meta16966){
return (new cljs.core.async.t_cljs$core$async16965(map_GT___$1,f__$1,ch__$1,meta16966));
});

}

return (new cljs.core.async.t_cljs$core$async16965(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16979 = (function (filter_GT_,p,ch,meta16980){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16980 = meta16980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16981,meta16980__$1){
var self__ = this;
var _16981__$1 = this;
return (new cljs.core.async.t_cljs$core$async16979(self__.filter_GT_,self__.p,self__.ch,meta16980__$1));
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16981){
var self__ = this;
var _16981__$1 = this;
return self__.meta16980;
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16980","meta16980",1332802124,null)], null);
});

cljs.core.async.t_cljs$core$async16979.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16979";

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16979");
});

cljs.core.async.__GT_t_cljs$core$async16979 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16979(filter_GT___$1,p__$1,ch__$1,meta16980){
return (new cljs.core.async.t_cljs$core$async16979(filter_GT___$1,p__$1,ch__$1,meta16980));
});

}

return (new cljs.core.async.t_cljs$core$async16979(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16990 = [];
var len__7107__auto___17034 = arguments.length;
var i__7108__auto___17035 = (0);
while(true){
if((i__7108__auto___17035 < len__7107__auto___17034)){
args16990.push((arguments[i__7108__auto___17035]));

var G__17036 = (i__7108__auto___17035 + (1));
i__7108__auto___17035 = G__17036;
continue;
} else {
}
break;
}

var G__16992 = args16990.length;
switch (G__16992) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16990.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17038,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17038,out){
return (function (state_17013){
var state_val_17014 = (state_17013[(1)]);
if((state_val_17014 === (7))){
var inst_17009 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
var statearr_17015_17040 = state_17013__$1;
(statearr_17015_17040[(2)] = inst_17009);

(statearr_17015_17040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (1))){
var state_17013__$1 = state_17013;
var statearr_17016_17042 = state_17013__$1;
(statearr_17016_17042[(2)] = null);

(statearr_17016_17042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (4))){
var inst_16995 = (state_17013[(7)]);
var inst_16995__$1 = (state_17013[(2)]);
var inst_16996 = (inst_16995__$1 == null);
var state_17013__$1 = (function (){var statearr_17017 = state_17013;
(statearr_17017[(7)] = inst_16995__$1);

return statearr_17017;
})();
if(cljs.core.truth_(inst_16996)){
var statearr_17018_17043 = state_17013__$1;
(statearr_17018_17043[(1)] = (5));

} else {
var statearr_17019_17044 = state_17013__$1;
(statearr_17019_17044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (6))){
var inst_16995 = (state_17013[(7)]);
var inst_17000 = p.call(null,inst_16995);
var state_17013__$1 = state_17013;
if(cljs.core.truth_(inst_17000)){
var statearr_17020_17047 = state_17013__$1;
(statearr_17020_17047[(1)] = (8));

} else {
var statearr_17021_17048 = state_17013__$1;
(statearr_17021_17048[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (3))){
var inst_17011 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17013__$1,inst_17011);
} else {
if((state_val_17014 === (2))){
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17013__$1,(4),ch);
} else {
if((state_val_17014 === (11))){
var inst_17003 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
var statearr_17022_17052 = state_17013__$1;
(statearr_17022_17052[(2)] = inst_17003);

(statearr_17022_17052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (9))){
var state_17013__$1 = state_17013;
var statearr_17023_17054 = state_17013__$1;
(statearr_17023_17054[(2)] = null);

(statearr_17023_17054[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (5))){
var inst_16998 = cljs.core.async.close_BANG_.call(null,out);
var state_17013__$1 = state_17013;
var statearr_17024_17055 = state_17013__$1;
(statearr_17024_17055[(2)] = inst_16998);

(statearr_17024_17055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (10))){
var inst_17006 = (state_17013[(2)]);
var state_17013__$1 = (function (){var statearr_17025 = state_17013;
(statearr_17025[(8)] = inst_17006);

return statearr_17025;
})();
var statearr_17026_17059 = state_17013__$1;
(statearr_17026_17059[(2)] = null);

(statearr_17026_17059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (8))){
var inst_16995 = (state_17013[(7)]);
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17013__$1,(11),out,inst_16995);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17038,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17038,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17030 = [null,null,null,null,null,null,null,null,null];
(statearr_17030[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17030[(1)] = (1));

return statearr_17030;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17013){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17013);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17031){if((e17031 instanceof Object)){
var ex__14240__auto__ = e17031;
var statearr_17032_17061 = state_17013;
(statearr_17032_17061[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17062 = state_17013;
state_17013 = G__17062;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17038,out))
})();
var state__14370__auto__ = (function (){var statearr_17033 = f__14369__auto__.call(null);
(statearr_17033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17038);

return statearr_17033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17038,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17063 = [];
var len__7107__auto___17066 = arguments.length;
var i__7108__auto___17067 = (0);
while(true){
if((i__7108__auto___17067 < len__7107__auto___17066)){
args17063.push((arguments[i__7108__auto___17067]));

var G__17068 = (i__7108__auto___17067 + (1));
i__7108__auto___17067 = G__17068;
continue;
} else {
}
break;
}

var G__17065 = args17063.length;
switch (G__17065) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17063.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__){
return (function (state_17242){
var state_val_17243 = (state_17242[(1)]);
if((state_val_17243 === (7))){
var inst_17238 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
var statearr_17245_17286 = state_17242__$1;
(statearr_17245_17286[(2)] = inst_17238);

(statearr_17245_17286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (20))){
var inst_17208 = (state_17242[(7)]);
var inst_17219 = (state_17242[(2)]);
var inst_17220 = cljs.core.next.call(null,inst_17208);
var inst_17194 = inst_17220;
var inst_17195 = null;
var inst_17196 = (0);
var inst_17197 = (0);
var state_17242__$1 = (function (){var statearr_17246 = state_17242;
(statearr_17246[(8)] = inst_17197);

(statearr_17246[(9)] = inst_17196);

(statearr_17246[(10)] = inst_17195);

(statearr_17246[(11)] = inst_17219);

(statearr_17246[(12)] = inst_17194);

return statearr_17246;
})();
var statearr_17247_17287 = state_17242__$1;
(statearr_17247_17287[(2)] = null);

(statearr_17247_17287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (1))){
var state_17242__$1 = state_17242;
var statearr_17248_17288 = state_17242__$1;
(statearr_17248_17288[(2)] = null);

(statearr_17248_17288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (4))){
var inst_17183 = (state_17242[(13)]);
var inst_17183__$1 = (state_17242[(2)]);
var inst_17184 = (inst_17183__$1 == null);
var state_17242__$1 = (function (){var statearr_17249 = state_17242;
(statearr_17249[(13)] = inst_17183__$1);

return statearr_17249;
})();
if(cljs.core.truth_(inst_17184)){
var statearr_17250_17291 = state_17242__$1;
(statearr_17250_17291[(1)] = (5));

} else {
var statearr_17251_17292 = state_17242__$1;
(statearr_17251_17292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (15))){
var state_17242__$1 = state_17242;
var statearr_17255_17294 = state_17242__$1;
(statearr_17255_17294[(2)] = null);

(statearr_17255_17294[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (21))){
var state_17242__$1 = state_17242;
var statearr_17256_17296 = state_17242__$1;
(statearr_17256_17296[(2)] = null);

(statearr_17256_17296[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (13))){
var inst_17197 = (state_17242[(8)]);
var inst_17196 = (state_17242[(9)]);
var inst_17195 = (state_17242[(10)]);
var inst_17194 = (state_17242[(12)]);
var inst_17204 = (state_17242[(2)]);
var inst_17205 = (inst_17197 + (1));
var tmp17252 = inst_17196;
var tmp17253 = inst_17195;
var tmp17254 = inst_17194;
var inst_17194__$1 = tmp17254;
var inst_17195__$1 = tmp17253;
var inst_17196__$1 = tmp17252;
var inst_17197__$1 = inst_17205;
var state_17242__$1 = (function (){var statearr_17257 = state_17242;
(statearr_17257[(8)] = inst_17197__$1);

(statearr_17257[(9)] = inst_17196__$1);

(statearr_17257[(10)] = inst_17195__$1);

(statearr_17257[(12)] = inst_17194__$1);

(statearr_17257[(14)] = inst_17204);

return statearr_17257;
})();
var statearr_17258_17300 = state_17242__$1;
(statearr_17258_17300[(2)] = null);

(statearr_17258_17300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (22))){
var state_17242__$1 = state_17242;
var statearr_17259_17301 = state_17242__$1;
(statearr_17259_17301[(2)] = null);

(statearr_17259_17301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (6))){
var inst_17183 = (state_17242[(13)]);
var inst_17192 = f.call(null,inst_17183);
var inst_17193 = cljs.core.seq.call(null,inst_17192);
var inst_17194 = inst_17193;
var inst_17195 = null;
var inst_17196 = (0);
var inst_17197 = (0);
var state_17242__$1 = (function (){var statearr_17260 = state_17242;
(statearr_17260[(8)] = inst_17197);

(statearr_17260[(9)] = inst_17196);

(statearr_17260[(10)] = inst_17195);

(statearr_17260[(12)] = inst_17194);

return statearr_17260;
})();
var statearr_17261_17302 = state_17242__$1;
(statearr_17261_17302[(2)] = null);

(statearr_17261_17302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (17))){
var inst_17208 = (state_17242[(7)]);
var inst_17212 = cljs.core.chunk_first.call(null,inst_17208);
var inst_17213 = cljs.core.chunk_rest.call(null,inst_17208);
var inst_17214 = cljs.core.count.call(null,inst_17212);
var inst_17194 = inst_17213;
var inst_17195 = inst_17212;
var inst_17196 = inst_17214;
var inst_17197 = (0);
var state_17242__$1 = (function (){var statearr_17262 = state_17242;
(statearr_17262[(8)] = inst_17197);

(statearr_17262[(9)] = inst_17196);

(statearr_17262[(10)] = inst_17195);

(statearr_17262[(12)] = inst_17194);

return statearr_17262;
})();
var statearr_17263_17304 = state_17242__$1;
(statearr_17263_17304[(2)] = null);

(statearr_17263_17304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (3))){
var inst_17240 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17242__$1,inst_17240);
} else {
if((state_val_17243 === (12))){
var inst_17228 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
var statearr_17264_17305 = state_17242__$1;
(statearr_17264_17305[(2)] = inst_17228);

(statearr_17264_17305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (2))){
var state_17242__$1 = state_17242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17242__$1,(4),in$);
} else {
if((state_val_17243 === (23))){
var inst_17236 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
var statearr_17265_17306 = state_17242__$1;
(statearr_17265_17306[(2)] = inst_17236);

(statearr_17265_17306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (19))){
var inst_17223 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
var statearr_17266_17307 = state_17242__$1;
(statearr_17266_17307[(2)] = inst_17223);

(statearr_17266_17307[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (11))){
var inst_17208 = (state_17242[(7)]);
var inst_17194 = (state_17242[(12)]);
var inst_17208__$1 = cljs.core.seq.call(null,inst_17194);
var state_17242__$1 = (function (){var statearr_17267 = state_17242;
(statearr_17267[(7)] = inst_17208__$1);

return statearr_17267;
})();
if(inst_17208__$1){
var statearr_17268_17308 = state_17242__$1;
(statearr_17268_17308[(1)] = (14));

} else {
var statearr_17269_17309 = state_17242__$1;
(statearr_17269_17309[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (9))){
var inst_17230 = (state_17242[(2)]);
var inst_17231 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17242__$1 = (function (){var statearr_17270 = state_17242;
(statearr_17270[(15)] = inst_17230);

return statearr_17270;
})();
if(cljs.core.truth_(inst_17231)){
var statearr_17271_17310 = state_17242__$1;
(statearr_17271_17310[(1)] = (21));

} else {
var statearr_17272_17311 = state_17242__$1;
(statearr_17272_17311[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (5))){
var inst_17186 = cljs.core.async.close_BANG_.call(null,out);
var state_17242__$1 = state_17242;
var statearr_17273_17312 = state_17242__$1;
(statearr_17273_17312[(2)] = inst_17186);

(statearr_17273_17312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (14))){
var inst_17208 = (state_17242[(7)]);
var inst_17210 = cljs.core.chunked_seq_QMARK_.call(null,inst_17208);
var state_17242__$1 = state_17242;
if(inst_17210){
var statearr_17274_17313 = state_17242__$1;
(statearr_17274_17313[(1)] = (17));

} else {
var statearr_17275_17314 = state_17242__$1;
(statearr_17275_17314[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (16))){
var inst_17226 = (state_17242[(2)]);
var state_17242__$1 = state_17242;
var statearr_17276_17315 = state_17242__$1;
(statearr_17276_17315[(2)] = inst_17226);

(statearr_17276_17315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17243 === (10))){
var inst_17197 = (state_17242[(8)]);
var inst_17195 = (state_17242[(10)]);
var inst_17202 = cljs.core._nth.call(null,inst_17195,inst_17197);
var state_17242__$1 = state_17242;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17242__$1,(13),out,inst_17202);
} else {
if((state_val_17243 === (18))){
var inst_17208 = (state_17242[(7)]);
var inst_17217 = cljs.core.first.call(null,inst_17208);
var state_17242__$1 = state_17242;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17242__$1,(20),out,inst_17217);
} else {
if((state_val_17243 === (8))){
var inst_17197 = (state_17242[(8)]);
var inst_17196 = (state_17242[(9)]);
var inst_17199 = (inst_17197 < inst_17196);
var inst_17200 = inst_17199;
var state_17242__$1 = state_17242;
if(cljs.core.truth_(inst_17200)){
var statearr_17277_17316 = state_17242__$1;
(statearr_17277_17316[(1)] = (10));

} else {
var statearr_17278_17317 = state_17242__$1;
(statearr_17278_17317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__))
;
return ((function (switch__14236__auto__,c__14368__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17282[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17282[(1)] = (1));

return statearr_17282;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17242){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17283){if((e17283 instanceof Object)){
var ex__14240__auto__ = e17283;
var statearr_17284_17318 = state_17242;
(statearr_17284_17318[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17242);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17319 = state_17242;
state_17242 = G__17319;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17242){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__))
})();
var state__14370__auto__ = (function (){var statearr_17285 = f__14369__auto__.call(null);
(statearr_17285[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_17285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__))
);

return c__14368__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17323 = [];
var len__7107__auto___17327 = arguments.length;
var i__7108__auto___17328 = (0);
while(true){
if((i__7108__auto___17328 < len__7107__auto___17327)){
args17323.push((arguments[i__7108__auto___17328]));

var G__17329 = (i__7108__auto___17328 + (1));
i__7108__auto___17328 = G__17329;
continue;
} else {
}
break;
}

var G__17326 = args17323.length;
switch (G__17326) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17323.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17334 = [];
var len__7107__auto___17341 = arguments.length;
var i__7108__auto___17342 = (0);
while(true){
if((i__7108__auto___17342 < len__7107__auto___17341)){
args17334.push((arguments[i__7108__auto___17342]));

var G__17343 = (i__7108__auto___17342 + (1));
i__7108__auto___17342 = G__17343;
continue;
} else {
}
break;
}

var G__17340 = args17334.length;
switch (G__17340) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17334.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17346 = [];
var len__7107__auto___17397 = arguments.length;
var i__7108__auto___17398 = (0);
while(true){
if((i__7108__auto___17398 < len__7107__auto___17397)){
args17346.push((arguments[i__7108__auto___17398]));

var G__17399 = (i__7108__auto___17398 + (1));
i__7108__auto___17398 = G__17399;
continue;
} else {
}
break;
}

var G__17348 = args17346.length;
switch (G__17348) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17346.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17401,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17401,out){
return (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (7))){
var inst_17367 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17374_17402 = state_17372__$1;
(statearr_17374_17402[(2)] = inst_17367);

(statearr_17374_17402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (1))){
var inst_17349 = null;
var state_17372__$1 = (function (){var statearr_17375 = state_17372;
(statearr_17375[(7)] = inst_17349);

return statearr_17375;
})();
var statearr_17376_17403 = state_17372__$1;
(statearr_17376_17403[(2)] = null);

(statearr_17376_17403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (4))){
var inst_17352 = (state_17372[(8)]);
var inst_17352__$1 = (state_17372[(2)]);
var inst_17353 = (inst_17352__$1 == null);
var inst_17354 = cljs.core.not.call(null,inst_17353);
var state_17372__$1 = (function (){var statearr_17377 = state_17372;
(statearr_17377[(8)] = inst_17352__$1);

return statearr_17377;
})();
if(inst_17354){
var statearr_17378_17404 = state_17372__$1;
(statearr_17378_17404[(1)] = (5));

} else {
var statearr_17379_17405 = state_17372__$1;
(statearr_17379_17405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var state_17372__$1 = state_17372;
var statearr_17380_17406 = state_17372__$1;
(statearr_17380_17406[(2)] = null);

(statearr_17380_17406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (3))){
var inst_17369 = (state_17372[(2)]);
var inst_17370 = cljs.core.async.close_BANG_.call(null,out);
var state_17372__$1 = (function (){var statearr_17381 = state_17372;
(statearr_17381[(9)] = inst_17369);

return statearr_17381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (2))){
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17372__$1,(4),ch);
} else {
if((state_val_17373 === (11))){
var inst_17352 = (state_17372[(8)]);
var inst_17361 = (state_17372[(2)]);
var inst_17349 = inst_17352;
var state_17372__$1 = (function (){var statearr_17382 = state_17372;
(statearr_17382[(7)] = inst_17349);

(statearr_17382[(10)] = inst_17361);

return statearr_17382;
})();
var statearr_17383_17407 = state_17372__$1;
(statearr_17383_17407[(2)] = null);

(statearr_17383_17407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (9))){
var inst_17352 = (state_17372[(8)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17372__$1,(11),out,inst_17352);
} else {
if((state_val_17373 === (5))){
var inst_17349 = (state_17372[(7)]);
var inst_17352 = (state_17372[(8)]);
var inst_17356 = cljs.core._EQ_.call(null,inst_17352,inst_17349);
var state_17372__$1 = state_17372;
if(inst_17356){
var statearr_17385_17409 = state_17372__$1;
(statearr_17385_17409[(1)] = (8));

} else {
var statearr_17386_17410 = state_17372__$1;
(statearr_17386_17410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (10))){
var inst_17364 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17387_17415 = state_17372__$1;
(statearr_17387_17415[(2)] = inst_17364);

(statearr_17387_17415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (8))){
var inst_17349 = (state_17372[(7)]);
var tmp17384 = inst_17349;
var inst_17349__$1 = tmp17384;
var state_17372__$1 = (function (){var statearr_17388 = state_17372;
(statearr_17388[(7)] = inst_17349__$1);

return statearr_17388;
})();
var statearr_17389_17418 = state_17372__$1;
(statearr_17389_17418[(2)] = null);

(statearr_17389_17418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17401,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17401,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17393 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17393[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17393[(1)] = (1));

return statearr_17393;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17372){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17394){if((e17394 instanceof Object)){
var ex__14240__auto__ = e17394;
var statearr_17395_17421 = state_17372;
(statearr_17395_17421[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17426 = state_17372;
state_17372 = G__17426;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17401,out))
})();
var state__14370__auto__ = (function (){var statearr_17396 = f__14369__auto__.call(null);
(statearr_17396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17401);

return statearr_17396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17401,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17429 = [];
var len__7107__auto___17503 = arguments.length;
var i__7108__auto___17504 = (0);
while(true){
if((i__7108__auto___17504 < len__7107__auto___17503)){
args17429.push((arguments[i__7108__auto___17504]));

var G__17505 = (i__7108__auto___17504 + (1));
i__7108__auto___17504 = G__17505;
continue;
} else {
}
break;
}

var G__17433 = args17429.length;
switch (G__17433) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17429.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17507 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17507,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17507,out){
return (function (state_17472){
var state_val_17473 = (state_17472[(1)]);
if((state_val_17473 === (7))){
var inst_17468 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17474_17508 = state_17472__$1;
(statearr_17474_17508[(2)] = inst_17468);

(statearr_17474_17508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (1))){
var inst_17434 = (new Array(n));
var inst_17435 = inst_17434;
var inst_17436 = (0);
var state_17472__$1 = (function (){var statearr_17475 = state_17472;
(statearr_17475[(7)] = inst_17435);

(statearr_17475[(8)] = inst_17436);

return statearr_17475;
})();
var statearr_17476_17509 = state_17472__$1;
(statearr_17476_17509[(2)] = null);

(statearr_17476_17509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (4))){
var inst_17439 = (state_17472[(9)]);
var inst_17439__$1 = (state_17472[(2)]);
var inst_17440 = (inst_17439__$1 == null);
var inst_17441 = cljs.core.not.call(null,inst_17440);
var state_17472__$1 = (function (){var statearr_17477 = state_17472;
(statearr_17477[(9)] = inst_17439__$1);

return statearr_17477;
})();
if(inst_17441){
var statearr_17478_17514 = state_17472__$1;
(statearr_17478_17514[(1)] = (5));

} else {
var statearr_17479_17516 = state_17472__$1;
(statearr_17479_17516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (15))){
var inst_17462 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17480_17518 = state_17472__$1;
(statearr_17480_17518[(2)] = inst_17462);

(statearr_17480_17518[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (13))){
var state_17472__$1 = state_17472;
var statearr_17481_17520 = state_17472__$1;
(statearr_17481_17520[(2)] = null);

(statearr_17481_17520[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (6))){
var inst_17436 = (state_17472[(8)]);
var inst_17458 = (inst_17436 > (0));
var state_17472__$1 = state_17472;
if(cljs.core.truth_(inst_17458)){
var statearr_17482_17522 = state_17472__$1;
(statearr_17482_17522[(1)] = (12));

} else {
var statearr_17483_17527 = state_17472__$1;
(statearr_17483_17527[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (3))){
var inst_17470 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17472__$1,inst_17470);
} else {
if((state_val_17473 === (12))){
var inst_17435 = (state_17472[(7)]);
var inst_17460 = cljs.core.vec.call(null,inst_17435);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(15),out,inst_17460);
} else {
if((state_val_17473 === (2))){
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17472__$1,(4),ch);
} else {
if((state_val_17473 === (11))){
var inst_17452 = (state_17472[(2)]);
var inst_17453 = (new Array(n));
var inst_17435 = inst_17453;
var inst_17436 = (0);
var state_17472__$1 = (function (){var statearr_17484 = state_17472;
(statearr_17484[(7)] = inst_17435);

(statearr_17484[(10)] = inst_17452);

(statearr_17484[(8)] = inst_17436);

return statearr_17484;
})();
var statearr_17485_17532 = state_17472__$1;
(statearr_17485_17532[(2)] = null);

(statearr_17485_17532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (9))){
var inst_17435 = (state_17472[(7)]);
var inst_17450 = cljs.core.vec.call(null,inst_17435);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(11),out,inst_17450);
} else {
if((state_val_17473 === (5))){
var inst_17435 = (state_17472[(7)]);
var inst_17439 = (state_17472[(9)]);
var inst_17444 = (state_17472[(11)]);
var inst_17436 = (state_17472[(8)]);
var inst_17443 = (inst_17435[inst_17436] = inst_17439);
var inst_17444__$1 = (inst_17436 + (1));
var inst_17445 = (inst_17444__$1 < n);
var state_17472__$1 = (function (){var statearr_17486 = state_17472;
(statearr_17486[(12)] = inst_17443);

(statearr_17486[(11)] = inst_17444__$1);

return statearr_17486;
})();
if(cljs.core.truth_(inst_17445)){
var statearr_17487_17535 = state_17472__$1;
(statearr_17487_17535[(1)] = (8));

} else {
var statearr_17488_17536 = state_17472__$1;
(statearr_17488_17536[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (14))){
var inst_17465 = (state_17472[(2)]);
var inst_17466 = cljs.core.async.close_BANG_.call(null,out);
var state_17472__$1 = (function (){var statearr_17490 = state_17472;
(statearr_17490[(13)] = inst_17465);

return statearr_17490;
})();
var statearr_17491_17541 = state_17472__$1;
(statearr_17491_17541[(2)] = inst_17466);

(statearr_17491_17541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (10))){
var inst_17456 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17492_17544 = state_17472__$1;
(statearr_17492_17544[(2)] = inst_17456);

(statearr_17492_17544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (8))){
var inst_17435 = (state_17472[(7)]);
var inst_17444 = (state_17472[(11)]);
var tmp17489 = inst_17435;
var inst_17435__$1 = tmp17489;
var inst_17436 = inst_17444;
var state_17472__$1 = (function (){var statearr_17493 = state_17472;
(statearr_17493[(7)] = inst_17435__$1);

(statearr_17493[(8)] = inst_17436);

return statearr_17493;
})();
var statearr_17494_17545 = state_17472__$1;
(statearr_17494_17545[(2)] = null);

(statearr_17494_17545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17507,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17507,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17499[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17499[(1)] = (1));

return statearr_17499;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17472){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17500){if((e17500 instanceof Object)){
var ex__14240__auto__ = e17500;
var statearr_17501_17553 = state_17472;
(statearr_17501_17553[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17500;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17555 = state_17472;
state_17472 = G__17555;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17472){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17507,out))
})();
var state__14370__auto__ = (function (){var statearr_17502 = f__14369__auto__.call(null);
(statearr_17502[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17507);

return statearr_17502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17507,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17558 = [];
var len__7107__auto___17633 = arguments.length;
var i__7108__auto___17634 = (0);
while(true){
if((i__7108__auto___17634 < len__7107__auto___17633)){
args17558.push((arguments[i__7108__auto___17634]));

var G__17635 = (i__7108__auto___17634 + (1));
i__7108__auto___17634 = G__17635;
continue;
} else {
}
break;
}

var G__17560 = args17558.length;
switch (G__17560) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17558.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14368__auto___17639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___17639,out){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___17639,out){
return (function (state_17603){
var state_val_17604 = (state_17603[(1)]);
if((state_val_17604 === (7))){
var inst_17599 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17605_17641 = state_17603__$1;
(statearr_17605_17641[(2)] = inst_17599);

(statearr_17605_17641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (1))){
var inst_17562 = [];
var inst_17563 = inst_17562;
var inst_17564 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17603__$1 = (function (){var statearr_17606 = state_17603;
(statearr_17606[(7)] = inst_17563);

(statearr_17606[(8)] = inst_17564);

return statearr_17606;
})();
var statearr_17607_17643 = state_17603__$1;
(statearr_17607_17643[(2)] = null);

(statearr_17607_17643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (4))){
var inst_17567 = (state_17603[(9)]);
var inst_17567__$1 = (state_17603[(2)]);
var inst_17568 = (inst_17567__$1 == null);
var inst_17569 = cljs.core.not.call(null,inst_17568);
var state_17603__$1 = (function (){var statearr_17608 = state_17603;
(statearr_17608[(9)] = inst_17567__$1);

return statearr_17608;
})();
if(inst_17569){
var statearr_17609_17644 = state_17603__$1;
(statearr_17609_17644[(1)] = (5));

} else {
var statearr_17610_17645 = state_17603__$1;
(statearr_17610_17645[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (15))){
var inst_17593 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17611_17649 = state_17603__$1;
(statearr_17611_17649[(2)] = inst_17593);

(statearr_17611_17649[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (13))){
var state_17603__$1 = state_17603;
var statearr_17612_17650 = state_17603__$1;
(statearr_17612_17650[(2)] = null);

(statearr_17612_17650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (6))){
var inst_17563 = (state_17603[(7)]);
var inst_17588 = inst_17563.length;
var inst_17589 = (inst_17588 > (0));
var state_17603__$1 = state_17603;
if(cljs.core.truth_(inst_17589)){
var statearr_17613_17651 = state_17603__$1;
(statearr_17613_17651[(1)] = (12));

} else {
var statearr_17614_17652 = state_17603__$1;
(statearr_17614_17652[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (3))){
var inst_17601 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17603__$1,inst_17601);
} else {
if((state_val_17604 === (12))){
var inst_17563 = (state_17603[(7)]);
var inst_17591 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(15),out,inst_17591);
} else {
if((state_val_17604 === (2))){
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17603__$1,(4),ch);
} else {
if((state_val_17604 === (11))){
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17581 = (state_17603[(2)]);
var inst_17582 = [];
var inst_17583 = inst_17582.push(inst_17567);
var inst_17563 = inst_17582;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17615 = state_17603;
(statearr_17615[(7)] = inst_17563);

(statearr_17615[(8)] = inst_17564);

(statearr_17615[(11)] = inst_17583);

(statearr_17615[(12)] = inst_17581);

return statearr_17615;
})();
var statearr_17616_17654 = state_17603__$1;
(statearr_17616_17654[(2)] = null);

(statearr_17616_17654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (9))){
var inst_17563 = (state_17603[(7)]);
var inst_17579 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(11),out,inst_17579);
} else {
if((state_val_17604 === (5))){
var inst_17571 = (state_17603[(10)]);
var inst_17564 = (state_17603[(8)]);
var inst_17567 = (state_17603[(9)]);
var inst_17571__$1 = f.call(null,inst_17567);
var inst_17572 = cljs.core._EQ_.call(null,inst_17571__$1,inst_17564);
var inst_17573 = cljs.core.keyword_identical_QMARK_.call(null,inst_17564,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17574 = (inst_17572) || (inst_17573);
var state_17603__$1 = (function (){var statearr_17617 = state_17603;
(statearr_17617[(10)] = inst_17571__$1);

return statearr_17617;
})();
if(cljs.core.truth_(inst_17574)){
var statearr_17618_17655 = state_17603__$1;
(statearr_17618_17655[(1)] = (8));

} else {
var statearr_17619_17656 = state_17603__$1;
(statearr_17619_17656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (14))){
var inst_17596 = (state_17603[(2)]);
var inst_17597 = cljs.core.async.close_BANG_.call(null,out);
var state_17603__$1 = (function (){var statearr_17621 = state_17603;
(statearr_17621[(13)] = inst_17596);

return statearr_17621;
})();
var statearr_17622_17657 = state_17603__$1;
(statearr_17622_17657[(2)] = inst_17597);

(statearr_17622_17657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (10))){
var inst_17586 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17623_17658 = state_17603__$1;
(statearr_17623_17658[(2)] = inst_17586);

(statearr_17623_17658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (8))){
var inst_17563 = (state_17603[(7)]);
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17576 = inst_17563.push(inst_17567);
var tmp17620 = inst_17563;
var inst_17563__$1 = tmp17620;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17624 = state_17603;
(statearr_17624[(7)] = inst_17563__$1);

(statearr_17624[(14)] = inst_17576);

(statearr_17624[(8)] = inst_17564);

return statearr_17624;
})();
var statearr_17625_17659 = state_17603__$1;
(statearr_17625_17659[(2)] = null);

(statearr_17625_17659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___17639,out))
;
return ((function (switch__14236__auto__,c__14368__auto___17639,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17629[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17629[(1)] = (1));

return statearr_17629;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17603){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17630){if((e17630 instanceof Object)){
var ex__14240__auto__ = e17630;
var statearr_17631_17660 = state_17603;
(statearr_17631_17660[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17603);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17630;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17661 = state_17603;
state_17603 = G__17661;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17603){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___17639,out))
})();
var state__14370__auto__ = (function (){var statearr_17632 = f__14369__auto__.call(null);
(statearr_17632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___17639);

return statearr_17632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___17639,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472741865428